/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.aclib.sort;

import java.util.Comparator;
import zext.plantuml.com.ctreber.aclib.sort.CTSort;

public class QuickSort
extends CTSort {
    @Override
    public void sort(Object[] items, Comparator comparator) {
        if (items.length <= 1) {
            return;
        }
        this.qsort(items, comparator, 0, items.length - 1);
        QuickSort.insertionSort(items, comparator, 0, items.length - 1);
    }

    private void qsort(Object[] items, Comparator comparator, int l, int r) {
        int M = 4;
        if (r - l > 4) {
            int i = (r + l) / 2;
            if (comparator.compare(items[l], items[i]) > 0) {
                QuickSort.swap(items, l, i);
            }
            if (comparator.compare(items[l], items[r]) > 0) {
                QuickSort.swap(items, l, r);
            }
            if (comparator.compare(items[i], items[r]) > 0) {
                QuickSort.swap(items, i, r);
            }
            int j = r - 1;
            QuickSort.swap(items, i, j);
            i = l;
            Object v = items[j];
            while (true) {
                if (comparator.compare(items[++i], v) < 0) {
                    continue;
                }
                while (comparator.compare(items[--j], v) > 0) {
                }
                if (j < i) break;
                QuickSort.swap(items, i, j);
            }
            QuickSort.swap(items, i, r - 1);
            this.qsort(items, comparator, l, j);
            this.qsort(items, comparator, i + 1, r);
        }
    }

    private static void swap(Object[] items, int i, int j) {
        Object tmp = items[i];
        items[i] = items[j];
        items[j] = tmp;
    }

    private static void insertionSort(Object[] items, Comparator comparator, int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            Object v = items[i];
            for (int j = i; j > lo0 && comparator.compare(items[j - 1], v) > 0; --j) {
                items[j] = items[j - 1];
            }
            items[j] = v;
        }
    }
}

