/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;

public class FontInfo {
    public static final int NUMBER_OF_CHAR_CODES = 256;
    private static Map<Integer, FontInfo> fonts = new HashMap<Integer, FontInfo>();
    private final int fontId;
    private Font font;
    private final Object base;
    private final String path;
    private final String fontName;
    private final Map<CharCouple, Character> lig = new HashMap<CharCouple, Character>();
    private final Map<CharCouple, Float> kern = new HashMap<CharCouple, Float>();
    private float[][] metrics;
    private CharFont[] nextLarger;
    private int[][] extensions;
    private HashMap<Character, Character> unicode = null;
    private char skewChar = (char)65535;
    private final float xHeight;
    private final float space;
    private final float quad;
    private int boldId;
    private int romanId;
    private int ssId;
    private int ttId;
    private int itId;
    protected final String boldVersion;
    protected final String romanVersion;
    protected final String ssVersion;
    protected final String ttVersion;
    protected final String itVersion;

    public FontInfo(int fontId, Object base, String path, String fontName, int unicode, float xHeight, float space, float quad, String boldVersion, String romanVersion, String ssVersion, String ttVersion, String itVersion) {
        this.fontId = fontId;
        this.base = base;
        this.path = path;
        this.fontName = fontName;
        this.xHeight = xHeight;
        this.space = space;
        this.quad = quad;
        this.boldVersion = boldVersion;
        this.romanVersion = romanVersion;
        this.ssVersion = ssVersion;
        this.ttVersion = ttVersion;
        this.itVersion = itVersion;
        int num = 256;
        if (unicode != 0) {
            this.unicode = new HashMap(unicode);
            num = unicode;
        }
        this.metrics = new float[num][];
        this.nextLarger = new CharFont[num];
        this.extensions = new int[num][];
        fonts.put(fontId, this);
    }

    public void addKern(char left, char right, float k) {
        this.kern.put(new CharCouple(left, right), new Float(k));
    }

    public void addLigature(char left, char right, char ligChar) {
        this.lig.put(new CharCouple(left, right), new Character(ligChar));
    }

    public int[] getExtension(char ch) {
        if (this.unicode == null) {
            return this.extensions[ch];
        }
        return this.extensions[this.unicode.get(Character.valueOf(ch)).charValue()];
    }

    public float getKern(char left, char right, float factor) {
        Float obj = this.kern.get(new CharCouple(left, right));
        if (obj == null) {
            return 0.0f;
        }
        return obj.floatValue() * factor;
    }

    public CharFont getLigature(char left, char right) {
        Character obj = this.lig.get(new CharCouple(left, right));
        if (obj == null) {
            return null;
        }
        return new CharFont(obj.charValue(), this.fontId);
    }

    public float[] getMetrics(char c) {
        if (this.unicode == null) {
            return this.metrics[c];
        }
        return this.metrics[this.unicode.get(Character.valueOf(c)).charValue()];
    }

    public CharFont getNextLarger(char ch) {
        if (this.unicode == null) {
            return this.nextLarger[ch];
        }
        return this.nextLarger[this.unicode.get(Character.valueOf(ch)).charValue()];
    }

    public float getQuad(float factor) {
        return this.quad * factor;
    }

    public char getSkewChar() {
        return this.skewChar;
    }

    public float getSpace(float factor) {
        return this.space * factor;
    }

    public float getXHeight(float factor) {
        return this.xHeight * factor;
    }

    public boolean hasSpace() {
        return this.space > 1.0E-7f;
    }

    public void setExtension(char ch, int[] ext) {
        if (this.unicode == null) {
            this.extensions[ch] = ext;
        } else if (!this.unicode.containsKey(Character.valueOf(ch))) {
            char s = (char)this.unicode.size();
            this.unicode.put(Character.valueOf(ch), Character.valueOf(s));
            this.extensions[s] = ext;
        } else {
            this.extensions[this.unicode.get((Object)Character.valueOf((char)ch)).charValue()] = ext;
        }
    }

    public void setMetrics(char c, float[] arr) {
        if (this.unicode == null) {
            this.metrics[c] = arr;
        } else if (!this.unicode.containsKey(Character.valueOf(c))) {
            char s = (char)this.unicode.size();
            this.unicode.put(Character.valueOf(c), Character.valueOf(s));
            this.metrics[s] = arr;
        } else {
            this.metrics[this.unicode.get((Object)Character.valueOf((char)c)).charValue()] = arr;
        }
    }

    public void setNextLarger(char ch, char larger, int fontLarger) {
        if (this.unicode == null) {
            this.nextLarger[ch] = new CharFont(larger, fontLarger);
        } else if (!this.unicode.containsKey(Character.valueOf(ch))) {
            char s = (char)this.unicode.size();
            this.unicode.put(Character.valueOf(ch), Character.valueOf(s));
            this.nextLarger[s] = new CharFont(larger, fontLarger);
        } else {
            this.nextLarger[this.unicode.get((Object)Character.valueOf((char)ch)).charValue()] = new CharFont(larger, fontLarger);
        }
    }

    public void setSkewChar(char c) {
        this.skewChar = c;
    }

    public int getId() {
        return this.fontId;
    }

    public int getBoldId() {
        return this.boldId;
    }

    public int getRomanId() {
        return this.romanId;
    }

    public int getTtId() {
        return this.ttId;
    }

    public int getItId() {
        return this.itId;
    }

    public int getSsId() {
        return this.ssId;
    }

    public void setSsId(int id) {
        this.ssId = id == -1 ? this.fontId : id;
    }

    public void setTtId(int id) {
        this.ttId = id == -1 ? this.fontId : id;
    }

    public void setItId(int id) {
        this.itId = id == -1 ? this.fontId : id;
    }

    public void setRomanId(int id) {
        this.romanId = id == -1 ? this.fontId : id;
    }

    public void setBoldId(int id) {
        this.boldId = id == -1 ? this.fontId : id;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = this.base == null ? DefaultTeXFontParser.createFont(this.path) : DefaultTeXFontParser.createFont(this.base.getClass().getResourceAsStream(this.path), this.fontName);
        }
        return this.font;
    }

    public static Font getFont(int id) {
        return fonts.get(id).getFont();
    }

    private class CharCouple {
        private final char left;
        private final char right;

        CharCouple(char l, char r) {
            this.left = l;
            this.right = r;
        }

        public boolean equals(Object o) {
            CharCouple lig = (CharCouple)o;
            return this.left == lig.left && this.right == lig.right;
        }

        public int hashCode() {
            return (this.left + this.right) % 128;
        }
    }
}

