"""
FNV test vectors

Derived from http://isthe.com/chongo/src/fnv/test_fnv.c
"""

def TEST(s):
    return s

def TEST0(s):
    return s + b"\x00"

def R10(s):
    return s * 10

def R100(s):
    return s * 100

def R500(s):
    return s * 500

fnv_test_str = [
    TEST(b""),
    TEST(b"a"),
    TEST(b"b"),
    TEST(b"c"),
    TEST(b"d"),
    TEST(b"e"),
    TEST(b"f"),
    TEST(b"fo"),
    TEST(b"foo"),
    TEST(b"foob"),
    TEST(b"fooba"),
    TEST(b"foobar"),
    TEST0(b""),
    TEST0(b"a"),
    TEST0(b"b"),
    TEST0(b"c"),
    TEST0(b"d"),
    TEST0(b"e"),
    TEST0(b"f"),
    TEST0(b"fo"),
    TEST0(b"foo"),
    TEST0(b"foob"),
    TEST0(b"fooba"),
    TEST0(b"foobar"),
    TEST(b"ch"),
    TEST(b"cho"),
    TEST(b"chon"),
    TEST(b"chong"),
    TEST(b"chongo"),
    TEST(b"chongo "),
    TEST(b"chongo w"),
    TEST(b"chongo wa"),
    TEST(b"chongo was"),
    TEST(b"chongo was "),
    TEST(b"chongo was h"),
    TEST(b"chongo was he"),
    TEST(b"chongo was her"),
    TEST(b"chongo was here"),
    TEST(b"chongo was here!"),
    TEST(b"chongo was here!\n"),
    TEST0(b"ch"),
    TEST0(b"cho"),
    TEST0(b"chon"),
    TEST0(b"chong"),
    TEST0(b"chongo"),
    TEST0(b"chongo "),
    TEST0(b"chongo w"),
    TEST0(b"chongo wa"),
    TEST0(b"chongo was"),
    TEST0(b"chongo was "),
    TEST0(b"chongo was h"),
    TEST0(b"chongo was he"),
    TEST0(b"chongo was her"),
    TEST0(b"chongo was here"),
    TEST0(b"chongo was here!"),
    TEST0(b"chongo was here!\n"),
    TEST(b"cu"),
    TEST(b"cur"),
    TEST(b"curd"),
    TEST(b"curds"),
    TEST(b"curds "),
    TEST(b"curds a"),
    TEST(b"curds an"),
    TEST(b"curds and"),
    TEST(b"curds and "),
    TEST(b"curds and w"),
    TEST(b"curds and wh"),
    TEST(b"curds and whe"),
    TEST(b"curds and whey"),
    TEST(b"curds and whey\n"),
    TEST0(b"cu"),
    TEST0(b"cur"),
    TEST0(b"curd"),
    TEST0(b"curds"),
    TEST0(b"curds "),
    TEST0(b"curds a"),
    TEST0(b"curds an"),
    TEST0(b"curds and"),
    TEST0(b"curds and "),
    TEST0(b"curds and w"),
    TEST0(b"curds and wh"),
    TEST0(b"curds and whe"),
    TEST0(b"curds and whey"),
    TEST0(b"curds and whey\n"),
    TEST(b"hi"), TEST0(b"hi"),
    TEST(b"hello"), TEST0(b"hello"),
    TEST(b"\xff\x00\x00\x01"), TEST(b"\x01\x00\x00\xff"),
    TEST(b"\xff\x00\x00\x02"), TEST(b"\x02\x00\x00\xff"),
    TEST(b"\xff\x00\x00\x03"), TEST(b"\x03\x00\x00\xff"),
    TEST(b"\xff\x00\x00\x04"), TEST(b"\x04\x00\x00\xff"),
    TEST(b"\x40\x51\x4e\x44"), TEST(b"\x44\x4e\x51\x40"),
    TEST(b"\x40\x51\x4e\x4a"), TEST(b"\x4a\x4e\x51\x40"),
    TEST(b"\x40\x51\x4e\x54"), TEST(b"\x54\x4e\x51\x40"),
    TEST(b"127.0.0.1"), TEST0(b"127.0.0.1"),
    TEST(b"127.0.0.2"), TEST0(b"127.0.0.2"),
    TEST(b"127.0.0.3"), TEST0(b"127.0.0.3"),
    TEST(b"64.81.78.68"), TEST0(b"64.81.78.68"),
    TEST(b"64.81.78.74"), TEST0(b"64.81.78.74"),
    TEST(b"64.81.78.84"), TEST0(b"64.81.78.84"),
    TEST(b"feedface"), TEST0(b"feedface"),
    TEST(b"feedfacedaffdeed"), TEST0(b"feedfacedaffdeed"),
    TEST(b"feedfacedeadbeef"), TEST0(b"feedfacedeadbeef"),
    TEST(b"line 1\nline 2\nline 3"),
    TEST(b"chongo <Landon Curt Noll> /\\../\\"),
    TEST0(b"chongo <Landon Curt Noll> /\\../\\"),
    TEST(b"chongo (Landon Curt Noll) /\\../\\"),
    TEST0(b"chongo (Landon Curt Noll) /\\../\\"),
    TEST(b"http://antwrp.gsfc.nasa.gov/apod/astropix.html"),
    TEST(b"http://en.wikipedia.org/wiki/Fowler_Noll_Vo_hash"),
    TEST(b"http://epod.usra.edu/"),
    TEST(b"http://exoplanet.eu/"),
    TEST(b"http://hvo.wr.usgs.gov/cam3/"),
    TEST(b"http://hvo.wr.usgs.gov/cams/HMcam/"),
    TEST(b"http://hvo.wr.usgs.gov/kilauea/update/deformation.html"),
    TEST(b"http://hvo.wr.usgs.gov/kilauea/update/images.html"),
    TEST(b"http://hvo.wr.usgs.gov/kilauea/update/maps.html"),
    TEST(b"http://hvo.wr.usgs.gov/volcanowatch/current_issue.html"),
    TEST(b"http://neo.jpl.nasa.gov/risk/"),
    TEST(b"http://norvig.com/21-days.html"),
    TEST(b"http://primes.utm.edu/curios/home.php"),
    TEST(b"http://slashdot.org/"),
    TEST(b"http://tux.wr.usgs.gov/Maps/155.25-19.5.html"),
    TEST(b"http://volcano.wr.usgs.gov/kilaueastatus.php"),
    TEST(b"http://www.avo.alaska.edu/activity/Redoubt.php"),
    TEST(b"http://www.dilbert.com/fast/"),
    TEST(b"http://www.fourmilab.ch/gravitation/orbits/"),
    TEST(b"http://www.fpoa.net/"),
    TEST(b"http://www.ioccc.org/index.html"),
    TEST(b"http://www.isthe.com/cgi-bin/number.cgi"),
    TEST(b"http://www.isthe.com/chongo/bio.html"),
    TEST(b"http://www.isthe.com/chongo/index.html"),
    TEST(b"http://www.isthe.com/chongo/src/calc/lucas-calc"),
    TEST(b"http://www.isthe.com/chongo/tech/astro/venus2004.html"),
    TEST(b"http://www.isthe.com/chongo/tech/astro/vita.html"),
    TEST(b"http://www.isthe.com/chongo/tech/comp/c/expert.html"),
    TEST(b"http://www.isthe.com/chongo/tech/comp/calc/index.html"),
    TEST(b"http://www.isthe.com/chongo/tech/comp/fnv/index.html"),
    TEST(b"http://www.isthe.com/chongo/tech/math/number/howhigh.html"),
    TEST(b"http://www.isthe.com/chongo/tech/math/number/number.html"),
    TEST(b"http://www.isthe.com/chongo/tech/math/prime/mersenne.html"),
    TEST(b"http://www.isthe.com/chongo/tech/math/prime/mersenne.html#largest"),
    TEST(b"http://www.lavarnd.org/cgi-bin/corpspeak.cgi"),
    TEST(b"http://www.lavarnd.org/cgi-bin/haiku.cgi"),
    TEST(b"http://www.lavarnd.org/cgi-bin/rand-none.cgi"),
    TEST(b"http://www.lavarnd.org/cgi-bin/randdist.cgi"),
    TEST(b"http://www.lavarnd.org/index.html"),
    TEST(b"http://www.lavarnd.org/what/nist-test.html"),
    TEST(b"http://www.macosxhints.com/"),
    TEST(b"http://www.mellis.com/"),
    TEST(b"http://www.nature.nps.gov/air/webcams/parks/havoso2alert/havoalert.cfm"),
    TEST(b"http://www.nature.nps.gov/air/webcams/parks/havoso2alert/timelines_24.cfm"),
    TEST(b"http://www.paulnoll.com/"),
    TEST(b"http://www.pepysdiary.com/"),
    TEST(b"http://www.sciencenews.org/index/home/activity/view"),
    TEST(b"http://www.skyandtelescope.com/"),
    TEST(b"http://www.sput.nl/~rob/sirius.html"),
    TEST(b"http://www.systemexperts.com/"),
    TEST(b"http://www.tq-international.com/phpBB3/index.php"),
    TEST(b"http://www.travelquesttours.com/index.htm"),
    TEST(b"http://www.wunderground.com/global/stations/89606.html"),
    TEST(R10(b"21701")),
    TEST(R10(b"M21701")),
    TEST(R10(b"2^21701-1")),
    TEST(R10(b"\x54\xc5")),
    TEST(R10(b"\xc5\x54")),
    TEST(R10(b"23209")),
    TEST(R10(b"M23209")),
    TEST(R10(b"2^23209-1")),
    TEST(R10(b"\x5a\xa9")),
    TEST(R10(b"\xa9\x5a")),
    TEST(R10(b"391581216093")),
    TEST(R10(b"391581*2^216093-1")),
    TEST(R10(b"\x05\xf9\x9d\x03\x4c\x81")),
    TEST(R10(b"FEDCBA9876543210")),
    TEST(R10(b"\xfe\xdc\xba\x98\x76\x54\x32\x10")),
    TEST(R10(b"EFCDAB8967452301")),
    TEST(R10(b"\xef\xcd\xab\x89\x67\x45\x23\x01")),
    TEST(R10(b"0123456789ABCDEF")),
    TEST(R10(b"\x01\x23\x45\x67\x89\xab\xcd\xef")),
    TEST(R10(b"1032547698BADCFE")),
    TEST(R10(b"\x10\x32\x54\x76\x98\xba\xdc\xfe")),
    TEST(R500(b"\x00")),
    TEST(R500(b"\x07")),
    TEST(R500(b"~")),
    TEST(R500(b"\x7f")),
]

"""
FNV-0 32 bit test vectors
"""
fnv0_32_vector = {
    fnv_test_str[0]: 0x00000000,
    fnv_test_str[1]: 0x00000061,
    fnv_test_str[2]: 0x00000062,
    fnv_test_str[3]: 0x00000063,
    fnv_test_str[4]: 0x00000064,
    fnv_test_str[5]: 0x00000065,
    fnv_test_str[6]: 0x00000066,
    fnv_test_str[7]: 0x6600a0fd,
    fnv_test_str[8]: 0x8ffd6e28,
    fnv_test_str[9]: 0xd3f4689a,
    fnv_test_str[10]: 0x43c0aa0f,
    fnv_test_str[11]: 0xb74bb5ef,
    fnv_test_str[12]: 0x00000000,
    fnv_test_str[13]: 0x610098b3,
    fnv_test_str[14]: 0x62009a46,
    fnv_test_str[15]: 0x63009bd9,
    fnv_test_str[16]: 0x64009d6c,
    fnv_test_str[17]: 0x65009eff,
    fnv_test_str[18]: 0x6600a092,
    fnv_test_str[19]: 0x8ffd6e47,
    fnv_test_str[20]: 0xd3f468f8,
    fnv_test_str[21]: 0x43c0aa6e,
    fnv_test_str[22]: 0xb74bb59d,
    fnv_test_str[23]: 0x7b2f673d,
    fnv_test_str[24]: 0x63009bb1,
    fnv_test_str[25]: 0x8af517cc,
    fnv_test_str[26]: 0x8bd4764a,
    fnv_test_str[27]: 0x69763619,
    fnv_test_str[28]: 0x1e172934,
    fnv_test_str[29]: 0x9275dcfc,
    fnv_test_str[30]: 0x8b8ae0c3,
    fnv_test_str[31]: 0x6e9fd298,
    fnv_test_str[32]: 0xbd98853b,
    fnv_test_str[33]: 0xb219bbc1,
    fnv_test_str[34]: 0x1f8290bb,
    fnv_test_str[35]: 0x5589d604,
    fnv_test_str[36]: 0xabfbe83e,
    fnv_test_str[37]: 0xfb8e99ff,
    fnv_test_str[38]: 0x007c6c4c,
    fnv_test_str[39]: 0x0fde7bae,
    fnv_test_str[40]: 0x8af517a3,
    fnv_test_str[41]: 0x8bd47624,
    fnv_test_str[42]: 0x6976367e,
    fnv_test_str[43]: 0x1e17295b,
    fnv_test_str[44]: 0x9275dcdc,
    fnv_test_str[45]: 0x8b8ae0b4,
    fnv_test_str[46]: 0x6e9fd2f9,
    fnv_test_str[47]: 0xbd988548,
    fnv_test_str[48]: 0xb219bbe1,
    fnv_test_str[49]: 0x1f8290d3,
    fnv_test_str[50]: 0x5589d661,
    fnv_test_str[51]: 0xabfbe84c,
    fnv_test_str[52]: 0xfb8e999a,
    fnv_test_str[53]: 0x007c6c6d,
    fnv_test_str[54]: 0x0fde7ba4,
    fnv_test_str[55]: 0xa93cb2ea,
    fnv_test_str[56]: 0x63009bac,
    fnv_test_str[57]: 0x85f50fb6,
    fnv_test_str[58]: 0x96c7bbe6,
    fnv_test_str[59]: 0x426ccb61,
    fnv_test_str[60]: 0xf2442993,
    fnv_test_str[61]: 0xf44d7208,
    fnv_test_str[62]: 0x9dea82f6,
    fnv_test_str[63]: 0x8e2c2926,
    fnv_test_str[64]: 0xf584c6f2,
    fnv_test_str[65]: 0x72052e81,
    fnv_test_str[66]: 0xff28357b,
    fnv_test_str[67]: 0x274c30c4,
    fnv_test_str[68]: 0xa0f0c4f5,
    fnv_test_str[69]: 0x50060da5,
    fnv_test_str[70]: 0x85f50fc4,
    fnv_test_str[71]: 0x96c7bb82,
    fnv_test_str[72]: 0x426ccb12,
    fnv_test_str[73]: 0xf24429b3,
    fnv_test_str[74]: 0xf44d7269,
    fnv_test_str[75]: 0x9dea8298,
    fnv_test_str[76]: 0x8e2c2942,
    fnv_test_str[77]: 0xf584c6d2,
    fnv_test_str[78]: 0x72052ef6,
    fnv_test_str[79]: 0xff283513,
    fnv_test_str[80]: 0x274c30a1,
    fnv_test_str[81]: 0xa0f0c48c,
    fnv_test_str[82]: 0x50060daf,
    fnv_test_str[83]: 0x9e877abf,
    fnv_test_str[84]: 0x6800a3d1,
    fnv_test_str[85]: 0x8a01e203,
    fnv_test_str[86]: 0xec6d6be8,
    fnv_test_str[87]: 0x1840de38,
    fnv_test_str[88]: 0xa7cc97b4,
    fnv_test_str[89]: 0x3ee6b3b4,
    fnv_test_str[90]: 0xa7cc97b7,
    fnv_test_str[91]: 0x7dcd6669,
    fnv_test_str[92]: 0xa7cc97b6,
    fnv_test_str[93]: 0xbcb4191e,
    fnv_test_str[94]: 0xa7cc97b1,
    fnv_test_str[95]: 0xfb9acdd3,
    fnv_test_str[96]: 0x89380433,
    fnv_test_str[97]: 0x8acd2855,
    fnv_test_str[98]: 0x8938043d,
    fnv_test_str[99]: 0xcaeed493,
    fnv_test_str[100]: 0x89380423,
    fnv_test_str[101]: 0x59382a25,
    fnv_test_str[102]: 0x567f75d7,
    fnv_test_str[103]: 0x01a68175,
    fnv_test_str[104]: 0x567f75d4,
    fnv_test_str[105]: 0xfea67cbc,
    fnv_test_str[106]: 0x567f75d5,
    fnv_test_str[107]: 0xffa67e4f,
    fnv_test_str[108]: 0xd131b668,
    fnv_test_str[109]: 0xb94225b8,
    fnv_test_str[110]: 0xd231b7d7,
    fnv_test_str[111]: 0xbb446775,
    fnv_test_str[112]: 0xdf31cc6e,
    fnv_test_str[113]: 0xc964d12a,
    fnv_test_str[114]: 0x23af8f9f,
    fnv_test_str[115]: 0xcc5f174d,
    fnv_test_str[116]: 0x96b29b8c,
    fnv_test_str[117]: 0xc72add64,
    fnv_test_str[118]: 0x528fb7ef,
    fnv_test_str[119]: 0xe73e8d3d,
    fnv_test_str[120]: 0x876386fe,
    fnv_test_str[121]: 0x811c9dc5,
    fnv_test_str[122]: 0x050c5d1f,
    fnv_test_str[123]: 0x14bf7238,
    fnv_test_str[124]: 0xe160ce28,
    fnv_test_str[125]: 0x89dc5a75,
    fnv_test_str[126]: 0xd89b69a0,
    fnv_test_str[127]: 0x94471a88,
    fnv_test_str[128]: 0xe78db65f,
    fnv_test_str[129]: 0x0c3009a2,
    fnv_test_str[130]: 0x122dff03,
    fnv_test_str[131]: 0xb4cd8875,
    fnv_test_str[132]: 0xf4dba725,
    fnv_test_str[133]: 0x41a16560,
    fnv_test_str[134]: 0x9c0f941f,
    fnv_test_str[135]: 0x451a5348,
    fnv_test_str[136]: 0x3f1d1d89,
    fnv_test_str[137]: 0x1b91b57a,
    fnv_test_str[138]: 0x3e99b577,
    fnv_test_str[139]: 0x4c9de07a,
    fnv_test_str[140]: 0x1ddf7572,
    fnv_test_str[141]: 0x64e81976,
    fnv_test_str[142]: 0x1106a888,
    fnv_test_str[143]: 0xa498d8e5,
    fnv_test_str[144]: 0x3c03d2e3,
    fnv_test_str[145]: 0x26568b28,
    fnv_test_str[146]: 0x70d7fb42,
    fnv_test_str[147]: 0xd3ae1d22,
    fnv_test_str[148]: 0xac8ea5f4,
    fnv_test_str[149]: 0x4d0abd60,
    fnv_test_str[150]: 0x48f5e086,
    fnv_test_str[151]: 0xa8f6241b,
    fnv_test_str[152]: 0x572f864f,
    fnv_test_str[153]: 0xa5340803,
    fnv_test_str[154]: 0x22881aa8,
    fnv_test_str[155]: 0xc2e2f5a2,
    fnv_test_str[156]: 0xebf5aec7,
    fnv_test_str[157]: 0x3cdbfb85,
    fnv_test_str[158]: 0xbb859704,
    fnv_test_str[159]: 0xc956fe11,
    fnv_test_str[160]: 0x8f11a7c9,
    fnv_test_str[161]: 0x36c48ecf,
    fnv_test_str[162]: 0x24bfa27e,
    fnv_test_str[163]: 0xf2596ad1,
    fnv_test_str[164]: 0xf14a9b45,
    fnv_test_str[165]: 0x7d45835a,
    fnv_test_str[166]: 0x6e49334d,
    fnv_test_str[167]: 0x71767337,
    fnv_test_str[168]: 0x858a1a8a,
    fnv_test_str[169]: 0x16e75ac2,
    fnv_test_str[170]: 0x409f99df,
    fnv_test_str[171]: 0x6d6652dd,
    fnv_test_str[172]: 0x2761a9ff,
    fnv_test_str[173]: 0x41f0d616,
    fnv_test_str[174]: 0x0e2d0d0f,
    fnv_test_str[175]: 0x06adc8fd,
    fnv_test_str[176]: 0x60e0d4b9,
    fnv_test_str[177]: 0x5ddc79d3,
    fnv_test_str[178]: 0x1e6d0b46,
    fnv_test_str[179]: 0x1d1514d8,
    fnv_test_str[180]: 0xb1903a4e,
    fnv_test_str[181]: 0x8200c318,
    fnv_test_str[182]: 0x15e22888,
    fnv_test_str[183]: 0x57591760,
    fnv_test_str[184]: 0x02462efc,
    fnv_test_str[185]: 0x7651ec44,
    fnv_test_str[186]: 0x7c24e9d4,
    fnv_test_str[187]: 0x1952a034,
    fnv_test_str[188]: 0xd4c46864,
    fnv_test_str[189]: 0xcb57cde0,
    fnv_test_str[190]: 0x71136a70,
    fnv_test_str[191]: 0x0618fb40,
    fnv_test_str[192]: 0x69a24fc0,
    fnv_test_str[193]: 0x6a9be510,
    fnv_test_str[194]: 0xe0477040,
    fnv_test_str[195]: 0x85aa94b0,
    fnv_test_str[196]: 0xc6d76240,
    fnv_test_str[197]: 0xa9f09e40,
    fnv_test_str[198]: 0xa0291540,
    fnv_test_str[199]: 0x00000000,
    fnv_test_str[200]: 0x2e672aa4,
    fnv_test_str[201]: 0x84b1aa48,
    fnv_test_str[202]: 0xfc24ba24,
}

"""
FNV-1 32 bit test vectors
"""
fnv1_32_vector = {
    fnv_test_str[0]: 0x811c9dc5,
    fnv_test_str[1]: 0x050c5d7e,
    fnv_test_str[2]: 0x050c5d7d,
    fnv_test_str[3]: 0x050c5d7c,
    fnv_test_str[4]: 0x050c5d7b,
    fnv_test_str[5]: 0x050c5d7a,
    fnv_test_str[6]: 0x050c5d79,
    fnv_test_str[7]: 0x6b772514,
    fnv_test_str[8]: 0x408f5e13,
    fnv_test_str[9]: 0xb4b1178b,
    fnv_test_str[10]: 0xfdc80fb0,
    fnv_test_str[11]: 0x31f0b262,
    fnv_test_str[12]: 0x050c5d1f,
    fnv_test_str[13]: 0x70772d5a,
    fnv_test_str[14]: 0x6f772bc7,
    fnv_test_str[15]: 0x6e772a34,
    fnv_test_str[16]: 0x6d7728a1,
    fnv_test_str[17]: 0x6c77270e,
    fnv_test_str[18]: 0x6b77257b,
    fnv_test_str[19]: 0x408f5e7c,
    fnv_test_str[20]: 0xb4b117e9,
    fnv_test_str[21]: 0xfdc80fd1,
    fnv_test_str[22]: 0x31f0b210,
    fnv_test_str[23]: 0xffe8d046,
    fnv_test_str[24]: 0x6e772a5c,
    fnv_test_str[25]: 0x4197aebb,
    fnv_test_str[26]: 0xfcc8100f,
    fnv_test_str[27]: 0xfdf147fa,
    fnv_test_str[28]: 0xbcd44ee1,
    fnv_test_str[29]: 0x23382c13,
    fnv_test_str[30]: 0x846d619e,
    fnv_test_str[31]: 0x1630abdb,
    fnv_test_str[32]: 0xc99e89b2,
    fnv_test_str[33]: 0x1692c316,
    fnv_test_str[34]: 0x9f091bca,
    fnv_test_str[35]: 0x2556be9b,
    fnv_test_str[36]: 0x628e0e73,
    fnv_test_str[37]: 0x98a0bf6c,
    fnv_test_str[38]: 0xb10d5725,
    fnv_test_str[39]: 0xdd002f35,
    fnv_test_str[40]: 0x4197aed4,
    fnv_test_str[41]: 0xfcc81061,
    fnv_test_str[42]: 0xfdf1479d,
    fnv_test_str[43]: 0xbcd44e8e,
    fnv_test_str[44]: 0x23382c33,
    fnv_test_str[45]: 0x846d61e9,
    fnv_test_str[46]: 0x1630abba,
    fnv_test_str[47]: 0xc99e89c1,
    fnv_test_str[48]: 0x1692c336,
    fnv_test_str[49]: 0x9f091ba2,
    fnv_test_str[50]: 0x2556befe,
    fnv_test_str[51]: 0x628e0e01,
    fnv_test_str[52]: 0x98a0bf09,
    fnv_test_str[53]: 0xb10d5704,
    fnv_test_str[54]: 0xdd002f3f,
    fnv_test_str[55]: 0x1c4a506f,
    fnv_test_str[56]: 0x6e772a41,
    fnv_test_str[57]: 0x26978421,
    fnv_test_str[58]: 0xe184ff97,
    fnv_test_str[59]: 0x9b5e5ac6,
    fnv_test_str[60]: 0x5b88e592,
    fnv_test_str[61]: 0xaa8164b7,
    fnv_test_str[62]: 0x20b18c7b,
    fnv_test_str[63]: 0xf28025c5,
    fnv_test_str[64]: 0x84bb753f,
    fnv_test_str[65]: 0x3219925a,
    fnv_test_str[66]: 0x384163c6,
    fnv_test_str[67]: 0x54f010d7,
    fnv_test_str[68]: 0x8cea820c,
    fnv_test_str[69]: 0xe12ab8ee,
    fnv_test_str[70]: 0x26978453,
    fnv_test_str[71]: 0xe184fff3,
    fnv_test_str[72]: 0x9b5e5ab5,
    fnv_test_str[73]: 0x5b88e5b2,
    fnv_test_str[74]: 0xaa8164d6,
    fnv_test_str[75]: 0x20b18c15,
    fnv_test_str[76]: 0xf28025a1,
    fnv_test_str[77]: 0x84bb751f,
    fnv_test_str[78]: 0x3219922d,
    fnv_test_str[79]: 0x384163ae,
    fnv_test_str[80]: 0x54f010b2,
    fnv_test_str[81]: 0x8cea8275,
    fnv_test_str[82]: 0xe12ab8e4,
    fnv_test_str[83]: 0x64411eaa,
    fnv_test_str[84]: 0x6977223c,
    fnv_test_str[85]: 0x428ae474,
    fnv_test_str[86]: 0xb6fa7167,
    fnv_test_str[87]: 0x73408525,
    fnv_test_str[88]: 0xb78320a1,
    fnv_test_str[89]: 0x0caf4135,
    fnv_test_str[90]: 0xb78320a2,
    fnv_test_str[91]: 0xcdc88e80,
    fnv_test_str[92]: 0xb78320a3,
    fnv_test_str[93]: 0x8ee1dbcb,
    fnv_test_str[94]: 0xb78320a4,
    fnv_test_str[95]: 0x4ffb2716,
    fnv_test_str[96]: 0x860632aa,
    fnv_test_str[97]: 0xcc2c5c64,
    fnv_test_str[98]: 0x860632a4,
    fnv_test_str[99]: 0x2a7ec4a6,
    fnv_test_str[100]: 0x860632ba,
    fnv_test_str[101]: 0xfefe8e14,
    fnv_test_str[102]: 0x0a3cffd8,
    fnv_test_str[103]: 0xf606c108,
    fnv_test_str[104]: 0x0a3cffdb,
    fnv_test_str[105]: 0xf906c5c1,
    fnv_test_str[106]: 0x0a3cffda,
    fnv_test_str[107]: 0xf806c42e,
    fnv_test_str[108]: 0xc07167d7,
    fnv_test_str[109]: 0xc9867775,
    fnv_test_str[110]: 0xbf716668,
    fnv_test_str[111]: 0xc78435b8,
    fnv_test_str[112]: 0xc6717155,
    fnv_test_str[113]: 0xb99568cf,
    fnv_test_str[114]: 0x7662e0d6,
    fnv_test_str[115]: 0x33a7f0e2,
    fnv_test_str[116]: 0xc2732f95,
    fnv_test_str[117]: 0xb053e78f,
    fnv_test_str[118]: 0x3a19c02a,
    fnv_test_str[119]: 0xa089821e,
    fnv_test_str[120]: 0x31ae8f83,
    fnv_test_str[121]: 0x995fa9c4,
    fnv_test_str[122]: 0x35983f8c,
    fnv_test_str[123]: 0x5036a251,
    fnv_test_str[124]: 0x97018583,
    fnv_test_str[125]: 0xb4448d60,
    fnv_test_str[126]: 0x025dfe59,
    fnv_test_str[127]: 0xc5eab3af,
    fnv_test_str[128]: 0x7d21ba1e,
    fnv_test_str[129]: 0x7704cddb,
    fnv_test_str[130]: 0xd0071bfe,
    fnv_test_str[131]: 0x0ff3774c,
    fnv_test_str[132]: 0xb0fea0ea,
    fnv_test_str[133]: 0x58177303,
    fnv_test_str[134]: 0x4f599cda,
    fnv_test_str[135]: 0x3e590a47,
    fnv_test_str[136]: 0x965595f8,
    fnv_test_str[137]: 0xc37f178d,
    fnv_test_str[138]: 0x9711dd26,
    fnv_test_str[139]: 0x23c99b7f,
    fnv_test_str[140]: 0x6e568b17,
    fnv_test_str[141]: 0x43f0245b,
    fnv_test_str[142]: 0xbcb7a001,
    fnv_test_str[143]: 0x12e6dffe,
    fnv_test_str[144]: 0x0792f2d6,
    fnv_test_str[145]: 0xb966936b,
    fnv_test_str[146]: 0x46439ac5,
    fnv_test_str[147]: 0x728d49af,
    fnv_test_str[148]: 0xd33745c9,
    fnv_test_str[149]: 0xbc382a57,
    fnv_test_str[150]: 0x4bda1d31,
    fnv_test_str[151]: 0xce35ccae,
    fnv_test_str[152]: 0x3b6eed94,
    fnv_test_str[153]: 0x445c9c58,
    fnv_test_str[154]: 0x3db8bf9d,
    fnv_test_str[155]: 0x2dee116d,
    fnv_test_str[156]: 0xc18738da,
    fnv_test_str[157]: 0x5b156176,
    fnv_test_str[158]: 0x2aa7d593,
    fnv_test_str[159]: 0xb2409658,
    fnv_test_str[160]: 0xe1489528,
    fnv_test_str[161]: 0xfe1ee07e,
    fnv_test_str[162]: 0xe8842315,
    fnv_test_str[163]: 0x3a6a63a2,
    fnv_test_str[164]: 0x06d2c18c,
    fnv_test_str[165]: 0xf8ef7225,
    fnv_test_str[166]: 0x843d3300,
    fnv_test_str[167]: 0xbb24f7ae,
    fnv_test_str[168]: 0x878c0ec9,
    fnv_test_str[169]: 0xb557810f,
    fnv_test_str[170]: 0x57423246,
    fnv_test_str[171]: 0x87f7505e,
    fnv_test_str[172]: 0xbb809f20,
    fnv_test_str[173]: 0x8932abb5,
    fnv_test_str[174]: 0x0a9b3aa0,
    fnv_test_str[175]: 0xb8682a24,
    fnv_test_str[176]: 0xa7ac1c56,
    fnv_test_str[177]: 0x11409252,
    fnv_test_str[178]: 0xa987f517,
    fnv_test_str[179]: 0xf309e7ed,
    fnv_test_str[180]: 0xc9e8f417,
    fnv_test_str[181]: 0x7f447bdd,
    fnv_test_str[182]: 0xb929adc5,
    fnv_test_str[183]: 0x57022879,
    fnv_test_str[184]: 0xdcfd2c49,
    fnv_test_str[185]: 0x6edafff5,
    fnv_test_str[186]: 0xf04fb1f1,
    fnv_test_str[187]: 0xfb7de8b9,
    fnv_test_str[188]: 0xc5f1d7e9,
    fnv_test_str[189]: 0x32c1f439,
    fnv_test_str[190]: 0x7fd3eb7d,
    fnv_test_str[191]: 0x81597da5,
    fnv_test_str[192]: 0x05eb7a25,
    fnv_test_str[193]: 0x9c0fa1b5,
    fnv_test_str[194]: 0x53ccb1c5,
    fnv_test_str[195]: 0xfabece15,
    fnv_test_str[196]: 0x4ad745a5,
    fnv_test_str[197]: 0xe5bdc495,
    fnv_test_str[198]: 0x23b3c0a5,
    fnv_test_str[199]: 0xfa823dd5,
    fnv_test_str[200]: 0x0c6c58b9,
    fnv_test_str[201]: 0xe2dbccd5,
    fnv_test_str[202]: 0xdb7f50f9,
}

"""
FNV-1a 32 bit test vectors
"""
fnv1a_32_vector = {
    fnv_test_str[0]: 0x811c9dc5,
    fnv_test_str[1]: 0xe40c292c,
    fnv_test_str[2]: 0xe70c2de5,
    fnv_test_str[3]: 0xe60c2c52,
    fnv_test_str[4]: 0xe10c2473,
    fnv_test_str[5]: 0xe00c22e0,
    fnv_test_str[6]: 0xe30c2799,
    fnv_test_str[7]: 0x6222e842,
    fnv_test_str[8]: 0xa9f37ed7,
    fnv_test_str[9]: 0x3f5076ef,
    fnv_test_str[10]: 0x39aaa18a,
    fnv_test_str[11]: 0xbf9cf968,
    fnv_test_str[12]: 0x050c5d1f,
    fnv_test_str[13]: 0x2b24d044,
    fnv_test_str[14]: 0x9d2c3f7f,
    fnv_test_str[15]: 0x7729c516,
    fnv_test_str[16]: 0xb91d6109,
    fnv_test_str[17]: 0x931ae6a0,
    fnv_test_str[18]: 0x052255db,
    fnv_test_str[19]: 0xbef39fe6,
    fnv_test_str[20]: 0x6150ac75,
    fnv_test_str[21]: 0x9aab3a3d,
    fnv_test_str[22]: 0x519c4c3e,
    fnv_test_str[23]: 0x0c1c9eb8,
    fnv_test_str[24]: 0x5f299f4e,
    fnv_test_str[25]: 0xef8580f3,
    fnv_test_str[26]: 0xac297727,
    fnv_test_str[27]: 0x4546b9c0,
    fnv_test_str[28]: 0xbd564e7d,
    fnv_test_str[29]: 0x6bdd5c67,
    fnv_test_str[30]: 0xdd77ed30,
    fnv_test_str[31]: 0xf4ca9683,
    fnv_test_str[32]: 0x4aeb9bd0,
    fnv_test_str[33]: 0xe0e67ad0,
    fnv_test_str[34]: 0xc2d32fa8,
    fnv_test_str[35]: 0x7f743fb7,
    fnv_test_str[36]: 0x6900631f,
    fnv_test_str[37]: 0xc59c990e,
    fnv_test_str[38]: 0x448524fd,
    fnv_test_str[39]: 0xd49930d5,
    fnv_test_str[40]: 0x1c85c7ca,
    fnv_test_str[41]: 0x0229fe89,
    fnv_test_str[42]: 0x2c469265,
    fnv_test_str[43]: 0xce566940,
    fnv_test_str[44]: 0x8bdd8ec7,
    fnv_test_str[45]: 0x34787625,
    fnv_test_str[46]: 0xd3ca6290,
    fnv_test_str[47]: 0xddeaf039,
    fnv_test_str[48]: 0xc0e64870,
    fnv_test_str[49]: 0xdad35570,
    fnv_test_str[50]: 0x5a740578,
    fnv_test_str[51]: 0x5b004d15,
    fnv_test_str[52]: 0x6a9c09cd,
    fnv_test_str[53]: 0x2384f10a,
    fnv_test_str[54]: 0xda993a47,
    fnv_test_str[55]: 0x8227df4f,
    fnv_test_str[56]: 0x4c298165,
    fnv_test_str[57]: 0xfc563735,
    fnv_test_str[58]: 0x8cb91483,
    fnv_test_str[59]: 0x775bf5d0,
    fnv_test_str[60]: 0xd5c428d0,
    fnv_test_str[61]: 0x34cc0ea3,
    fnv_test_str[62]: 0xea3b4cb7,
    fnv_test_str[63]: 0x8e59f029,
    fnv_test_str[64]: 0x2094de2b,
    fnv_test_str[65]: 0xa65a0ad4,
    fnv_test_str[66]: 0x9bbee5f4,
    fnv_test_str[67]: 0xbe836343,
    fnv_test_str[68]: 0x22d5344e,
    fnv_test_str[69]: 0x19a1470c,
    fnv_test_str[70]: 0x4a56b1ff,
    fnv_test_str[71]: 0x70b8e86f,
    fnv_test_str[72]: 0x0a5b4a39,
    fnv_test_str[73]: 0xb5c3f670,
    fnv_test_str[74]: 0x53cc3f70,
    fnv_test_str[75]: 0xc03b0a99,
    fnv_test_str[76]: 0x7259c415,
    fnv_test_str[77]: 0x4095108b,
    fnv_test_str[78]: 0x7559bdb1,
    fnv_test_str[79]: 0xb3bf0bbc,
    fnv_test_str[80]: 0x2183ff1c,
    fnv_test_str[81]: 0x2bd54279,
    fnv_test_str[82]: 0x23a156ca,
    fnv_test_str[83]: 0x64e2d7e4,
    fnv_test_str[84]: 0x683af69a,
    fnv_test_str[85]: 0xaed2346e,
    fnv_test_str[86]: 0x4f9f2cab,
    fnv_test_str[87]: 0x02935131,
    fnv_test_str[88]: 0xc48fb86d,
    fnv_test_str[89]: 0x2269f369,
    fnv_test_str[90]: 0xc18fb3b4,
    fnv_test_str[91]: 0x50ef1236,
    fnv_test_str[92]: 0xc28fb547,
    fnv_test_str[93]: 0x96c3bf47,
    fnv_test_str[94]: 0xbf8fb08e,
    fnv_test_str[95]: 0xf3e4d49c,
    fnv_test_str[96]: 0x32179058,
    fnv_test_str[97]: 0x280bfee6,
    fnv_test_str[98]: 0x30178d32,
    fnv_test_str[99]: 0x21addaf8,
    fnv_test_str[100]: 0x4217a988,
    fnv_test_str[101]: 0x772633d6,
    fnv_test_str[102]: 0x08a3d11e,
    fnv_test_str[103]: 0xb7e2323a,
    fnv_test_str[104]: 0x07a3cf8b,
    fnv_test_str[105]: 0x91dfb7d1,
    fnv_test_str[106]: 0x06a3cdf8,
    fnv_test_str[107]: 0x6bdd3d68,
    fnv_test_str[108]: 0x1d5636a7,
    fnv_test_str[109]: 0xd5b808e5,
    fnv_test_str[110]: 0x1353e852,
    fnv_test_str[111]: 0xbf16b916,
    fnv_test_str[112]: 0xa55b89ed,
    fnv_test_str[113]: 0x3c1a2017,
    fnv_test_str[114]: 0x0588b13c,
    fnv_test_str[115]: 0xf22f0174,
    fnv_test_str[116]: 0xe83641e1,
    fnv_test_str[117]: 0x6e69b533,
    fnv_test_str[118]: 0xf1760448,
    fnv_test_str[119]: 0x64c8bd58,
    fnv_test_str[120]: 0x97b4ea23,
    fnv_test_str[121]: 0x9a4e92e6,
    fnv_test_str[122]: 0xcfb14012,
    fnv_test_str[123]: 0xf01b2511,
    fnv_test_str[124]: 0x0bbb59c3,
    fnv_test_str[125]: 0xce524afa,
    fnv_test_str[126]: 0xdd16ef45,
    fnv_test_str[127]: 0x60648bb3,
    fnv_test_str[128]: 0x7fa4bcfc,
    fnv_test_str[129]: 0x5053ae17,
    fnv_test_str[130]: 0xc9302890,
    fnv_test_str[131]: 0x956ded32,
    fnv_test_str[132]: 0x9136db84,
    fnv_test_str[133]: 0xdf9d3323,
    fnv_test_str[134]: 0x32bb6cd0,
    fnv_test_str[135]: 0xc8f8385b,
    fnv_test_str[136]: 0xeb08bfba,
    fnv_test_str[137]: 0x62cc8e3d,
    fnv_test_str[138]: 0xc3e20f5c,
    fnv_test_str[139]: 0x39e97f17,
    fnv_test_str[140]: 0x7837b203,
    fnv_test_str[141]: 0x319e877b,
    fnv_test_str[142]: 0xd3e63f89,
    fnv_test_str[143]: 0x29b50b38,
    fnv_test_str[144]: 0x5ed678b8,
    fnv_test_str[145]: 0xb0d5b793,
    fnv_test_str[146]: 0x52450be5,
    fnv_test_str[147]: 0xfa72d767,
    fnv_test_str[148]: 0x95066709,
    fnv_test_str[149]: 0x7f52e123,
    fnv_test_str[150]: 0x76966481,
    fnv_test_str[151]: 0x063258b0,
    fnv_test_str[152]: 0x2ded6e8a,
    fnv_test_str[153]: 0xb07d7c52,
    fnv_test_str[154]: 0xd0c71b71,
    fnv_test_str[155]: 0xf684f1bd,
    fnv_test_str[156]: 0x868ecfa8,
    fnv_test_str[157]: 0xf794f684,
    fnv_test_str[158]: 0xd19701c3,
    fnv_test_str[159]: 0x346e171e,
    fnv_test_str[160]: 0x91f8f676,
    fnv_test_str[161]: 0x0bf58848,
    fnv_test_str[162]: 0x6317b6d1,
    fnv_test_str[163]: 0xafad4c54,
    fnv_test_str[164]: 0x0f25681e,
    fnv_test_str[165]: 0x91b18d49,
    fnv_test_str[166]: 0x7d61c12e,
    fnv_test_str[167]: 0x5147d25c,
    fnv_test_str[168]: 0x9a8b6805,
    fnv_test_str[169]: 0x4cd2a447,
    fnv_test_str[170]: 0x1e549b14,
    fnv_test_str[171]: 0x2fe1b574,
    fnv_test_str[172]: 0xcf0cd31e,
    fnv_test_str[173]: 0x6c471669,
    fnv_test_str[174]: 0x0e5eef1e,
    fnv_test_str[175]: 0x2bed3602,
    fnv_test_str[176]: 0xb26249e0,
    fnv_test_str[177]: 0x2c9b86a4,
    fnv_test_str[178]: 0xe415e2bb,
    fnv_test_str[179]: 0x18a98d1d,
    fnv_test_str[180]: 0xb7df8b7b,
    fnv_test_str[181]: 0x241e9075,
    fnv_test_str[182]: 0x063f70dd,
    fnv_test_str[183]: 0x0295aed9,
    fnv_test_str[184]: 0x56a7f781,
    fnv_test_str[185]: 0x253bc645,
    fnv_test_str[186]: 0x46610921,
    fnv_test_str[187]: 0x7c1577f9,
    fnv_test_str[188]: 0x512b2851,
    fnv_test_str[189]: 0x76823999,
    fnv_test_str[190]: 0xc0586935,
    fnv_test_str[191]: 0xf3415c85,
    fnv_test_str[192]: 0x0ae4ff65,
    fnv_test_str[193]: 0x58b79725,
    fnv_test_str[194]: 0xdea43aa5,
    fnv_test_str[195]: 0x2bb3be35,
    fnv_test_str[196]: 0xea777a45,
    fnv_test_str[197]: 0x8f21c305,
    fnv_test_str[198]: 0x5c9d0865,
    fnv_test_str[199]: 0xfa823dd5,
    fnv_test_str[200]: 0x21a27271,
    fnv_test_str[201]: 0x83c5c6d5,
    fnv_test_str[202]: 0x813b0881,
}

"""
FNV-0 64 bit test vectors
"""
fnv0_64_vector = {
    fnv_test_str[0]: 0x0000000000000000,
    fnv_test_str[1]: 0x0000000000000061,
    fnv_test_str[2]: 0x0000000000000062,
    fnv_test_str[3]: 0x0000000000000063,
    fnv_test_str[4]: 0x0000000000000064,
    fnv_test_str[5]: 0x0000000000000065,
    fnv_test_str[6]: 0x0000000000000066,
    fnv_test_str[7]: 0x000066000000ad3d,
    fnv_test_str[8]: 0x015a8f0001265ec8,
    fnv_test_str[9]: 0x733fc501f4330dba,
    fnv_test_str[10]: 0x08697c51f2c0536f,
    fnv_test_str[11]: 0x0b91ae3f7ccdc5ef,
    fnv_test_str[12]: 0x0000000000000000,
    fnv_test_str[13]: 0x000061000000a4d3,
    fnv_test_str[14]: 0x000062000000a686,
    fnv_test_str[15]: 0x000063000000a839,
    fnv_test_str[16]: 0x000064000000a9ec,
    fnv_test_str[17]: 0x000065000000ab9f,
    fnv_test_str[18]: 0x000066000000ad52,
    fnv_test_str[19]: 0x015a8f0001265ea7,
    fnv_test_str[20]: 0x733fc501f4330dd8,
    fnv_test_str[21]: 0x08697c51f2c0530e,
    fnv_test_str[22]: 0x0b91ae3f7ccdc59d,
    fnv_test_str[23]: 0x765104e111a7551d,
    fnv_test_str[24]: 0x000063000000a851,
    fnv_test_str[25]: 0x01508a00011e01cc,
    fnv_test_str[26]: 0x59dc4a01e5fd0dca,
    fnv_test_str[27]: 0xae5f8b39ccfe6e59,
    fnv_test_str[28]: 0x4ac7ec3754558154,
    fnv_test_str[29]: 0x6737b6044d4ac19c,
    fnv_test_str[30]: 0xae6be54f5606fc63,
    fnv_test_str[31]: 0x685308cf2ddedc58,
    fnv_test_str[32]: 0x23f4500af1b069fb,
    fnv_test_str[33]: 0xc88dfd98aec415a1,
    fnv_test_str[34]: 0x8d5b8b70f730c0fb,
    fnv_test_str[35]: 0x634eebf407d7eae4,
    fnv_test_str[36]: 0x9705d3a953e4211e,
    fnv_test_str[37]: 0x8307c6b98ca4459f,
    fnv_test_str[38]: 0x4a7c4c49fb224d0c,
    fnv_test_str[39]: 0xb382adb5bb48eb6e,
    fnv_test_str[40]: 0x01508a00011e01a3,
    fnv_test_str[41]: 0x59dc4a01e5fd0da4,
    fnv_test_str[42]: 0xae5f8b39ccfe6e3e,
    fnv_test_str[43]: 0x4ac7ec375455813b,
    fnv_test_str[44]: 0x6737b6044d4ac1bc,
    fnv_test_str[45]: 0xae6be54f5606fc14,
    fnv_test_str[46]: 0x685308cf2ddedc39,
    fnv_test_str[47]: 0x23f4500af1b06988,
    fnv_test_str[48]: 0xc88dfd98aec41581,
    fnv_test_str[49]: 0x8d5b8b70f730c093,
    fnv_test_str[50]: 0x634eebf407d7ea81,
    fnv_test_str[51]: 0x9705d3a953e4216c,
    fnv_test_str[52]: 0x8307c6b98ca445fa,
    fnv_test_str[53]: 0x4a7c4c49fb224d2d,
    fnv_test_str[54]: 0xb382adb5bb48eb64,
    fnv_test_str[55]: 0x4ff899cd3ce80bea,
    fnv_test_str[56]: 0x000063000000a84c,
    fnv_test_str[57]: 0x01508500011df956,
    fnv_test_str[58]: 0x59cb5501e5eead46,
    fnv_test_str[59]: 0x832eb839b4906d81,
    fnv_test_str[60]: 0x78d08b0dd16a1213,
    fnv_test_str[61]: 0xb46e5b7ad73cb628,
    fnv_test_str[62]: 0xd43b99bbbc298596,
    fnv_test_str[63]: 0xcacbd000ba8dfd86,
    fnv_test_str[64]: 0x264ff73cff45ca92,
    fnv_test_str[65]: 0x5fabaea5c3973661,
    fnv_test_str[66]: 0x27f024ab59f166bb,
    fnv_test_str[67]: 0xce750a29d5318fa4,
    fnv_test_str[68]: 0x026fe915433713d5,
    fnv_test_str[69]: 0x5b3ce4213696b2e5,
    fnv_test_str[70]: 0x01508500011df924,
    fnv_test_str[71]: 0x59cb5501e5eead22,
    fnv_test_str[72]: 0x832eb839b4906df2,
    fnv_test_str[73]: 0x78d08b0dd16a1233,
    fnv_test_str[74]: 0xb46e5b7ad73cb649,
    fnv_test_str[75]: 0xd43b99bbbc2985f8,
    fnv_test_str[76]: 0xcacbd000ba8dfde2,
    fnv_test_str[77]: 0x264ff73cff45cab2,
    fnv_test_str[78]: 0x5fabaea5c3973616,
    fnv_test_str[79]: 0x27f024ab59f166d3,
    fnv_test_str[80]: 0xce750a29d5318fc1,
    fnv_test_str[81]: 0x026fe915433713ac,
    fnv_test_str[82]: 0x5b3ce4213696b2ef,
    fnv_test_str[83]: 0x9f2a896fc211fb1f,
    fnv_test_str[84]: 0x000068000000b0d1,
    fnv_test_str[85]: 0x01618900012c7323,
    fnv_test_str[86]: 0x3fa86e63bc7d03c8,
    fnv_test_str[87]: 0xa8375b79486d6cd8,
    fnv_test_str[88]: 0xa0d18504e316ac54,
    fnv_test_str[89]: 0x08a97b0004e7fe54,
    fnv_test_str[90]: 0xa0d18504e316ac57,
    fnv_test_str[91]: 0x1152f60009cffda9,
    fnv_test_str[92]: 0xa0d18504e316ac56,
    fnv_test_str[93]: 0x19fc71000eb7fcfe,
    fnv_test_str[94]: 0xa0d18504e316ac51,
    fnv_test_str[95]: 0x22a5ec00139ffa53,
    fnv_test_str[96]: 0x29bed00139779a33,
    fnv_test_str[97]: 0x4dbc81014e3c19f5,
    fnv_test_str[98]: 0x29bed00139779a3d,
    fnv_test_str[99]: 0x81a72b016b9f7573,
    fnv_test_str[100]: 0x29bed00139779a23,
    fnv_test_str[101]: 0xd85411019cbbce45,
    fnv_test_str[102]: 0xf548616b8621d657,
    fnv_test_str[103]: 0xebd3e0b4eb7f35d5,
    fnv_test_str[104]: 0xf548616b8621d654,
    fnv_test_str[105]: 0xebd3ddb4eb7f30bc,
    fnv_test_str[106]: 0xf548616b8621d655,
    fnv_test_str[107]: 0xebd3deb4eb7f326f,
    fnv_test_str[108]: 0x581cb60340ab0968,
    fnv_test_str[109]: 0x63d2af86e2a0fbb8,
    fnv_test_str[110]: 0x581cb70340ab0b37,
    fnv_test_str[111]: 0x63d63186e2a40e75,
    fnv_test_str[112]: 0x581cc40340ab212e,
    fnv_test_str[113]: 0x64023f86e2c9612a,
    fnv_test_str[114]: 0xdbda6a26c33c909f,
    fnv_test_str[115]: 0xd0b2feddbfe9be2d,
    fnv_test_str[116]: 0x9c9eae3f5d037dec,
    fnv_test_str[117]: 0x252001ab0ceef804,
    fnv_test_str[118]: 0x4456a56f9e05cfef,
    fnv_test_str[119]: 0x250b0ba983e0531d,
    fnv_test_str[120]: 0x52b007213b27b33e,
    fnv_test_str[121]: 0xcbf29ce484222325,
    fnv_test_str[122]: 0xaf63bd4c8601b7df,
    fnv_test_str[123]: 0x128599ccddae09f8,
    fnv_test_str[124]: 0x270e4f1caebaf068,
    fnv_test_str[125]: 0x01517d497446a395,
    fnv_test_str[126]: 0x9af5a29a89450b40,
    fnv_test_str[127]: 0xb502f6c063ba72e8,
    fnv_test_str[128]: 0xacf41561498ca7df,
    fnv_test_str[129]: 0x6be8c2423a351542,
    fnv_test_str[130]: 0xd04f1f6da96ce4a3,
    fnv_test_str[131]: 0x69eb9a8f282c7235,
    fnv_test_str[132]: 0x6a7e5a418f77cfc5,
    fnv_test_str[133]: 0xbcaf568ddc2ecba0,
    fnv_test_str[134]: 0xb03b5cc4c38f8b1f,
    fnv_test_str[135]: 0xf89a9f51432db828,
    fnv_test_str[136]: 0x549e856be6103429,
    fnv_test_str[137]: 0x3cf50d224d29377a,
    fnv_test_str[138]: 0xdb762df418c10c37,
    fnv_test_str[139]: 0xfeeb4226b0e9a6ba,
    fnv_test_str[140]: 0x7004a4cd9310c052,
    fnv_test_str[141]: 0xd1c727d7f5329276,
    fnv_test_str[142]: 0xbe313796596ce908,
    fnv_test_str[143]: 0x768f67ede090fcc5,
    fnv_test_str[144]: 0xa81563cc9db9bfc3,
    fnv_test_str[145]: 0x47194043c55197a8,
    fnv_test_str[146]: 0xc99d81864aebab02,
    fnv_test_str[147]: 0xcc1f161b235ea4a2,
    fnv_test_str[148]: 0xaadab0c420ecd434,
    fnv_test_str[149]: 0x6b3c034d6f44d740,
    fnv_test_str[150]: 0x73a45e850602cbc6,
    fnv_test_str[151]: 0x72360f04f0cd227b,
    fnv_test_str[152]: 0xa9ca80be384a778f,
    fnv_test_str[153]: 0xd4085e66906889e3,
    fnv_test_str[154]: 0x93aa8b2748efdbc8,
    fnv_test_str[155]: 0x6f8cd678407436a2,
    fnv_test_str[156]: 0xf39a43d4dc8be4c7,
    fnv_test_str[157]: 0xd7f5cec91125d245,
    fnv_test_str[158]: 0x691d7b73be18adc4,
    fnv_test_str[159]: 0xf4361e01caf6b691,
    fnv_test_str[160]: 0xde7d8264f64be089,
    fnv_test_str[161]: 0xa34ff43e5545c06f,
    fnv_test_str[162]: 0x181f0b8e908a2bde,
    fnv_test_str[163]: 0x28a965b78ddbc071,
    fnv_test_str[164]: 0xead9cea0e3cc6ae5,
    fnv_test_str[165]: 0x0b6743153b43ebba,
    fnv_test_str[166]: 0xa7aa3f012c74528d,
    fnv_test_str[167]: 0x2d5d8ad7f9dffeb7,
    fnv_test_str[168]: 0x00750fb6e19624ea,
    fnv_test_str[169]: 0x01c125a4e6c76c82,
    fnv_test_str[170]: 0x3fde3afac0722f1f,
    fnv_test_str[171]: 0xd7c3eaf4abaa379d,
    fnv_test_str[172]: 0xd2217e1c923c9f3f,
    fnv_test_str[173]: 0x82d0a2e3b725caf6,
    fnv_test_str[174]: 0x0a10bee8eeb72e4f,
    fnv_test_str[175]: 0xc530e8723e72c6fd,
    fnv_test_str[176]: 0xd8d34dcd2e7bad99,
    fnv_test_str[177]: 0xecf77466e9a2baf3,
    fnv_test_str[178]: 0xde3d2ddb043b9666,
    fnv_test_str[179]: 0xd1cc824e1a8157d8,
    fnv_test_str[180]: 0x7d5c68ecbc90512e,
    fnv_test_str[181]: 0x2f7c691b1d7c76d8,
    fnv_test_str[182]: 0x5d88c2bad3a46bc8,
    fnv_test_str[183]: 0xdf107320276647a0,
    fnv_test_str[184]: 0x0f78f22e7e70e9bc,
    fnv_test_str[185]: 0x8c67be5c80f67d04,
    fnv_test_str[186]: 0x07c1adfa4d019194,
    fnv_test_str[187]: 0xce1312420c5b1af4,
    fnv_test_str[188]: 0x043a41b2dc53ab24,
    fnv_test_str[189]: 0x0b038eebf7340860,
    fnv_test_str[190]: 0x1bcd837353fb69b0,
    fnv_test_str[191]: 0x46f992fc59eff180,
    fnv_test_str[192]: 0x497678ee29ae79c0,
    fnv_test_str[193]: 0xb10a62280ddd4450,
    fnv_test_str[194]: 0x35eb228db4d68140,
    fnv_test_str[195]: 0x8b350e86d9470870,
    fnv_test_str[196]: 0x4e1fbdb2812e9540,
    fnv_test_str[197]: 0x051e080df69a0600,
    fnv_test_str[198]: 0x45e1e8ae54dadb40,
    fnv_test_str[199]: 0x0000000000000000,
    fnv_test_str[200]: 0xcd73806290557064,
    fnv_test_str[201]: 0x2613a37bbe0317c8,
    fnv_test_str[202]: 0x1480e21fcf2ae5e4,
}

"""
FNV-1 64 bit test vectors
"""
fnv1_64_vector = {
    fnv_test_str[0]: 0xcbf29ce484222325,
    fnv_test_str[1]: 0xaf63bd4c8601b7be,
    fnv_test_str[2]: 0xaf63bd4c8601b7bd,
    fnv_test_str[3]: 0xaf63bd4c8601b7bc,
    fnv_test_str[4]: 0xaf63bd4c8601b7bb,
    fnv_test_str[5]: 0xaf63bd4c8601b7ba,
    fnv_test_str[6]: 0xaf63bd4c8601b7b9,
    fnv_test_str[7]: 0x08326207b4eb2f34,
    fnv_test_str[8]: 0xd8cbc7186ba13533,
    fnv_test_str[9]: 0x0378817ee2ed65cb,
    fnv_test_str[10]: 0xd329d59b9963f790,
    fnv_test_str[11]: 0x340d8765a4dda9c2,
    fnv_test_str[12]: 0xaf63bd4c8601b7df,
    fnv_test_str[13]: 0x08326707b4eb37da,
    fnv_test_str[14]: 0x08326607b4eb3627,
    fnv_test_str[15]: 0x08326507b4eb3474,
    fnv_test_str[16]: 0x08326407b4eb32c1,
    fnv_test_str[17]: 0x08326307b4eb310e,
    fnv_test_str[18]: 0x08326207b4eb2f5b,
    fnv_test_str[19]: 0xd8cbc7186ba1355c,
    fnv_test_str[20]: 0x0378817ee2ed65a9,
    fnv_test_str[21]: 0xd329d59b9963f7f1,
    fnv_test_str[22]: 0x340d8765a4dda9b0,
    fnv_test_str[23]: 0x50a6d3b724a774a6,
    fnv_test_str[24]: 0x08326507b4eb341c,
    fnv_test_str[25]: 0xd8d5c8186ba98bfb,
    fnv_test_str[26]: 0x1ccefc7ef118dbef,
    fnv_test_str[27]: 0x0c92fab3ad3db77a,
    fnv_test_str[28]: 0x9b77794f5fdec421,
    fnv_test_str[29]: 0x0ac742dfe7874433,
    fnv_test_str[30]: 0xd7dad5766ad8e2de,
    fnv_test_str[31]: 0xa1bb96378e897f5b,
    fnv_test_str[32]: 0x5b3f9b6733a367d2,
    fnv_test_str[33]: 0xb07ce25cbea969f6,
    fnv_test_str[34]: 0x8d9e9997f9df0d6a,
    fnv_test_str[35]: 0x838c673d9603cb7b,
    fnv_test_str[36]: 0x8b5ee8a5e872c273,
    fnv_test_str[37]: 0x4507c4e9fb00690c,
    fnv_test_str[38]: 0x4c9ca59581b27f45,
    fnv_test_str[39]: 0xe0aca20b624e4235,
    fnv_test_str[40]: 0xd8d5c8186ba98b94,
    fnv_test_str[41]: 0x1ccefc7ef118db81,
    fnv_test_str[42]: 0x0c92fab3ad3db71d,
    fnv_test_str[43]: 0x9b77794f5fdec44e,
    fnv_test_str[44]: 0x0ac742dfe7874413,
    fnv_test_str[45]: 0xd7dad5766ad8e2a9,
    fnv_test_str[46]: 0xa1bb96378e897f3a,
    fnv_test_str[47]: 0x5b3f9b6733a367a1,
    fnv_test_str[48]: 0xb07ce25cbea969d6,
    fnv_test_str[49]: 0x8d9e9997f9df0d02,
    fnv_test_str[50]: 0x838c673d9603cb1e,
    fnv_test_str[51]: 0x8b5ee8a5e872c201,
    fnv_test_str[52]: 0x4507c4e9fb006969,
    fnv_test_str[53]: 0x4c9ca59581b27f64,
    fnv_test_str[54]: 0xe0aca20b624e423f,
    fnv_test_str[55]: 0x13998e580afa800f,
    fnv_test_str[56]: 0x08326507b4eb3401,
    fnv_test_str[57]: 0xd8d5ad186ba95dc1,
    fnv_test_str[58]: 0x1c72e17ef0ca4e97,
    fnv_test_str[59]: 0x2183c1b327c38ae6,
    fnv_test_str[60]: 0xb66d096c914504f2,
    fnv_test_str[61]: 0x404bf57ad8476757,
    fnv_test_str[62]: 0x887976bd815498bb,
    fnv_test_str[63]: 0x3afd7f02c2bf85a5,
    fnv_test_str[64]: 0xfc4476b0eb70177f,
    fnv_test_str[65]: 0x186d2da00f77ecba,
    fnv_test_str[66]: 0xf97140fa48c74066,
    fnv_test_str[67]: 0xa2b1cf49aa926d37,
    fnv_test_str[68]: 0x0690712cd6cf940c,
    fnv_test_str[69]: 0xf7045b3102b8906e,
    fnv_test_str[70]: 0xd8d5ad186ba95db3,
    fnv_test_str[71]: 0x1c72e17ef0ca4ef3,
    fnv_test_str[72]: 0x2183c1b327c38a95,
    fnv_test_str[73]: 0xb66d096c914504d2,
    fnv_test_str[74]: 0x404bf57ad8476736,
    fnv_test_str[75]: 0x887976bd815498d5,
    fnv_test_str[76]: 0x3afd7f02c2bf85c1,
    fnv_test_str[77]: 0xfc4476b0eb70175f,
    fnv_test_str[78]: 0x186d2da00f77eccd,
    fnv_test_str[79]: 0xf97140fa48c7400e,
    fnv_test_str[80]: 0xa2b1cf49aa926d52,
    fnv_test_str[81]: 0x0690712cd6cf9475,
    fnv_test_str[82]: 0xf7045b3102b89064,
    fnv_test_str[83]: 0x74f762479f9d6aea,
    fnv_test_str[84]: 0x08326007b4eb2b9c,
    fnv_test_str[85]: 0xd8c4c9186b9b1a14,
    fnv_test_str[86]: 0x7b495389bdbdd4c7,
    fnv_test_str[87]: 0x3b6dba0d69908e25,
    fnv_test_str[88]: 0xd6b2b17bf4b71261,
    fnv_test_str[89]: 0x447bfb7f98e615b5,
    fnv_test_str[90]: 0xd6b2b17bf4b71262,
    fnv_test_str[91]: 0x3bd2807f93fe1660,
    fnv_test_str[92]: 0xd6b2b17bf4b71263,
    fnv_test_str[93]: 0x3329057f8f16170b,
    fnv_test_str[94]: 0xd6b2b17bf4b71264,
    fnv_test_str[95]: 0x2a7f8a7f8a2e19b6,
    fnv_test_str[96]: 0x23d3767e64b2f98a,
    fnv_test_str[97]: 0xff768d7e4f9d86a4,
    fnv_test_str[98]: 0x23d3767e64b2f984,
    fnv_test_str[99]: 0xccd1837e334e4aa6,
    fnv_test_str[100]: 0x23d3767e64b2f99a,
    fnv_test_str[101]: 0x7691fd7e028f6754,
    fnv_test_str[102]: 0x34ad3b1041204318,
    fnv_test_str[103]: 0xa29e749ea9d201c8,
    fnv_test_str[104]: 0x34ad3b104120431b,
    fnv_test_str[105]: 0xa29e779ea9d206e1,
    fnv_test_str[106]: 0x34ad3b104120431a,
    fnv_test_str[107]: 0xa29e769ea9d2052e,
    fnv_test_str[108]: 0x02a17ebca4aa3497,
    fnv_test_str[109]: 0x229ef18bcd375c95,
    fnv_test_str[110]: 0x02a17dbca4aa32c8,
    fnv_test_str[111]: 0x229b6f8bcd3449d8,
    fnv_test_str[112]: 0x02a184bca4aa3ed5,
    fnv_test_str[113]: 0x22b3618bcd48c3ef,
    fnv_test_str[114]: 0x5c2c346706186f36,
    fnv_test_str[115]: 0xb78c410f5b84f8c2,
    fnv_test_str[116]: 0xed9478212b267395,
    fnv_test_str[117]: 0xd9bbb55c5256662f,
    fnv_test_str[118]: 0x8c54f0203249438a,
    fnv_test_str[119]: 0xbd9790b5727dc37e,
    fnv_test_str[120]: 0xa64e5f36c9e2b0e3,
    fnv_test_str[121]: 0x8fd0680da3088a04,
    fnv_test_str[122]: 0x67aad32c078284cc,
    fnv_test_str[123]: 0xb37d55d81c57b331,
    fnv_test_str[124]: 0x55ac0f3829057c43,
    fnv_test_str[125]: 0xcb27f4b8e1b6cc20,
    fnv_test_str[126]: 0x26caf88bcbef2d19,
    fnv_test_str[127]: 0x8e6e063b97e61b8f,
    fnv_test_str[128]: 0xb42750f7f3b7c37e,
    fnv_test_str[129]: 0xf3c6ba64cf7ca99b,
    fnv_test_str[130]: 0xebfb69b427ea80fe,
    fnv_test_str[131]: 0x39b50c3ed970f46c,
    fnv_test_str[132]: 0x5b9b177aa3eb3e8a,
    fnv_test_str[133]: 0x6510063ecf4ec903,
    fnv_test_str[134]: 0x2b3bbd2c00797c7a,
    fnv_test_str[135]: 0xf1d6204ff5cb4aa7,
    fnv_test_str[136]: 0x4836e27ccf099f38,
    fnv_test_str[137]: 0x82efbb0dd073b44d,
    fnv_test_str[138]: 0x4a80c282ffd7d4c6,
    fnv_test_str[139]: 0x305d1a9c9ee43bdf,
    fnv_test_str[140]: 0x15c366948ffc6997,
    fnv_test_str[141]: 0x80153ae218916e7b,
    fnv_test_str[142]: 0xfa23e2bdf9e2a9e1,
    fnv_test_str[143]: 0xd47e8d8a2333c6de,
    fnv_test_str[144]: 0x7e128095f688b056,
    fnv_test_str[145]: 0x2f5356890efcedab,
    fnv_test_str[146]: 0x95c2b383014f55c5,
    fnv_test_str[147]: 0x4727a5339ce6070f,
    fnv_test_str[148]: 0xb0555ecd575108e9,
    fnv_test_str[149]: 0x48d785770bb4af37,
    fnv_test_str[150]: 0x09d4701c12af02b1,
    fnv_test_str[151]: 0x79f031e78f3cf62e,
    fnv_test_str[152]: 0x52a1ee85db1b5a94,
    fnv_test_str[153]: 0x6bd95b2eb37fa6b8,
    fnv_test_str[154]: 0x74971b7077aef85d,
    fnv_test_str[155]: 0xb4e4fae2ffcc1aad,
    fnv_test_str[156]: 0x2bd48bd898b8f63a,
    fnv_test_str[157]: 0xe9966ac1556257f6,
    fnv_test_str[158]: 0x92a3d1cd078ba293,
    fnv_test_str[159]: 0xf81175a482e20ab8,
    fnv_test_str[160]: 0x5bbb3de722e73048,
    fnv_test_str[161]: 0x6b4f363492b9f2be,
    fnv_test_str[162]: 0xc2d559df73d59875,
    fnv_test_str[163]: 0xf75f62284bc7a8c2,
    fnv_test_str[164]: 0xda8dd8e116a9f1cc,
    fnv_test_str[165]: 0xbdc1e6ab76057885,
    fnv_test_str[166]: 0xfec6a4238a1224a0,
    fnv_test_str[167]: 0xc03f40f3223e290e,
    fnv_test_str[168]: 0x1ed21673466ffda9,
    fnv_test_str[169]: 0xdf70f906bb0dd2af,
    fnv_test_str[170]: 0xf3dcda369f2af666,
    fnv_test_str[171]: 0x9ebb11573cdcebde,
    fnv_test_str[172]: 0x81c72d9077fedca0,
    fnv_test_str[173]: 0x0ec074a31be5fb15,
    fnv_test_str[174]: 0x2a8b3280b6c48f20,
    fnv_test_str[175]: 0xfd31777513309344,
    fnv_test_str[176]: 0x194534a86ad006b6,
    fnv_test_str[177]: 0x3be6fdf46e0cfe12,
    fnv_test_str[178]: 0x017cc137a07eb057,
    fnv_test_str[179]: 0x9428fc6e7d26b54d,
    fnv_test_str[180]: 0x9aaa2e3603ef8ad7,
    fnv_test_str[181]: 0x82c6d3f3a0ccdf7d,
    fnv_test_str[182]: 0xc86eeea00cf09b65,
    fnv_test_str[183]: 0x705f8189dbb58299,
    fnv_test_str[184]: 0x415a7f554391ca69,
    fnv_test_str[185]: 0xcfe3d49fa2bdc555,
    fnv_test_str[186]: 0xf0f9c56039b25191,
    fnv_test_str[187]: 0x7075cb6abd1d32d9,
    fnv_test_str[188]: 0x43c94e2c8b277509,
    fnv_test_str[189]: 0x3cbfd4e4ea670359,
    fnv_test_str[190]: 0xc05887810f4d019d,
    fnv_test_str[191]: 0x14468ff93ac22dc5,
    fnv_test_str[192]: 0xebed699589d99c05,
    fnv_test_str[193]: 0x6d99f6df321ca5d5,
    fnv_test_str[194]: 0x0cd410d08c36d625,
    fnv_test_str[195]: 0xef1b2a2c86831d35,
    fnv_test_str[196]: 0x3b349c4d69ee5f05,
    fnv_test_str[197]: 0x55248ce88f45f035,
    fnv_test_str[198]: 0xaa69ca6a18a4c885,
    fnv_test_str[199]: 0x1fe3fce62bd816b5,
    fnv_test_str[200]: 0x0289a488a8df69d9,
    fnv_test_str[201]: 0x15e96e1613df98b5,
    fnv_test_str[202]: 0xe6be57375ad89b99,
}

"""
FNV-1a 64 bit test vectors
"""
fnv1a_64_vector = {
    fnv_test_str[0]: 0xcbf29ce484222325,
    fnv_test_str[1]: 0xaf63dc4c8601ec8c,
    fnv_test_str[2]: 0xaf63df4c8601f1a5,
    fnv_test_str[3]: 0xaf63de4c8601eff2,
    fnv_test_str[4]: 0xaf63d94c8601e773,
    fnv_test_str[5]: 0xaf63d84c8601e5c0,
    fnv_test_str[6]: 0xaf63db4c8601ead9,
    fnv_test_str[7]: 0x08985907b541d342,
    fnv_test_str[8]: 0xdcb27518fed9d577,
    fnv_test_str[9]: 0xdd120e790c2512af,
    fnv_test_str[10]: 0xcac165afa2fef40a,
    fnv_test_str[11]: 0x85944171f73967e8,
    fnv_test_str[12]: 0xaf63bd4c8601b7df,
    fnv_test_str[13]: 0x089be207b544f1e4,
    fnv_test_str[14]: 0x08a61407b54d9b5f,
    fnv_test_str[15]: 0x08a2ae07b54ab836,
    fnv_test_str[16]: 0x0891b007b53c4869,
    fnv_test_str[17]: 0x088e4a07b5396540,
    fnv_test_str[18]: 0x08987c07b5420ebb,
    fnv_test_str[19]: 0xdcb28a18fed9f926,
    fnv_test_str[20]: 0xdd1270790c25b935,
    fnv_test_str[21]: 0xcac146afa2febf5d,
    fnv_test_str[22]: 0x8593d371f738acfe,
    fnv_test_str[23]: 0x34531ca7168b8f38,
    fnv_test_str[24]: 0x08a25607b54a22ae,
    fnv_test_str[25]: 0xf5faf0190cf90df3,
    fnv_test_str[26]: 0xf27397910b3221c7,
    fnv_test_str[27]: 0x2c8c2b76062f22e0,
    fnv_test_str[28]: 0xe150688c8217b8fd,
    fnv_test_str[29]: 0xf35a83c10e4f1f87,
    fnv_test_str[30]: 0xd1edd10b507344d0,
    fnv_test_str[31]: 0x2a5ee739b3ddb8c3,
    fnv_test_str[32]: 0xdcfb970ca1c0d310,
    fnv_test_str[33]: 0x4054da76daa6da90,
    fnv_test_str[34]: 0xf70a2ff589861368,
    fnv_test_str[35]: 0x4c628b38aed25f17,
    fnv_test_str[36]: 0x9dd1f6510f78189f,
    fnv_test_str[37]: 0xa3de85bd491270ce,
    fnv_test_str[38]: 0x858e2fa32a55e61d,
    fnv_test_str[39]: 0x46810940eff5f915,
    fnv_test_str[40]: 0xf5fadd190cf8edaa,
    fnv_test_str[41]: 0xf273ed910b32b3e9,
    fnv_test_str[42]: 0x2c8c5276062f6525,
    fnv_test_str[43]: 0xe150b98c821842a0,
    fnv_test_str[44]: 0xf35aa3c10e4f55e7,
    fnv_test_str[45]: 0xd1ed680b50729265,
    fnv_test_str[46]: 0x2a5f0639b3dded70,
    fnv_test_str[47]: 0xdcfbaa0ca1c0f359,
    fnv_test_str[48]: 0x4054ba76daa6a430,
    fnv_test_str[49]: 0xf709c7f5898562b0,
    fnv_test_str[50]: 0x4c62e638aed2f9b8,
    fnv_test_str[51]: 0x9dd1a8510f779415,
    fnv_test_str[52]: 0xa3de2abd4911d62d,
    fnv_test_str[53]: 0x858e0ea32a55ae0a,
    fnv_test_str[54]: 0x46810f40eff60347,
    fnv_test_str[55]: 0xc33bce57bef63eaf,
    fnv_test_str[56]: 0x08a24307b54a0265,
    fnv_test_str[57]: 0xf5b9fd190cc18d15,
    fnv_test_str[58]: 0x4c968290ace35703,
    fnv_test_str[59]: 0x07174bd5c64d9350,
    fnv_test_str[60]: 0x5a294c3ff5d18750,
    fnv_test_str[61]: 0x05b3c1aeb308b843,
    fnv_test_str[62]: 0xb92a48da37d0f477,
    fnv_test_str[63]: 0x73cdddccd80ebc49,
    fnv_test_str[64]: 0xd58c4c13210a266b,
    fnv_test_str[65]: 0xe78b6081243ec194,
    fnv_test_str[66]: 0xb096f77096a39f34,
    fnv_test_str[67]: 0xb425c54ff807b6a3,
    fnv_test_str[68]: 0x23e520e2751bb46e,
    fnv_test_str[69]: 0x1a0b44ccfe1385ec,
    fnv_test_str[70]: 0xf5ba4b190cc2119f,
    fnv_test_str[71]: 0x4c962690ace2baaf,
    fnv_test_str[72]: 0x0716ded5c64cda19,
    fnv_test_str[73]: 0x5a292c3ff5d150f0,
    fnv_test_str[74]: 0x05b3e0aeb308ecf0,
    fnv_test_str[75]: 0xb92a5eda37d119d9,
    fnv_test_str[76]: 0x73ce41ccd80f6635,
    fnv_test_str[77]: 0xd58c2c132109f00b,
    fnv_test_str[78]: 0xe78baf81243f47d1,
    fnv_test_str[79]: 0xb0968f7096a2ee7c,
    fnv_test_str[80]: 0xb425a84ff807855c,
    fnv_test_str[81]: 0x23e4e9e2751b56f9,
    fnv_test_str[82]: 0x1a0b4eccfe1396ea,
    fnv_test_str[83]: 0x54abd453bb2c9004,
    fnv_test_str[84]: 0x08ba5f07b55ec3da,
    fnv_test_str[85]: 0x337354193006cb6e,
    fnv_test_str[86]: 0xa430d84680aabd0b,
    fnv_test_str[87]: 0xa9bc8acca21f39b1,
    fnv_test_str[88]: 0x6961196491cc682d,
    fnv_test_str[89]: 0xad2bb1774799dfe9,
    fnv_test_str[90]: 0x6961166491cc6314,
    fnv_test_str[91]: 0x8d1bb3904a3b1236,
    fnv_test_str[92]: 0x6961176491cc64c7,
    fnv_test_str[93]: 0xed205d87f40434c7,
    fnv_test_str[94]: 0x6961146491cc5fae,
    fnv_test_str[95]: 0xcd3baf5e44f8ad9c,
    fnv_test_str[96]: 0xe3b36596127cd6d8,
    fnv_test_str[97]: 0xf77f1072c8e8a646,
    fnv_test_str[98]: 0xe3b36396127cd372,
    fnv_test_str[99]: 0x6067dce9932ad458,
    fnv_test_str[100]: 0xe3b37596127cf208,
    fnv_test_str[101]: 0x4b7b10fa9fe83936,
    fnv_test_str[102]: 0xaabafe7104d914be,
    fnv_test_str[103]: 0xf4d3180b3cde3eda,
    fnv_test_str[104]: 0xaabafd7104d9130b,
    fnv_test_str[105]: 0xf4cfb20b3cdb5bb1,
    fnv_test_str[106]: 0xaabafc7104d91158,
    fnv_test_str[107]: 0xf4cc4c0b3cd87888,
    fnv_test_str[108]: 0xe729bac5d2a8d3a7,
    fnv_test_str[109]: 0x74bc0524f4dfa4c5,
    fnv_test_str[110]: 0xe72630c5d2a5b352,
    fnv_test_str[111]: 0x6b983224ef8fb456,
    fnv_test_str[112]: 0xe73042c5d2ae266d,
    fnv_test_str[113]: 0x8527e324fdeb4b37,
    fnv_test_str[114]: 0x0a83c86fee952abc,
    fnv_test_str[115]: 0x7318523267779d74,
    fnv_test_str[116]: 0x3e66d3d56b8caca1,
    fnv_test_str[117]: 0x956694a5c0095593,
    fnv_test_str[118]: 0xcac54572bb1a6fc8,
    fnv_test_str[119]: 0xa7a4c9f3edebf0d8,
    fnv_test_str[120]: 0x7829851fac17b143,
    fnv_test_str[121]: 0x2c8f4c9af81bcf06,
    fnv_test_str[122]: 0xd34e31539740c732,
    fnv_test_str[123]: 0x3605a2ac253d2db1,
    fnv_test_str[124]: 0x08c11b8346f4a3c3,
    fnv_test_str[125]: 0x6be396289ce8a6da,
    fnv_test_str[126]: 0xd9b957fb7fe794c5,
    fnv_test_str[127]: 0x05be33da04560a93,
    fnv_test_str[128]: 0x0957f1577ba9747c,
    fnv_test_str[129]: 0xda2cc3acc24fba57,
    fnv_test_str[130]: 0x74136f185b29e7f0,
    fnv_test_str[131]: 0xb2f2b4590edb93b2,
    fnv_test_str[132]: 0xb3608fce8b86ae04,
    fnv_test_str[133]: 0x4a3a865079359063,
    fnv_test_str[134]: 0x5b3a7ef496880a50,
    fnv_test_str[135]: 0x48fae3163854c23b,
    fnv_test_str[136]: 0x07aaa640476e0b9a,
    fnv_test_str[137]: 0x2f653656383a687d,
    fnv_test_str[138]: 0xa1031f8e7599d79c,
    fnv_test_str[139]: 0xa31908178ff92477,
    fnv_test_str[140]: 0x097edf3c14c3fb83,
    fnv_test_str[141]: 0xb51ca83feaa0971b,
    fnv_test_str[142]: 0xdd3c0d96d784f2e9,
    fnv_test_str[143]: 0x86cd26a9ea767d78,
    fnv_test_str[144]: 0xe6b215ff54a30c18,
    fnv_test_str[145]: 0xec5b06a1c5531093,
    fnv_test_str[146]: 0x45665a929f9ec5e5,
    fnv_test_str[147]: 0x8c7609b4a9f10907,
    fnv_test_str[148]: 0x89aac3a491f0d729,
    fnv_test_str[149]: 0x32ce6b26e0f4a403,
    fnv_test_str[150]: 0x614ab44e02b53e01,
    fnv_test_str[151]: 0xfa6472eb6eef3290,
    fnv_test_str[152]: 0x9e5d75eb1948eb6a,
    fnv_test_str[153]: 0xb6d12ad4a8671852,
    fnv_test_str[154]: 0x88826f56eba07af1,
    fnv_test_str[155]: 0x44535bf2645bc0fd,
    fnv_test_str[156]: 0x169388ffc21e3728,
    fnv_test_str[157]: 0xf68aac9e396d8224,
    fnv_test_str[158]: 0x8e87d7e7472b3883,
    fnv_test_str[159]: 0x295c26caa8b423de,
    fnv_test_str[160]: 0x322c814292e72176,
    fnv_test_str[161]: 0x8a06550eb8af7268,
    fnv_test_str[162]: 0xef86d60e661bcf71,
    fnv_test_str[163]: 0x9e5426c87f30ee54,
    fnv_test_str[164]: 0xf1ea8aa826fd047e,
    fnv_test_str[165]: 0x0babaf9a642cb769,
    fnv_test_str[166]: 0x4b3341d4068d012e,
    fnv_test_str[167]: 0xd15605cbc30a335c,
    fnv_test_str[168]: 0x5b21060aed8412e5,
    fnv_test_str[169]: 0x45e2cda1ce6f4227,
    fnv_test_str[170]: 0x50ae3745033ad7d4,
    fnv_test_str[171]: 0xaa4588ced46bf414,
    fnv_test_str[172]: 0xc1b0056c4a95467e,
    fnv_test_str[173]: 0x56576a71de8b4089,
    fnv_test_str[174]: 0xbf20965fa6dc927e,
    fnv_test_str[175]: 0x569f8383c2040882,
    fnv_test_str[176]: 0xe1e772fba08feca0,
    fnv_test_str[177]: 0x4ced94af97138ac4,
    fnv_test_str[178]: 0xc4112ffb337a82fb,
    fnv_test_str[179]: 0xd64a4fd41de38b7d,
    fnv_test_str[180]: 0x4cfc32329edebcbb,
    fnv_test_str[181]: 0x0803564445050395,
    fnv_test_str[182]: 0xaa1574ecf4642ffd,
    fnv_test_str[183]: 0x694bc4e54cc315f9,
    fnv_test_str[184]: 0xa3d7cb273b011721,
    fnv_test_str[185]: 0x577c2f8b6115bfa5,
    fnv_test_str[186]: 0xb7ec8c1a769fb4c1,
    fnv_test_str[187]: 0x5d5cfce63359ab19,
    fnv_test_str[188]: 0x33b96c3cd65b5f71,
    fnv_test_str[189]: 0xd845097780602bb9,
    fnv_test_str[190]: 0x84d47645d02da3d5,
    fnv_test_str[191]: 0x83544f33b58773a5,
    fnv_test_str[192]: 0x9175cbb2160836c5,
    fnv_test_str[193]: 0xc71b3bc175e72bc5,
    fnv_test_str[194]: 0x636806ac222ec985,
    fnv_test_str[195]: 0xb6ef0e6950f52ed5,
    fnv_test_str[196]: 0xead3d8a0f3dfdaa5,
    fnv_test_str[197]: 0x922908fe9a861ba5,
    fnv_test_str[198]: 0x6d4821de275fd5c5,
    fnv_test_str[199]: 0x1fe3fce62bd816b5,
    fnv_test_str[200]: 0xc23e9fccd6f70591,
    fnv_test_str[201]: 0xc1af12bdfe16b5b5,
    fnv_test_str[202]: 0x39e9f18f2f85e221,
}
