/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;

public class TextureAttributesState
extends NodeComponentState {
    private static final int MAX_COLOR_OPERANDS = 2;

    public TextureAttributesState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        int n;
        super.writeObject(dataOutput);
        TextureAttributes textureAttributes = (TextureAttributes)this.node;
        Color4f color4f = new Color4f();
        Matrix4d matrix4d = new Matrix4d();
        Transform3D transform3D = new Transform3D();
        int n2 = textureAttributes.getNumTextureColorTableComponents();
        int n3 = textureAttributes.getTextureColorTableSize();
        int[][] nArray = new int[n2][n3];
        dataOutput.writeInt(textureAttributes.getPerspectiveCorrectionMode());
        textureAttributes.getTextureBlendColor(color4f);
        this.control.writeColor4f(dataOutput, color4f);
        dataOutput.writeInt(n2);
        dataOutput.writeInt(n3);
        textureAttributes.getTextureColorTable(nArray);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                dataOutput.writeInt(nArray[n][i]);
            }
        }
        dataOutput.writeInt(textureAttributes.getTextureMode());
        textureAttributes.getTextureTransform(transform3D);
        transform3D.get(matrix4d);
        this.control.writeMatrix4d(dataOutput, matrix4d);
        dataOutput.writeInt(textureAttributes.getCombineRgbMode());
        dataOutput.writeInt(textureAttributes.getCombineAlphaMode());
        for (n = 0; n < 2; ++n) {
            dataOutput.writeInt(textureAttributes.getCombineRgbSource(n));
            dataOutput.writeInt(textureAttributes.getCombineAlphaSource(n));
            dataOutput.writeInt(textureAttributes.getCombineRgbFunction(n));
            dataOutput.writeInt(textureAttributes.getCombineAlphaFunction(n));
        }
        dataOutput.writeInt(textureAttributes.getCombineRgbScale());
        dataOutput.writeInt(textureAttributes.getCombineAlphaScale());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        TextureAttributes textureAttributes = (TextureAttributes)this.node;
        textureAttributes.setPerspectiveCorrectionMode(dataInput.readInt());
        textureAttributes.setTextureBlendColor(this.control.readColor4f(dataInput));
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[i][j] = dataInput.readInt();
            }
        }
        if (n != 0) {
            textureAttributes.setTextureColorTable(nArray);
        }
        textureAttributes.setTextureMode(dataInput.readInt());
        Matrix4d matrix4d = this.control.readMatrix4d(dataInput);
        Transform3D transform3D = new Transform3D(matrix4d);
        textureAttributes.setTextureTransform(transform3D);
        textureAttributes.setCombineRgbMode(dataInput.readInt());
        textureAttributes.setCombineAlphaMode(dataInput.readInt());
        for (int i = 0; i < 2; ++i) {
            textureAttributes.setCombineRgbSource(i, dataInput.readInt());
            textureAttributes.setCombineAlphaSource(i, dataInput.readInt());
            textureAttributes.setCombineRgbFunction(i, dataInput.readInt());
            textureAttributes.setCombineAlphaFunction(i, dataInput.readInt());
        }
        textureAttributes.setCombineRgbScale(dataInput.readInt());
        textureAttributes.setCombineAlphaScale(dataInput.readInt());
    }

    protected SceneGraphObject createNode() {
        return new TextureAttributes();
    }
}

