/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public abstract class Light
extends Leaf {
    public static final int ALLOW_STATE_READ = 12;
    public static final int ALLOW_STATE_WRITE = 13;
    public static final int ALLOW_COLOR_READ = 14;
    public static final int ALLOW_COLOR_WRITE = 15;
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 16;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 17;
    public static final int ALLOW_SCOPE_READ = 28;
    public static final int ALLOW_SCOPE_WRITE = 29;
    private static final int[] readCapabilities = new int[]{12, 14, 16, 28};

    public Light() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Light(Color3f color3f) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((LightRetained)this.retained).initColor(color3f);
    }

    public Light(boolean bl, Color3f color3f) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((LightRetained)this.retained).initEnable(bl);
        ((LightRetained)this.retained).initColor(color3f);
    }

    public void setEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light0"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setEnable(bl);
        } else {
            ((LightRetained)this.retained).initEnable(bl);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light1"));
        }
        return ((LightRetained)this.retained).getEnable();
    }

    public void setColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light2"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setColor(color3f);
        } else {
            ((LightRetained)this.retained).initColor(color3f);
        }
    }

    public void getColor(Color3f color3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light3"));
        }
        ((LightRetained)this.retained).getColor(color3f);
    }

    public void setScope(Group group, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light4"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setScope(group, n);
        } else {
            ((LightRetained)this.retained).initScope(group, n);
        }
    }

    public Group getScope(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light5"));
        }
        return ((LightRetained)this.retained).getScope(n);
    }

    public void insertScope(Group group, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light6"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).insertScope(group, n);
        } else {
            ((LightRetained)this.retained).initInsertScope(group, n);
        }
    }

    public void removeScope(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light7"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).removeScope(n);
        } else {
            ((LightRetained)this.retained).initRemoveScope(n);
        }
    }

    public Enumeration<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light8"));
        }
        return ((LightRetained)this.retained).getAllScopes();
    }

    public void addScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light9"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).addScope(group);
        } else {
            ((LightRetained)this.retained).initAddScope(group);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light8"));
        }
        return ((LightRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(28)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light8"));
        }
        return ((LightRetained)this.retained).indexOfScope(group);
    }

    public void removeScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light7"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).removeScope(group);
        } else {
            ((LightRetained)this.retained).initRemoveScope(group);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(29)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light7"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).removeAllScopes();
        } else {
            ((LightRetained)this.retained).initRemoveAllScopes();
        }
    }

    public void setInfluencingBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light11"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setInfluencingBounds(bounds);
        } else {
            ((LightRetained)this.retained).initInfluencingBounds(bounds);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light12"));
        }
        return ((LightRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light11"));
        }
        if (this.isLive()) {
            ((LightRetained)this.retained).setInfluencingBoundingLeaf(boundingLeaf);
        } else {
            ((LightRetained)this.retained).initInfluencingBoundingLeaf(boundingLeaf);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Light12"));
        }
        return ((LightRetained)this.retained).getInfluencingBoundingLeaf();
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        LightRetained lightRetained = (LightRetained)node.retained;
        LightRetained lightRetained2 = (LightRetained)this.retained;
        Color3f color3f = new Color3f();
        lightRetained.getColor(color3f);
        lightRetained2.initColor(color3f);
        lightRetained2.initInfluencingBounds(lightRetained.getInfluencingBounds());
        Enumeration<Group> enumeration = lightRetained.getAllScopes();
        while (enumeration.hasMoreElements()) {
            lightRetained2.initAddScope(enumeration.nextElement());
        }
        lightRetained2.initInfluencingBoundingLeaf(lightRetained.getInfluencingBoundingLeaf());
        lightRetained2.initEnable(lightRetained.getEnable());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        LightRetained lightRetained = (LightRetained)this.retained;
        BoundingLeaf boundingLeaf = lightRetained.getInfluencingBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            lightRetained.initInfluencingBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
        int n = lightRetained.numScopes();
        for (int i = 0; i < n; ++i) {
            lightRetained.initScope((Group)nodeReferenceTable.getNewObjectReference(lightRetained.getScope(i)), i);
        }
    }
}

