/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureCubeMapRetained;

public class TextureCubeMap
extends Texture {
    public static final int POSITIVE_X = 0;
    public static final int NEGATIVE_X = 1;
    public static final int POSITIVE_Y = 2;
    public static final int NEGATIVE_Y = 3;
    public static final int POSITIVE_Z = 4;
    public static final int NEGATIVE_Z = 5;

    public TextureCubeMap() {
    }

    public TextureCubeMap(int n, int n2, int n3) {
        super(n, n2, n3, n3);
    }

    public TextureCubeMap(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n3, n4);
    }

    public void setImage(int n, int n2, ImageComponent2D imageComponent2D) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap1"));
        }
        this.validateImageIllegalSharing(imageComponent2D);
        if (this.isLive()) {
            ((TextureCubeMapRetained)this.retained).setImage(n, n2, imageComponent2D);
        } else {
            ((TextureCubeMapRetained)this.retained).initImage(n, n2, imageComponent2D);
        }
    }

    public void setImages(int n, ImageComponent2D[] imageComponent2DArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap1"));
        }
        for (int i = 0; i < imageComponent2DArray.length; ++i) {
            this.validateImageIllegalSharing(imageComponent2DArray[i]);
        }
        if (this.isLive()) {
            ((TextureCubeMapRetained)this.retained).setImages(n, imageComponent2DArray);
        } else {
            ((TextureCubeMapRetained)this.retained).initImages(n, imageComponent2DArray);
        }
    }

    public ImageComponent getImage(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap2"));
        }
        return ((TextureCubeMapRetained)this.retained).getImage(n, n2);
    }

    public ImageComponent[] getImages(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureCubeMap2"));
        }
        return ((TextureCubeMapRetained)this.retained).getImages(n);
    }

    public void setImage(int n, ImageComponent imageComponent) {
        throw new UnsupportedOperationException();
    }

    public void setImages(ImageComponent[] imageComponentArray) {
        throw new UnsupportedOperationException();
    }

    public ImageComponent getImage(int n) {
        throw new UnsupportedOperationException();
    }

    public ImageComponent[] getImages() {
        throw new UnsupportedOperationException();
    }

    void createRetained() {
        this.retained = new TextureCubeMapRetained();
        this.retained.setSource(this);
    }

    public void duplicateNodeComponent(NodeComponent nodeComponent) {
        this.checkDuplicateNodeComponent(nodeComponent);
    }
}

