/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.HomePrintableComponent;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class HomePDFPrinter {
    private final Home home;
    private final UserPreferences preferences;
    private final HomeController controller;
    private final Font defaultFont;

    public HomePDFPrinter(Home home, UserPreferences userPreferences, HomeController homeController, Font font) {
        this.home = home;
        this.preferences = userPreferences;
        this.controller = homeController;
        this.defaultFont = font;
    }

    public void write(OutputStream outputStream) throws IOException {
        PageFormat pageFormat = HomePrintableComponent.getPageFormat(this.home.getPrint());
        Document document = new Document(new Rectangle((float)pageFormat.getWidth(), (float)pageFormat.getHeight()));
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            document.addAuthor(System.getProperty("user.name", ""));
            String string = this.preferences.getLocalizedString(HomePDFPrinter.class, "pdfDocument.creator", new Object[0]);
            document.addCreator(string);
            document.addCreationDate();
            String string2 = this.home.getName();
            if (string2 != null) {
                document.addTitle(this.controller.getContentManager().getPresentationName(string2, ContentManager.ContentType.PDF));
            }
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            HomePrintableComponent homePrintableComponent = new HomePrintableComponent(this.home, this.controller, this.defaultFont);
            int n = homePrintableComponent.getPageCount();
            for (int i = 0; i < n; ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedIOException();
                }
                PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)pageFormat.getWidth(), (float)pageFormat.getHeight());
                Graphics2D graphics2D = pdfTemplate.createGraphicsShapes((float)pageFormat.getWidth(), (float)pageFormat.getHeight());
                homePrintableComponent.print(graphics2D, pageFormat, i);
                pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
                graphics2D.dispose();
                if (i == n - 1) continue;
                document.newPage();
            }
            document.close();
        }
        catch (DocumentException documentException) {
            IOException iOException = new IOException("Couldn't print to PDF");
            iOException.initCause(documentException);
            throw iOException;
        }
        catch (InterruptedPrinterException interruptedPrinterException) {
            throw new InterruptedIOException("Print to PDF interrupted");
        }
        catch (PrinterException printerException) {
            IOException iOException = new IOException("Couldn't print to PDF");
            iOException.initCause(printerException);
            throw iOException;
        }
    }
}

