/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.math.Vector3;

public final class Point3 {
    public float x;
    public float y;
    public float z;

    public Point3() {
    }

    public Point3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Point3(Point3 point3) {
        this.x = point3.x;
        this.y = point3.y;
        this.z = point3.z;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        return this.z;
    }

    public final float distanceTo(Point3 point3) {
        float f = this.x - point3.x;
        float f2 = this.y - point3.y;
        float f3 = this.z - point3.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public final float distanceTo(float f, float f2, float f3) {
        float f4 = this.x - f;
        float f5 = this.y - f2;
        float f6 = this.z - f3;
        return (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
    }

    public final float distanceToSquared(Point3 point3) {
        float f = this.x - point3.x;
        float f2 = this.y - point3.y;
        float f3 = this.z - point3.z;
        return f * f + f2 * f2 + f3 * f3;
    }

    public final float distanceToSquared(float f, float f2, float f3) {
        float f4 = this.x - f;
        float f5 = this.y - f2;
        float f6 = this.z - f3;
        return f4 * f4 + f5 * f5 + f6 * f6;
    }

    public final Point3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public final Point3 set(Point3 point3) {
        this.x = point3.x;
        this.y = point3.y;
        this.z = point3.z;
        return this;
    }

    public static final Point3 add(Point3 point3, Vector3 vector3, Point3 point32) {
        point32.x = point3.x + vector3.x;
        point32.y = point3.y + vector3.y;
        point32.z = point3.z + vector3.z;
        return point32;
    }

    public static final Vector3 sub(Point3 point3, Point3 point32, Vector3 vector3) {
        vector3.x = point3.x - point32.x;
        vector3.y = point3.y - point32.y;
        vector3.z = point3.z - point32.z;
        return vector3;
    }

    public static final Point3 mid(Point3 point3, Point3 point32, Point3 point33) {
        point33.x = 0.5f * (point3.x + point32.x);
        point33.y = 0.5f * (point3.y + point32.y);
        point33.z = 0.5f * (point3.z + point32.z);
        return point33;
    }

    public static final Point3 blend(Point3 point3, Point3 point32, float f, Point3 point33) {
        point33.x = (1.0f - f) * point3.x + f * point32.x;
        point33.y = (1.0f - f) * point3.y + f * point32.y;
        point33.z = (1.0f - f) * point3.z + f * point32.z;
        return point33;
    }

    public static final Vector3 normal(Point3 point3, Point3 point32, Point3 point33) {
        float f = point32.x - point3.x;
        float f2 = point32.y - point3.y;
        float f3 = point32.z - point3.z;
        float f4 = point33.x - point3.x;
        float f5 = point33.y - point3.y;
        float f6 = point33.z - point3.z;
        float f7 = f2 * f6 - f3 * f5;
        float f8 = f3 * f4 - f * f6;
        float f9 = f * f5 - f2 * f4;
        return new Vector3(f7, f8, f9);
    }

    public static final Vector3 normal(Point3 point3, Point3 point32, Point3 point33, Vector3 vector3) {
        float f = point32.x - point3.x;
        float f2 = point32.y - point3.y;
        float f3 = point32.z - point3.z;
        float f4 = point33.x - point3.x;
        float f5 = point33.y - point3.y;
        float f6 = point33.z - point3.z;
        vector3.x = f2 * f6 - f3 * f5;
        vector3.y = f3 * f4 - f * f6;
        vector3.z = f * f5 - f2 * f4;
        return vector3;
    }

    public final String toString() {
        return String.format("(%.2f, %.2f, %.2f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

