/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.math.Recti;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.util.Iterator;
import jogamp.graph.curve.opengl.shader.AttributeNames;

public final class RegionRenderer {
    protected static final boolean DEBUG = Region.DEBUG;
    protected static final boolean DEBUG_INSTANCE = Region.DEBUG_INSTANCE;
    public static final GLCallback defaultBlendEnable = new GLCallback(){

        @Override
        public void run(GL gL, RegionRenderer regionRenderer) {
            if (regionRenderer.isHintMaskSet(2)) {
                gL.glDepthMask(false);
            }
            gL.glEnable(3042);
            gL.glBlendEquation(32774);
            regionRenderer.setHintMask(1);
        }
    };
    public static final GLCallback defaultBlendDisable = new GLCallback(){

        @Override
        public void run(GL gL, RegionRenderer regionRenderer) {
            regionRenderer.clearHintMask(1);
            gL.glDisable(3042);
            if (regionRenderer.isHintMaskSet(2)) {
                gL.glDepthMask(true);
            }
        }
    };
    private final RenderState rs;
    private final GLCallback enableCallback;
    private final GLCallback disableCallback;
    private final Recti viewport = new Recti();
    private boolean initialized;
    private boolean vboSupported = false;
    private static final String SHADER_SRC_SUB = "";
    private static final String SHADER_BIN_SUB = "bin";
    private static final String GLSL_USE_COLOR_CHANNEL = "#define USE_COLOR_CHANNEL 1\n";
    private static final String GLSL_USE_COLOR_TEXTURE = "#define USE_COLOR_TEXTURE 1\n";
    private static final String GLSL_DEF_SAMPLE_COUNT = "#define SAMPLE_COUNT ";
    private static final String GLSL_CONST_SAMPLE_COUNT = "const float sample_count = ";
    private static final String GLSL_MAIN_BEGIN = "void main (void)\n{\n";
    private static final String gcuTexture2D = "gcuTexture2D";
    private static final String GLSL_USE_DISCARD = "#define USE_DISCARD 1\n";
    private static final String es2_precision_fp = "\nprecision mediump float;\nprecision mediump int;\nprecision mediump sampler2D;\n";
    private final IntObjectHashMap shaderPrograms = new IntObjectHashMap();
    private static final int HIGH_MASK = 1536;
    private static final int TWO_PASS_BIT = Integer.MIN_VALUE;

    public static RegionRenderer create() {
        return new RegionRenderer(null, null, null);
    }

    public static RegionRenderer create(GLCallback gLCallback, GLCallback gLCallback2) {
        return new RegionRenderer(gLCallback, gLCallback2);
    }

    public static RegionRenderer create(PMVMatrix pMVMatrix, GLCallback gLCallback, GLCallback gLCallback2) {
        return new RegionRenderer(pMVMatrix, gLCallback, gLCallback2);
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final Recti getViewport(Recti recti) {
        recti.set(this.viewport);
        return recti;
    }

    public final Recti getViewport() {
        return this.viewport;
    }

    public final int getWidth() {
        return this.viewport.width();
    }

    public final int getHeight() {
        return this.viewport.height();
    }

    protected RegionRenderer(GLCallback gLCallback, GLCallback gLCallback2) {
        this(null, gLCallback, gLCallback2);
    }

    protected RegionRenderer(PMVMatrix pMVMatrix, GLCallback gLCallback, GLCallback gLCallback2) {
        this.rs = new RenderState(pMVMatrix);
        this.enableCallback = gLCallback;
        this.disableCallback = gLCallback2;
    }

    public final boolean isVBOSupported() {
        return this.vboSupported;
    }

    public final void init(GL2ES2 gL2ES2) throws GLException {
        if (this.initialized) {
            return;
        }
        boolean bl = this.vboSupported = gL2ES2.isFunctionAvailable("glGenBuffers") && gL2ES2.isFunctionAvailable("glBindBuffer") && gL2ES2.isFunctionAvailable("glBufferData") && gL2ES2.isFunctionAvailable("glDrawElements") && gL2ES2.isFunctionAvailable("glVertexAttribPointer") && gL2ES2.isFunctionAvailable("glDeleteBuffers");
        if (DEBUG) {
            System.err.println("TextRendererImpl01: VBO Supported = " + this.isVBOSupported());
        }
        if (!this.vboSupported) {
            throw new GLException("VBO not supported");
        }
        this.rs.attachTo(gL2ES2);
        this.initialized = true;
        this.enable(gL2ES2, false);
    }

    public final void destroy(GL2ES2 gL2ES2) {
        if (!this.initialized) {
            if (DEBUG_INSTANCE) {
                System.err.println("TextRenderer: Not initialized!");
            }
            return;
        }
        Iterator iterator = this.shaderPrograms.iterator();
        while (iterator.hasNext()) {
            ShaderProgram shaderProgram = (ShaderProgram)((IntObjectHashMap.Entry)iterator.next()).getValue();
            shaderProgram.destroy(gL2ES2);
        }
        this.shaderPrograms.clear();
        this.rs.detachFrom(gL2ES2);
        this.rs.destroy();
        this.initialized = false;
    }

    public final RenderState getRenderState() {
        return this.rs;
    }

    public final PMVMatrix getMatrix() {
        return this.rs.getMatrix();
    }

    public final float getWeight() {
        return this.rs.getWeight();
    }

    public final void setWeight(float f) {
        this.rs.setWeight(f);
    }

    public final Vec4f getColorStatic(Vec4f vec4f) {
        return this.rs.getColorStatic(vec4f);
    }

    public final void setColorStatic(Vec4f vec4f) {
        this.rs.setColorStatic(vec4f);
    }

    public final void setColorStatic(float f, float f2, float f3, float f4) {
        this.rs.setColorStatic(f, f2, f3, f4);
    }

    public final boolean isHintMaskSet(int n) {
        return this.rs.isHintMaskSet(n);
    }

    public final void setHintMask(int n) {
        this.rs.setHintMask(n);
    }

    public final void clearHintMask(int n) {
        this.rs.clearHintMask(n);
    }

    public final void enable(GL2ES2 gL2ES2, boolean bl) {
        this.enable(gL2ES2, bl, this.enableCallback, this.disableCallback);
    }

    public final void enable(GL2ES2 gL2ES2, boolean bl, GLCallback gLCallback, GLCallback gLCallback2) {
        if (bl) {
            if (null != gLCallback) {
                gLCallback.run(gL2ES2, this);
            }
        } else {
            ShaderProgram shaderProgram;
            if (null != gLCallback2) {
                gLCallback2.run(gL2ES2, this);
            }
            if (null != (shaderProgram = this.rs.getShaderProgram())) {
                shaderProgram.useProgram(gL2ES2, false);
            }
        }
    }

    public final void reshapeNotify(int n, int n2, int n3, int n4) {
        this.viewport.set(n, n2, n3, n4);
    }

    public final void reshapePerspective(float f, int n, int n2, float f2, float f3) {
        this.reshapeNotify(0, 0, n, n2);
        float f4 = (float)n / (float)n2;
        PMVMatrix pMVMatrix = this.getMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(f, f4, f2, f3);
    }

    public final void reshapeOrtho(int n, int n2, float f, float f2) {
        this.reshapeNotify(0, 0, n, n2);
        PMVMatrix pMVMatrix = this.getMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glOrthof(0.0f, n, 0.0f, n2, f, f2);
    }

    private String getVersionedShaderName() {
        return "curverenderer01";
    }

    private final String getFragmentShaderPrecision(GL2ES2 gL2ES2) {
        if (gL2ES2.isGLES()) {
            return es2_precision_fp;
        }
        if (ShaderCode.requiresGL3DefaultPrecision(gL2ES2)) {
            return "\nprecision highp float;\nprecision mediump int;\n/*precision mediump sampler2D;*/\n";
        }
        return null;
    }

    public final boolean useShaderProgram(GL2ES2 gL2ES2, int n, boolean bl, int n2, int n3, TextureSequence textureSequence) {
        int n4;
        int n5;
        String string;
        boolean bl2;
        ShaderModeSelector1 shaderModeSelector1 = bl ? ShaderModeSelector1.selectPass1(n) : ShaderModeSelector1.selectPass2(n, n2, n3);
        boolean bl3 = Region.isTwoPass(n);
        boolean bl4 = Region.hasColorChannel(n);
        boolean bl5 = Region.hasColorTexture(n) && null != textureSequence;
        boolean bl6 = bl2 = bl && bl5;
        if (bl2) {
            string = textureSequence.setTextureLookupFunctionName(gcuTexture2D);
            n5 = textureSequence.getTextureFragmentShaderHashCode();
        } else {
            string = null;
            n5 = 0;
        }
        int n6 = (n5 << 5) - n5 + (shaderModeSelector1.ordinal() | 0x600 & n | (bl3 ? Integer.MIN_VALUE : 0));
        ShaderProgram shaderProgram = (ShaderProgram)this.shaderPrograms.get(n6);
        if (null != shaderProgram) {
            boolean bl7 = this.rs.setShaderProgram(gL2ES2, shaderProgram);
            if (DEBUG) {
                if (bl7) {
                    System.err.printf("RegionRendererImpl01.useShaderProgram.X1: GOT renderModes %s, sel1 %s, key 0x%X -> sp %d / %d (changed)%n", new Object[]{Region.getRenderModeString(n), shaderModeSelector1, n6, shaderProgram.program(), shaderProgram.id()});
                } else {
                    System.err.printf("RegionRendererImpl01.useShaderProgram.X1: GOT renderModes %s, sel1 %s, key 0x%X -> sp %d / %d (keep)%n", new Object[]{Region.getRenderModeString(n), shaderModeSelector1, n6, shaderProgram.program(), shaderProgram.id()});
                }
            }
            return bl7;
        }
        String string2 = this.getVersionedShaderName();
        String string3 = bl3 ? string2 + "-pass" + (bl ? 1 : 2) : string2 + "-single";
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, AttributeNames.class, SHADER_SRC_SUB, SHADER_BIN_SUB, string3, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, AttributeNames.class, SHADER_SRC_SUB, SHADER_BIN_SUB, string2 + "-segment-head", true);
        if (bl2 && 36197 == textureSequence.getTextureTarget() && !gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
            throw new GLException("GL_OES_EGL_image_external requested but not available");
        }
        boolean bl8 = false;
        if (bl2 && 36197 == textureSequence.getTextureTarget() && Platform.OSType.ANDROID == Platform.getOSType() && gL2ES2.isGLES3()) {
            bl8 = true;
        }
        int n7 = shaderCode.defaultShaderCustomization(gL2ES2, !bl8, true);
        int n8 = n4 = bl8 ? 0 : shaderCode2.addGLSLVersion(gL2ES2);
        if (bl2) {
            n4 = shaderCode2.insertShaderSource(0, n4, textureSequence.getRequiredExtensionsShaderStub());
        }
        if (bl && bl8 || gL2ES2.isGLES2() && !gL2ES2.isGLES3()) {
            n4 = shaderCode2.insertShaderSource(0, n4, ShaderCode.createExtensionDirective("GL_OES_standard_derivatives", "enable"));
        }
        n4 = shaderCode2.addDefaultShaderPrecision(gL2ES2, n4);
        n4 = -1;
        if (!gL2ES2.getContext().hasRendererQuirk(5)) {
            n4 = shaderCode2.insertShaderSource(0, n4, GLSL_USE_DISCARD);
        }
        if (bl4) {
            n7 = shaderCode.insertShaderSource(0, n7, GLSL_USE_COLOR_CHANNEL);
            n4 = shaderCode2.insertShaderSource(0, n4, GLSL_USE_COLOR_CHANNEL);
        }
        if (bl2) {
            shaderCode.insertShaderSource(0, n7, GLSL_USE_COLOR_TEXTURE);
            n4 = shaderCode2.insertShaderSource(0, n4, GLSL_USE_COLOR_TEXTURE);
        }
        if (!bl) {
            n4 = shaderCode2.insertShaderSource(0, n4, GLSL_DEF_SAMPLE_COUNT + shaderModeSelector1.sampleCount + "\n");
            n4 = shaderCode2.insertShaderSource(0, n4, GLSL_CONST_SAMPLE_COUNT + shaderModeSelector1.sampleCount + ".0;\n");
        }
        try {
            n4 = shaderCode2.insertShaderSource(0, n4, AttributeNames.class, "uniforms.glsl");
            n4 = shaderCode2.insertShaderSource(0, n4, AttributeNames.class, "varyings.glsl");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read: includes", iOException);
        }
        if (0 > n4) {
            throw new RuntimeException("Failed to read: includes");
        }
        if (bl2) {
            n4 = shaderCode2.insertShaderSource(0, n4, "uniform " + textureSequence.getTextureSampler2DType() + " " + "gcu_ColorTexUnit" + ";\n");
            n4 = shaderCode2.insertShaderSource(0, n4, textureSequence.getTextureLookupFragmentShaderImpl());
        }
        n4 = shaderCode2.insertShaderSource(0, n4, GLSL_MAIN_BEGIN);
        String string4 = bl ? "-pass1-" : "-pass2-";
        String string5 = string2 + string4 + shaderModeSelector1.tech + shaderModeSelector1.sub + ".glsl";
        if (DEBUG) {
            System.err.printf("RegionRendererImpl01.useShaderProgram.1: segment %s%n", string5);
        }
        try {
            n4 = shaderCode2.insertShaderSource(0, n4, AttributeNames.class, string5);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read: " + string5, iOException);
        }
        if (0 > n4) {
            throw new RuntimeException("Failed to read: " + string5);
        }
        n4 = shaderCode2.insertShaderSource(0, n4, "}\n");
        if (bl2) {
            shaderCode2.replaceInShaderSource(gcuTexture2D, string);
        }
        shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.init(gL2ES2)) {
            throw new GLException("RegionRenderer: Couldn't init program: " + shaderProgram);
        }
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("could not link program: " + shaderProgram);
        }
        this.rs.setShaderProgram(gL2ES2, shaderProgram);
        this.shaderPrograms.put(n6, (Object)shaderProgram);
        if (DEBUG) {
            System.err.printf("RegionRendererImpl01.useShaderProgram.X1: PUT renderModes %s, sel1 %s, key 0x%X -> sp %d / %d (changed, new)%n", new Object[]{Region.getRenderModeString(n), shaderModeSelector1, n6, shaderProgram.program(), shaderProgram.id()});
        }
        return true;
    }

    public static interface GLCallback {
        public void run(GL var1, RegionRenderer var2);
    }

    private static enum ShaderModeSelector1 {
        PASS1_SIMPLE("curve", "_simple", 0),
        PASS1_WEIGHT("curve", "_weight", 0),
        PASS2_MSAA("msaa", "", 0),
        PASS2_VBAA_QUAL0_SAMPLES1("vbaa", "_flipquad3", 1),
        PASS2_VBAA_QUAL0_SAMPLES2("vbaa", "_flipquad3", 2),
        PASS2_VBAA_QUAL0_SAMPLES4("vbaa", "_flipquad3", 4),
        PASS2_VBAA_QUAL0_SAMPLES8("vbaa", "_flipquad3", 8),
        PASS2_VBAA_QUAL1_SAMPLES1("vbaa", "_bforce_odd", 1),
        PASS2_VBAA_QUAL1_SAMPLES2("vbaa", "_bforce_even", 2),
        PASS2_VBAA_QUAL1_SAMPLES3("vbaa", "_bforce_odd", 3),
        PASS2_VBAA_QUAL1_SAMPLES4("vbaa", "_bforce_even", 4),
        PASS2_VBAA_QUAL1_SAMPLES5("vbaa", "_bforce_odd", 5),
        PASS2_VBAA_QUAL1_SAMPLES6("vbaa", "_bforce_even", 6),
        PASS2_VBAA_QUAL1_SAMPLES7("vbaa", "_bforce_odd", 7),
        PASS2_VBAA_QUAL1_SAMPLES8("vbaa", "_bforce_even", 8);

        public final String tech;
        public final String sub;
        public final int sampleCount;

        private ShaderModeSelector1(String string2, String string3, int n2) {
            this.tech = string2;
            this.sub = string3;
            this.sampleCount = n2;
        }

        public static ShaderModeSelector1 selectPass1(int n) {
            return Region.hasVariableWeight(n) ? PASS1_WEIGHT : PASS1_SIMPLE;
        }

        public static ShaderModeSelector1 selectPass2(int n, int n2, int n3) {
            if (Region.isMSAA(n)) {
                return PASS2_MSAA;
            }
            if (Region.isVBAA(n)) {
                if (0 == n2) {
                    if (n3 < 2) {
                        return PASS2_VBAA_QUAL0_SAMPLES1;
                    }
                    if (n3 < 4) {
                        return PASS2_VBAA_QUAL0_SAMPLES2;
                    }
                    if (n3 < 8) {
                        return PASS2_VBAA_QUAL0_SAMPLES4;
                    }
                    return PASS2_VBAA_QUAL0_SAMPLES8;
                }
                switch (n3) {
                    case 0: 
                    case 1: {
                        return PASS2_VBAA_QUAL1_SAMPLES1;
                    }
                    case 2: {
                        return PASS2_VBAA_QUAL1_SAMPLES2;
                    }
                    case 3: {
                        return PASS2_VBAA_QUAL1_SAMPLES3;
                    }
                    case 4: {
                        return PASS2_VBAA_QUAL1_SAMPLES4;
                    }
                    case 5: {
                        return PASS2_VBAA_QUAL1_SAMPLES5;
                    }
                    case 6: {
                        return PASS2_VBAA_QUAL1_SAMPLES6;
                    }
                    case 7: {
                        return PASS2_VBAA_QUAL1_SAMPLES7;
                    }
                }
                return PASS2_VBAA_QUAL1_SAMPLES8;
            }
            return null;
        }
    }
}

