/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.opengl.math.Vec2f;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vert3fImmutable;

public final class Vertex
implements Vert3fImmutable,
Cloneable {
    private int id;
    private boolean onCurve;
    private final Vec3f coord = new Vec3f();
    private final Vec3f texCoord = new Vec3f();

    public Vertex() {
        this.id = Integer.MAX_VALUE;
    }

    public Vertex(Vertex vertex) {
        this.id = Integer.MAX_VALUE;
        this.coord.set(vertex.getCoord());
        this.texCoord.set(vertex.getTexCoord());
        this.setOnCurve(vertex.isOnCurve());
    }

    public Vertex(int n, boolean bl, Vec3f vec3f) {
        this.id = n;
        this.onCurve = bl;
        this.texCoord.set(vec3f);
    }

    public Vertex(int n, boolean bl, float f, float f2, float f3) {
        this.id = n;
        this.onCurve = bl;
        this.texCoord.set(f, f2, f3);
    }

    public Vertex(Vec3f vec3f, boolean bl) {
        this.id = Integer.MAX_VALUE;
        this.coord.set(vec3f);
        this.setOnCurve(bl);
    }

    public Vertex(Vec2f vec2f, boolean bl) {
        this.id = Integer.MAX_VALUE;
        this.coord.set(vec2f, 0.0f);
        this.setOnCurve(bl);
    }

    public Vertex(float f, float f2, boolean bl) {
        this(f, f2, 0.0f, bl);
    }

    public Vertex(float[] fArray, int n, int n2, boolean bl) {
        this(fArray[n + 0], fArray[n + 1], 2 < n2 ? fArray[n + 2] : 0.0f, bl);
    }

    public Vertex(float f, float f2, float f3, boolean bl) {
        this.id = Integer.MAX_VALUE;
        this.coord.set(f, f2, f3);
        this.setOnCurve(bl);
    }

    public final void setCoord(Vec3f vec3f) {
        this.coord.set(vec3f);
    }

    public void setCoord(Vec2f vec2f) {
        this.coord.set(vec2f, 0.0f);
    }

    public final void setCoord(float f, float f2, float f3) {
        this.coord.set(f, f2, f3);
    }

    public final void setCoord(float f, float f2) {
        this.coord.set(f, f2, 0.0f);
    }

    @Override
    public int getCoordCount() {
        return 3;
    }

    @Override
    public final Vec3f getCoord() {
        return this.coord;
    }

    public final void setX(float f) {
        this.coord.setX(f);
    }

    public final void setY(float f) {
        this.coord.setY(f);
    }

    public final void setZ(float f) {
        this.coord.setZ(f);
    }

    @Override
    public final float x() {
        return this.coord.x();
    }

    @Override
    public final float y() {
        return this.coord.y();
    }

    @Override
    public final float z() {
        return this.coord.z();
    }

    public final boolean isOnCurve() {
        return this.onCurve;
    }

    public final void setOnCurve(boolean bl) {
        this.onCurve = bl;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof Vertex)) {
            return false;
        }
        Vertex vertex = (Vertex)object;
        return this == vertex || this.isOnCurve() == vertex.isOnCurve() && this.getTexCoord().isEqual(vertex.getTexCoord()) && this.getCoord().isEqual(vertex.getCoord());
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public final Vec3f getTexCoord() {
        return this.texCoord;
    }

    public final void setTexCoord(Vec3f vec3f) {
        this.texCoord.set(vec3f);
    }

    public final void setTexCoord(float f, float f2, float f3) {
        this.texCoord.set(f, f2, f3);
    }

    public Vertex clone() {
        return new Vertex(this);
    }

    public String toString() {
        return "[ID: " + this.id + ", onCurve: " + this.onCurve + ": p " + this.coord + ", t " + this.texCoord + "]";
    }
}

