/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class BottleNeck {
    BottleNeck() {
    }

    static boolean checkArea(Triangulator triangulator, int n, int n2) {
        int n3;
        int n4;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = triangulator.fetchData(n);
        int n6 = triangulator.fetchNextData(n);
        int n7 = triangulator.fetchData(n6);
        while (n6 != n2) {
            n4 = triangulator.fetchNextData(n6);
            n3 = triangulator.fetchData(n4);
            d = Numerics.stableDet2D(triangulator, n5, n7, n3);
            d2 += d;
            n6 = n4;
            n7 = n3;
        }
        if (Numerics.le(d2, 1.0E-8)) {
            return false;
        }
        n6 = triangulator.fetchNextData(n2);
        n7 = triangulator.fetchData(n6);
        while (n6 != n) {
            n4 = triangulator.fetchNextData(n6);
            n3 = triangulator.fetchData(n4);
            d = Numerics.stableDet2D(triangulator, n5, n7, n3);
            d3 += d;
            n6 = n4;
            n7 = n3;
        }
        return !Numerics.le(d3, 1.0E-8);
    }

    static boolean checkBottleNeck(Triangulator triangulator, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = n;
        int n6 = triangulator.fetchPrevData(n4);
        int n7 = triangulator.fetchData(n6);
        if (n7 != n2 && n7 != n3 && (bl = Numerics.pntInTriangle(triangulator, n, n2, n3, n7))) {
            return true;
        }
        bl = n2 <= n3 ? (n5 <= n7 ? Numerics.segIntersect(triangulator, n2, n3, n5, n7, -1) : Numerics.segIntersect(triangulator, n2, n3, n7, n5, -1)) : (n5 <= n7 ? Numerics.segIntersect(triangulator, n3, n2, n5, n7, -1) : Numerics.segIntersect(triangulator, n3, n2, n7, n5, -1));
        if (bl) {
            return true;
        }
        n6 = triangulator.fetchNextData(n4);
        n7 = triangulator.fetchData(n6);
        if (n7 != n2 && n7 != n3 && (bl = Numerics.pntInTriangle(triangulator, n, n2, n3, n7))) {
            return true;
        }
        bl = n2 <= n3 ? (n5 <= n7 ? Numerics.segIntersect(triangulator, n2, n3, n5, n7, -1) : Numerics.segIntersect(triangulator, n2, n3, n7, n5, -1)) : (n5 <= n7 ? Numerics.segIntersect(triangulator, n3, n2, n5, n7, -1) : Numerics.segIntersect(triangulator, n3, n2, n7, n5, -1));
        if (bl) {
            return true;
        }
        n6 = triangulator.fetchNextData(n4);
        n7 = triangulator.fetchData(n6);
        while (n6 != n4) {
            if (n5 == n7 && BottleNeck.checkArea(triangulator, n4, n6)) {
                return true;
            }
            n6 = triangulator.fetchNextData(n6);
            n7 = triangulator.fetchData(n6);
        }
        return false;
    }
}

