/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsSyntaxException;
import com.dickimawbooks.bib2gls.GlsRecord;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RecordCountRule {
    private RuleType ruleType;
    private Pattern formatPattern;
    private Pattern counterPattern;
    private boolean matchAnd;
    private Bib2Gls bib2gls;

    public RecordCountRule(Bib2Gls bib2Gls) {
        this.bib2gls = bib2Gls;
        this.ruleType = RuleType.ALL;
    }

    public RecordCountRule(Bib2Gls bib2Gls, String string) throws Bib2GlsSyntaxException {
        this.bib2gls = bib2Gls;
        this.setRule(string);
    }

    public void setRule(String string) throws Bib2GlsSyntaxException {
        block14: {
            try {
                if (string.equals("all") || string.equals("a")) {
                    this.ruleType = RuleType.ALL;
                    break block14;
                }
                if (string.equals("non-ignored") || string.equals("n")) {
                    this.ruleType = RuleType.NON_IGNORED;
                    break block14;
                }
                if (string.length() > 2 && string.startsWith("c/") && string.endsWith("/")) {
                    this.ruleType = RuleType.COUNTER;
                    this.counterPattern = Pattern.compile(string.substring(2, string.length() - 1));
                    break block14;
                }
                if (string.length() > 2 && string.startsWith("f/")) {
                    int n;
                    if (string.endsWith("/")) {
                        n = string.length() - 1;
                        this.matchAnd = true;
                    } else if (string.endsWith("/and")) {
                        this.matchAnd = true;
                        n = string.length() - 4;
                    } else if (string.endsWith("/or")) {
                        this.matchAnd = false;
                        n = string.length() - 3;
                    } else {
                        throw new Bib2GlsSyntaxException(this.bib2gls.getMessage("error.invalid.record.count.rule", string));
                    }
                    int n2 = string.indexOf("/c/");
                    if (n2 == -1) {
                        this.ruleType = RuleType.FORMAT;
                        this.formatPattern = Pattern.compile(string.substring(2, n));
                    } else {
                        this.ruleType = RuleType.FORMAT_COUNTER;
                        this.formatPattern = Pattern.compile(string.substring(2, n2));
                        this.counterPattern = Pattern.compile(string.substring(n2 + 3, n));
                    }
                    break block14;
                }
                throw new Bib2GlsSyntaxException(this.bib2gls.getMessage("error.invalid.record.count.rule", string));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new Bib2GlsSyntaxException(this.bib2gls.getMessage("error.invalid.record.count.rule", string), patternSyntaxException);
            }
        }
    }

    public boolean isAllowed(GlsRecord glsRecord) {
        switch (this.ruleType) {
            case ALL: {
                return true;
            }
            case NON_IGNORED: {
                return !this.bib2gls.isIgnored(glsRecord);
            }
            case FORMAT: {
                return this.formatPattern.matcher(glsRecord.getFormat()).matches();
            }
            case COUNTER: {
                return this.counterPattern.matcher(glsRecord.getCounter()).matches();
            }
        }
        if (this.matchAnd) {
            return this.formatPattern.matcher(glsRecord.getFormat()).matches() && this.counterPattern.matcher(glsRecord.getCounter()).matches();
        }
        return this.formatPattern.matcher(glsRecord.getFormat()).matches() || this.counterPattern.matcher(glsRecord.getCounter()).matches();
    }

    static enum RuleType {
        ALL,
        NON_IGNORED,
        FORMAT,
        COUNTER,
        FORMAT_COUNTER;

    }
}

