/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class AbstractTeXApp
implements TeXApp {
    @Override
    public abstract String kpsewhich(String var1) throws IOException, InterruptedException;

    @Override
    public abstract void epstopdf(File var1, File var2) throws IOException, InterruptedException;

    @Override
    public abstract void wmftoeps(File var1, File var2) throws IOException, InterruptedException;

    @Override
    public abstract void convertimage(int var1, String[] var2, File var3, String[] var4, File var5) throws IOException, InterruptedException;

    @Override
    public abstract void progress(int var1);

    @Override
    public abstract void copyFile(File var1, File var2) throws IOException, InterruptedException;

    @Override
    public abstract String requestUserInput(String var1) throws IOException;

    @Override
    public void substituting(TeXParser teXParser, String string, String string2) {
        this.message(string + " -> " + string2);
    }

    @Override
    public void message(String string) {
        System.out.println(string);
    }

    @Override
    public void warning(TeXParser teXParser, String string) {
        System.err.println(this.getApplicationName() + ": " + string);
    }

    @Override
    public void error(Exception exception) {
        if (exception instanceof TeXSyntaxException) {
            System.err.println(this.getApplicationName() + ": " + ((TeXSyntaxException)exception).getMessage(this));
        } else {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isReadAccessAllowed(TeXPath teXPath) {
        return this.isReadAccessAllowed(teXPath.getFile());
    }

    @Override
    public boolean isReadAccessAllowed(File file) {
        return file.canRead();
    }

    @Override
    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return this.isWriteAccessAllowed(teXPath.getFile());
    }

    @Override
    public boolean isWriteAccessAllowed(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            return file2.canWrite();
        }
        return new File(System.getProperty("user.dir")).canWrite();
    }

    @Override
    public Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    @Override
    public BufferedReader createBufferedReader(Path path, Charset charset) throws IOException, SecurityException {
        try {
            return Files.newBufferedReader(path, charset);
        }
        catch (Throwable throwable) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), charset));
        }
    }

    @Override
    public BufferedWriter createBufferedWriter(Path path, Charset charset) throws IOException, SecurityException {
        try {
            return Files.newBufferedWriter(path, charset, new OpenOption[0]);
        }
        catch (Throwable throwable) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), charset));
        }
    }
}

