/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;

public class IntegerContentCommand
extends TextualContentCommand
implements TeXNumber {
    protected boolean isConstant = false;

    public IntegerContentCommand(String string, int n) {
        this(string, n, false);
    }

    public IntegerContentCommand(String string, int n, boolean bl) {
        this(string, "" + n, new UserNumber(n), bl);
    }

    protected IntegerContentCommand(String string, String string2, UserNumber userNumber) {
        this(string, string2, userNumber, false);
    }

    protected IntegerContentCommand(String string, String string2, UserNumber userNumber, boolean bl) {
        super(string, string2, userNumber);
        this.isConstant = bl;
    }

    @Override
    public Object clone() {
        return this.isConstant ? this : new IntegerContentCommand(this.getName(), this.getText(), (UserNumber)this.getNumber().clone());
    }

    @Override
    public TextualContentCommand duplicate(String string) {
        return new IntegerContentCommand(string, this.getText(), new UserNumber(this.getValue()), false);
    }

    @Override
    public int getValue() {
        return this.getNumber().getValue();
    }

    @Override
    public long longValue() {
        return this.getValue();
    }

    @Override
    public double doubleValue() {
        return this.getValue();
    }

    public void setValue(int n) {
        if (!this.isConstant) {
            this.text = "" + n;
            this.getNumber().setValue(n);
        }
    }

    public UserNumber getNumber() {
        return (UserNumber)this.data;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getNumber().number(teXParser);
    }

    @Override
    public void multiply(int n) {
        if (!this.isConstant) {
            this.getNumber().multiply(n);
            this.text = "" + this.getValue();
        }
    }

    @Override
    public void divide(int n) {
        if (!this.isConstant) {
            this.getNumber().divide(n);
            this.text = "" + this.getValue();
        }
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (this.isConstant) {
            throw new TeXSyntaxException(teXParser, "tex.error.cant_change_const", this.toString(teXParser));
        }
        this.getNumber().advance(teXParser, numerical);
        this.text = "" + this.getValue();
    }
}

