/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.auxfile.DivisionInfo;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class DivisionNode
implements Comparable<DivisionNode> {
    protected final int index;
    protected final int level;
    protected final DivisionInfo data;
    protected final DivisionNode parent;
    protected Vector<DivisionNode> children;
    protected int siblingIndex = 0;
    protected String ref;
    protected String title;
    protected String prefix;
    protected File file;

    public DivisionNode(DivisionInfo divisionInfo) {
        this(0, divisionInfo, null);
    }

    public DivisionNode(int n, DivisionInfo divisionInfo, DivisionNode divisionNode) {
        if (divisionInfo == null) {
            throw new NullPointerException();
        }
        divisionInfo.setSpecial(this);
        this.index = n;
        this.data = divisionInfo;
        this.parent = divisionNode;
        if (divisionNode == null) {
            this.level = 0;
        } else {
            this.level = divisionNode.level + 1;
            divisionNode.addChild(this);
        }
    }

    @Override
    public int compareTo(DivisionNode divisionNode) {
        if (this.index < divisionNode.index) {
            return -1;
        }
        if (this.index == divisionNode.index) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DivisionNode)) {
            return false;
        }
        return this.compareTo((DivisionNode)object) == 0;
    }

    public DivisionNode getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSiblingIndex() {
        return this.siblingIndex;
    }

    public int getLevel() {
        return this.level;
    }

    public void addChild(DivisionNode divisionNode) {
        if (divisionNode == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(divisionNode);
        divisionNode.siblingIndex = this.children.size() - 1;
    }

    public void addChild(int n, DivisionInfo divisionInfo) {
        if (divisionInfo == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        DivisionNode divisionNode = new DivisionNode(n, divisionInfo, this);
        this.children.add(divisionNode);
        divisionNode.siblingIndex = this.children.size() - 1;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Iterator<DivisionNode> getChildIterator() {
        return this.children == null ? null : this.children.iterator();
    }

    public DivisionNode getFirstChild() {
        return this.children == null || this.children.isEmpty() ? null : this.children.firstElement();
    }

    public DivisionNode getLastChild() {
        return this.children == null || this.children.isEmpty() ? null : this.children.lastElement();
    }

    public DivisionNode getNextSibling() {
        if (this.parent == null || this.siblingIndex == this.parent.getChildCount() - 1) {
            return null;
        }
        return this.parent.children.get(this.siblingIndex + 1);
    }

    public DivisionNode getPreviousSibling() {
        if (this.parent == null || this.siblingIndex == 0) {
            return null;
        }
        return this.parent.children.get(this.siblingIndex - 1);
    }

    public boolean isAncestor(DivisionNode divisionNode) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == divisionNode) {
            return true;
        }
        return this.parent.isAncestor(divisionNode);
    }

    public DivisionNode getAncestorAtUnit(String string) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getUnit().equals(string)) {
            return this.parent;
        }
        return this.parent.getAncestorAtUnit(string);
    }

    public String getUnit() {
        return this.data.getUnit();
    }

    public DivisionInfo getData() {
        return this.data;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public String getRef() {
        return this.ref;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file == null && this.parent != null ? this.parent.getFile() : this.file;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getId() {
        String string = this.data.getLabel();
        if (string == null) {
            String string2 = this.data.getTarget();
            if (string2 == null) {
                return "node" + this.index;
            }
            return string2;
        }
        return string;
    }

    public String toString() {
        return String.format("%s[label=%s,target=%s,prefix=%s,title=%s,ref=%s,index=%d,level=%d,siblingIndex=%d,childcount=%d]", this.getClass().getSimpleName(), this.data.getLabel(), this.data.getTarget(), this.prefix, this.title, this.ref, this.index, this.level, this.siblingIndex, this.getChildCount());
    }
}

