/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.TokenRegister;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtNumberOfNumber;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.MissingValue;
import com.dickimawbooks.texparserlib.latex.datatool.AddDelimiterOption;
import com.dickimawbooks.texparserlib.latex.datatool.CsvBlankOption;
import com.dickimawbooks.texparserlib.latex.datatool.DTLaction;
import com.dickimawbooks.texparserlib.latex.datatool.DTLaddalign;
import com.dickimawbooks.texparserlib.latex.datatool.DTLaddcolumn;
import com.dickimawbooks.texparserlib.latex.datatool.DTLaddheaderalign;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcleardb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcolumncount;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdbNewEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdbNewRow;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdbProvideData;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdbSetHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdeletedb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdisplayDbRow;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdisplaydb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdisplaydbAddBegin;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdisplaydbAddEnd;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdisplaydbAddItem;
import com.dickimawbooks.texparserlib.latex.datatool.DTLforeach;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifDbEmpty;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifDbExists;
import com.dickimawbooks.texparserlib.latex.datatool.DTLloaddb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLloaddbtex;
import com.dickimawbooks.texparserlib.latex.datatool.DTLmessage;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewdb;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewdbentry;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewrow;
import com.dickimawbooks.texparserlib.latex.datatool.DTLread;
import com.dickimawbooks.texparserlib.latex.datatool.DTLreconstructdata;
import com.dickimawbooks.texparserlib.latex.datatool.DTLreconstructdatabase;
import com.dickimawbooks.texparserlib.latex.datatool.DTLreconstructdbdata;
import com.dickimawbooks.texparserlib.latex.datatool.DTLrowcount;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetExpansion;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetdelimiter;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetheader;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetseparator;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsettabseparator;
import com.dickimawbooks.texparserlib.latex.datatool.DTLwrite;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataGidxSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeader;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolHeaderRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.datatool.EscapeCharsOption;
import com.dickimawbooks.texparserlib.latex.datatool.FileFormatType;
import com.dickimawbooks.texparserlib.latex.datatool.FileLoadedListener;
import com.dickimawbooks.texparserlib.latex.datatool.FileOverwriteOption;
import com.dickimawbooks.texparserlib.latex.datatool.IOSettings;
import com.dickimawbooks.texparserlib.latex.datatool.NewRowReadEvent;
import com.dickimawbooks.texparserlib.latex.datatool.NewRowReadListener;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenSty;
import com.dickimawbooks.texparserlib.latex.latex3.LaTeX3Boolean;
import com.dickimawbooks.texparserlib.latex.latex3.PropertyCommand;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import com.dickimawbooks.texparserlib.primitives.EndGraf;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class DataToolSty
extends LaTeXSty {
    private DataToolBaseSty dataToolBaseSty;
    private DataGidxSty datagidxSty;
    private ConcurrentHashMap<String, DataBase> databases;
    private DataBase latestDatabase = null;
    private Vector<FileLoadedListener> fileLoadedListeners;
    private Vector<NewRowReadListener> newRowReadListeners;
    private HashMap<Integer, String> csvLiteralMap;
    private boolean csvLiteralMappingOn = true;
    public static final String ERROR_DB_EXISTS = "datatool.db_exists";
    public static final String ERROR_DB_DOESNT_EXIST = "datatool.db_doesnt_exist";
    public static final String ERROR_MISMATCHED = "datatool.mismatched";
    public static final String ERROR_HEADER_EXISTS = "datatool.header.exists";
    public static final String ERROR_HEADER_DOESNT_EXIST = "datatool.header.doesnt_exist";
    public static final String ERROR_INVALID_HEADER = "datatool.invalid.header";
    public static final String ERROR_INVALID_CONTENTS = "datatool.invalid.contents";
    public static final String ERROR_ROW_NOT_FOUND = "datatool.row.not.found";
    public static final String ERROR_NO_COLUMNS = "datatool.no.columns";
    public static final String MESSAGE_LOADDB = "datatool.loaddb.message";
    public static final String IF_DISPLAY_ROW = "__datatool_if_display_row:nNT";
    public static final String DISPLAY_DB_ROW = "__datatool_display_db_row:Nn";
    public static final String NEW_ELEMENT_TRIM_BOOL = "l__datatool_new_element_trim_bool";
    public static final String CSV_LITERAL_CONTENT_BOOL = "l__datatool_csv_literal_content_bool";
    public static final String APPEND_ALLOWED_BOOL = "l__datatool_append_allowed_bool";
    public static final String DB_GLOBAL_BOOL = "l__datatool_db_global_bool";
    public static final String DB_STORE_DATUM_BOOL = "l__datatool_db_store_datum_bool";
    public static final String INCLUDE_HEADER_BOOL = "l_datatool_include_header_bool";
    public static final String MAX_COLS_INT = "l__datatool_max_cols_int";
    public static final String ROW_IDX_INT = "l__datatool_row_idx_int";
    public static final String COL_IDX_INT = "l__datatool_col_idx_int";
    public static final String ITEM_TYPE_INT = "l__datatool_item_type_int";
    public static final String CSV_HEADERS_PROP = "l__datatool_csv_headers_prop";
    public static final String CSV_KEYS_PROP = "l__datatool_csv_keys_prop";
    public static final String OMIT_COLUMNS_SEQ = "l__datatool_omit_columns_seq";
    public static final String OMIT_KEYS_SEQ = "l__datatool_omit_keys_seq";
    public static final String ONLY_COLUMNS_SEQ = "l__datatool_only_columns_seq";
    public static final String ONLY_KEYS_SEQ = "l__datatool_only_keys_seq";
    public static final String COLUMN_INDEXES_SEQ = "l__datatool_column_indexes_seq";
    public static final String DELIMITER = "@dtl@delimiter";
    public static final String SEPARATOR = "@dtl@separator";
    public static final String OMIT_LINES = "dtl@omitlines";
    public static final String LAST_LOADED_NAME = "dtllastloadeddb";
    public static final String DEFAULT_NAME = "l__datatool_default_dbname_tl";
    public static final String IO_NAME = "l__datatool_io_name_tl";
    public static final String DEFAULT_EXT = "l__datatool_default_ext_tl";
    public static final String FORMAT = "l__datatool_format_tl";
    public static final String PRE_DISPLAY = "l__datatool_pre_display_tl";
    public static final String POST_HEAD = "l_datatool_post_head_tl";
    public static final String USER_ALIGN = "l__datatool_user_align_tl";
    public static final String USER_HEADER = "l__datatool_user_header_tl";
    public static final String CONTENT_VAR = "l__datatool_content_tl";
    public static final String ALIGN_VAR = "l__datatool_align_tl";
    public static final String ROW_VAR = "l__datatool_row_tl";
    public static final String CAPTION = "l_datatool_caption_tl";
    public static final String SHORT_CAPTION = "l_datatool_short_caption_tl";
    public static final String CONT_CAPTION = "l_datatool_cont_caption_tl";
    public static final String LABEL = "l_datatool_label_tl";
    public static final String FOOT = "l_datatool_foot_tl";
    public static final String LAST_FOOT = "l_datatool_last_foot_tl";
    public static final String IO_OVERWRITE = "l__texparser_io_overwrite_tl";
    public static final String IO_EXPAND = "l__texparser_io_expand_tl";
    public static final String IO_STRICT_QUOTES_BOOL = "l__texparser_io_strict_quotes_tl";
    public static final String IO_ADD_DELIMITER = "l__texparser_io_add_delimiter_tl";
    public static final String CSV_ESCAPE_CHARS = "l__texparser_io_csv_escape_chars_tl";
    public static final String CSV_BLANK = "l__texparser_io_csv_blank_tl";
    public static final String CURRENT_FILE_TYPE = "l__texparser_current_file_type_tl";
    public static final String CURRENT_FILE_VERSION = "l__texparser_current_file_version_tl";
    public static final String END_READ = "__texparser_end_read:";
    public static final String POST_READ_HOOK = "__texparser_post_read_hook:";

    public DataToolSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "datatool", laTeXParserListener, bl);
        this.initCsvLiteralMap();
    }

    protected void initCsvLiteralMap() {
        this.csvLiteralMap = new HashMap();
        this.csvLiteralMap.put(92, "\\textbackslash ");
        this.csvLiteralMap.put(35, "\\#");
        this.csvLiteralMap.put(36, "\\$");
        this.csvLiteralMap.put(37, "\\%");
        this.csvLiteralMap.put(38, "\\&");
        this.csvLiteralMap.put(95, "\\_");
        this.csvLiteralMap.put(123, "\\{");
        this.csvLiteralMap.put(125, "\\}");
        this.csvLiteralMap.put(94, "\\textasciicircum ");
        this.csvLiteralMap.put(126, "\\textasciitilde ");
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new DTLifDbExists(this));
        this.registerControlSequence(new DTLifDbEmpty(this));
        this.registerControlSequence(new DTLnewdb(this));
        this.registerControlSequence(new DTLnewdb("DTLgnewdb", true, this));
        this.registerControlSequence(new DTLnewrow(this));
        this.registerControlSequence(new DTLcleardb(this));
        this.registerControlSequence(new DTLcleardb("DTLgcleardb", true, this));
        this.registerControlSequence(new DTLdeletedb(this));
        this.registerControlSequence(new DTLdeletedb("DTLgdeletedb", true, this));
        this.registerControlSequence(new DTLrowcount(this));
        this.registerControlSequence(new DTLcolumncount(this));
        this.registerControlSequence(new DTLnewdbentry(this));
        this.registerControlSequence(new DTLmessage());
        this.registerControlSequence(new DTLforeach(this));
        this.registerControlSequence(new DTLdisplaydb(this));
        this.registerControlSequence(new DTLdisplaydb("DTLdisplaylongdb", true, this));
        this.registerControlSequence(new DTLsetdelimiter(this));
        this.registerControlSequence(new DTLsetseparator(this));
        this.registerControlSequence(new DTLsettabseparator(this));
        this.registerControlSequence(new DTLaddcolumn(this));
        this.registerControlSequence(new DTLsetheader(this));
        this.registerControlSequence(new DTLaction(this));
        this.registerControlSequence(new DTLsetExpansion("dtlexpandnewvalue", true, this));
        this.registerControlSequence(new DTLsetExpansion("dtlnoexpandnewvalue", false, this));
        this.registerControlSequence(new EndGraf("DTLpar"));
        this.registerControlSequence(new DTLloaddbtex());
        this.registerControlSequence(new DTLloaddb(this));
        this.registerControlSequence(new TextualContentCommand("dtldefaultkey", "Column"));
        this.registerControlSequence(new GenericCommand("dtldisplaycr", null, TeXParserUtils.createStack(this.getParser(), new TeXCsRef("tabularnewline"))));
        this.registerControlSequence(new GenericCommand("DTLunsettype"));
        this.registerControlSequence(new GenericCommand("DTLstringtype", null, new UserNumber(0)));
        this.registerControlSequence(new GenericCommand("DTLinttype", null, new UserNumber(1)));
        this.registerControlSequence(new GenericCommand("DTLrealtype", null, new UserNumber(2)));
        this.registerControlSequence(new GenericCommand("DTLcurrencytype", null, new UserNumber(3)));
        NewIf.createConditional(true, this.getParser(), "ifdtlnoheader", false);
        NewIf.createConditional(true, this.getParser(), "ifdtlautokeys", false);
        this.registerControlSequence(new TextualContentCommand(DELIMITER, "\""));
        this.registerControlSequence(new TextualContentCommand(SEPARATOR, ","));
        this.registerControlSequence(new TextualContentCommand("dtldisplayvalign", "c"));
        this.registerControlSequence(new TokenListCommand("dtldisplaystarttab"));
        this.registerControlSequence(new TokenListCommand("dtldisplayafterhead"));
        this.registerControlSequence(new TokenListCommand("dtldisplayendtab"));
        this.registerControlSequence(new TokenListCommand("dtldisplaystartrow"));
        this.registerControlSequence(new TextualContentCommand("dtlstringalign", "l"));
        this.registerControlSequence(new TextualContentCommand("dtlintalign", "r"));
        this.registerControlSequence(new TextualContentCommand("dtlrealalign", "r"));
        this.registerControlSequence(new TextualContentCommand("dtlcurrencyalign", "r"));
        this.registerControlSequence(new TokenListCommand("dtlbetweencols"));
        this.registerControlSequence(new TokenListCommand("dtlbeforecols"));
        this.registerControlSequence(new TokenListCommand("dtlaftercols"));
        this.getParser().getSettings().newcount(true, "dtlcolumnnum");
        this.getParser().getSettings().newcount(true, "dtlrownum");
        this.getParser().getSettings().newcount(true, OMIT_LINES);
        this.registerControlSequence(new DTLread(this));
        this.registerControlSequence(new DTLwrite(this));
        this.registerControlSequence(new TextualContentCommand("dtldisplaydbenv", "tabular"));
        this.registerControlSequence(new TextualContentCommand("dtldisplaylongdbenv", "longtable"));
        this.registerControlSequence(new DTLdisplaydbAddBegin());
        this.registerControlSequence(new DTLdisplaydbAddEnd());
        this.registerControlSequence(new DTLdisplaydbAddItem());
        this.registerControlSequence(new AtFirstOfOne("dtlstringformat"));
        this.registerControlSequence(new AtFirstOfOne("dtlintformat"));
        this.registerControlSequence(new AtFirstOfOne("dtlrealformat"));
        this.registerControlSequence(new AtFirstOfOne("dtlcurrencyformat"));
        this.registerControlSequence(new GenericCommand(this.listener, true, "dtlcolumnheader", 2, TeXParserUtils.createStack(this.getParser(), new TeXCsRef("multicolumn"), UserNumber.ONE, TeXParserUtils.createGroup(this.getParser(), this.listener.getParam(1)), TeXParserUtils.createGroup(this.getParser(), new TeXCsRef("dtlheaderformat"), TeXParserUtils.createGroup(this.getParser(), this.listener.getParam(2))))));
        this.registerControlSequence(new GenericCommand(this.listener, true, "dtlheaderformat", 1, TeXParserUtils.createStack(this.getParser(), new TeXCsRef("textbf"), TeXParserUtils.createGroup(this.getParser(), this.listener.getParam(1)))));
        this.registerControlSequence(new AtNumberOfNumber(IF_DISPLAY_ROW, 3, 3));
        this.registerControlSequence(new DTLdbProvideData(this));
        this.registerControlSequence(new DTLdbNewRow(this));
        this.registerControlSequence(new DTLdbNewEntry(this));
        this.registerControlSequence(new DTLdbSetHeader(this));
        this.registerControlSequence(new DTLreconstructdatabase(this));
        this.registerControlSequence(new DTLreconstructdbdata(this));
        this.registerControlSequence(new DTLreconstructdata(this));
        this.registerControlSequence(new DTLaddalign());
        this.registerControlSequence(new DTLaddheaderalign());
        this.registerControlSequence(new DTLdisplayDbRow(this));
        this.getParser().getSettings().newcount(true, MAX_COLS_INT);
        this.getParser().getSettings().newcount(true, ROW_IDX_INT);
        this.getParser().getSettings().newcount(true, COL_IDX_INT);
        this.getParser().getSettings().newcount(true, ITEM_TYPE_INT);
        this.registerControlSequence(new LaTeX3Boolean(DB_GLOBAL_BOOL, true));
        this.registerControlSequence(new LaTeX3Boolean(NEW_ELEMENT_TRIM_BOOL, true));
        this.registerControlSequence(new LaTeX3Boolean(DB_STORE_DATUM_BOOL, false));
        this.registerControlSequence(new LaTeX3Boolean(INCLUDE_HEADER_BOOL, true));
        this.registerControlSequence(new LaTeX3Boolean(APPEND_ALLOWED_BOOL, true));
        this.registerControlSequence(new LaTeX3Boolean(CSV_LITERAL_CONTENT_BOOL, true));
        this.registerControlSequence(new TextualContentCommand(DEFAULT_NAME, "untitled"));
        this.registerControlSequence(new PropertyCommand(CSV_HEADERS_PROP));
        this.registerControlSequence(new PropertyCommand(CSV_KEYS_PROP));
        this.registerControlSequence(new SequenceCommand(OMIT_COLUMNS_SEQ));
        this.registerControlSequence(new SequenceCommand(OMIT_KEYS_SEQ));
        this.registerControlSequence(new SequenceCommand(ONLY_COLUMNS_SEQ));
        this.registerControlSequence(new SequenceCommand(ONLY_KEYS_SEQ));
        this.registerControlSequence(new TokenListCommand(PRE_DISPLAY));
        this.registerControlSequence(new TokenListCommand(POST_HEAD));
        this.registerControlSequence(new TokenListCommand(USER_ALIGN));
        this.registerControlSequence(new TokenListCommand(USER_HEADER));
    }

    @Override
    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
        this.getListener().requirepackage(null, "etoolbox", false, teXObjectList);
        this.dataToolBaseSty = (DataToolBaseSty)this.getListener().requirepackage(null, "datatool-base", true, teXObjectList);
        this.dataToolBaseSty.setDataBaseSty(this);
    }

    public static String getContentsRegisterName(String string) {
        return String.format("dtldb@%s", string);
    }

    public static String getHeaderRegisterName(String string) {
        return String.format("dtlkeys@%s", string);
    }

    public static String getRowCountRegisterName(String string) {
        return String.format("dtlrows@%s", string);
    }

    public static String getColumnCountRegisterName(String string) {
        return String.format("dtlcols@%s", string);
    }

    public static String getColumnHeaderName(String string, String string2) {
        return String.format("dtl@ci@%s@%s", string, string2);
    }

    public static String getColumnHeaderName(String string, DataToolHeader dataToolHeader) {
        return DataToolSty.getColumnHeaderName(string, dataToolHeader.getColumnLabel());
    }

    public int getRowCount(String string) throws IOException {
        DataBase dataBase = this.update(string);
        return dataBase.getRowCount();
    }

    public int getColumnCount(String string) throws IOException {
        DataBase dataBase = this.update(string);
        return dataBase.getColumnCount();
    }

    public void setExpansion(boolean bl) {
        if (bl) {
            this.getListener().getParser().putControlSequence(true, new IfTrue("if@dtl@expansion@on"));
        } else {
            this.getListener().getParser().putControlSequence(true, new IfFalse("if@dtl@expansion@on"));
        }
    }

    public boolean isExpansionOn() {
        ControlSequence controlSequence = this.getListener().getParser().getControlSequence("if@dtl@expansion@on");
        return controlSequence instanceof IfTrue;
    }

    public boolean dbExists(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(DataToolSty.getContentsRegisterName(string));
        return controlSequence != null;
    }

    public boolean dbEmpty(String string) throws IOException {
        return this.getRowCount(string) == 0;
    }

    public DataBase createDataBase(String string, boolean bl) throws TeXSyntaxException {
        if (string == null) {
            throw new NullPointerException();
        }
        TeXParser teXParser = this.getListener().getParser();
        if (this.dbExists(string)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_EXISTS, string);
        }
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.newtoks(!bl, DataToolSty.getContentsRegisterName(string));
        teXSettings.newtoks(!bl, DataToolSty.getHeaderRegisterName(string));
        teXSettings.newcount(!bl, DataToolSty.getRowCountRegisterName(string));
        teXSettings.newcount(!bl, DataToolSty.getColumnCountRegisterName(string));
        DataBase dataBase = new DataBase(string);
        if (this.databases == null) {
            this.databases = new ConcurrentHashMap();
        }
        this.latestDatabase = dataBase;
        this.databases.put(string, dataBase);
        return dataBase;
    }

    public DataBase getLatestDataBase() {
        return this.latestDatabase;
    }

    public void clearLatestDataBase() {
        this.latestDatabase = null;
    }

    public void setLatestDataBase(DataBase dataBase) {
        this.latestDatabase = dataBase;
    }

    public void setLatestDataBase(String string) throws IOException {
        this.latestDatabase = this.getDataBase(string);
    }

    public int getDataBaseCount() {
        return this.databases == null ? 0 : this.databases.size();
    }

    public Enumeration<String> getDataBaseNames() {
        return this.databases == null ? null : this.databases.keys();
    }

    public DataBase getDataBase(String string) throws IOException {
        DataBase dataBase = null;
        if (this.databases != null) {
            dataBase = this.databases.get(string);
        }
        if (dataBase == null) {
            dataBase = this.update(string);
        }
        return dataBase;
    }

    public DataBase clearDataBase(String string, boolean bl) throws TeXSyntaxException {
        TeXParser teXParser = this.getListener().getParser();
        DataBase dataBase = null;
        if (this.databases == null) {
            this.databases = new ConcurrentHashMap();
        } else {
            dataBase = this.databases.get(string);
        }
        TeXSettings teXSettings = teXParser.getSettings();
        if (dataBase != null) {
            DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
            for (DataToolHeader dataToolHeader : dataToolHeaderRow) {
                if (bl) {
                    teXSettings.removeGlobalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
                    continue;
                }
                teXSettings.removeLocalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
            }
        }
        if (bl) {
            teXSettings.globalSetRegister(DataToolSty.getContentsRegisterName(string), new TeXObjectList());
            teXSettings.globalSetRegister(DataToolSty.getHeaderRegisterName(string), new TeXObjectList());
            teXSettings.globalSetRegister(DataToolSty.getRowCountRegisterName(string), (TeXObject)new UserNumber(0));
            teXSettings.globalSetRegister(DataToolSty.getColumnCountRegisterName(string), (TeXObject)new UserNumber(0));
        } else {
            teXSettings.localSetRegister(DataToolSty.getContentsRegisterName(string), new TeXObjectList());
            teXSettings.localSetRegister(DataToolSty.getHeaderRegisterName(string), new TeXObjectList());
            teXSettings.localSetRegister(DataToolSty.getRowCountRegisterName(string), (TeXObject)new UserNumber(0));
            teXSettings.localSetRegister(DataToolSty.getColumnCountRegisterName(string), (TeXObject)new UserNumber(0));
        }
        if (dataBase == null) {
            dataBase = new DataBase(string);
            this.databases.put(string, dataBase);
        } else {
            dataBase.update(null, null);
        }
        return dataBase;
    }

    public DataToolEntryRow addNewRow(String string) throws IOException {
        DataToolRows dataToolRows = this.getContents(string);
        DataToolEntryRow dataToolEntryRow = new DataToolEntryRow(this);
        dataToolRows.add(dataToolEntryRow);
        this.update(string, dataToolRows);
        return dataToolEntryRow;
    }

    public DataToolHeader addNewColumn(String string, String string2) throws IOException {
        DataToolHeaderRow dataToolHeaderRow = this.getHeaderContents(string);
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader(string2);
        if (dataToolHeader != null) {
            throw new LaTeXSyntaxException(this.getListener().getParser(), ERROR_HEADER_EXISTS, string2);
        }
        dataToolHeader = new DataToolHeader(this, dataToolHeaderRow.getMaxIndex() + 1, string2);
        dataToolHeaderRow.add(dataToolHeader);
        this.update(string, dataToolHeaderRow);
        return dataToolHeader;
    }

    public DataToolHeader setColumnHeader(String string, String string2, TeXObject teXObject) throws IOException {
        DataToolHeaderRow dataToolHeaderRow = this.getHeaderContents(string);
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader(string2);
        if (dataToolHeader == null) {
            throw new LaTeXSyntaxException(this.getListener().getParser(), ERROR_HEADER_DOESNT_EXIST, string2);
        }
        dataToolHeader.setTitle(teXObject);
        return dataToolHeader;
    }

    public DataElement getElement(TeXObject teXObject) throws IOException {
        return this.dataToolBaseSty.getElement(teXObject);
    }

    public boolean isNull(TeXObject teXObject) {
        return this.dataToolBaseSty.isNull(teXObject);
    }

    public DataToolEntry addNewEntry(String string, String string2, TeXObject teXObject) throws IOException {
        DataToolEntryRow dataToolEntryRow;
        DataToolRows dataToolRows = this.getContents(string);
        DataToolHeaderRow dataToolHeaderRow = this.getHeaderContents(string);
        if (dataToolRows.size() == 0) {
            dataToolEntryRow = new DataToolEntryRow(this);
            dataToolRows.add(dataToolEntryRow);
        } else {
            dataToolEntryRow = (DataToolEntryRow)dataToolRows.lastElement();
        }
        DataToolHeader dataToolHeader = dataToolHeaderRow.getHeader(string2);
        if (dataToolHeader == null) {
            dataToolHeader = new DataToolHeader(this, dataToolHeaderRow.getMaxIndex() + 1, string2);
            dataToolHeaderRow.add(dataToolHeader);
        }
        DataToolEntry dataToolEntry = new DataToolEntry(this, dataToolHeader.getColumnIndex(), teXObject);
        dataToolEntryRow.add(dataToolEntry);
        TeXObject teXObject2 = dataToolEntry.getContents();
        if (teXObject2 instanceof DataElement) {
            dataToolHeader.updateType((DataElement)teXObject2);
        }
        this.update(string, dataToolRows);
        return dataToolEntry;
    }

    public DataBase removeDataBase(String string) {
        return this.removeDataBase(string, true);
    }

    public DataBase removeDataBase(String string, boolean bl) {
        DataBase dataBase = null;
        if (this.databases != null) {
            dataBase = this.databases.remove(string);
        }
        TeXSettings teXSettings = this.getListener().getParser().getSettings();
        if (dataBase != null) {
            DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
            for (DataToolHeader dataToolHeader : dataToolHeaderRow) {
                if (bl) {
                    teXSettings.removeGlobalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
                    continue;
                }
                teXSettings.removeLocalControlSequence(DataToolSty.getColumnHeaderName(string, dataToolHeader));
            }
        }
        if (bl) {
            teXSettings.removeGlobalControlSequence(DataToolSty.getContentsRegisterName(string));
            teXSettings.removeGlobalControlSequence(DataToolSty.getHeaderRegisterName(string));
            teXSettings.removeGlobalControlSequence(DataToolSty.getRowCountRegisterName(string));
            teXSettings.removeGlobalControlSequence(DataToolSty.getColumnCountRegisterName(string));
        } else {
            teXSettings.removeLocalControlSequence(DataToolSty.getContentsRegisterName(string));
            teXSettings.removeLocalControlSequence(DataToolSty.getHeaderRegisterName(string));
            teXSettings.removeLocalControlSequence(DataToolSty.getRowCountRegisterName(string));
            teXSettings.removeLocalControlSequence(DataToolSty.getColumnCountRegisterName(string));
        }
        return dataBase;
    }

    public void updateInternals(boolean bl, String string) throws TeXSyntaxException {
        DataBase dataBase = null;
        if (this.databases != null) {
            dataBase = this.databases.get(string);
        }
        if (dataBase == null) {
            throw new LaTeXSyntaxException(this.getParser(), ERROR_DB_DOESNT_EXIST, string);
        }
        String string2 = DataToolSty.getHeaderRegisterName(string);
        String string3 = DataToolSty.getContentsRegisterName(string);
        String string4 = DataToolSty.getRowCountRegisterName(string);
        String string5 = DataToolSty.getColumnCountRegisterName(string);
        TeXSettings teXSettings = this.getParser().getSettings();
        DataToolHeaderRow dataToolHeaderRow = dataBase.getHeaders();
        if (bl) {
            teXSettings.globalSetRegister(string2, dataToolHeaderRow);
            teXSettings.globalSetRegister(string3, dataBase.getData());
            teXSettings.globalSetRegister(string4, dataBase.getRowCount());
            teXSettings.globalSetRegister(string5, dataBase.getColumnCount());
        } else {
            teXSettings.localSetRegister(string2, dataToolHeaderRow);
            teXSettings.localSetRegister(string3, dataBase.getData());
            teXSettings.localSetRegister(string4, dataBase.getRowCount());
            teXSettings.localSetRegister(string5, dataBase.getColumnCount());
        }
        for (DataToolHeader dataToolHeader : dataToolHeaderRow) {
            String string6 = dataToolHeader.getColumnLabel();
            int n = dataToolHeader.getColumnIndex();
            this.getParser().putControlSequence(!bl, new IntegerContentCommand(DataToolSty.getColumnHeaderName(string, string6), n));
        }
    }

    public DataToolHeaderRow getHeaderContents(String string) throws IOException {
        TeXParser teXParser = this.getListener().getParser();
        ControlSequence controlSequence = teXParser.getControlSequence(DataToolSty.getHeaderRegisterName(string));
        if (controlSequence == null || !(controlSequence instanceof TokenRegister)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_DOESNT_EXIST, string);
        }
        TokenRegister tokenRegister = (TokenRegister)controlSequence;
        TeXObject teXObject = tokenRegister.getContents(teXParser);
        if (teXObject instanceof DataToolHeaderRow) {
            return (DataToolHeaderRow)teXObject;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_HEADER, teXObject.toString(teXParser));
        }
        DataToolHeaderRow dataToolHeaderRow = DataToolHeaderRow.toHeaderRow(teXParser, (TeXObjectList)teXObject, this);
        tokenRegister.setContents(teXParser, dataToolHeaderRow);
        return dataToolHeaderRow;
    }

    public DataToolRows getContents(String string) throws IOException {
        DataToolRows dataToolRows;
        TeXParser teXParser = this.getListener().getParser();
        ControlSequence controlSequence = teXParser.getControlSequence(DataToolSty.getContentsRegisterName(string));
        if (controlSequence == null || !(controlSequence instanceof TokenRegister)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_DB_DOESNT_EXIST, string);
        }
        TokenRegister tokenRegister = (TokenRegister)controlSequence;
        TeXObject teXObject = tokenRegister.getContents(teXParser);
        if (teXObject instanceof DataToolRows) {
            return (DataToolRows)teXObject;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            throw new LaTeXSyntaxException(teXParser, ERROR_INVALID_CONTENTS, teXObject);
        }
        int n = ((TeXObjectList)teXObject).size();
        if (n == 0) {
            dataToolRows = new DataToolRows(this);
        } else {
            controlSequence = teXParser.getControlSequence(DataToolSty.getRowCountRegisterName(string));
            int n2 = 0;
            if (controlSequence instanceof CountRegister) {
                n2 = ((CountRegister)controlSequence).getValue();
            }
            dataToolRows = DataToolRows.toRows(teXParser, (TeXObjectList)teXObject, this, n2);
        }
        tokenRegister.setContents(teXParser, dataToolRows);
        return dataToolRows;
    }

    protected synchronized DataBase update(String string) throws IOException {
        return this.update(string, this.getHeaderContents(string), this.getContents(string));
    }

    protected synchronized DataBase update(String string, DataToolHeaderRow dataToolHeaderRow) throws IOException {
        return this.update(string, dataToolHeaderRow, this.getContents(string));
    }

    protected synchronized DataBase update(String string, DataToolRows dataToolRows) throws IOException {
        return this.update(string, this.getHeaderContents(string), dataToolRows);
    }

    protected synchronized DataBase update(String string, DataToolHeaderRow dataToolHeaderRow, DataToolRows dataToolRows) throws TeXSyntaxException {
        DataBase dataBase = null;
        if (this.databases == null) {
            this.databases = new ConcurrentHashMap();
        } else {
            dataBase = this.databases.get(string);
        }
        boolean bl = this.isDbGlobalOn();
        if (dataBase == null) {
            dataBase = new DataBase(string, dataToolHeaderRow, dataToolRows);
            this.databases.put(string, dataBase);
        } else {
            dataBase.update(dataToolHeaderRow, dataToolRows);
        }
        TeXParser teXParser = this.getListener().getParser();
        String string2 = DataToolSty.getColumnCountRegisterName(string);
        String string3 = DataToolSty.getRowCountRegisterName(string);
        if (bl) {
            teXParser.getSettings().globalSetRegister(string2, dataBase.getColumnCount());
            teXParser.getSettings().globalSetRegister(string3, dataBase.getRowCount());
        } else {
            teXParser.getSettings().localSetRegister(string2, dataBase.getColumnCount());
            teXParser.getSettings().localSetRegister(string3, dataBase.getRowCount());
        }
        return dataBase;
    }

    public boolean acceptNewRowRead(IOSettings iOSettings, DataBase dataBase, DataObjectList dataObjectList) {
        boolean bl = true;
        if (this.newRowReadListeners != null) {
            NewRowReadEvent newRowReadEvent = new NewRowReadEvent(iOSettings, dataBase, dataObjectList);
            for (NewRowReadListener newRowReadListener : this.newRowReadListeners) {
                if (!newRowReadListener.acceptNewRowRead(newRowReadEvent)) {
                    bl = false;
                }
                if (!newRowReadEvent.isConsumed()) continue;
                break;
            }
        }
        return bl;
    }

    public void addNewRowReadListener(NewRowReadListener newRowReadListener) {
        if (this.newRowReadListeners == null) {
            this.newRowReadListeners = new Vector();
        }
        this.newRowReadListeners.add(newRowReadListener);
    }

    public void removeNewRowReadListener(NewRowReadListener newRowReadListener) {
        if (this.newRowReadListeners != null) {
            this.newRowReadListeners.remove(newRowReadListener);
        }
    }

    public void removeAllNewRowReadListeners() {
        if (this.newRowReadListeners != null) {
            this.newRowReadListeners.clear();
        }
    }

    public boolean isDbGlobalOn() {
        return TeXParserUtils.isTrue(DB_GLOBAL_BOOL, this.getParser());
    }

    public DataToolBaseSty getDataToolBaseSty() {
        return this.dataToolBaseSty;
    }

    public IfThenSty getIfThenSty() {
        return this.dataToolBaseSty.getIfThenSty();
    }

    public DataGidxSty getDataGidxSty() {
        return this.datagidxSty;
    }

    public void setDataGidxSty(DataGidxSty dataGidxSty) {
        this.datagidxSty = dataGidxSty;
    }

    public Iterator<String> getDataBaseKeySetIterator() {
        return this.databases == null ? null : ((ConcurrentHashMap.KeySetView)this.databases.keySet()).iterator();
    }

    public int getSeparator() throws IOException {
        ControlSequence controlSequence = this.getParser().getControlSequence(SEPARATOR);
        if (controlSequence == null) {
            throw new TeXSyntaxException(this.getParser(), "tex.error.undefined", "\\@dtl@separator");
        }
        int n = -1;
        if (controlSequence instanceof TextualContentCommand) {
            n = ((TextualContentCommand)controlSequence).getText().codePointAt(0);
        } else {
            String string = this.getParser().expandToString(controlSequence, this.getParser());
            n = string.codePointAt(0);
        }
        return n;
    }

    public int getDelimiter() throws IOException {
        ControlSequence controlSequence = this.getParser().getControlSequence(DELIMITER);
        if (controlSequence == null) {
            throw new TeXSyntaxException(this.getParser(), "tex.error.undefined", "\\@dtl@delimiter");
        }
        int n = -1;
        if (controlSequence instanceof TextualContentCommand) {
            n = ((TextualContentCommand)controlSequence).getText().codePointAt(0);
        } else {
            String string = this.getParser().expandToString(controlSequence, this.getParser());
            n = string.codePointAt(0);
        }
        return n;
    }

    public void setSeparator(int n) {
        this.getParser().putControlSequence(true, new TextualContentCommand(SEPARATOR, new String(Character.toChars(n))));
    }

    public void setDelimiter(int n) {
        this.getParser().putControlSequence(true, new TextualContentCommand(DELIMITER, new String(Character.toChars(n))));
    }

    public void processSetupOption(String string, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (teXObject instanceof MissingValue) {
            teXObject = null;
        }
        if (string.equals("default-name")) {
            if (teXObject == null) {
                throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_key_value", string);
            }
            this.getParser().putControlSequence(true, new TextualContentCommand(DEFAULT_NAME, this.getParser().expandToString(teXObject, teXObjectList)));
        } else if (string.equals("global")) {
            boolean bl = true;
            if (teXObject != null) {
                bl = Boolean.parseBoolean(this.getParser().expandToString(teXObject, teXObjectList));
            }
            this.getParser().putControlSequence(true, new LaTeX3Boolean(DB_GLOBAL_BOOL, bl));
        } else if (string.equals("store-datum")) {
            boolean bl = true;
            if (teXObject != null) {
                bl = Boolean.parseBoolean(this.getParser().expandToString(teXObject, teXObjectList));
            }
            this.getParser().putControlSequence(true, new LaTeX3Boolean(DB_STORE_DATUM_BOOL, bl));
        } else if (string.equals("new-value-trim")) {
            boolean bl = true;
            if (teXObject != null) {
                bl = Boolean.parseBoolean(this.getParser().expandToString(teXObject, teXObjectList));
            }
            this.getParser().putControlSequence(true, new LaTeX3Boolean(NEW_ELEMENT_TRIM_BOOL, bl));
        } else if (string.equals("new-value-expand")) {
            boolean bl = true;
            if (teXObject != null) {
                bl = Boolean.parseBoolean(this.getParser().expandToString(teXObject, teXObjectList));
            }
            ControlSequence controlSequence = bl ? this.getParser().getListener().getControlSequence("dtlexpandnewvalue") : this.getParser().getListener().getControlSequence("dtlnoexpandnewvalue");
            TeXParserUtils.process(controlSequence, this.getParser(), teXObjectList);
        } else if (string.equals("delimiter")) {
            if (teXObject == null) {
                throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_key_value", string);
            }
            String string2 = this.getParser().expandToString(teXObject, teXObjectList);
            this.setDelimiter(string2.codePointAt(0));
        } else if (string.equals("separator")) {
            if (teXObject == null) {
                throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_key_value", string);
            }
            String string3 = this.getParser().expandToString(teXObject, teXObjectList);
            this.setSeparator(string3.codePointAt(0));
        } else if (string.equals("io")) {
            if (teXObject != null) {
                this.processIOKeys(teXObject, teXObjectList);
            }
        } else if (string.equals("display")) {
            if (teXObject != null) {
                this.processDisplayKeys(teXObject, teXObjectList);
            }
        } else {
            throw new LaTeXSyntaxException(this.getParser(), "latex.unknown.option", string, "datatool");
        }
    }

    public void processIOKeys(TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        TeXParser teXParser = this.getParser();
        KeyValList keyValList = TeXParserUtils.toKeyValList(teXObject, teXParser);
        for (String string : keyValList.keySet()) {
            TeXObject teXObject2;
            TeXObject teXObject3 = (TeXObject)keyValList.get(string);
            if (string.equals("name")) {
                teXParser.putControlSequence(true, new TextualContentCommand(IO_NAME, teXParser.expandToString(teXObject3, teXObjectList)));
                continue;
            }
            if (string.equals("keys")) {
                PropertyCommand<Integer> propertyCommand = new PropertyCommand<Integer>(CSV_KEYS_PROP);
                if (teXObject3 != null) {
                    CsvList csvList = TeXParserUtils.toCsvList(teXObject3, teXParser);
                    for (int i = 0; i < csvList.size(); ++i) {
                        teXObject2 = csvList.getValue(i);
                        propertyCommand.put(i + 1, teXObject2);
                    }
                }
                teXParser.putControlSequence(true, propertyCommand);
                continue;
            }
            if (string.equals("headers")) {
                PropertyCommand<Integer> propertyCommand = new PropertyCommand<Integer>(CSV_HEADERS_PROP);
                if (teXObject3 != null) {
                    CsvList csvList = TeXParserUtils.toCsvList(teXObject3, teXParser);
                    for (int i = 0; i < csvList.size(); ++i) {
                        teXObject2 = csvList.getValue(i);
                        propertyCommand.put(i + 1, teXObject2);
                    }
                }
                teXParser.putControlSequence(true, propertyCommand);
                continue;
            }
            if (string.equals("expand")) {
                String string2 = teXObject3 == null ? "protected" : teXParser.expandToString(teXObject3, teXObjectList);
                this.setIOExpandOption(string2, teXObjectList);
                continue;
            }
            if (string.equals("format")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string3 = teXParser.expandToString(teXObject3, teXObjectList);
                teXParser.putControlSequence(true, new TextualContentCommand(FORMAT, string3));
                if (string3.startsWith("dbtex")) {
                    teXParser.putControlSequence(true, new TextualContentCommand(DEFAULT_EXT, "dbtex"));
                    continue;
                }
                if (string3.startsWith("dtltex")) {
                    teXParser.putControlSequence(true, new TextualContentCommand(DEFAULT_EXT, "dtltex"));
                    continue;
                }
                if (string3.equals("csv")) {
                    teXParser.putControlSequence(true, new TextualContentCommand(DEFAULT_EXT, "csv"));
                    continue;
                }
                if (string3.equals("tsv")) {
                    teXParser.putControlSequence(true, new TextualContentCommand(DEFAULT_EXT, "tsv"));
                    this.setSeparator(9);
                    continue;
                }
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string3, "datatool/io");
            }
            if (string.equals("add-delimiter")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string4 = teXParser.expandToString(teXObject3, teXObjectList);
                AddDelimiterOption addDelimiterOption = AddDelimiterOption.fromOptionName(string4);
                if (addDelimiterOption != null) {
                    teXParser.putControlSequence(true, new TextualContentCommand(IO_ADD_DELIMITER, string4));
                    continue;
                }
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string4, "datatool/io");
            }
            if (string.equals("csv-escape-chars")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string5 = teXParser.expandToString(teXObject3, teXObjectList);
                EscapeCharsOption escapeCharsOption = EscapeCharsOption.fromOptionName(string5);
                if (escapeCharsOption != null) {
                    teXParser.putControlSequence(true, new TextualContentCommand(CSV_ESCAPE_CHARS, string5));
                    continue;
                }
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string5, "datatool/io");
            }
            if (string.equals("csv-content")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                boolean bl = true;
                String string6 = teXParser.expandToString(teXObject3, teXObjectList).trim();
                if (string6.equals("tex")) {
                    bl = false;
                } else if (string6.equals("literal")) {
                    bl = true;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string6, "datatool/io");
                }
                this.getParser().putControlSequence(true, new LaTeX3Boolean(CSV_LITERAL_CONTENT_BOOL, bl));
                continue;
            }
            if (string.equals("csv-blank")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string7 = teXParser.expandToString(teXObject3, teXObjectList);
                CsvBlankOption csvBlankOption = CsvBlankOption.fromOptionName(string7);
                if (csvBlankOption != null) {
                    teXParser.putControlSequence(true, new TextualContentCommand(CSV_BLANK, string7));
                    continue;
                }
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string7, "datatool/io");
            }
            if (string.equals("csv-skip-lines") || string.equals("omitlines")) {
                int n;
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string8 = teXObject3.toString(teXParser).trim();
                if (string8.equals("false")) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(string8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = TeXParserUtils.toInt(teXObject3, teXParser, teXObjectList);
                    }
                }
                teXParser.getSettings().localSetRegister(OMIT_LINES, n);
                continue;
            }
            if (string.equals("no-header") || string.equals("noheader")) {
                String string9;
                String string10 = string9 = teXObject3 == null ? "" : teXObject3.toString(teXParser).trim();
                if (string9.equals("") || string9.equals("true")) {
                    teXParser.putControlSequence(true, new IfTrue("ifdtlnoheader"));
                    continue;
                }
                teXParser.putControlSequence(true, new IfFalse("ifdtlnoheader"));
                continue;
            }
            if (string.equals("auto-keys") || string.equals("autokeys")) {
                String string11;
                String string12 = string11 = teXObject3 == null ? "" : teXObject3.toString(teXParser).trim();
                if (string11.equals("") || string11.equals("true")) {
                    teXParser.putControlSequence(true, new IfTrue("ifdtlautokeys"));
                    continue;
                }
                teXParser.putControlSequence(true, new IfFalse("ifdtlautokeys"));
                continue;
            }
            if (string.equals("overwrite")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string13 = teXParser.expandToString(teXObject3, teXObjectList);
                FileOverwriteOption fileOverwriteOption = FileOverwriteOption.fromOptionName(string13);
                if (fileOverwriteOption != null) {
                    teXParser.putControlSequence(true, new TextualContentCommand(IO_OVERWRITE, string13));
                    continue;
                }
                throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string13, "datatool/io");
            }
            if (string.equals("load-action")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                boolean bl = true;
                String string14 = teXParser.expandToString(teXObject3, teXObjectList).trim();
                if (string14.equals("detect") || string14.equals("append")) {
                    bl = true;
                } else if (string14.equals("create") || string14.equals("old-style")) {
                    bl = false;
                } else {
                    throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string + "=" + string14, "datatool/io");
                }
                this.getParser().putControlSequence(true, new LaTeX3Boolean(APPEND_ALLOWED_BOOL, bl));
                continue;
            }
            if (string.equals("delimiter")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string15 = teXParser.expandToString(teXObject3, teXObjectList);
                this.setDelimiter(string15.codePointAt(0));
                continue;
            }
            if (string.equals("separator")) {
                if (teXObject3 == null) {
                    throw new TeXSyntaxException(teXParser, "latex.error.missing_key_value", string);
                }
                String string16 = teXParser.expandToString(teXObject3, teXObjectList);
                this.setSeparator(string16.codePointAt(0));
                continue;
            }
            if (string.equals("trim")) {
                boolean bl = true;
                if (teXObject3 != null) {
                    bl = Boolean.parseBoolean(this.getParser().expandToString(teXObject3, teXObjectList));
                }
                this.getParser().putControlSequence(true, new LaTeX3Boolean(NEW_ELEMENT_TRIM_BOOL, bl));
                continue;
            }
            if (string.equals("strict-quotes")) {
                boolean bl = true;
                if (teXObject3 != null) {
                    bl = Boolean.parseBoolean(this.getParser().expandToString(teXObject3, teXObjectList));
                }
                this.getParser().putControlSequence(true, new LaTeX3Boolean(IO_STRICT_QUOTES_BOOL, bl));
                continue;
            }
            TeXApp teXApp = this.getListener().getTeXApp();
            teXApp.warning(teXParser, teXApp.getMessage("latex.unknown.option", string, "datatool/io"));
        }
    }

    public void processIOSettings(IOSettings iOSettings, TeXObjectList teXObjectList) throws IOException {
        String string;
        TeXParser teXParser = this.getParser();
        String string2 = iOSettings.getDefaultName();
        if (string2 != null) {
            teXParser.putControlSequence(true, new TextualContentCommand(IO_NAME, string2));
        }
        if ((string = iOSettings.getDefaultExtension()) != null) {
            teXParser.putControlSequence(true, new TextualContentCommand(DEFAULT_EXT, string));
        }
        if (iOSettings.isHeaderIncluded()) {
            teXParser.putControlSequence(true, new IfFalse("ifdtlnoheader"));
        } else {
            teXParser.putControlSequence(true, new IfTrue("ifdtlnoheader"));
        }
        FileFormatType fileFormatType = iOSettings.getFormat();
        String string3 = fileFormatType.toString();
        if (fileFormatType == FileFormatType.DBTEX || fileFormatType == FileFormatType.DTLTEX) {
            String string4 = iOSettings.getFileVersion();
            if ("3.0".equals(string4)) {
                string3 = string3 + "-3";
            } else if ("2.0".equals(string4)) {
                string3 = string3 + "-2";
            }
        }
        teXParser.putControlSequence(true, new TextualContentCommand(FORMAT, string3));
        this.setSeparator(iOSettings.getSeparator());
        this.setDelimiter(iOSettings.getDelimiter());
        teXParser.putControlSequence(true, new TextualContentCommand(CSV_ESCAPE_CHARS, iOSettings.getEscapeCharsOption().getName()));
        if (iOSettings.isAutoKeysOn()) {
            teXParser.putControlSequence(true, new IfTrue("ifdtlautokeys"));
        } else {
            teXParser.putControlSequence(true, new IfFalse("ifdtlautokeys"));
        }
        teXParser.getSettings().localSetRegister(OMIT_LINES, iOSettings.getSkipLines());
        teXParser.putControlSequence(true, new TextualContentCommand(CSV_BLANK, iOSettings.getCsvBlankOption().getName()));
        teXParser.putControlSequence(true, new LaTeX3Boolean(CSV_LITERAL_CONTENT_BOOL, iOSettings.isCsvLiteral()));
        teXParser.putControlSequence(true, new LaTeX3Boolean(APPEND_ALLOWED_BOOL, iOSettings.isAppendAllowed()));
        teXParser.putControlSequence(true, new LaTeX3Boolean(NEW_ELEMENT_TRIM_BOOL, iOSettings.isTrimElementOn()));
        teXParser.putControlSequence(true, new LaTeX3Boolean(IO_STRICT_QUOTES_BOOL, iOSettings.isCsvStrictQuotes()));
        teXParser.putControlSequence(true, new TextualContentCommand(IO_OVERWRITE, iOSettings.getOverwriteOption().getName()));
        this.setIOExpandOption(iOSettings.getExpandOption().getName(), teXObjectList);
        teXParser.putControlSequence(true, new TextualContentCommand(IO_ADD_DELIMITER, iOSettings.getAddDelimiterOption().getName()));
    }

    public void setCsvKeys(String ... stringArray) {
        PropertyCommand<Integer> propertyCommand = new PropertyCommand<Integer>(CSV_KEYS_PROP);
        for (int i = 0; i < stringArray.length; ++i) {
            propertyCommand.put(i + 1, this.getListener().createString(stringArray[i]));
        }
        this.getParser().putControlSequence(true, propertyCommand);
    }

    public void setCsvKeys(TeXObject ... teXObjectArray) {
        PropertyCommand<Integer> propertyCommand = new PropertyCommand<Integer>(CSV_KEYS_PROP);
        for (int i = 0; i < teXObjectArray.length; ++i) {
            propertyCommand.put(i + 1, teXObjectArray[i]);
        }
        this.getParser().putControlSequence(true, propertyCommand);
    }

    public void setCsvHeaders(String ... stringArray) {
        PropertyCommand<Integer> propertyCommand = new PropertyCommand<Integer>(CSV_HEADERS_PROP);
        for (int i = 0; i < stringArray.length; ++i) {
            propertyCommand.put(i + 1, this.getListener().createString(stringArray[i]));
        }
        this.getParser().putControlSequence(true, propertyCommand);
    }

    public void setCsvHeaders(TeXObject ... teXObjectArray) {
        PropertyCommand<Integer> propertyCommand = new PropertyCommand<Integer>(CSV_HEADERS_PROP);
        for (int i = 0; i < teXObjectArray.length; ++i) {
            propertyCommand.put(i + 1, teXObjectArray[i]);
        }
        this.getParser().putControlSequence(true, propertyCommand);
    }

    public void setIOExpandOption(String string, TeXObjectList teXObjectList) throws IOException {
        ControlSequence controlSequence;
        if (string.equals("none")) {
            this.getParser().putControlSequence(true, new TextualContentCommand(IO_EXPAND, string));
            controlSequence = this.getParser().getListener().getControlSequence("dtlnoexpandnewvalue");
        } else if (string.equals("protected") || string.equals("full")) {
            this.getParser().putControlSequence(true, new TextualContentCommand(IO_EXPAND, string));
            controlSequence = this.getParser().getListener().getControlSequence("dtlexpandnewvalue");
        } else {
            throw new LaTeXSyntaxException(this.getParser(), "latex.unknown.option", "expand=" + string, "datatool/io");
        }
        TeXParserUtils.process(controlSequence, this.getParser(), teXObjectList);
    }

    public void processDisplayKeys(TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        TeXParser teXParser = this.getParser();
        KeyValList keyValList = TeXParserUtils.toKeyValList(teXObject, teXParser);
        for (String string : keyValList.keySet()) {
            Object object;
            TeXObject teXObject2 = (TeXObject)keyValList.get(string);
            if (string.equals("omit-columns") || string.equals("omit")) {
                if (teXObject2 == null || teXObject2.isEmpty()) {
                    teXParser.putControlSequence(true, new SequenceCommand(OMIT_COLUMNS_SEQ));
                    continue;
                }
                object = TeXParserUtils.toCsvList(teXObject2, teXParser);
                teXParser.putControlSequence(true, SequenceCommand.createFromClist(teXParser, OMIT_COLUMNS_SEQ, (CsvList)object));
                teXParser.putControlSequence(true, new SequenceCommand(ONLY_COLUMNS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(ONLY_KEYS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(OMIT_KEYS_SEQ));
                continue;
            }
            if (string.equals("only-columns")) {
                if (teXObject2 == null || teXObject2.isEmpty()) {
                    teXParser.putControlSequence(true, new SequenceCommand(ONLY_COLUMNS_SEQ));
                    continue;
                }
                object = TeXParserUtils.toCsvList(teXObject2, teXParser);
                teXParser.putControlSequence(true, SequenceCommand.createFromClist(teXParser, ONLY_COLUMNS_SEQ, (CsvList)object));
                teXParser.putControlSequence(true, new SequenceCommand(OMIT_COLUMNS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(ONLY_KEYS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(OMIT_KEYS_SEQ));
                continue;
            }
            if (string.equals("omit-keys")) {
                if (teXObject2 == null || teXObject2.isEmpty()) {
                    teXParser.putControlSequence(true, new SequenceCommand(OMIT_KEYS_SEQ));
                    continue;
                }
                object = TeXParserUtils.toCsvList(teXObject2, teXParser);
                teXParser.putControlSequence(true, SequenceCommand.createFromClist(teXParser, OMIT_KEYS_SEQ, (CsvList)object));
                teXParser.putControlSequence(true, new SequenceCommand(OMIT_COLUMNS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(ONLY_COLUMNS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(ONLY_KEYS_SEQ));
                continue;
            }
            if (string.equals("only-keys")) {
                if (teXObject2 == null || teXObject2.isEmpty()) {
                    teXParser.putControlSequence(true, new SequenceCommand(ONLY_KEYS_SEQ));
                    continue;
                }
                object = TeXParserUtils.toCsvList(teXObject2, teXParser);
                teXParser.putControlSequence(true, SequenceCommand.createFromClist(teXParser, ONLY_KEYS_SEQ, (CsvList)object));
                teXParser.putControlSequence(true, new SequenceCommand(OMIT_KEYS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(ONLY_COLUMNS_SEQ));
                teXParser.putControlSequence(true, new SequenceCommand(OMIT_COLUMNS_SEQ));
                continue;
            }
            if (string.equals("row-condition")) {
                teXParser.putControlSequence(true, new GenericCommand(teXParser.getListener(), true, IF_DISPLAY_ROW, 3, TeXParserUtils.toList(teXObject2, teXParser)));
                continue;
            }
            if (string.equals("pre-content")) {
                teXParser.putControlSequence(true, new TokenListCommand(PRE_DISPLAY, teXObject2));
                continue;
            }
            if (string.equals("pre-head")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtldisplaystarttab", teXObject2));
                continue;
            }
            if (string.equals("post-head")) {
                teXParser.putControlSequence(true, new TokenListCommand(POST_HEAD, teXObject2));
                continue;
            }
            if (string.equals("align-specs")) {
                teXParser.putControlSequence(true, new TokenListCommand(USER_ALIGN, teXObject2));
                continue;
            }
            if (string.equals("header-row")) {
                teXParser.putControlSequence(true, new TokenListCommand(USER_HEADER, teXObject2));
                continue;
            }
            if (string.equals("no-header")) {
                teXParser.putControlSequence(true, new LaTeX3Boolean(INCLUDE_HEADER_BOOL, teXObject2 != null && !teXObject2.isEmpty() && !teXObject2.toString(teXParser).trim().equals("true")));
                continue;
            }
            if (string.equals("string-align")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlstringalign", teXObject2));
                continue;
            }
            if (string.equals("int-align") || string.equals("integer-align")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlintalign", teXObject2));
                continue;
            }
            if (string.equals("real-align") || string.equals("decimal-align")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlrealalign", teXObject2));
                continue;
            }
            if (string.equals("currency-align")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlcurrencyalign", teXObject2));
                continue;
            }
            if (string.equals("inter-col")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlbetweencols", teXObject2));
                continue;
            }
            if (string.equals("pre-col")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlbeforecols", teXObject2));
                continue;
            }
            if (string.equals("post-col")) {
                teXParser.putControlSequence(true, new TokenListCommand("dtlaftercols", teXObject2));
                continue;
            }
            if (string.equals("tabular-env")) {
                String string2;
                object = teXObject2 == null || teXObject2.isEmpty() ? "tabular" : teXParser.expandToString(teXObject2, teXObjectList).trim();
                teXParser.putControlSequence(true, new TextualContentCommand("dtldisplaydbenv", (String)object));
                if (!((String)object).equals("tabular") && !((String)object).equals("array") || (string2 = teXParser.expandToString(teXParser.getControlSequence("dtldisplayvalign"), teXObjectList)).equals("t") || string2.equals("b") || string2.equals("c")) continue;
                teXParser.putControlSequence(true, new TextualContentCommand("dtldisplayvalign", "c"));
                continue;
            }
            if (string.equals("longtable-env")) {
                object = teXObject2 == null || teXObject2.isEmpty() ? "longtable" : teXParser.expandToString(teXObject2, teXObjectList).trim();
                teXParser.putControlSequence(true, new TextualContentCommand("dtldisplaylongdbenv", (String)object));
                continue;
            }
            if (string.equals("caption")) {
                teXParser.putControlSequence(true, new TokenListCommand(CAPTION, teXObject2));
                continue;
            }
            if (string.equals("short-caption") || string.equals("shortcaption")) {
                teXParser.putControlSequence(true, new TokenListCommand(SHORT_CAPTION, teXObject2));
                continue;
            }
            if (string.equals("cont-caption") || string.equals("contcaption")) {
                teXParser.putControlSequence(true, new TokenListCommand(CONT_CAPTION, teXObject2));
                continue;
            }
            if (string.equals("label")) {
                teXParser.putControlSequence(true, new TokenListCommand(LABEL, teXObject2));
                continue;
            }
            if (string.equals("foot")) {
                teXParser.putControlSequence(true, new TokenListCommand(FOOT, teXObject2));
                continue;
            }
            if (string.equals("last-foot") || string.equals("lastfoot")) {
                teXParser.putControlSequence(true, new TokenListCommand(LAST_FOOT, teXObject2));
                continue;
            }
            throw new LaTeXSyntaxException(teXParser, "latex.unknown.option", string, "datatool/display");
        }
    }

    public void addFileLoadedListener(FileLoadedListener fileLoadedListener) {
        if (this.fileLoadedListeners == null) {
            this.fileLoadedListeners = new Vector();
        }
        this.fileLoadedListeners.add(fileLoadedListener);
    }

    public void registerFileLoaded(String string, String string2, String string3, TeXPath teXPath) {
        if (this.fileLoadedListeners != null) {
            for (FileLoadedListener fileLoadedListener : this.fileLoadedListeners) {
                fileLoadedListener.fileLoaded(string, string2, string3, teXPath);
            }
        }
    }

    public void showDbInfo(String string) throws TeXSyntaxException {
        TeXObject teXObject;
        TeXObject teXObject2;
        Object object;
        Object object2;
        TeXObject teXObject3;
        DataBase dataBase = this.databases == null ? null : this.databases.get(string);
        TeXParser teXParser = this.getParser();
        LaTeXParserListener laTeXParserListener = this.getListener();
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        if (dataBase == null) {
            System.out.println("No DataBase map");
        } else {
            n = dataBase.getColumnCount();
            n2 = dataBase.getRowCount();
            System.out.format("Database '%s': row count = %d, column count = %d%n", string, n2, n);
            teXObject3 = dataBase.getHeaders();
            if (teXObject3 == null) {
                System.out.println("No header set.");
            } else {
                System.out.println("Header row found. Number of columns: " + ((Vector)((Object)teXObject3)).size());
                object2 = ((Vector)((Object)teXObject3)).iterator();
                while (object2.hasNext()) {
                    object = (DataToolHeader)object2.next();
                    teXObject2 = ((DataToolHeader)object).getTitle();
                    System.out.format("Header for column %d (key=%s, type=%d): %s%n", ((DataToolHeader)object).getColumnIndex(), ((DataToolHeader)object).getColumnLabel(), ((DataToolHeader)object).getType(), teXObject2 == null ? "NULL" : teXObject2.toString(teXParser));
                    vector.add(((DataToolHeader)object).getColumnLabel());
                }
            }
            object2 = dataBase.getData();
            if (object2 == null) {
                System.out.println("No content set.");
            } else {
                System.out.println("Content found. Number of rows: " + ((Vector)object2).size());
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    teXObject2 = (DataToolEntryRow)object.next();
                    System.out.format("Row %d (column count: %d):%n", ((DataToolEntryRow)teXObject2).getRowIndex(), ((Vector)((Object)teXObject2)).size());
                    Iterator iterator = ((Vector)((Object)teXObject2)).iterator();
                    while (iterator.hasNext()) {
                        DataToolEntry object3 = (DataToolEntry)iterator.next();
                        teXObject = object3.getContents();
                        System.out.format("Column %d (%s): %s%n", object3.getColumnIndex(), teXObject.getClass().getSimpleName(), teXObject.toString(teXParser));
                    }
                }
            }
        }
        System.out.println("Internal Commands");
        teXObject3 = teXParser.getControlSequence(DataToolSty.getHeaderRegisterName(string));
        if (teXObject3 == null) {
            System.out.println("No header command.");
        } else {
            System.out.println("Header command: " + teXObject3);
            if (teXObject3 instanceof TokenRegister) {
                object2 = ((TokenRegister)teXObject3).getContents(teXParser);
                if (object2.isEmpty()) {
                    System.out.println("Empty");
                } else if (object2 instanceof DataToolHeaderRow) {
                    ((DataToolHeaderRow)object2).info();
                } else {
                    this.showHeaderContent(TeXParserUtils.toList((TeXObject)object2, teXParser));
                }
            } else {
                System.out.println("Not a TokenRegister!");
            }
        }
        object2 = teXParser.getControlSequence(DataToolSty.getContentsRegisterName(string));
        if (object2 == null) {
            System.out.println("No contents command.");
        } else {
            System.out.println("Contents command: " + object2);
            if (object2 instanceof TokenRegister) {
                object = ((TokenRegister)object2).getContents(teXParser);
                if (object.isEmpty()) {
                    System.out.println("Empty");
                } else if (object instanceof DataToolRows) {
                    ((DataToolRows)object).info();
                } else {
                    this.showDataContent(TeXParserUtils.toList((TeXObject)object, teXParser));
                }
            } else {
                System.out.println("Not a TokenRegister!");
            }
        }
        object = teXParser.getControlSequence(DataToolSty.getRowCountRegisterName(string));
        if (object == null) {
            System.out.println("No row count command.");
        } else {
            System.out.println("Row count command: " + object);
        }
        teXObject2 = teXParser.getControlSequence(DataToolSty.getColumnCountRegisterName(string));
        if (teXObject2 == null) {
            System.out.println("No column count command.");
        } else {
            System.out.println("Column count command: " + teXObject2);
        }
        for (String string2 : vector) {
            teXObject = teXParser.getControlSequence(DataToolSty.getColumnHeaderName(string, string2));
            if (teXObject == null) {
                System.out.format("No mapping command for column '%s'%n", string2);
                continue;
            }
            System.out.format("Mapping command for column '%s': %s%n", string2, teXObject);
        }
    }

    public void showHeaderContent(TeXObjectList teXObjectList) {
        TeXObject teXObject;
        TeXParser teXParser = this.getParser();
        LaTeXParserListener laTeXParserListener = this.getListener();
        int n = 0;
        int n2 = 0;
        TeXObjectList teXObjectList2 = ((TeXParserListener)laTeXParserListener).createStack();
        for (n2 = 0; n2 < teXObjectList.size(); ++n2) {
            int n3;
            int n4;
            ++n;
            teXObject = (TeXObject)teXObjectList.get(n2);
            while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                teXObject = (TeXObject)teXObjectList.get(++n2);
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@plist@elt@w")) {
                System.out.println("Invalid start of header block " + n + ". Expected \\db@plist@elt@w found: " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@plist@elt@w for column index " + n);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@w")) {
                System.out.println("Expected \\db@col@id@w after \\db@plist@elt@w for column index " + n + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject instanceof UserNumber) {
                n4 = ((UserNumber)teXObject).getValue();
            } else {
                TeXObject teXObject2;
                teXObjectList2.clear();
                teXObjectList2.add(teXObject);
                while (n2 + 1 < teXObjectList.size() && (teXObject2 = (TeXObject)teXObjectList.get(n2 + 1)) instanceof CharObject) {
                    ++n2;
                    teXObjectList2.add(teXObject2);
                }
                teXObject = teXObjectList2;
                try {
                    n4 = Integer.parseInt(teXObject.toString(teXParser));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Expected number after \\db@col@id@w. Found " + teXObject);
                    break;
                }
            }
            if (n4 != n) {
                System.out.println("Header columns out of sequence. Found index " + n4 + " in block " + n);
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@col@id@w " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@end@")) {
                System.out.println("Expected \\db@col@id@end@ after \\db@col@id@w " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            System.out.println("Header block for column " + n4);
            System.out.println("\\db@plist@elt@w");
            System.out.println("\\db@col@id@w " + n4 + "%");
            System.out.println("\\db@col@id@end@");
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@col@id@end@ for header " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@key@id@w")) {
                System.out.println("Expected \\db@key@id@w after \\db@col@id@end@ for header " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObjectList2.clear();
            while (n2 < teXObjectList.size() - 1 && !TeXParserUtils.isControlSequence(teXObject = (TeXObject)teXObjectList.get(++n2), "db@key@id@end@")) {
                teXObjectList2.add(teXObject);
            }
            if (n2 >= teXObjectList.size()) {
                System.out.println("Missing closing header block following \\db@key@id@w for column " + n4);
                break;
            }
            System.out.println("\\db@key@id@w " + teXObjectList2.toString(teXParser) + "%");
            System.out.println("\\db@key@id@end@");
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@col@id@end@ for header " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@type@id@w")) {
                System.out.println("Expected \\db@type@id@w after \\db@key@id@end@ for header " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObjectList2.clear();
            while (n2 < teXObjectList.size() - 1 && !TeXParserUtils.isControlSequence(teXObject = (TeXObject)teXObjectList.get(++n2), "db@type@id@end@")) {
                teXObjectList2.add(teXObject);
            }
            if (n2 >= teXObjectList.size()) {
                System.out.println("Missing closing header block following \\db@type@id@w for column " + n4);
                break;
            }
            System.out.println("\\db@type@id@w " + teXObjectList2.toString(teXParser) + "%");
            System.out.println("\\db@type@id@end@");
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@col@id@end@ for header " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@header@id@w")) {
                System.out.println("Expected \\db@header@id@w after \\db@type@id@end@ for header " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObjectList2.clear();
            while (n2 < teXObjectList.size() - 1 && !TeXParserUtils.isControlSequence(teXObject = (TeXObject)teXObjectList.get(++n2), "db@header@id@end@")) {
                teXObjectList2.add(teXObject);
            }
            if (n2 >= teXObjectList.size()) {
                System.out.println("Missing closing header block following \\db@header@id@w for column " + n4);
                break;
            }
            System.out.println("\\db@header@id@w " + teXObjectList2.toString(teXParser) + "%");
            System.out.println("\\db@header@id@end@");
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing end header block \\db@col@id@w for column " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@w")) {
                System.out.println("Expected \\db@col@id@w after \\db@header@id@end@ for column " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject instanceof UserNumber) {
                n3 = ((UserNumber)teXObject).getValue();
            } else {
                TeXObject teXObject3;
                teXObjectList2.clear();
                teXObjectList2.add(teXObject);
                while (n2 + 1 < teXObjectList.size() && (teXObject3 = (TeXObject)teXObjectList.get(n2 + 1)) instanceof CharObject) {
                    ++n2;
                    teXObjectList2.add(teXObject3);
                }
                teXObject = teXObjectList2;
                try {
                    n3 = Integer.parseInt(teXObject.toString(teXParser));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Expected number after \\db@col@id@w. Found " + teXObject);
                    break;
                }
            }
            if (n3 != n4) {
                System.out.println("End header block index " + n3 + "does not match start header block index " + n4);
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing end header index block \\db@col@id@end@ for column " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@end@")) {
                System.out.println("Expected \\db@col@id@end@ after \\db@col@id@w " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing end header block \\db@plist@elt@end@ for column " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@plist@elt@end@")) {
                System.out.println("Expected \\db@plist@elt@end@ after \\db@col@id@end@ " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            System.out.println("\\db@col@id@w " + n4 + "%");
            System.out.println("\\db@col@id@end@");
            System.out.println("\\db@plist@elt@end@");
        }
        if (n2 < teXObjectList.size()) {
            System.out.println("Remaining content: ");
            while (n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().startsWith("db@")) {
                    System.out.println(teXObject.format());
                } else {
                    System.out.print(teXObject.format());
                }
                ++n2;
            }
        }
    }

    public void showDataContent(TeXObjectList teXObjectList) {
        TeXObject teXObject;
        TeXParser teXParser = this.getParser();
        LaTeXParserListener laTeXParserListener = this.getListener();
        int n = 0;
        int n2 = 0;
        TeXObjectList teXObjectList2 = ((TeXParserListener)laTeXParserListener).createStack();
        for (n2 = 0; n2 < teXObjectList.size(); ++n2) {
            TeXObject teXObject2;
            int n3;
            TeXObject teXObject3;
            int n4;
            ++n;
            teXObject = (TeXObject)teXObjectList.get(n2);
            while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                teXObject = (TeXObject)teXObjectList.get(++n2);
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@row@elt@w")) {
                System.out.println("Invalid start of data block " + n + ". Expected \\db@plist@elt@w found: " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@row@elt@w for row index " + n);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@row@id@w")) {
                System.out.println("Expected \\db@col@id@w after \\db@row@id@w for row index " + n + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject instanceof UserNumber) {
                n4 = ((UserNumber)teXObject).getValue();
            } else {
                teXObjectList2.clear();
                teXObjectList2.add(teXObject);
                while (n2 + 1 < teXObjectList.size() && (teXObject3 = (TeXObject)teXObjectList.get(n2 + 1)) instanceof CharObject) {
                    ++n2;
                    teXObjectList2.add(teXObject3);
                }
                teXObject = teXObjectList2;
                try {
                    n4 = Integer.parseInt(teXObject.toString(teXParser));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Expected number after \\db@row@id@w. Found " + teXObject);
                    break;
                }
            }
            if (n4 != n) {
                System.out.println("Rows out of sequence. Found index " + n4 + " in block " + n);
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@row@id@w " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@row@id@end@")) {
                System.out.println("Expected \\db@row@id@end@ after \\db@row@id@w " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            System.out.println("Start of Row " + n4);
            System.out.println("\\db@row@elt@w");
            System.out.println("\\db@row@id@w " + n4 + "%");
            System.out.println("\\db@row@id@end@");
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@row@id@end@");
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@row@elt@w", "db@col@id@w")) {
                System.out.println("Expected \\db@col@id@w or \\db@row@elt@w after \\db@row@id@w " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObject3 = (ControlSequence)teXObject;
            int n5 = 0;
            int n6 = 0;
            while (!((ControlSequence)teXObject3).getName().equals("db@row@elt@w")) {
                ++n5;
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject instanceof UserNumber) {
                    n6 = ((UserNumber)teXObject).getValue();
                } else {
                    TeXObject teXObject4;
                    teXObjectList2.clear();
                    teXObjectList2.add(teXObject);
                    while (n2 < teXObjectList.size() - 1 && (teXObject4 = (TeXObject)teXObjectList.get(n2 + 1)) instanceof CharObject) {
                        ++n2;
                        teXObjectList2.add(teXObject4);
                    }
                    teXObject = teXObjectList2;
                    try {
                        n6 = Integer.parseInt(teXObject.toString(teXParser));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Expected number after \\db@col@id@w. Found " + teXObject);
                        break;
                    }
                }
                if (n6 != n5) {
                    System.out.println("Columns out of sequence. Found index " + n6 + " in block " + n5 + " for row " + n4);
                }
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject == null || teXObject instanceof Ignoreable) {
                    System.out.println("Missing content after \\db@col@id@w " + n6);
                    break;
                }
                if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@end@")) {
                    System.out.println("Expected \\db@col@id@end@ after \\db@col@id@w " + n6 + ". Found " + teXObject);
                    ++n2;
                    break;
                }
                System.out.println("Column " + n6);
                System.out.println("\\db@col@id@w " + n6 + "%");
                System.out.println("\\db@col@id@end@");
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject == null || teXObject instanceof Ignoreable) {
                    System.out.println("Missing content after \\db@col@id@end@ for column " + n6);
                    break;
                }
                if (!TeXParserUtils.isControlSequence(teXObject, "db@col@elt@w")) {
                    System.out.println("Expected \\db@col@elt@w after \\db@col@id@end@ for column " + n6 + ". Found " + teXObject);
                    ++n2;
                    break;
                }
                teXObjectList2.clear();
                while (n2 < teXObjectList.size() - 1 && !TeXParserUtils.isControlSequence(teXObject = (TeXObject)teXObjectList.get(++n2), "db@col@elt@end@")) {
                    teXObjectList2.add(teXObject);
                }
                if (n2 >= teXObjectList.size()) {
                    System.out.println("Missing closing value block following \\db@col@elt@w for column " + n6);
                    break;
                }
                System.out.println("\\db@col@elt@w " + teXObjectList2.toString(teXParser) + "%");
                System.out.println("\\db@col@elt@end@");
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject == null || teXObject instanceof Ignoreable) {
                    System.out.println("Missing end column block \\db@col@id@w for column " + n6);
                    break;
                }
                if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@w")) {
                    System.out.println("Expected \\db@col@id@w after \\db@col@elt@end@ for column " + n6 + ". Found " + teXObject);
                    ++n2;
                    break;
                }
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject instanceof UserNumber) {
                    n3 = ((UserNumber)teXObject).getValue();
                } else {
                    teXObjectList2.clear();
                    teXObjectList2.add(teXObject);
                    while (n2 + 1 < teXObjectList.size() && (teXObject2 = (TeXObject)teXObjectList.get(n2 + 1)) instanceof CharObject) {
                        ++n2;
                        teXObjectList2.add(teXObject2);
                    }
                    teXObject = teXObjectList2;
                    try {
                        n3 = Integer.parseInt(teXObject.toString(teXParser));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Expected number after \\db@col@id@w. Found " + teXObject);
                        break;
                    }
                }
                if (n3 != n6) {
                    System.out.println("End column block index " + n3 + "does not match start column block index " + n6);
                }
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject == null || teXObject instanceof Ignoreable) {
                    System.out.println("Missing content after \\db@col@id@w " + n3 + " for row " + n4);
                    break;
                }
                if (!TeXParserUtils.isControlSequence(teXObject, "db@col@id@end@")) {
                    System.out.println("Expected \\db@col@id@end@ after \\db@col@id@w " + n3 + " for row " + n4 + ". Found " + teXObject);
                    ++n2;
                    break;
                }
                System.out.println("\\db@col@id@w " + n3 + "%");
                System.out.println("\\db@col@id@end@ % End of Column " + n6);
                teXObject = null;
                if (++n2 < teXObjectList.size()) {
                    teXObject = (TeXObject)teXObjectList.get(n2);
                    while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                        teXObject = (TeXObject)teXObjectList.get(++n2);
                    }
                }
                if (teXObject == null || teXObject instanceof Ignoreable) {
                    System.out.println("Missing content after \\db@col@id@end@ for row " + n4);
                    break;
                }
                if (!TeXParserUtils.isControlSequence(teXObject, "db@row@elt@w", "db@col@id@w")) {
                    System.out.println("Expected \\db@col@id@w or \\db@row@elt@w after \\db@col@id@end@ " + n4 + ". Found " + teXObject);
                    ++n2;
                    break;
                }
                teXObject3 = (ControlSequence)teXObject;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@row@elt@w for row " + n4);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@row@id@w")) {
                System.out.println("Expected \\db@row@id@w after \\db@row@elt@w at end of row " + n4 + ". Found " + teXObject);
                ++n2;
                break;
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Expected number after \\db@row@id@w for row " + n4);
                break;
            }
            if (teXObject instanceof UserNumber) {
                n3 = ((UserNumber)teXObject).getValue();
            } else {
                teXObjectList2.clear();
                teXObjectList2.add(teXObject);
                while (n2 + 1 < teXObjectList.size() && (teXObject2 = (TeXObject)teXObjectList.get(n2 + 1)) instanceof CharObject) {
                    ++n2;
                    teXObjectList2.add(teXObject2);
                }
                teXObject = teXObjectList2;
                try {
                    n3 = Integer.parseInt(teXObject.toString(teXParser));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Expected number after \\db@row@id@w. Found " + teXObject);
                    break;
                }
            }
            if (n3 != n4) {
                System.out.println("End row block index " + n3 + "does not match start row block index " + n4);
            }
            teXObject = null;
            if (++n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                while (teXObject instanceof Ignoreable && n2 < teXObjectList.size() - 1) {
                    teXObject = (TeXObject)teXObjectList.get(++n2);
                }
            }
            if (teXObject == null || teXObject instanceof Ignoreable) {
                System.out.println("Missing content after \\db@row@id@w " + n3);
                break;
            }
            if (!TeXParserUtils.isControlSequence(teXObject, "db@row@id@end@")) {
                System.out.println("Expected \\db@row@id@end@ after \\db@row@id@w " + n3 + ". Found " + teXObject);
                ++n2;
                break;
            }
            System.out.println("End of Row " + n4);
            System.out.println("\\db@row@elt@w");
            System.out.println("\\db@row@id@w " + n3 + "%");
            System.out.println("\\db@row@id@end@");
        }
        if (n2 < teXObjectList.size()) {
            System.out.println("Remaining content: ");
            while (n2 < teXObjectList.size()) {
                teXObject = (TeXObject)teXObjectList.get(n2);
                if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().startsWith("db@")) {
                    System.out.println(teXObject.format());
                } else {
                    System.out.print(teXObject.format());
                }
                ++n2;
            }
        }
    }

    public void setCsvLiteralMappingOn(boolean bl) {
        this.csvLiteralMappingOn = bl;
    }

    public boolean isCsvLiteralMappingOn() {
        return this.csvLiteralMappingOn;
    }

    public String getCsvLiteralMap(int n) {
        return this.getCsvLiteralMap((Integer)n);
    }

    public String getCsvLiteralMap(Integer n) {
        return this.csvLiteralMap.get(n);
    }

    public void appendCsvLiteral(int n, StringBuilder stringBuilder) {
        if (this.csvLiteralMappingOn) {
            String string = this.getCsvLiteralMap(n);
            if (string == null) {
                stringBuilder.appendCodePoint(n);
            } else {
                stringBuilder.append(string);
            }
        } else {
            stringBuilder.appendCodePoint(n);
        }
    }

    public void putCsvLiteralMap(int n, String string) {
        this.putCsvLiteralMap((Integer)n, string);
    }

    public void putCsvLiteralMap(Integer n, String string) {
        this.csvLiteralMap.put(n, string);
    }

    public void removeCsvLiteralMap(int n) {
        this.removeCsvLiteralMap((Integer)n);
    }

    public void removeCsvLiteralMap(Integer n) {
        this.csvLiteralMap.remove(n);
    }
}

