/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatter
extends Command {
    private SimpleDateFormat dateFormat;

    public DateFormatter(String string, SimpleDateFormat simpleDateFormat) {
        super(string);
        this.dateFormat = simpleDateFormat;
    }

    @Override
    public Object clone() {
        return this;
    }

    public Date parse(String string) throws ParseException {
        return this.dateFormat.parse(string);
    }

    protected String fmtArg(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        double d;
        if (teXObject instanceof TeXNumber) {
            d = ((TeXFloatingPoint)teXObject).doubleValue();
        } else {
            String string = teXParser.expandToString(teXObject, teXObjectList);
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
            }
        }
        String string = this.dateFormat.format(new Date(DataToolBaseSty.unixEpochMillisFromJulianDate(d)));
        return string;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        return teXParser.getListener().createString(this.fmtArg(teXObject, teXParser, teXObjectList));
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.popArg(teXParser, teXObjectList);
        teXParser.getListener().getWriteable().write(this.fmtArg(teXObject, teXParser, teXObjectList));
    }
}

