/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.jmlr;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.AlignHStyle;
import com.dickimawbooks.texparserlib.latex.AlignVStyle;
import com.dickimawbooks.texparserlib.latex.BorderStyle;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.Label;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import java.io.IOException;

public class SubFloat
extends FrameBox {
    protected String floatname;
    private TeXObject caption = null;

    public SubFloat(String string) {
        this("sub" + string, string);
    }

    public SubFloat(String string, String string2) {
        super(string, BorderStyle.NONE, AlignHStyle.DEFAULT, AlignVStyle.DEFAULT, true, true, null, null);
        this.floatname = string2;
    }

    @Override
    public FrameBox createBox() {
        return new SubFloat(this.getName(), this.floatname);
    }

    @Override
    protected void popSettings(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.caption = this.popOptArg(teXParser, teXObjectList);
        String string = this.popOptLabelString(teXParser, teXObjectList);
        if (string != null) {
            if ((string = string.trim()).equals("c")) {
                this.valign = AlignVStyle.MIDDLE;
            } else if (string.equals("t")) {
                this.valign = AlignVStyle.TOP;
            } else if (string.equals("b")) {
                this.valign = AlignVStyle.BOTTOM;
            } else {
                TeXApp teXApp = teXParser.getListener().getTeXApp();
                teXApp.warning(teXParser, teXApp.getMessage("latex.illegal.argtype", string));
            }
        }
    }

    @Override
    protected TeXObject popContents(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2;
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        TeXObject teXObject3 = this.popArg(teXParser, teXObjectList);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        ControlSequence controlSequence = teXParser.getControlSequence(String.format("if%scaptiontop", this.floatname));
        boolean bl = false;
        if (controlSequence instanceof IfTrue) {
            bl = true;
        }
        TeXObject teXObject4 = null;
        if (teXObject3 instanceof TeXObjectList) {
            teXObject2 = new TeXObjectList();
            teXObject = ((TeXObjectList)teXObject3).popStack(teXParser);
            while (teXObject != null) {
                if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Label) {
                    TeXObjectList teXObjectList3;
                    teXObject4 = ((TeXObjectList)teXObject3).popArg(teXParser);
                    if (teXObject4 instanceof Expandable && (teXObjectList3 = ((Expandable)((Object)teXObject4)).expandfully(teXParser, (TeXObjectList)teXObject3)) != null) {
                        teXObject4 = teXObjectList3;
                    }
                } else {
                    ((TeXObjectList)teXObject2).add(teXObject);
                }
                teXObject = ((TeXObjectList)teXObject3).popStack(teXParser);
            }
        } else {
            teXObject2 = teXObject3;
        }
        if (teXObject4 != null) {
            teXObjectList2.add(laTeXParserListener.getAnchor(teXObject4.toString(teXParser)));
        }
        laTeXParserListener.stepcounter(this.getName());
        teXObject = laTeXParserListener.createGroup();
        ((TeXObjectList)teXObject).add(new TeXCsRef(this.getName() + "label"));
        ((TeXObjectList)teXObject).add(new TeXCsRef("the" + this.getName()));
        if (this.caption != null) {
            ((TeXObjectList)teXObject).add(laTeXParserListener.getSpace());
            ((TeXObjectList)teXObject).add(this.caption);
        }
        if (bl) {
            teXObjectList2.add(teXObject);
            teXObjectList2.add(new TeXCsRef("medskip"));
        }
        teXObjectList2.add(teXObject2);
        if (!bl) {
            teXObjectList2.add(new TeXCsRef("medskip"));
            teXObjectList2.add(teXObject);
        }
        return teXObjectList2;
    }
}

