/*
 * Decompiled with CFR 0.152.
 */
package TeXLive;

import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext$Implicits$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.sys.package$;

public final class OsTools$ {
    public static OsTools$ MODULE$;
    private final String OS;
    private final boolean CygwinRootIsSet;

    static {
        new OsTools$();
    }

    public String OS() {
        return this.OS;
    }

    public boolean CygwinRootIsSet() {
        return this.CygwinRootIsSet;
    }

    public boolean isWindows() {
        return this.OS().startsWith("windows") && !this.CygwinRootIsSet();
    }

    public boolean isCygwin() {
        return this.OS().startsWith("windows") && this.CygwinRootIsSet();
    }

    public boolean isApple() {
        return this.OS().startsWith("mac os");
    }

    public boolean isUnix() {
        return !this.isWindows() && !this.isApple() && !this.isCygwin();
    }

    public Seq<String> openFileCmd(String f) {
        String absf = new File(f).getCanonicalPath();
        return this.isWindows() ? (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cmd", "/c", "start", absf})) : (this.isCygwin() ? (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cygstart", absf})) : (this.isApple() ? (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"open", absf})) : (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xdg-open", absf}))));
    }

    public void openFile(String f) {
        Seq<String> cmd = this.openFileCmd(f);
        Future future = Future$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> {
            Serializable serializable;
            try {
                serializable = BoxesRunTime.boxToInteger(scala.sys.process.package$.MODULE$.stringSeqToProcess(cmd).$bang());
            }
            catch (Exception e) {
                Predef$.MODULE$.println(new StringBuilder(25).append("Cannot run command: ").append(cmd).append(" -- ").append(e).append("\n").toString());
                serializable = BoxedUnit.UNIT;
            }
            return serializable;
        }, ExecutionContext$Implicits$.MODULE$.global());
    }

    private OsTools$() {
        boolean bl;
        MODULE$ = this;
        this.OS = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("os.name"))).map((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$1)))), Predef$.MODULE$.StringCanBuildFrom());
        Option option = package$.MODULE$.env().get("CYGWIN_ROOT");
        if (option instanceof Some) {
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        this.CygwinRootIsSet = bl;
    }
}

