/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;

public class TableCache
extends JDBCStructLookupCache<GenericStructContainer, GenericTableBase, GenericTableColumn> {
    private final GenericDataSource dataSource;
    private final GenericMetaObject tableObject;
    private final GenericMetaObject columnObject;

    protected TableCache(@NotNull GenericDataSource dataSource) {
        super(GenericUtils.getColumn(dataSource, "table", "TABLE_NAME"));
        this.dataSource = dataSource;
        this.tableObject = dataSource.getMetaObject("table");
        this.columnObject = dataSource.getMetaObject("table-column");
        this.setListOrderComparator(DBUtils.nameComparatorIgnoreCase());
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return this.dataSource;
    }

    public GenericMetaObject getTableObject() {
        return this.tableObject;
    }

    @NotNull
    public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        return this.dataSource.getMetaModel().prepareTableLoadStatement(session, owner, object, objectName);
    }

    @Nullable
    protected GenericTableBase fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return this.getDataSource().getMetaModel().createTableImpl(session, owner, this.tableObject, dbResult);
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        return this.dataSource.getMetaModel().prepareTableColumnLoadStatement(session, owner, forTable);
    }

    protected GenericTableColumn fetchChild(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return this.dataSource.getMetaModel().fetchTableColumn(session, owner, table, dbResult);
    }
}

