/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.formatters;

import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class BinaryFormatterHex
implements DBDBinaryFormatter {
    public static final BinaryFormatterHex INSTANCE = new BinaryFormatterHex();

    @Override
    public String getId() {
        return "hex";
    }

    @Override
    public String getTitle() {
        return "Hex";
    }

    @Override
    public String toString(byte[] bytes, int offset, int length) {
        return new String(BinaryFormatterHex.toHexChars(bytes, offset, length));
    }

    protected static char[] toHexChars(byte[] bytes, int offset, int length) {
        char[] chars = new char[length * 2];
        int i = 0;
        while (i < length) {
            String hex = GeneralUtils.byteToHex[bytes[offset + i] & 0xFF];
            chars[i * 2] = hex.charAt(0);
            chars[i * 2 + 1] = hex.charAt(1);
            ++i;
        }
        return chars;
    }

    @Override
    public byte[] toBytes(String string) {
        int length = string.length();
        if (length > 0 && length % 2 != 0) {
            --length;
        }
        byte[] bytes = new byte[length / 2];
        int i = 0;
        while (i < length) {
            bytes[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
            i += 2;
        }
        return bytes;
    }
}

