define(["exports","./../modules/viewmanager/baseview.js","./../modules/loading/loading.js","./../modules/common/globalize.js","./../modules/emby-elements/emby-input/emby-input.js","./../modules/emby-elements/emby-button/emby-button.js","./../modules/emby-elements/emby-select/emby-select.js","./../modules/emby-elements/emby-scroller/emby-scroller.js","./../modules/emby-elements/emby-file-input/emby-file-input.js","./../modules/emby-apiclient/connectionmanager.js","./../modules/common/servicelocator.js","./../modules/appheader/appheader.js","./userpasswordcontroller.js","./../modules/common/textencoding.js"],function(_exports,_baseview,_loading,_globalize,_embyInput,_embyButton,_embySelect,_embyScroller,_embyFileInput,_connectionmanager,_servicelocator,_appheader,_userpasswordcontroller,_textencoding){var currentFile;function reloadUser(page,apiClient,userId){_loading.default.show(),apiClient.getUser(userId).then(function(user){page.querySelector(".username").innerHTML=_textencoding.default.htmlEncode(user.Name);var imageUrl,uploadUserImage=page.querySelector(".uploadUserImage"),uploadUserImage=(uploadUserImage.value="",uploadUserImage.dispatchEvent(new CustomEvent("change",{bubbles:!0})),_appheader.default.setTitle(user.Name),page.querySelector(".fldImage"));user.PrimaryImageTag?(imageUrl=apiClient.getUserImageUrl(user.Id,{height:200,tag:user.PrimaryImageTag,type:"Primary"}),uploadUserImage.innerHTML='<img style="border-radius:.3em;width:7em;margin-right:1em;" src="'+imageUrl+'" />'):uploadUserImage.innerHTML='<i class="md-icon" style="font-size:6em;margin:0 .25em;">person</i>',uploadUserImage.classList.remove("hide");apiClient.getCurrentUser().then(function(loggedInUser){_servicelocator.appHost.supports("fileinput")&&(loggedInUser.Policy.IsAdministrator||user.Policy.EnableUserPreferenceAccess)?(page.querySelector(".newImageForm").classList.remove("hide"),user.PrimaryImageTag?page.querySelector(".btnDeleteImage").classList.remove("hide"):page.querySelector(".btnDeleteImage").classList.add("hide")):(page.querySelector(".newImageForm").classList.add("hide"),page.querySelector(".btnDeleteImage").classList.add("hide"))}),_loading.default.hide()})}function displayFileError(text){var options;options=_globalize.default.translate(text),Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}function onFileReaderError(evt){switch(_loading.default.hide(),evt.target.error.code){case evt.target.error.NOT_FOUND_ERR:displayFileError("FileNotFound");break;case evt.target.error.NOT_READABLE_ERR:displayFileError("FileReadError");break;case evt.target.error.ABORT_ERR:break;default:displayFileError("FileReadError")}}function onFileReaderAbort(evt){_loading.default.hide(),displayFileError("FileReadCancelled")}function setFiles(page,files){var file=(files=function(files){for(var list=[],i=0,length=files.length;i<length;i++)validateImage(files[i])&&list.push(files[i]);return list}(files))[0];file&&file.type.match("image.*")?(currentFile=file,(files=new FileReader).onerror=onFileReaderError,files.onloadstart=function(){page.querySelector(".fldUpload").classList.add("hide")},files.onabort=onFileReaderAbort,files.onload=function(e){e=['<img style="max-width:100%;max-height:100%;" src="',e.target.result,'" title="',_textencoding.default.htmlEncode(file.name||""),'"/>'].join("");page.querySelector(".userImageOutput").innerHTML=e,page.querySelector(".fldUpload").classList.remove("hide")},files.readAsDataURL(file)):(page.querySelector(".userImageOutput").innerHTML="",page.querySelector(".fldUpload").classList.add("hide"),currentFile=null)}function onImageDragOver(e){return e.preventDefault(),!(e.originalEvent.dataTransfer.dropEffect="Copy")}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,require(["css!settings/profile.css"]);var supportedImageTypes=["image/png","image/jpg","image/jpeg","image/webp","image/gif"];function validateImage(file){return!!supportedImageTypes.includes(file.type)}function View(view,params){_baseview.default.apply(this,arguments);var apiClient=_connectionmanager.default.getApiClient(params.serverId),userId=params.userId;reloadUser(view,apiClient,userId),view.querySelector(".userImageDropZone").addEventListener("dragOver",onImageDragOver),view.querySelector(".uploadUserImage").setAttribute("accept",supportedImageTypes.join(",")),view.querySelector(".btnDeleteImage").addEventListener("click",function(){var options;options={title:_globalize.default.translate("HeaderDeleteImage"),text:_globalize.default.translate("ConfirmDeleteImage"),confirmText:_globalize.default.translate("Delete"),primary:"cancel"},Emby.importModule("./modules/common/dialogs/confirm.js").then(function(confirm){return confirm(options)}).then(function(){_loading.default.show(),apiClient.deleteUserImage(userId,"primary").then(function(){_loading.default.hide(),reloadUser(view,apiClient,userId)})})}),view.querySelector(".btnBrowse").addEventListener("click",function(){view.querySelector(".uploadUserImage").click()}),view.querySelector(".newImageForm").addEventListener("submit",function(e){e.preventDefault();e=currentFile;return e&&validateImage(e)&&(_loading.default.show(),apiClient.uploadUserImage(userId,"Primary",e).then(function(){_loading.default.hide(),reloadUser(view,apiClient,userId)})),!1}),view.querySelector(".uploadUserImage").addEventListener("change",function(e){setFiles(view,e.target.files)}),this.userPasswordController=new _userpasswordcontroller.default(view,params,apiClient)}Object.assign(View.prototype,_baseview.default.prototype),View.prototype.onResume=function(options){_baseview.default.prototype.onResume.apply(this,arguments),this.userPasswordController&&this.userPasswordController.resume(options)},View.prototype.onPause=function(){_baseview.default.prototype.onPause.apply(this,arguments),this.userPasswordController&&this.userPasswordController.pause()},View.prototype.destroy=function(){_baseview.default.prototype.destroy.apply(this,arguments),this.userPasswordController.destroy(),this.userPasswordController=null};_exports.default=View});