/**
 * SECTION:persona-store
 * @short_description: A store for <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>After creating a PersonaStore instance, you must connect to the <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal, <emphasis>then</emphasis> call <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>, otherwise a race condition may occur between emission of <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> and your code connecting to it.</para>
 */
/**
 * FOLKS_TYPE_PERSONA_STORE:
 * 
 * The type for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.
 */
/**
 * folks_persona_store_prepare:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Prepare the PersonaStore for use.
 * 
 * <para>This connects the PersonaStore to whichever backend-specific services it requires to be able to provide <link linkend="FolksPersona"><type>FolksPersona</type></link>s. This should be called <emphasis>after</emphasis> connecting to the <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal, or a race condition could occur, with the signal being emitted before your code has connected to it, and <link linkend="FolksPersona"><type>FolksPersona</type></link>s getting &quot;lost&quot; as a result.</para><para>This is normally handled transparently by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para><para>If this function throws an error, the PersonaStore will not be functional.</para><para>This function is guaranteed to be idempotent (since version 0.3.0).</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-prepare-finish"><function>folks_persona_store_prepare_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_persona_store_prepare_finish:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Prepare the PersonaStore for use.
 * 
 * <para>This connects the PersonaStore to whichever backend-specific services it requires to be able to provide <link linkend="FolksPersona"><type>FolksPersona</type></link>s. This should be called <emphasis>after</emphasis> connecting to the <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal, or a race condition could occur, with the signal being emitted before your code has connected to it, and <link linkend="FolksPersona"><type>FolksPersona</type></link>s getting &quot;lost&quot; as a result.</para><para>This is normally handled transparently by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para><para>If this function throws an error, the PersonaStore will not be functional.</para><para>This function is guaranteed to be idempotent (since version 0.3.0).</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_persona_store_flush:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Flush any pending changes to the PersonaStore&apos;s backing store.
 * 
 * <para>PersonaStores may (transparently) implement caching or I/O queueing which means that changes to their <link linkend="FolksPersona"><type>FolksPersona</type></link>s may not be immediately written to the PersonaStore&apos;s backing store. Calling this function will force all pending changes to be flushed to the backing store.</para><para>This must not be called before <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-flush-finish"><function>folks_persona_store_flush_finish()</function></link>
 *
 * Since: 0.1.17
 */
/**
 * folks_persona_store_flush_finish:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * 
 * Flush any pending changes to the PersonaStore&apos;s backing store.
 * 
 * <para>PersonaStores may (transparently) implement caching or I/O queueing which means that changes to their <link linkend="FolksPersona"><type>FolksPersona</type></link>s may not be immediately written to the PersonaStore&apos;s backing store. Calling this function will force all pending changes to be flushed to the backing store.</para><para>This must not be called before <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-flush"><function>folks_persona_store_flush()</function></link>
 *
 * Since: 0.1.17
 */
/**
 * folks_persona_store_add_persona_from_details:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @details: (in): &nbsp;.  <para>a key-value map of details to use in creating the new <link linkend="FolksPersona"><type>FolksPersona</type></link> </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Add a new <link linkend="FolksPersona"><type>FolksPersona</type></link> to the PersonaStore.
 * 
 * <para>The <link linkend="FolksPersona"><type>FolksPersona</type></link> will be created by the PersonaStore backend from the key-value pairs given in <code>details</code>.</para><para>All additions through this function will later be emitted through the personas-changed signal to be notified of the new <link linkend="FolksPersona"><type>FolksPersona</type></link>. The return value is purely for convenience, since it can be complicated to correlate the provided details with the final Persona.</para><para>If the store is offline (or <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> hasn&apos;t yet been called successfully), this function will throw <link linkend="FOLKS-PERSONA-STORE-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE</literal></link>. It&apos;s the responsibility of the caller to cache details and re-try this function if it wishes to make offline adds work.</para><para>If the details are not recognised or are invalid, <link linkend="FOLKS-PERSONA-STORE-ERROR-INVALID-ARGUMENT:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT</literal></link> will be thrown. A default set of possible details are defined by <link linkend="FolksPersonaDetail"><type>FolksPersonaDetail</type></link> but backends can either support a subset or superset of the suggested defaults.</para><para>If a <link linkend="FolksPersona"><type>FolksPersona</type></link> with the given details already exists in the store, no error will be thrown and this function will return <code>null</code>.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>if adding the persona failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-add-persona-from-details-finish"><function>folks_persona_store_add_persona_from_details_finish()</function></link>
 */
/**
 * folks_persona_store_add_persona_from_details_finish:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPersonaStoreError): location to store the error occurring, or %NULL to ignore
 * 
 * Add a new <link linkend="FolksPersona"><type>FolksPersona</type></link> to the PersonaStore.
 * 
 * <para>The <link linkend="FolksPersona"><type>FolksPersona</type></link> will be created by the PersonaStore backend from the key-value pairs given in <code>details</code>.</para><para>All additions through this function will later be emitted through the personas-changed signal to be notified of the new <link linkend="FolksPersona"><type>FolksPersona</type></link>. The return value is purely for convenience, since it can be complicated to correlate the provided details with the final Persona.</para><para>If the store is offline (or <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> hasn&apos;t yet been called successfully), this function will throw <link linkend="FOLKS-PERSONA-STORE-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE</literal></link>. It&apos;s the responsibility of the caller to cache details and re-try this function if it wishes to make offline adds work.</para><para>If the details are not recognised or are invalid, <link linkend="FOLKS-PERSONA-STORE-ERROR-INVALID-ARGUMENT:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT</literal></link> will be thrown. A default set of possible details are defined by <link linkend="FolksPersonaDetail"><type>FolksPersonaDetail</type></link> but backends can either support a subset or superset of the suggested defaults.</para><para>If a <link linkend="FolksPersona"><type>FolksPersona</type></link> with the given details already exists in the store, no error will be thrown and this function will return <code>null</code>.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>if adding the persona failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>
 * 
 * Returns: <para>the new <link linkend="FolksPersona"><type>FolksPersona</type></link> or <code>null</code> if the corresponding Persona already existed. If non-<code>null</code>, the new <link linkend="FolksPersona"><type>FolksPersona</type></link> will also be amongst the <link linkend="FolksPersona"><type>FolksPersona</type></link>(s) in a future emission of <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link>. </para>
 */
/**
 * folks_persona_store_remove_persona:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @persona: (in): &nbsp;.  <para>the <link linkend="FolksPersona"><type>FolksPersona</type></link> to remove </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Remove a <link linkend="FolksPersona"><type>FolksPersona</type></link> from the PersonaStore.
 * 
 * <para>It isn&apos;t guaranteed that the Persona will actually be removed by the time this asynchronous function finishes. The successful removal of the Persona will be signalled through emission of <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link>.</para><para>If the store is offline (or <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> hasn&apos;t yet been called successfully), this function will throw <link linkend="FOLKS-PERSONA-STORE-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE</literal></link>. It&apos;s the responsibility of the caller to cache details and re-try this function if it wishes to make offline removals work.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>if removing the persona failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-remove-persona-finish"><function>folks_persona_store_remove_persona_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_persona_store_remove_persona_finish:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPersonaStoreError): location to store the error occurring, or %NULL to ignore
 * 
 * Remove a <link linkend="FolksPersona"><type>FolksPersona</type></link> from the PersonaStore.
 * 
 * <para>It isn&apos;t guaranteed that the Persona will actually be removed by the time this asynchronous function finishes. The successful removal of the Persona will be signalled through emission of <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link>.</para><para>If the store is offline (or <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> hasn&apos;t yet been called successfully), this function will throw <link linkend="FOLKS-PERSONA-STORE-ERROR-STORE-OFFLINE:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE</literal></link>. It&apos;s the responsibility of the caller to cache details and re-try this function if it wishes to make offline removals work.</para>
 * <para><link linkend="FolksPersonaStoreError"><type>FolksPersonaStoreError</type></link> will be returned in @error <para>if removing the persona failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * FolksPersonaStore:type-id:
 * 
 * The type of PersonaStore this is.
 * 
 * <para>This is the same for all PersonaStores provided by a given <link linkend="FolksBackend"><type>FolksBackend</type></link>.</para><para>This is guaranteed to always be available; even before <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> is called. It is immutable over the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 */
/**
 * folks_persona_store_get_type_id:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--type-id"><type>"type-id"</type></link> property.
 * 
 * The type of PersonaStore this is.
 * 
 * <para>This is the same for all PersonaStores provided by a given <link linkend="FolksBackend"><type>FolksBackend</type></link>.</para><para>This is guaranteed to always be available; even before <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> is called. It is immutable over the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--type-id"><type>"type-id"</type></link> property
 */
/**
 * FolksPersonaStore:display-name:
 * 
 * The human-readable, service-specific name used to represent the PersonaStore to the user.
 * 
 * <para>For example: <code>foo@@xmpp.example.org</code>.</para><para>This should be used whenever the user needs to be presented with a familiar, service-specific name. For instance, in a prompt for the user to select a specific IM account from which to initiate a chat.</para><para>This is not guaranteed to be unique even within this PersonaStore&apos;s <link linkend="FolksBackend"><type>FolksBackend</type></link>. Its value may change throughout the life of the store.</para>
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_store_get_display_name:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--display-name"><type>"display-name"</type></link> property.
 * 
 * The human-readable, service-specific name used to represent the PersonaStore to the user.
 * 
 * <para>For example: <code>foo@@xmpp.example.org</code>.</para><para>This should be used whenever the user needs to be presented with a familiar, service-specific name. For instance, in a prompt for the user to select a specific IM account from which to initiate a chat.</para><para>This is not guaranteed to be unique even within this PersonaStore&apos;s <link linkend="FolksBackend"><type>FolksBackend</type></link>. Its value may change throughout the life of the store.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--display-name"><type>"display-name"</type></link> property
 *
 * Since: 0.1.13
 */
/**
 * FolksPersonaStore:id:
 * 
 * The instance identifier for this PersonaStore.
 * 
 * <para>Since each <link linkend="FolksBackend"><type>FolksBackend</type></link> can provide multiple different PersonaStores for different accounts or servers (for example), they each need an ID which is unique within the backend.</para><para>It is immutable over the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 */
/**
 * folks_persona_store_get_id:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--id"><type>"id"</type></link> property.
 * 
 * The instance identifier for this PersonaStore.
 * 
 * <para>Since each <link linkend="FolksBackend"><type>FolksBackend</type></link> can provide multiple different PersonaStores for different accounts or servers (for example), they each need an ID which is unique within the backend.</para><para>It is immutable over the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--id"><type>"id"</type></link> property
 */
/**
 * FolksPersonaStore:personas:
 * 
 * The <link linkend="FolksPersona"><type>FolksPersona</type></link>s exposed by this PersonaStore.
 *
 * Since: 0.5.1
 */
/**
 * folks_persona_store_get_personas:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--personas"><type>"personas"</type></link> property.
 * 
 * The <link linkend="FolksPersona"><type>FolksPersona</type></link>s exposed by this PersonaStore.
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--personas"><type>"personas"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * FolksPersonaStore:can-add-personas:
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can add <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 *
 * Since: 0.3.1
 */
/**
 * folks_persona_store_get_can_add_personas:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--can-add-personas"><type>"can-add-personas"</type></link> property.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can add <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--can-add-personas"><type>"can-add-personas"</type></link> property
 *
 * Since: 0.3.1
 */
/**
 * FolksPersonaStore:can-alias-personas:
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can set the alias of <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 *
 * Since: 0.3.1
 * Deprecated: 0.6.3.1: Replaced by #FolksPersonaStore:always-writeable-properties.
 */
/**
 * folks_persona_store_get_can_alias_personas:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--can-alias-personas"><type>"can-alias-personas"</type></link> property.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can set the alias of <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--can-alias-personas"><type>"can-alias-personas"</type></link> property
 *
 * Since: 0.3.1
 * Deprecated: 0.6.3.1: Replaced by #FolksPersonaStore:always-writeable-properties.
 */
/**
 * FolksPersonaStore:can-group-personas:
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can set the groups of <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 *
 * Since: 0.3.1
 * Deprecated: 0.6.3.1: Replaced by #FolksPersonaStore:always-writeable-properties.
 */
/**
 * folks_persona_store_get_can_group_personas:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--can-group-personas"><type>"can-group-personas"</type></link> property.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can set the groups of <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--can-group-personas"><type>"can-group-personas"</type></link> property
 *
 * Since: 0.3.1
 * Deprecated: 0.6.3.1: Replaced by #FolksPersonaStore:always-writeable-properties.
 */
/**
 * FolksPersonaStore:can-remove-personas:
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can remove <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 *
 * Since: 0.3.1
 */
/**
 * folks_persona_store_get_can_remove_personas:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--can-remove-personas"><type>"can-remove-personas"</type></link> property.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> can remove <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--can-remove-personas"><type>"can-remove-personas"</type></link> property
 *
 * Since: 0.3.1
 */
/**
 * FolksPersonaStore:is-prepared:
 * 
 * Whether <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> has successfully completed for this store.
 * 
 * <para>It’s guaranteed that this will only ever change from <code>false</code> to <code>true</code> in the lifetime of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 *
 * Since: 0.3.0
 */
/**
 * folks_persona_store_get_is_prepared:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--is-prepared"><type>"is-prepared"</type></link> property.
 * 
 * Whether <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> has successfully completed for this store.
 * 
 * <para>It’s guaranteed that this will only ever change from <code>false</code> to <code>true</code> in the lifetime of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--is-prepared"><type>"is-prepared"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksPersonaStore:is-quiescent:
 * 
 * Whether the store has reached a quiescent state. This will happen at some point after <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> has successfully completed for the store. A store is in a quiescent state when all the <link linkend="FolksPersona"><type>FolksPersona</type></link>s that it originally knows about have been loaded.
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksIndividualAggregator--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para>
 *
 * Since: 0.6.2
 */
/**
 * folks_persona_store_get_is_quiescent:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--is-quiescent"><type>"is-quiescent"</type></link> property.
 * 
 * Whether the store has reached a quiescent state. This will happen at some point after <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> has successfully completed for the store. A store is in a quiescent state when all the <link linkend="FolksPersona"><type>FolksPersona</type></link>s that it originally knows about have been loaded.
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksIndividualAggregator--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--is-quiescent"><type>"is-quiescent"</type></link> property
 *
 * Since: 0.6.2
 */
/**
 * FolksPersonaStore:is-writeable:
 * 
 * Whether the PersonaStore is writeable.
 * 
 * <para>Only if a PersonaStore is writeable will its <link linkend="FolksPersona"><type>FolksPersona</type></link>s be updated by changes to the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s containing them, and those changes then be written out to the relevant backing store.</para><para>If this property is <code>false</code>, it doesn&apos;t mean that <link linkend="FolksPersona"><type>FolksPersona</type></link>s in this persona store aren&apos;t writeable at all. If their properties are updated through the <link linkend="FolksPersona"><type>FolksPersona</type></link>, rather than through the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> containing that persona, changes may be propagated to the backing store.</para><para>PersonaStores must not set this property themselves; it will be set as appropriate by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para>
 *
 * Since: 0.1.13
 * Deprecated: 0.6.3: Replaced by #FolksPersonaStore:is-primary-store.
 */
/**
 * folks_persona_store_get_is_writeable:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--is-writeable"><type>"is-writeable"</type></link> property.
 * 
 * Whether the PersonaStore is writeable.
 * 
 * <para>Only if a PersonaStore is writeable will its <link linkend="FolksPersona"><type>FolksPersona</type></link>s be updated by changes to the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s containing them, and those changes then be written out to the relevant backing store.</para><para>If this property is <code>false</code>, it doesn&apos;t mean that <link linkend="FolksPersona"><type>FolksPersona</type></link>s in this persona store aren&apos;t writeable at all. If their properties are updated through the <link linkend="FolksPersona"><type>FolksPersona</type></link>, rather than through the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> containing that persona, changes may be propagated to the backing store.</para><para>PersonaStores must not set this property themselves; it will be set as appropriate by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--is-writeable"><type>"is-writeable"</type></link> property
 *
 * Since: 0.1.13
 * Deprecated: 0.6.3: Replaced by #FolksPersonaStore:is-primary-store.
 */
/**
 * folks_persona_store_set_is_writeable:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPersonaStore--is-writeable"><type>"is-writeable"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPersonaStore--is-writeable"><type>"is-writeable"</type></link> property to @value.
 * 
 * Whether the PersonaStore is writeable.
 * 
 * <para>Only if a PersonaStore is writeable will its <link linkend="FolksPersona"><type>FolksPersona</type></link>s be updated by changes to the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s containing them, and those changes then be written out to the relevant backing store.</para><para>If this property is <code>false</code>, it doesn&apos;t mean that <link linkend="FolksPersona"><type>FolksPersona</type></link>s in this persona store aren&apos;t writeable at all. If their properties are updated through the <link linkend="FolksPersona"><type>FolksPersona</type></link>, rather than through the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> containing that persona, changes may be propagated to the backing store.</para><para>PersonaStores must not set this property themselves; it will be set as appropriate by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para>
 *
 * Since: 0.1.13
 * Deprecated: 0.6.3: Replaced by #FolksPersonaStore:is-primary-store.
 */
/**
 * FolksPersonaStore:trust-level:
 * 
 * The trust level of the PersonaStore for linking.
 * 
 * <para>Each <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is assigned a trust level by the IndividualAggregator, designating whether to trust the properties of its <link linkend="FolksPersona"><type>FolksPersona</type></link>s for linking to produce <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para><para>The trust level may be queried by clients, but must not be set by them. The setter for this property is for libfolks internal use only.</para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="FolksPersonaStoreTrust"><type>FolksPersonaStoreTrust</type></link>
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_store_get_trust_level:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--trust-level"><type>"trust-level"</type></link> property.
 * 
 * The trust level of the PersonaStore for linking.
 * 
 * <para>Each <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is assigned a trust level by the IndividualAggregator, designating whether to trust the properties of its <link linkend="FolksPersona"><type>FolksPersona</type></link>s for linking to produce <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para><para>The trust level may be queried by clients, but must not be set by them. The setter for this property is for libfolks internal use only.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--trust-level"><type>"trust-level"</type></link> property
 *
 * Since: 0.1.13
 */
/**
 * folks_persona_store_set_trust_level:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPersonaStore--trust-level"><type>"trust-level"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPersonaStore--trust-level"><type>"trust-level"</type></link> property to @value.
 * 
 * The trust level of the PersonaStore for linking.
 * 
 * <para>Each <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is assigned a trust level by the IndividualAggregator, designating whether to trust the properties of its <link linkend="FolksPersona"><type>FolksPersona</type></link>s for linking to produce <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>This value may change throughout the life of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para><para>The trust level may be queried by clients, but must not be set by them. The setter for this property is for libfolks internal use only.</para>
 *
 * Since: 0.1.13
 */
/**
 * FolksPersonaStore:always-writeable-properties:
 * @result_length1: return location for the length of the property's value
 * 
 * The names of the properties of the <link linkend="FolksPersona"><type>FolksPersona</type></link>s in this store which are always writeable.
 * 
 * <para>If a property name is in this list, setting the property on a persona should result in the updated value being stored in the backend&apos;s permanent storage (unless it gets rejected due to being invalid, or a different error occurs).</para><para>This property value is guaranteed to be constant for a given persona store, but may vary between persona stores in the same backend. It&apos;s guaranteed that this will always be a subset of the value of <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link> for the personas in this persona store.</para>
 *
 * Since: 0.6.2
 */
/**
 * folks_persona_store_get_always_writeable_properties:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--always-writeable-properties"><type>"always-writeable-properties"</type></link> property.
 * 
 * The names of the properties of the <link linkend="FolksPersona"><type>FolksPersona</type></link>s in this store which are always writeable.
 * 
 * <para>If a property name is in this list, setting the property on a persona should result in the updated value being stored in the backend&apos;s permanent storage (unless it gets rejected due to being invalid, or a different error occurs).</para><para>This property value is guaranteed to be constant for a given persona store, but may vary between persona stores in the same backend. It&apos;s guaranteed that this will always be a subset of the value of <link linkend="FolksPersona--writeable-properties"><type>"writeable-properties"</type></link> for the personas in this persona store.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--always-writeable-properties"><type>"always-writeable-properties"</type></link> property
 *
 * Since: 0.6.2
 */
/**
 * FolksPersonaStore:is-primary-store:
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is the primary store to be used for linking <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 *
 * Since: 0.6.3
 */
/**
 * folks_persona_store_get_is_primary_store:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--is-primary-store"><type>"is-primary-store"</type></link> property.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is the primary store to be used for linking <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--is-primary-store"><type>"is-primary-store"</type></link> property
 *
 * Since: 0.6.3
 */
/**
 * folks_persona_store_set_is_primary_store:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPersonaStore--is-primary-store"><type>"is-primary-store"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPersonaStore--is-primary-store"><type>"is-primary-store"</type></link> property to @value.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is the primary store to be used for linking <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 *
 * Since: 0.6.3
 */
/**
 * FolksPersonaStore:is-user-set-default:
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is marked as the default in its backend by the user.
 * 
 * <para>i.e. A <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> for the EDS backend would set this to <code>true</code> if it represents the user’s default address book.</para>
 *
 * Since: 0.6.3
 */
/**
 * folks_persona_store_get_is_user_set_default:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPersonaStore--is-user-set-default"><type>"is-user-set-default"</type></link> property.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is marked as the default in its backend by the user.
 * 
 * <para>i.e. A <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> for the EDS backend would set this to <code>true</code> if it represents the user’s default address book.</para>
 * 
 * Returns: the value of the <link linkend="FolksPersonaStore--is-user-set-default"><type>"is-user-set-default"</type></link> property
 *
 * Since: 0.6.3
 */
/**
 * folks_persona_store_set_is_user_set_default:
 * @self: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPersonaStore--is-user-set-default"><type>"is-user-set-default"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPersonaStore--is-user-set-default"><type>"is-user-set-default"</type></link> property to @value.
 * 
 * Whether this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is marked as the default in its backend by the user.
 * 
 * <para>i.e. A <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> for the EDS backend would set this to <code>true</code> if it represents the user’s default address book.</para>
 *
 * Since: 0.6.3
 */
/**
 * FolksPersonaStore::personas-changed:
 * @persona_store: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance that received the signal
 * @added: &nbsp;.  <para>a set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s which have been removed </para><para></para>
 * @removed: &nbsp;.  <para>a set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s which have been removed </para><para></para>
 * @message: &nbsp;.  <para>a string message from the backend, if any </para><para></para>
 * @actor: &nbsp;.  <para>the <link linkend="FolksPersona"><type>FolksPersona</type></link> who made the change, if known </para><para></para>
 * @reason: &nbsp;.  <para>the reason for the change </para><para></para>
 * 
 * Emitted when one or more <link linkend="FolksPersona"><type>FolksPersona</type></link>s are added to or removed from the store.
 * 
 * <para>This will not be emitted until after <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> has been called.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksPersonaStore::removed:
 * @persona_store: the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> instance that received the signal
 * 
 * Emitted when the backing store for this PersonaStore has been removed.
 * 
 * <para>At this point, the PersonaStore and all its <link linkend="FolksPersona"><type>FolksPersona</type></link>s are invalid, so any client referencing it should unreference it.</para><para>This will not be emitted until after <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link> has been called.</para>
 */
/**
 * folks_persona_store_detail_key:
 * @detail: (in): &nbsp;.  <para>the <link linkend="FolksPersonaDetail"><type>FolksPersonaDetail</type></link> to lookup </para>
 * 
 * Returns the key corresponding to @detail, for use in the details param of <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>.
 * 
 * Returns: (transfer none): <para>the corresponding property name, or <code>null</code> if <code>detail</code> is invalid </para>
 *
 * Since: 0.5.0
 */
/**
 * FolksPersonaStore:
 * 
 * A store for <link linkend="FolksPersona"><type>FolksPersona</type></link>s.
 * 
 * <para>After creating a PersonaStore instance, you must connect to the <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> signal, <emphasis>then</emphasis> call <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>, otherwise a race condition may occur between emission of <link linkend="FolksPersonaStore-personas-changed"><type>"personas-changed"</type></link> and your code connecting to it.</para>
 */
/**
 * FolksPersonaStoreClass:
 * @prepare: virtual method called by <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>
 * @prepare_finish: asynchronous finish function for <structfield>prepare</structfield>, called by <link linkend="folks-persona-store-prepare"><function>folks_persona_store_prepare()</function></link>
 * @flush: virtual method called by <link linkend="folks-persona-store-flush"><function>folks_persona_store_flush()</function></link>
 * @flush_finish: asynchronous finish function for <structfield>flush</structfield>, called by <link linkend="folks-persona-store-flush"><function>folks_persona_store_flush()</function></link>
 * @add_persona_from_details: virtual method called by <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>
 * @add_persona_from_details_finish: asynchronous finish function for <structfield>add_persona_from_details</structfield>, called by <link linkend="folks-persona-store-add-persona-from-details"><function>folks_persona_store_add_persona_from_details()</function></link>
 * @remove_persona: virtual method called by <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>
 * @remove_persona_finish: asynchronous finish function for <structfield>remove_persona</structfield>, called by <link linkend="folks-persona-store-remove-persona"><function>folks_persona_store_remove_persona()</function></link>
 * @get_type_id: getter method for the abstract property <link linkend="FolksPersonaStore--type-id"><type>"type-id"</type></link>
 * @get_personas: getter method for the abstract property <link linkend="FolksPersonaStore--personas"><type>"personas"</type></link>
 * @get_can_add_personas: getter method for the abstract property <link linkend="FolksPersonaStore--can-add-personas"><type>"can-add-personas"</type></link>
 * @get_can_alias_personas: getter method for the abstract property <link linkend="FolksPersonaStore--can-alias-personas"><type>"can-alias-personas"</type></link>
 * @get_can_group_personas: getter method for the abstract property <link linkend="FolksPersonaStore--can-group-personas"><type>"can-group-personas"</type></link>
 * @get_can_remove_personas: getter method for the abstract property <link linkend="FolksPersonaStore--can-remove-personas"><type>"can-remove-personas"</type></link>
 * @get_is_prepared: getter method for the abstract property <link linkend="FolksPersonaStore--is-prepared"><type>"is-prepared"</type></link>
 * @get_is_quiescent: getter method for the abstract property <link linkend="FolksPersonaStore--is-quiescent"><type>"is-quiescent"</type></link>
 * @get_always_writeable_properties: getter method for the abstract property <link linkend="FolksPersonaStore--always-writeable-properties"><type>"always-writeable-properties"</type></link>
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-PERSONA-STORE:CAPS"><literal>FOLKS_TYPE_PERSONA_STORE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FolksPersonaStoreTrust:
 * @FOLKS_PERSONA_STORE_TRUST_NONE: The <link linkend="FolksPersona"><type>FolksPersona</type></link>s aren&apos;t trusted at all, and cannot be linked.<para>This should be used for <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s where even the <link linkend="FolksPersona"><type>FolksPersona</type></link> UID could be maliciously edited to corrupt <link linkend="FolksPersona"><type>FolksPersona</type></link> links, or where the UID changes regularly.</para>
 * @FOLKS_PERSONA_STORE_TRUST_PARTIAL: Only the <link linkend="FolksPersona--uid"><type>"uid"</type></link> property is trusted for linking.<para>In practice, this means that <link linkend="FolksPersona"><type>FolksPersona</type></link>s from this <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> will not contribute towards the linking process, but can be linked together by their UIDs using data from <link linkend="FolksPersona"><type>FolksPersona</type></link>s from a fully-trusted <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.</para>
 * @FOLKS_PERSONA_STORE_TRUST_FULL: Every property in <link linkend="FolksPersona--linkable-properties"><type>"linkable-properties"</type></link> is trusted.<para>This should only be used for user-controlled <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s, as if a remote store is compromised, malicious changes could be made to its data which corrupt the user&apos;s <link linkend="FolksPersona"><type>FolksPersona</type></link> links.</para>
 * 
 * Trust level for a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>&apos;s <link linkend="FolksPersona"><type>FolksPersona</type></link>s for linking purposes.
 * 
 * <para>Trust levels are set internally by the backends, and must not be modified by clients.</para>
 *
 * Since: 0.1.13
 */
/**
 * FolksPersonaDetail:
 * @FOLKS_PERSONA_DETAIL_INVALID: Invalid field for use in error returns.
 * @FOLKS_PERSONA_DETAIL_ALIAS: Field for <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link>.
 * @FOLKS_PERSONA_DETAIL_AVATAR: Field for <link linkend="FolksAvatarDetails--avatar"><type>"avatar"</type></link>.
 * @FOLKS_PERSONA_DETAIL_BIRTHDAY: Field for <link linkend="FolksBirthdayDetails--birthday"><type>"birthday"</type></link>.
 * @FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES: Field for <link linkend="FolksEmailDetails--email-addresses"><type>"email-addresses"</type></link>.
 * @FOLKS_PERSONA_DETAIL_FULL_NAME: Field for <link linkend="FolksNameDetails--full-name"><type>"full-name"</type></link>.
 * @FOLKS_PERSONA_DETAIL_GENDER: Field for <link linkend="FolksGenderDetails--gender"><type>"gender"</type></link>.
 * @FOLKS_PERSONA_DETAIL_IM_ADDRESSES: Field for <link linkend="FolksImDetails--im-addresses"><type>"im-addresses"</type></link>.
 * @FOLKS_PERSONA_DETAIL_IS_FAVOURITE: Field for <link linkend="FolksFavouriteDetails--is-favourite"><type>"is-favourite"</type></link>.
 * @FOLKS_PERSONA_DETAIL_LOCAL_IDS: Field for <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link>.
 * @FOLKS_PERSONA_DETAIL_LOCATION: Field for <link linkend="FolksLocationDetails--location"><type>"location"</type></link>.
 * @FOLKS_PERSONA_DETAIL_NICKNAME: Field for <link linkend="FolksNameDetails--nickname"><type>"nickname"</type></link>.
 * @FOLKS_PERSONA_DETAIL_NOTES: Field for <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link>.
 * @FOLKS_PERSONA_DETAIL_PHONE_NUMBERS: Field for <link linkend="FolksPhoneDetails--phone-numbers"><type>"phone-numbers"</type></link>.
 * @FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES: Field for <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link>.
 * @FOLKS_PERSONA_DETAIL_ROLES: Field for <link linkend="FolksRoleDetails--roles"><type>"roles"</type></link>.
 * @FOLKS_PERSONA_DETAIL_STRUCTURED_NAME: Field for <link linkend="FolksNameDetails--structured-name"><type>"structured-name"</type></link>.
 * @FOLKS_PERSONA_DETAIL_URLS: Field for <link linkend="FolksUrlDetails--urls"><type>"urls"</type></link>.
 * @FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES: Field for <link linkend="FolksWebServiceDetails--web-service-addresses"><type>"web-service-addresses"</type></link>.
 * @FOLKS_PERSONA_DETAIL_GROUPS: Field for <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link>.
 * @FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT: Field for <link linkend="FolksInteractionDetails--im-interaction-count"><type>"im-interaction-count"</type></link>.
 * @FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME: Field for <link linkend="FolksInteractionDetails--last-im-interaction-datetime"><type>"last-im-interaction-datetime"</type></link>.
 * @FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT: Field for <link linkend="FolksInteractionDetails--call-interaction-count"><type>"call-interaction-count"</type></link>.
 * @FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME: Field for <link linkend="FolksInteractionDetails--last-call-interaction-datetime"><type>"last-call-interaction-datetime"</type></link>.
 * @FOLKS_PERSONA_DETAIL_ANTI_LINKS: Field for <link linkend="FolksAntiLinkable--anti-links"><type>"anti-links"</type></link>.
 * @FOLKS_PERSONA_DETAIL_EXTENDED_INFO: Field for <link linkend="FolksExtendedFieldDetails"><type>FolksExtendedFieldDetails</type></link>.
 * 
 * Definition of the available fields to be looked up with <link linkend="folks-persona-store-detail-key"><function>folks_persona_store_detail_key()</function></link>.
 *
 * Since: 0.5.0
 */
/**
 * FolksPersonaStoreError:
 * @FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT: An argument to the method was invalid.
 * @FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED: Creation of a <link linkend="FolksPersona"><type>FolksPersona</type></link> failed.
 * @FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER: Such an operation may not be performed on a <link linkend="FolksPersona"><type>FolksPersona</type></link> with <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>true</code>.
 * @FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE: The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> was offline (ie, this is a temporary failure).
 * @FOLKS_PERSONA_STORE_ERROR_READ_ONLY: The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> doesn&apos;t support write operations.
 * @FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED: The operation was denied due to not having sufficient permissions.
 * @FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED: Removal of a <link linkend="FolksPersona"><type>FolksPersona</type></link> failed. This is a generic error which is used if no other error code (such as, e.g., <link linkend="FOLKS-PERSONA-STORE-ERROR-PERMISSION-DENIED:CAPS"><literal>FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED</literal></link>) is applicable.
 * @FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER: Such an operation may only be performed on a <link linkend="FolksPersona"><type>FolksPersona</type></link> with <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>true</code>.
 * 
 * Errors from <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s.
 */
