/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.util.ViewFactory;
import net.infonode.docking.util.ViewFactoryManager;

public abstract class AbstractViewMap
implements ViewFactoryManager,
ViewSerializer {
    private HashMap viewMap = new HashMap();
    private ArrayList views = new ArrayList(20);

    protected abstract void writeViewId(Object var1, ObjectOutputStream var2) throws IOException;

    protected abstract Object readViewId(ObjectInputStream var1) throws IOException;

    public int getViewCount() {
        return this.viewMap.size();
    }

    public View getViewAtIndex(int index) {
        return (View)this.views.get(index);
    }

    @Override
    public ViewFactory[] getViewFactories() {
        ArrayList<1> f = new ArrayList<1>();
        int i = 0;
        while (i < this.views.size()) {
            final View view = (View)this.views.get(i);
            if (view.getRootWindow() == null) {
                f.add(new ViewFactory(){

                    @Override
                    public Icon getIcon() {
                        return view.getIcon();
                    }

                    @Override
                    public String getTitle() {
                        return view.getTitle();
                    }

                    @Override
                    public View createView() {
                        return view;
                    }
                });
            }
            ++i;
        }
        return f.toArray(new ViewFactory[f.size()]);
    }

    public boolean contains(View view) {
        return this.views.contains(view);
    }

    @Override
    public void writeView(View view, ObjectOutputStream out) throws IOException {
        for (Map.Entry entry : this.viewMap.entrySet()) {
            if (entry.getValue() != view) continue;
            this.writeViewId(entry.getKey(), out);
            return;
        }
        throw new IOException("Serialization of unknown view!");
    }

    @Override
    public View readView(ObjectInputStream in) throws IOException {
        return (View)this.viewMap.get(this.readViewId(in));
    }

    protected void addView(Object id, View view) {
        View oldView = this.viewMap.put(id, view);
        if (oldView != null) {
            this.views.remove(oldView);
        }
        this.views.add(view);
    }

    protected void removeView(Object id) {
        Object view = this.viewMap.remove(id);
        if (view != null) {
            this.views.remove(view);
        }
    }

    protected View getView(Object id) {
        return (View)this.viewMap.get(id);
    }
}

