/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public class CursorManager {
    private static boolean enabled = true;
    private static WeakHashMap windowPanels = new WeakHashMap();

    private CursorManager() {
    }

    public static void setGlobalCursor(final JRootPane root, Cursor cursor) {
        if (root == null) {
            return;
        }
        RootCursorInfo rci = (RootCursorInfo)windowPanels.get(root);
        if (rci == null) {
            rci = new RootCursorInfo(new JComponent(){});
            windowPanels.put(root, rci);
            root.getLayeredPane().add(rci.getComponent());
            root.getLayeredPane().setLayer(rci.getComponent(), JLayeredPane.DRAG_LAYER + 10);
            rci.getComponent().setBounds(0, 0, root.getWidth(), root.getHeight());
            root.getLayeredPane().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ((RootCursorInfo)windowPanels.get(root)).getComponent().setSize(root.getSize());
                }
            });
        }
        if (!rci.isCursorSet()) {
            rci.setCursor(cursor);
            rci.pushCursor(root.isCursorSet() ? root.getCursor() : null);
        }
        if (enabled) {
            root.setCursor(cursor);
            rci.getComponent().setVisible(true);
        }
    }

    public static Cursor getCurrentGlobalCursor(JRootPane root) {
        if (root == null) {
            return Cursor.getDefaultCursor();
        }
        RootCursorInfo rci = (RootCursorInfo)windowPanels.get(root);
        return rci == null || !rci.isCursorSet() ? Cursor.getDefaultCursor() : rci.getCursor();
    }

    public static void resetGlobalCursor(JRootPane root) {
        if (root == null) {
            return;
        }
        RootCursorInfo rci = (RootCursorInfo)windowPanels.get(root);
        if (rci != null && rci.isCursorSet()) {
            root.setCursor(rci.popCursor());
            rci.getComponent().setVisible(false);
        }
    }

    public static void setEnabled(boolean enabled) {
        CursorManager.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static JComponent getCursorLayerComponent(JRootPane root) {
        if (root == null) {
            return null;
        }
        RootCursorInfo rci = (RootCursorInfo)windowPanels.get(root);
        return rci == null ? null : rci.getComponent();
    }

    public static boolean isGlobalCursorSet(JRootPane root) {
        if (root == null) {
            return false;
        }
        RootCursorInfo rci = (RootCursorInfo)windowPanels.get(root);
        return rci != null && rci.isCursorSet();
    }

    private static class RootCursorInfo {
        private Cursor savedCursor;
        private Cursor cursor;
        private JComponent panel;
        private boolean cursorSet = false;

        RootCursorInfo(JComponent panel) {
            this.panel = panel;
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public void pushCursor(Cursor cursor) {
            if (this.savedCursor == null) {
                this.savedCursor = cursor;
            }
            this.cursorSet = true;
        }

        public Cursor popCursor() {
            Cursor c = this.savedCursor;
            this.savedCursor = null;
            this.cursorSet = false;
            return c;
        }

        public boolean isCursorSet() {
            return this.cursorSet;
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public void setCursor(Cursor cursor) {
            this.cursor = cursor;
        }
    }
}

