/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.panel;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.infonode.gui.CursorManager;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.util.Direction;

public class ResizablePanel
extends BaseContainer {
    private Direction direction;
    private int resizeWidth = 4;
    private boolean cursorChanged;
    private int offset = -1;
    private boolean mouseInside;
    private boolean heavyWeight = true;
    private boolean continuousLayout = false;
    private Component dragIndicator;
    private JComponent layeredPane;
    private JComponent innerArea;
    private Dimension lastSize;
    private int dragIndicatorThickness = 4;
    private Component comp;

    public ResizablePanel(Direction _direction) {
        this(false, _direction, null);
    }

    public ResizablePanel(boolean useHeavyWeightDragIndicator, Direction _direction, Component mouseListenComponent) {
        super(new BorderLayout());
        this.heavyWeight = useHeavyWeightDragIndicator;
        this.direction = _direction;
        this.dragIndicator = this.heavyWeight ? new Canvas() : new BaseContainer();
        this.setDragIndicatorColor(null);
        if (mouseListenComponent == null) {
            mouseListenComponent = this;
        }
        mouseListenComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (ResizablePanel.this.offset == -1) {
                    ResizablePanel.this.resetCursor();
                }
                ResizablePanel.this.mouseInside = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ResizablePanel.this.mouseInside = true;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ResizablePanel.this.continuousLayout && ResizablePanel.this.layeredPane != null) {
                    if (ResizablePanel.this.layeredPane instanceof JLayeredPane) {
                        ResizablePanel.this.layeredPane.add(ResizablePanel.this.dragIndicator, JLayeredPane.DRAG_LAYER);
                    } else {
                        ResizablePanel.this.layeredPane.add(ResizablePanel.this.dragIndicator, 0);
                    }
                    ResizablePanel.this.layeredPane.repaint();
                    ResizablePanel.this.updateDragIndicator(e);
                }
                if (ResizablePanel.this.cursorChanged) {
                    ResizablePanel.this.offset = ResizablePanel.this.direction == Direction.LEFT ? e.getPoint().x : (ResizablePanel.this.direction == Direction.RIGHT ? ResizablePanel.this.getWidth() - e.getPoint().x : (ResizablePanel.this.direction == Direction.UP ? e.getPoint().y : ResizablePanel.this.getHeight() - e.getPoint().y));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ResizablePanel.this.continuousLayout && ResizablePanel.this.layeredPane != null) {
                    ResizablePanel.this.layeredPane.remove(ResizablePanel.this.dragIndicator);
                    ResizablePanel.this.layeredPane.repaint();
                }
                ResizablePanel.this.offset = -1;
                ResizablePanel.this.checkCursor(e.getPoint());
                if (!ResizablePanel.this.continuousLayout && ResizablePanel.this.lastSize != null) {
                    ResizablePanel.this.setPreferredSize(ResizablePanel.this.lastSize);
                    ResizablePanel.this.revalidate();
                }
                ResizablePanel.this.lastSize = null;
            }
        });
        mouseListenComponent.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ResizablePanel.this.checkCursor(e.getPoint());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ResizablePanel.this.offset != -1) {
                    int size = ResizablePanel.this.direction.isHorizontal() ? (ResizablePanel.this.direction == Direction.LEFT ? ResizablePanel.this.getWidth() - e.getPoint().x + ResizablePanel.this.offset : e.getPoint().x + ResizablePanel.this.offset) : (ResizablePanel.this.direction == Direction.UP ? ResizablePanel.this.getHeight() - e.getPoint().y + ResizablePanel.this.offset : e.getPoint().y + ResizablePanel.this.offset);
                    ResizablePanel.this.lastSize = ResizablePanel.this.getBoundedSize(size);
                    if (ResizablePanel.this.continuousLayout) {
                        ResizablePanel.this.setPreferredSize(ResizablePanel.this.lastSize);
                        ResizablePanel.this.revalidate();
                    } else {
                        ResizablePanel.this.updateDragIndicator(e);
                    }
                }
            }
        });
    }

    public void setComponent(Component c) {
        if (this.comp != null) {
            this.remove(this.comp);
        }
        if (c != null) {
            this.add(c, "Center");
            this.revalidate();
        }
        this.comp = c;
    }

    public void setDragIndicatorColor(Color color) {
        this.dragIndicator.setBackground(color == null ? Color.DARK_GRAY : color);
    }

    public void setLayeredPane(JComponent layeredPane) {
        this.layeredPane = layeredPane;
        if (this.innerArea == null) {
            this.innerArea = layeredPane;
        }
    }

    public void setInnerArea(JComponent innerArea) {
        if (innerArea == null) {
            innerArea = this.layeredPane;
        } else {
            this.innerArea = innerArea;
        }
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean continuousLayout) {
        this.continuousLayout = continuousLayout;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return this.getBoundedSize(this.direction.isHorizontal() ? d.width : d.height);
    }

    private void updateDragIndicator(MouseEvent e) {
        if (this.layeredPane != null) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.layeredPane);
            Point p2 = SwingUtilities.convertPoint(this.getParent(), this.getLocation(), this.layeredPane);
            Dimension size = this.innerArea.getSize();
            Dimension minimumSize = this.getMinimumSize();
            Point offset = SwingUtilities.convertPoint(this.innerArea, 0, 0, this.layeredPane);
            if (this.direction.isHorizontal()) {
                int x = 0;
                x = this.direction == Direction.LEFT ? Math.min(Math.max(offset.x, p.x), offset.x + size.width - minimumSize.width) : Math.min(Math.max(offset.x + minimumSize.width, p.x), offset.x + size.width) - this.dragIndicatorThickness;
                this.dragIndicator.setBounds(x, p2.y, this.dragIndicatorThickness, this.getHeight());
            } else {
                int y = 0;
                y = this.direction == Direction.UP ? Math.min(Math.max(offset.y, p.y), offset.y + size.height - minimumSize.height) : Math.min(Math.max(offset.y + minimumSize.height, p.y), offset.y + size.height) - this.dragIndicatorThickness;
                this.dragIndicator.setBounds(p2.x, y, this.getWidth(), this.dragIndicatorThickness);
            }
        }
    }

    private Dimension getBoundedSize(int size) {
        if (this.direction.isHorizontal()) {
            return new Dimension(Math.max(this.getMinimumSize().width, Math.min(size, this.getMaximumSize().width)), 0);
        }
        return new Dimension(0, Math.max(this.getMinimumSize().height, Math.min(size, this.getMaximumSize().height)));
    }

    public void setResizeWidth(int width) {
        this.resizeWidth = width;
    }

    public int getResizeWidth() {
        return this.resizeWidth;
    }

    private void checkCursor(Point point) {
        int dist;
        if (this.offset != -1) {
            return;
        }
        int n = this.direction == Direction.UP ? point.y : (this.direction == Direction.DOWN ? this.getHeight() - point.y : (dist = this.direction == Direction.LEFT ? point.x : this.getWidth() - point.x));
        if (dist >= 0 && dist < this.resizeWidth && this.mouseInside) {
            if (!this.cursorChanged) {
                this.cursorChanged = true;
                CursorManager.setGlobalCursor(this.getRootPane(), new Cursor(this.direction == Direction.LEFT ? 10 : (this.direction == Direction.RIGHT ? 11 : (this.direction == Direction.UP ? 8 : 9))));
            }
        } else {
            this.resetCursor();
        }
    }

    private void resetCursor() {
        CursorManager.resetGlobalCursor(this.getRootPane());
        this.cursorChanged = false;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }
}

