/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;

public class AntiAliasingConfigurator {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private long lastRenderTime;
    private Timer repaintTimer;
    private final int repaintDelay;
    private boolean isRepaintScheduled;
    private boolean isRepaintInProgress;
    private final JComponent component;
    private Rectangle repaintedClipBounds;
    private Dimension lastPaintedComponentSize;
    private Point lastComponentLocation;
    private static boolean isAntialiasingEnabled = true;
    private static Object hintAntialiasCurves = RenderingHints.VALUE_ANTIALIAS_ON;
    private static Object hintAntialiasText = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    private static Thread currentPaintingThread = null;

    private static void changeAntialias(String antialiasOption) {
        if (antialiasOption.equals("antialias_none")) {
            isAntialiasingEnabled = false;
            hintAntialiasCurves = RenderingHints.VALUE_ANTIALIAS_OFF;
            hintAntialiasText = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        } else {
            isAntialiasingEnabled = true;
            if (antialiasOption.equals("antialias_edges")) {
                hintAntialiasCurves = RenderingHints.VALUE_ANTIALIAS_ON;
                hintAntialiasText = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            } else if (antialiasOption.equals("antialias_all")) {
                hintAntialiasCurves = RenderingHints.VALUE_ANTIALIAS_ON;
                hintAntialiasText = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            }
        }
    }

    private static void disableAntialiasing(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    private static void enableAntialiasing(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static void setAntialiasing(Graphics2D g2) {
        if (!AntiAliasingConfigurator.isManagedPaintingInProgress()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hintAntialiasCurves);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hintAntialiasText);
        }
    }

    private static boolean isManagedPaintingInProgress() {
        return currentPaintingThread != null && currentPaintingThread == Thread.currentThread();
    }

    private static boolean antialliasDuringScrolling() {
        return ResourceController.getResourceController().getBooleanProperty("antialias_during_scrolling");
    }

    public AntiAliasingConfigurator(JComponent component) {
        this(component, 40);
    }

    public AntiAliasingConfigurator(JComponent component, int repaintDelay) {
        this.component = component;
        this.repaintDelay = repaintDelay;
        this.isRepaintScheduled = false;
        this.isRepaintInProgress = false;
        this.lastRenderTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withAntialias(Graphics2D g2, Runnable painter) {
        if (AntiAliasingConfigurator.isManagedPaintingInProgress()) {
            painter.run();
            return;
        }
        if (!this.managesPaint(g2)) {
            AntiAliasingConfigurator.enableAntialiasing(g2);
            painter.run();
            return;
        }
        if (!isAntialiasingEnabled) {
            AntiAliasingConfigurator.disableAntialiasing(g2);
            painter.run();
            return;
        }
        Rectangle newClipBounds = g2.getClipBounds();
        Dimension newComponentSize = this.component.getSize();
        Point newComponentLocation = this.component.getLocation();
        if (!this.isRepaintInProgress && (this.isRepaintScheduled || newComponentSize.equals(this.lastPaintedComponentSize) && !newComponentLocation.equals(this.lastComponentLocation) && !AntiAliasingConfigurator.antialliasDuringScrolling())) {
            this.repaintedClipBounds = this.repaintedClipBounds == null ? newClipBounds : this.repaintedClipBounds.union(newClipBounds);
            this.isRepaintScheduled = true;
            SwingUtilities.invokeLater(this::restartRepaintTimer);
            AntiAliasingConfigurator.disableAntialiasing(g2);
        } else {
            this.repaintedClipBounds = null;
            this.isRepaintInProgress = false;
            this.isRepaintScheduled = false;
            this.stopRepaintTimer();
            AntiAliasingConfigurator.enableAntialiasing(g2);
        }
        this.lastPaintedComponentSize = newComponentSize;
        this.lastComponentLocation = newComponentLocation;
        try {
            this.startManagedPainting();
            painter.run();
        }
        finally {
            this.endManagedPainting();
            this.lastRenderTime = System.currentTimeMillis();
        }
    }

    private void startManagedPainting() {
        currentPaintingThread = Thread.currentThread();
    }

    private void endManagedPainting() {
        currentPaintingThread = null;
    }

    private long timeSinceLastRendering() {
        return System.currentTimeMillis() - this.lastRenderTime;
    }

    private void restartRepaintTimer() {
        if (this.repaintedClipBounds == null) {
            return;
        }
        if (this.repaintTimer != null && this.repaintTimer.isRunning()) {
            this.repaintTimer.restart();
        } else {
            this.repaintTimer = new Timer(this.repaintDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AntiAliasingConfigurator.this.isRepaintScheduled && AntiAliasingConfigurator.this.timeSinceLastRendering() >= (long)AntiAliasingConfigurator.this.repaintDelay) {
                        AntiAliasingConfigurator.this.isRepaintInProgress = true;
                        AntiAliasingConfigurator.this.component.paintImmediately(AntiAliasingConfigurator.this.repaintedClipBounds);
                    }
                }
            });
            this.repaintTimer.setRepeats(false);
            this.repaintTimer.start();
        }
    }

    private void stopRepaintTimer() {
        if (this.repaintTimer != null && this.repaintTimer.isRunning()) {
            this.repaintTimer.stop();
        }
    }

    private boolean managesPaint(Graphics2D g2) {
        return !this.component.isPaintingForPrint() && EventQueue.isDispatchThread();
    }

    static {
        ResourceController.getResourceController().addPropertyChangeListenerAndPropagate(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("antialias")) {
                    AntiAliasingConfigurator.changeAntialias(newValue);
                }
            }
        });
    }
}

