/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import org.freeplane.core.util.FactoryMethod;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.SerializationMethod;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedNumber;
import org.freeplane.features.link.LinkController;

public class TypeReference {
    public static Object create(String objSpec) {
        return TypeReference.create(objSpec, true);
    }

    public static Object create(String objSpec, boolean verbose) {
        try {
            int sep = objSpec.indexOf(124);
            if (sep == -1) {
                return objSpec;
            }
            String type = objSpec.substring(0, sep);
            String spec = objSpec.substring(sep + 1);
            if (String.class.getName().equals(type)) {
                return spec;
            }
            AccessibleObject factory = TypeReference.getFactory(type);
            if (factory instanceof Method) {
                return ((Method)factory).invoke(null, spec);
            }
            return ((Constructor)factory).newInstance(spec);
        }
        catch (Exception e) {
            if (verbose) {
                LogUtils.warn("cannot create for type reference " + objSpec, e);
            }
            return objSpec;
        }
    }

    private static AccessibleObject getFactory(String typeReference) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        if (typeReference.equals("org.freeplane.core.util.FreeplaneDate") || typeReference.equals("org.freeplane.features.common.format.FormattedDate")) {
            typeReference = FormattedDate.class.getName();
        } else if (typeReference.equals("org.freeplane.features.common.format.FormattedNumber")) {
            typeReference = FormattedNumber.class.getName();
        } else if (typeReference.equals(URI.class.getName())) {
            return LinkController.class.getMethod("createHyperlink", String.class);
        }
        Class<?> clazz = TypeReference.class.getClassLoader().loadClass(typeReference);
        FactoryMethod factoryAnnotation = clazz.getAnnotation(FactoryMethod.class);
        if (factoryAnnotation != null) {
            return clazz.getMethod(factoryAnnotation.value(), String.class);
        }
        return clazz.getConstructor(String.class);
    }

    public static String toSpec(Object obj) {
        Class<?> clazz = obj.getClass();
        SerializationMethod method = clazz.getAnnotation(SerializationMethod.class);
        String type = (clazz.equals(Hyperlink.class) ? URI.class : clazz).getName() + '|';
        if (method == null) {
            return type + obj.toString();
        }
        try {
            return type + clazz.getMethod(method.value(), obj.getClass()).invoke(null, obj).toString();
        }
        catch (Exception e) {
            LogUtils.warn(e);
            return obj.toString();
        }
    }

    public static String encode(String text) {
        StringBuilder result = new StringBuilder((int)((double)text.length() * 1.2));
        for (int i = 0; i < text.length(); ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue < ' ' || intValue == '\"' || intValue == '&' || intValue == '|') {
                result.append("&#x").append(Integer.toString(intValue, 16)).append(';');
                continue;
            }
            result.append(myChar);
        }
        return result.toString();
    }

    public static String decode(String spec) {
        return HtmlUtils.unescapeHTMLUnicodeEntity(spec);
    }
}

