/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagReference;
import org.freeplane.features.icon.TreeInverseMap;
import org.freeplane.features.icon.TreeTagChangeListener;

public class TagCategories {
    public static final Tag NOT_A_TAG = new Tag("", Color.BLACK);
    private final DefaultTreeModel nodes;
    private TreeInverseMap<Tag> nodesByTags;
    private final SortedComboBoxModel<Tag> mapTags;
    private final TreeMap<String, List<TagReference>> tagReferences;
    private boolean categoriesChanged;
    private String categorySeparator;
    private final DefaultMutableTreeNode uncategorizedTagsNode;
    public static final String UNCATEGORIZED_NODE = " uncategorized node ";
    private boolean mergeIsRunning;

    public static Tag readTag(String spec) {
        int colorIndex = spec.length() - 9;
        if (colorIndex > 0 && spec.charAt(colorIndex) == '#') {
            String content = spec.substring(0, colorIndex);
            String colorSpec = spec.substring(colorIndex);
            try {
                return new Tag(content, TagCategories.tagColor(content, colorSpec));
            }
            catch (NumberFormatException e) {
                LogUtils.severe(e);
            }
        }
        return new Tag(spec);
    }

    public TagCategories() {
        this(new DefaultMutableTreeNode(TextUtils.getRawText("tags")), new DefaultMutableTreeNode(TextUtils.getRawText("uncategorized_tags")), ResourceController.getResourceController().getProperty("category_separator"));
    }

    public TagCategories(DefaultMutableTreeNode rootNode, DefaultMutableTreeNode uncategorizedTagsNode, String categorySeparator) {
        this.uncategorizedTagsNode = uncategorizedTagsNode;
        this.categorySeparator = categorySeparator;
        this.mapTags = new SortedComboBoxModel<Tag>(Tag.class);
        rootNode.add(uncategorizedTagsNode);
        this.nodes = new TagCategoryTree(rootNode);
        this.tagReferences = new TreeMap();
        this.nodesByTags = null;
        this.categoriesChanged = false;
        this.mergeIsRunning = false;
    }

    private TagCategories(TagCategories tagCategories) {
        this.mapTags = new SortedComboBoxModel<Tag>(Tag.class);
        DefaultMutableTreeNode rootNode = tagCategories.getRootNode();
        this.categorySeparator = tagCategories.categorySeparator;
        this.tagReferences = new TreeMap();
        tagCategories.tagReferences.entrySet().forEach(e -> this.tagReferences.put((String)e.getKey(), new ArrayList((Collection)e.getValue())));
        DefaultMutableTreeNode rootCopy = this.copySubtree(rootNode);
        this.uncategorizedTagsNode = (DefaultMutableTreeNode)rootCopy.getLastChild();
        this.nodes = new TagCategoryTree(rootCopy);
        this.nodesByTags = null;
        tagCategories.mapTags.forEach(this.mapTags::addIfNotExists);
        this.categoriesChanged = false;
        this.mergeIsRunning = false;
    }

    public String getTagCategorySeparator() {
        return this.categorySeparator;
    }

    public void updateTagCategorySeparator(String newCategorySeparator) {
        String initialCategorySeparator = this.categorySeparator;
        if (!initialCategorySeparator.equals(newCategorySeparator)) {
            Tag[] initialTags;
            this.setTagCategorySeparator(newCategorySeparator);
            for (Tag tag2 : initialTags = (Tag[])this.mapTags.stream().filter(tag -> tag.getContent().contains(initialCategorySeparator)).toArray(Tag[]::new)) {
                String updatedContent = tag2.getContent().replace(initialCategorySeparator, newCategorySeparator);
                Tag updatedTag = new Tag(updatedContent, tag2.getColor());
                this.mapTags.replace(tag2, updatedTag);
                List<TagReference> replacedContentReferences = this.tagReferences.remove(tag2.getContent());
                if (replacedContentReferences == null) continue;
                this.tagReferences.computeIfAbsent(updatedContent, x -> new ArrayList()).addAll(replacedContentReferences);
            }
            for (int i = this.uncategorizedTagsNode.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode uncategorizedTagNode = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(i);
                Tag tag3 = this.categorizedTag(uncategorizedTagNode);
                if (!tag3.getContent().contains(newCategorySeparator)) continue;
                this.uncategorizedTagsNode.remove(i);
                this.mapTags.remove((Object)tag3);
                this.registerTagReference(tag3, true);
            }
            this.categoriesChanged = true;
        }
    }

    public void setTagCategorySeparator(String newCategorySeparator) {
        this.categorySeparator = newCategorySeparator;
    }

    public void writeCategorizedTag(DefaultMutableTreeNode node, StringWriter writer) {
        if (this.containsTag(node)) {
            try {
                TagCategories.writeTag(this.categorizedTag(node), writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void writeTagCategories(DefaultMutableTreeNode node, String indent, Writer writer) throws IOException {
        if (this.containsTag(node)) {
            writer.append(indent);
            TagCategories.writeTag(this.tagWithoutCategories(node), writer);
            indent = indent + " ";
        } else if (node.getParent() != null) {
            return;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            this.writeTagCategories(childNode, indent, writer);
        }
    }

    public Tag withoutCategories(Tag tag) {
        return tag.withoutCategories(this.categorySeparator);
    }

    public static void writeTag(Tag tag, Writer writer) throws IOException {
        if (!tag.isEmpty()) {
            writer.append(tag.getContent());
            writer.append(ColorUtils.colorToRGBAString(tag.getColor()));
        }
        writer.append(System.lineSeparator());
    }

    public boolean isEmpty() {
        return this.getRootNode().isLeaf();
    }

    public void readTagCategories(DefaultMutableTreeNode target, int firstIndex, Scanner scanner) {
        String prefix;
        DefaultMutableTreeNode lastNode = target;
        int lastIndentation = -1;
        int index = firstIndex;
        LinkedList<String> categorizedContent = new LinkedList<String>();
        String tagCategorySeparator = this.getTagCategorySeparator();
        if (!target.isRoot() && !(prefix = this.categorizedContent((DefaultMutableTreeNode)lastNode.getParent())).isEmpty()) {
            categorizedContent.add(prefix + tagCategorySeparator);
        }
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String lineTags = line.trim();
            if (lineTags.isEmpty()) continue;
            int indentation = this.getIndentationLevel(line);
            int lineTagIndex = 0;
            while (lineTagIndex < lineTags.length()) {
                DefaultMutableTreeNode parent;
                int lineTagEnd = lineTags.indexOf(tagCategorySeparator, lineTagIndex);
                String lineTag = lineTagEnd >= 0 ? lineTags.substring(lineTagIndex, lineTagEnd) : lineTags.substring(lineTagIndex);
                lineTagIndex = lineTagEnd >= 0 ? lineTagEnd + tagCategorySeparator.length() : lineTags.length();
                Tag tag = TagCategories.readTag(lineTag);
                if (target == this.uncategorizedTagsNode) {
                    Tag savedTag = this.mapTags.addAndReturn(tag);
                    this.insertUncategorizedTagNodeSorted(savedTag);
                    if (savedTag != tag) continue;
                    this.addNewTagReference(tag);
                    continue;
                }
                if (indentation == lastIndentation) {
                    parent = (DefaultMutableTreeNode)lastNode.getParent();
                } else if (indentation > lastIndentation) {
                    parent = lastNode;
                    String categorizedParentContent = this.containsTag(parent) ? this.categorizedTag(parent).getContent() + tagCategorySeparator : "";
                    categorizedContent.add(categorizedParentContent);
                } else {
                    parent = (DefaultMutableTreeNode)lastNode.getParent();
                    for (int i = 0; i < lastIndentation - indentation; ++i) {
                        parent = (DefaultMutableTreeNode)parent.getParent();
                        categorizedContent.removeLast();
                    }
                }
                String categorizedTagContent = (String)categorizedContent.getLast() + tag.getContent();
                Tag categorizedTag = new Tag(categorizedTagContent, Color.BLACK);
                categorizedTag.setAlternativeTag(tag);
                Tag savedTag = this.mapTags.addAndReturn(categorizedTag);
                if (!lineTag.equals(tag.getContent())) {
                    savedTag.setColor(tag.getColor());
                } else if (savedTag == categorizedTag) {
                    savedTag.setColor(Tag.getDefaultColor(categorizedTagContent));
                }
                if (savedTag == categorizedTag) {
                    this.addNewTagReference(categorizedTag);
                }
                savedTag.setAlternativeTag(tag);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(tag);
                parent.insert(newNode, target == parent ? index++ : parent.getChildCount());
                lastNode = newNode;
                lastIndentation = indentation++;
            }
        }
        if (target != this.uncategorizedTagsNode) {
            this.nodes.nodesWereInserted(target, IntStream.range(firstIndex, index).toArray());
        }
    }

    private boolean addNewTagReference(Tag tag) {
        return this.tagReferences.computeIfAbsent(tag.getContent(), x -> new ArrayList()).add(new TagReference(tag));
    }

    private void insertNode(DefaultMutableTreeNode parent, int index, DefaultMutableTreeNode newChild) {
        parent.insert(newChild, index);
        this.nodes.nodesWereInserted(parent, new int[]{index});
    }

    private int findUncategorizedTagIndex(Tag tag) {
        int low = 0;
        int high = this.uncategorizedTagsNode.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            DefaultMutableTreeNode midNode = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(mid);
            Tag midUserObject = this.categorizedTag(midNode);
            if (tag.compareTo(midUserObject) == 0) {
                return mid;
            }
            if (tag.compareTo(midUserObject) < 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    private void insertUncategorizedTagNodeSorted(Tag tag) {
        int index = this.findUncategorizedTagIndex(tag);
        int insertionPoint = index >= 0 ? index : -index - 1;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(tag);
        this.insertNode(this.uncategorizedTagsNode, insertionPoint, node);
    }

    private void insertUncategorizedTagNodeSorted(DefaultMutableTreeNode node) {
        int index = this.findUncategorizedTagIndex(new Tag(this.categorizedContent(node), Color.BLACK));
        int insertionPoint = index >= 0 ? index : -index - 1;
        this.insertNode(this.uncategorizedTagsNode, insertionPoint, node);
    }

    private DefaultMutableTreeNode removeUncategorizedTagNode(Tag tag) {
        int index = this.findUncategorizedTagIndex(tag);
        if (index < 0) {
            return null;
        }
        DefaultMutableTreeNode removedNode = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(index);
        this.removeNodeFromParent(removedNode);
        return removedNode;
    }

    private int getIndentationLevel(String line) {
        int indentation = 0;
        while (line.charAt(indentation) == ' ') {
            ++indentation;
        }
        return indentation;
    }

    public void load(File tagCategoryFile) {
        try (Scanner scanner = new Scanner(tagCategoryFile);){
            this.load(scanner);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void load(String data) {
        try (Scanner scanner = new Scanner(data);){
            this.load(scanner);
        }
    }

    private void load(Scanner scanner) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        while (rootNode.getChildCount() > 1) {
            rootNode.remove(0);
        }
        this.readTagCategories(rootNode, 0, scanner);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.nodes.getRoot();
    }

    public DefaultMutableTreeNode getUncategorizedTagsNode() {
        return this.uncategorizedTagsNode;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.nodes.addTreeModelListener(treeModelListener);
    }

    void removeTreeModelListener(TreeModelListener l) {
        this.nodes.removeTreeModelListener(l);
    }

    public TreeNode[] addChildNode(MutableTreeNode parent) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        if (parent == null) {
            parent = rootNode;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(NOT_A_TAG);
        this.nodes.insertNodeInto(newNode, parent, parent == rootNode ? parent.getChildCount() - 1 : parent.getChildCount());
        return this.nodes.getPathToRoot(newNode);
    }

    public TreeNode[] addSiblingNode(MutableTreeNode node) {
        TreeNode[] nothing = new TreeNode[]{};
        if (node == null) {
            return nothing;
        }
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            return nothing;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(NOT_A_TAG);
        this.nodes.insertNodeInto(newNode, parent, parent.getIndex(node) + 1);
        return this.nodes.getPathToRoot(newNode);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        if (node.getParent() != null) {
            this.nodes.removeNodeFromParent(node);
        }
    }

    void save(File tagCategoryFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tagCategoryFile));){
            this.writeTagCategories(this.getRootNode(), "", writer);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
    }

    public String serialize() {
        try {
            StringWriter writer = new StringWriter();
            this.writeTagCategories(this.getRootNode(), "", writer);
            String serializedData = writer.toString();
            return serializedData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void insert(DefaultMutableTreeNode parent, int index, String data) {
        if (parent == null) {
            parent = this.getRootNode();
        }
        try (Scanner st = new Scanner(new StringReader(data));){
            this.readTagCategories(parent, index, st);
        }
    }

    public List<Tag> extendCategories(Iterable<Tag> tags) {
        LinkedList<Tag> categorizedTags = new LinkedList<Tag>();
        HashSet<Tag> addedTags = new HashSet<Tag>();
        for (Tag qualifiedTag : tags) {
            Tag tagWithoutCategories;
            if (qualifiedTag.isEmpty() || !addedTags.add(tagWithoutCategories = qualifiedTag.withoutCategories(this.getTagCategorySeparator()))) continue;
            Set<DefaultMutableTreeNode> tagCategoryNodes = this.getNodes(tagWithoutCategories);
            if (tagCategoryNodes.isEmpty()) {
                categorizedTags.add(tagWithoutCategories);
                continue;
            }
            for (DefaultMutableTreeNode node : tagCategoryNodes) {
                categorizedTags.add(this.categorizedTag(node));
            }
        }
        return categorizedTags;
    }

    private Set<DefaultMutableTreeNode> getNodes(Tag tag) {
        if (this.nodesByTags == null) {
            this.nodesByTags = new TreeInverseMap<Tag>(this.nodes, node -> this.tagWithoutCategories((DefaultMutableTreeNode)node));
            this.nodes.addTreeModelListener(this.nodesByTags);
        }
        return this.nodesByTags.getNodes(tag);
    }

    public DefaultTreeModel getNodes() {
        return this.nodes;
    }

    public SortedComboBoxModel<Tag> getTagsAsListModel() {
        return this.mapTags;
    }

    public Tag createTag(String string) {
        return this.createTagReference(string).getTag();
    }

    public TagReference createTagReference(String string) {
        return this.registerTagReference(new Tag(string));
    }

    public TagReference registerTagReference(Tag tag) {
        return this.registerTagReference(tag, false);
    }

    private TagReference registerTagReference(Tag tag, boolean setColor) {
        DefaultMutableTreeNode rootNode;
        int addedElementIndex = this.mapTags.addIfNotExists(tag);
        if (addedElementIndex < 0) {
            String content;
            List<TagReference> references;
            TagReference tagReference;
            Tag oldTag = this.mapTags.getElementAt(-addedElementIndex - 1);
            if (setColor) {
                oldTag.setColor(tag.getColor());
            }
            if ((tagReference = (references = this.tagReferences.get(content = oldTag.getContent())).get(0)).getTag() == oldTag) {
                return tagReference;
            }
            return new TagReference(oldTag);
        }
        String fullContent = tag.getContent();
        DefaultMutableTreeNode currentNode = rootNode = this.getRootNode();
        int start = 0;
        int end = fullContent.indexOf(this.categorySeparator);
        while (true) {
            block10: {
                block7: {
                    Tag qualifiedTag;
                    block8: {
                        block9: {
                            DefaultMutableTreeNode childNode;
                            boolean found = false;
                            String qualifiedContent = end >= 0 ? fullContent.substring(0, end) : fullContent;
                            Enumeration<TreeNode> children = currentNode.children();
                            while (children.hasMoreElements() && this.containsTag(childNode = (DefaultMutableTreeNode)children.nextElement())) {
                                String childTagContent = this.categorizedContent(childNode);
                                if (!childTagContent.equals(qualifiedContent)) continue;
                                if (tag.getContent().equals(childTagContent)) {
                                    this.addNewTagReference(tag);
                                }
                                currentNode = childNode;
                                found = true;
                                break;
                            }
                            if (found) break block7;
                            Tag prototype = new Tag(qualifiedContent);
                            qualifiedTag = setColor && qualifiedContent == fullContent ? tag : this.mapTags.getElement(prototype).orElse(prototype);
                            this.mapTags.addIfNotExists(qualifiedTag);
                            if (!currentNode.isRoot()) break block8;
                            if (!fullContent.contains(this.categorySeparator)) break block9;
                            DefaultMutableTreeNode uncategorizedTagNode = this.removeUncategorizedTagNode(qualifiedTag);
                            if (uncategorizedTagNode == null) break block8;
                            this.insertNode(currentNode, currentNode.getChildCount() - 1, uncategorizedTagNode);
                            currentNode = uncategorizedTagNode;
                            break block10;
                        }
                        this.insertUncategorizedTagNodeSorted(tag);
                        currentNode = this.uncategorizedTagsNode;
                    }
                    if (currentNode != this.uncategorizedTagsNode) {
                        Tag tagWithoutCategories = qualifiedTag.withoutCategories(this.categorySeparator);
                        qualifiedTag.setAlternativeTag(tagWithoutCategories);
                        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(tagWithoutCategories);
                        this.insertNode(currentNode, currentNode.isRoot() ? currentNode.getChildCount() - 1 : currentNode.getChildCount(), newNode);
                        currentNode = newNode;
                        this.categoriesChanged = true;
                    }
                    this.addNewTagReference(qualifiedTag);
                }
                if (end < 0) break;
            }
            start = end + this.categorySeparator.length();
            end = fullContent.indexOf(this.categorySeparator, start);
        }
        List<TagReference> references = this.tagReferences.get(fullContent);
        return references.get(0);
    }

    public Tag setTagColor(String tagContent, String tagColor) {
        return this.setTagColor(tagContent, TagCategories.tagColor(tagContent, tagColor));
    }

    public static Color tagColor(String tagContent, String tagColor) {
        return Optional.ofNullable(tagColor).map(ColorUtils::stringToColor).orElseGet(() -> Tag.getDefaultColor(tagContent));
    }

    public Tag setTagColor(String tagContent, Color color) {
        Tag tag = this.registerTagReference(new Tag(tagContent, color), true).getTag();
        return tag;
    }

    public Optional<Tag> getTag(Tag required) {
        return this.mapTags.getElement(required);
    }

    public boolean contains(String tagContent) {
        return this.mapTags.contains((Object)new Tag(tagContent, Color.BLACK));
    }

    public Color getTagColor(Tag required) {
        return this.getTag(required).get().getColor();
    }

    public Tag registerTag(String spec) {
        int colorIndex = spec.length() - 9;
        if (colorIndex > 0 && spec.charAt(colorIndex) == '#') {
            String content = spec.substring(0, colorIndex);
            String colorSpec = spec.substring(colorIndex);
            try {
                return this.setTagColor(content, colorSpec);
            }
            catch (NumberFormatException e) {
                LogUtils.severe(e);
            }
        }
        return this.createTagReference(spec).getTag();
    }

    public Tag registerTag(Tag tag) {
        return this.registerTagReference(tag).getTag();
    }

    public TagCategories copy() {
        TagCategories tagCategories = new TagCategories(this);
        return tagCategories;
    }

    private DefaultMutableTreeNode copySubtree(DefaultMutableTreeNode node) {
        Object tagCopy = this.copyTag(node);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(tagCopy);
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            newNode.add(this.copySubtree(child));
        }
        return newNode;
    }

    private Object copyTag(DefaultMutableTreeNode node) {
        if (this.containsTag(node)) {
            Tag copy = this.tagWithoutCategories(node).copy();
            String categorizedContent = this.categorizedContent(node);
            Tag categorizedTag = new Tag(categorizedContent, copy.getColor());
            categorizedTag.setAlternativeTag(copy);
            this.mapTags.add(categorizedTag);
            return copy;
        }
        return node.getUserObject();
    }

    public boolean areCategoriesChanged() {
        return this.categoriesChanged;
    }

    public void fireNodeChanged(DefaultMutableTreeNode node) {
        this.nodes.nodeChanged(node);
    }

    public void replaceReferencedTags(List<String> replacements) {
        Set<String> keptTags = this.collectCategorizedTags();
        for (int i = 0; i < replacements.size(); i += 2) {
            String categoryKey;
            String toTag;
            String fromTag = replacements.get(i);
            if (fromTag.isEmpty() || fromTag.equals(toTag = replacements.get(i + 1))) continue;
            this.replaceReferencedTags(fromTag, toTag, keptTags);
            String fromCategory = fromTag + this.categorySeparator;
            String from = categoryKey = this.tagReferences.ceilingKey(fromCategory);
            while (from != null && from.startsWith(fromCategory)) {
                String to = toTag.equals(UNCATEGORIZED_NODE) || toTag.isEmpty() ? toTag : toTag + from.substring(fromTag.length());
                this.replaceReferencedTags(from, to, keptTags);
                from = this.tagReferences.higherKey(from);
            }
        }
    }

    private Set<String> collectCategorizedTags() {
        HashSet<String> categorizedTags = new HashSet<String>();
        Enumeration<TreeNode> preorderEnumeration = this.getRootNode().preorderEnumeration();
        preorderEnumeration.nextElement();
        TreeNode node = preorderEnumeration.nextElement();
        while (node != this.uncategorizedTagsNode) {
            categorizedTags.add(this.categorizedContent((DefaultMutableTreeNode)node));
            node = preorderEnumeration.nextElement();
        }
        return categorizedTags;
    }

    private void replaceReferencedTags(String from, String to, Set<String> keptTags) {
        boolean keepsTag;
        List<TagReference> replacedTagReferences;
        if ((to.equals(UNCATEGORIZED_NODE) || to.isEmpty()) && keptTags.contains(from)) {
            return;
        }
        if (to.equals(UNCATEGORIZED_NODE)) {
            int lastSeparatorIndex = from.lastIndexOf(this.categorySeparator);
            if (lastSeparatorIndex >= 0) {
                to = from.substring(lastSeparatorIndex + this.categorySeparator.length());
            } else {
                return;
            }
        }
        List<TagReference> list = replacedTagReferences = (keepsTag = keptTags.contains(from)) ? this.tagReferences.get(from) : this.tagReferences.remove(from);
        if (keepsTag) {
            this.tagReferences.put(from, new ArrayList());
        } else {
            this.mapTags.remove((Object)new Tag(from, Color.BLACK));
        }
        List list2 = this.tagReferences.computeIfAbsent(to, key -> new ArrayList());
        if (replacedTagReferences != null && !from.isEmpty()) {
            list2.addAll(replacedTagReferences);
        }
    }

    public void updateTagReferences() {
        this.tagReferences.values().stream().flatMap(Collection::stream).map(TagReference::getTag).filter(tag -> !this.tagReferences.containsKey(tag.getContent())).forEach(this.mapTags::remove);
        this.tagReferences.getOrDefault("", Collections.emptyList()).forEach(tagReference -> tagReference.setTag(Tag.REMOVED_TAG));
        this.updateTagReferences(this.getRootNode());
    }

    private void updateTagReferences(DefaultMutableTreeNode node) {
        if (this.containsTag(node)) {
            Tag tagWithoutCategories = this.tagWithoutCategories(node);
            String categorizedContent = this.categorizedContent(node);
            Tag categorizedTag = new Tag(categorizedContent, tagWithoutCategories.getColor());
            categorizedTag.setAlternativeTag(tagWithoutCategories);
            Tag savedTag = this.mapTags.addAndReturn(categorizedTag);
            this.tagReferences.getOrDefault(categorizedContent, Collections.emptyList()).forEach(tagReference -> tagReference.setTag(savedTag));
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.updateTagReferences((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    public String categorizedContent(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof Tag)) {
            return "";
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        Tag tagWithoutCategories = (Tag)userObject;
        if (!this.containsTag(parent)) {
            return tagWithoutCategories.getContent();
        }
        return this.categorizedContent(parent) + this.categorySeparator + tagWithoutCategories.getContent();
    }

    public Tag categorizedTag(DefaultMutableTreeNode node) {
        Tag tagWithoutCategories = this.tagWithoutCategories(node);
        if (tagWithoutCategories.isEmpty()) {
            return tagWithoutCategories;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (!this.containsTag(parent)) {
            return tagWithoutCategories;
        }
        Tag tag = this.createTag(this.categorizedContent(parent) + this.categorySeparator + tagWithoutCategories.getContent());
        tag.setAlternativeTag(tagWithoutCategories);
        return tag;
    }

    public Tag tagWithoutCategories(DefaultMutableTreeNode node) {
        if (node == null) {
            return NOT_A_TAG;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof Tag) {
            return (Tag)userObject;
        }
        return NOT_A_TAG;
    }

    public boolean containsTag(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        Object userObject = node.getUserObject();
        return userObject instanceof Tag;
    }

    public List<Tag> getUncategorizedTags() {
        int tagCount = this.uncategorizedTagsNode.getChildCount();
        ArrayList<Tag> tags = new ArrayList<Tag>(tagCount);
        for (int i = 0; i < tagCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.uncategorizedTagsNode.getChildAt(i);
            tags.add(this.categorizedTag(child));
        }
        return tags;
    }

    public void registerTagReferenceIfUnknown(Tag tag) {
        if (!this.tagReferences.containsKey(tag.getContent())) {
            this.registerTagReference(tag);
        }
    }

    SortedSet<Tag> referencedTags() {
        return this.tagReferences.values().stream().flatMap(Collection::stream).map(TagReference::getTag).collect(Collectors.toCollection(TreeSet::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode merge(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode keptNode;
        boolean mergeWasRunning = this.mergeIsRunning;
        this.mergeIsRunning = true;
        try {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            DefaultMutableTreeNode mergeParent = parent == this.getUncategorizedTagsNode() ? this.getRootNode() : parent;
            keptNode = this.merge(node, null, mergeParent);
            if (mergeParent.isRoot()) {
                keptNode = this.merge(node, keptNode, this.getUncategorizedTagsNode());
            }
        }
        finally {
            this.mergeIsRunning = mergeWasRunning;
        }
        return keptNode;
    }

    private DefaultMutableTreeNode merge(DefaultMutableTreeNode node, DefaultMutableTreeNode keptNode, DefaultMutableTreeNode parent) {
        DefaultTreeModel nodes = this.getNodes();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode removedNode;
            DefaultMutableTreeNode sibling = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (sibling == node || !sibling.getUserObject().equals(node.getUserObject())) continue;
            if (keptNode != null) {
                removedNode = sibling;
            } else {
                if (node.getParent() != parent) {
                    return sibling;
                }
                keptNode = sibling;
                removedNode = node;
            }
            while (!removedNode.isLeaf()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                nodes.removeNodeFromParent(child);
                nodes.insertNodeInto(child, keptNode, keptNode.getChildCount());
                this.merge(child);
            }
            nodes.removeNodeFromParent(removedNode);
            break;
        }
        return keptNode;
    }

    public boolean isMergeRunning() {
        return this.mergeIsRunning;
    }

    private class TagCategoryTree
    extends DefaultTreeModel {
        private TagCategoryTree(TreeNode root) {
            super(root);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Tag oldValue = TagCategories.this.categorizedTag(node);
            Tag tag = (Tag)newValue;
            if (node.getParent() == TagCategories.this.uncategorizedTagsNode) {
                TagCategories.this.removeUncategorizedTagNode(oldValue);
                if (TagCategories.this.mapTags.addIfNotExists(tag) >= 0) {
                    TagCategories.this.addNewTagReference(tag);
                }
                node.setUserObject(tag);
                TagCategories.this.insertUncategorizedTagNodeSorted(node);
            } else {
                for (TreeModelListener listener : this.getTreeModelListeners()) {
                    if (!(listener instanceof TreeTagChangeListener)) continue;
                    ((TreeTagChangeListener)((Object)listener)).valueForPathChanged(path, tag);
                }
                super.valueForPathChanged(path, tag);
            }
        }

        @Override
        public void nodeChanged(TreeNode node) {
            Tag tagWithoutCategories = TagCategories.this.tagWithoutCategories((DefaultMutableTreeNode)node);
            String categorizedContent = TagCategories.this.categorizedContent((DefaultMutableTreeNode)node);
            Tag categorizedTag = new Tag(categorizedContent, tagWithoutCategories.getColor());
            if (TagCategories.this.mapTags.addIfNotExists(categorizedTag) >= 0) {
                TagCategories.this.addNewTagReference(categorizedTag);
            }
            super.nodeChanged(node);
        }
    }
}

