/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.factory;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.menubuilders.XmlEntryStructureBuilder;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.RecursiveMenuStructureProcessor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.EmojiIcon;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.UserIcon;

public class IconStoreFactory {
    private static final String USER_GROUP_ICON = "user_icon";
    private static final String USER_ICON_GROUP_NAME = "user";
    public static final String SEPARATOR = ";";
    private static final ResourceController RESOURCE_CONTROLLER = ResourceController.getResourceController();
    private static final String GROUP_NAMES_KEY = "icons.groups";
    private static final String STATE_ICON_NAMES_KEY = "icons.state";
    private static final String GROUP_KEY = "icons.group.%s";
    private static final String GROUPS_KEY = "icons.groups.%s";
    private static final String GROUP_ICON_KEY = "IconGroupPopupAction.%s.icon";
    private static final String GROUP_DESC_KEY = "IconGroupPopupAction.%s.text";
    private static final Pattern iconFileNamePattern = Pattern.compile(".*\\.(svg|png)$", 2);
    private static final String EMOJI_ENTRIES_RESOURCE = "/images/emoji/xml/emojientries.xml";
    public static final IconStoreFactory INSTANCE = new IconStoreFactory();
    public static IconStore ICON_STORE = INSTANCE.createIcons();
    private int order = 0;
    private final IconStore iconStore = new IconStore();

    private IconStoreFactory() {
    }

    private MindIcon createMindIcon(String name) {
        String translationKeyLabel = name.indexOf(47) > 0 ? "" : "icon_" + name;
        MindIcon mindIcon = new MindIcon(name, name + ".svg", translationKeyLabel, this.order++);
        mindIcon.initializeUrl();
        return mindIcon;
    }

    private IconStore createIcons() {
        this.createClassicIcons();
        this.createEmojiIcons();
        this.createStateIcons();
        return this.iconStore;
    }

    private void createEmojiIcons() {
        RecursiveMenuStructureProcessor actionBuilder = new RecursiveMenuStructureProcessor();
        EmojiGroupBuilder defaultBuilder = new EmojiGroupBuilder();
        actionBuilder.setDefaultBuilder(defaultBuilder);
        try {
            InputStream resource = ResourceController.getResourceController().getResourceStream(EMOJI_ENTRIES_RESOURCE);
            InputStreamReader reader = new InputStreamReader(resource, StandardCharsets.UTF_8);
            Entry emojiGroupEntry = XmlEntryStructureBuilder.buildMenuStructure(reader);
            emojiGroupEntry.setName("emoji_group");
            emojiGroupEntry.setAttribute("emoji", (Object)"\ud83d\udcd9");
            emojiGroupEntry.setAttribute("file", (Object)"1f4d9.svg");
            emojiGroupEntry.setAttribute("description", (Object)TextUtils.getText("emoji_collection"));
            actionBuilder.build(emojiGroupEntry);
            this.iconStore.addGroup(emojiGroupEntry.getAttribute(IconGroup.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createStateIcons() {
        String[] stateIconNames;
        for (String name : stateIconNames = RESOURCE_CONTROLLER.getProperty(STATE_ICON_NAMES_KEY).split(SEPARATOR)) {
            String file = RESOURCE_CONTROLLER.getProperty("stateIcon." + name, name);
            this.createStateIcon(name, file);
        }
    }

    public void createStateIcon(String name, String file) {
        UIIcon icon = new UIIcon(name, file, this.order++);
        this.iconStore.addUIIcon(icon);
    }

    private void createClassicIcons() {
        String[] groupNames = RESOURCE_CONTROLLER.getProperty(GROUP_NAMES_KEY).split(SEPARATOR);
        IconGroup userIcons = this.getUserIcons();
        for (String groupName : groupNames) {
            if (USER_ICON_GROUP_NAME.equals(groupName)) {
                this.iconStore.addGroup(userIcons);
                continue;
            }
            this.iconStore.addGroup(this.getBuiltinIconGroups(groupName));
        }
        userIcons.addGroups(this.loadUserIcons());
        this.iconStore.addIcons(userIcons);
    }

    private IconGroup getBuiltinIconGroups(String groupName) {
        List<MindIcon> icons = this.getBuiltinIcons(groupName);
        List<IconGroup> groups = this.getBuiltinGroups(groupName);
        String description = this.createDescription(groupName);
        MindIcon groupIcon = this.findGroupIcon(icons, groups, groupName);
        IconGroup iconGroup = new IconGroup(groupName, groupIcon, description);
        iconGroup.addIcons(icons);
        iconGroup.addGroups(groups);
        return iconGroup;
    }

    private String createDescription(String groupName) {
        String translatedDescription = TextUtils.getText(String.format(GROUP_DESC_KEY, groupName), "");
        if (translatedDescription.isEmpty()) {
            String x = groupName.replaceFirst(".*\\.", "");
            return TextUtils.capitalize(x);
        }
        return translatedDescription;
    }

    private MindIcon findGroupIcon(List<MindIcon> icons, List<IconGroup> groups, String groupName) {
        String key = String.format(GROUP_ICON_KEY, groupName);
        String groupIconName = RESOURCE_CONTROLLER.getProperty(key);
        MindIcon groupIcon = null;
        if (groupIconName != null) {
            groupIcon = icons.stream().filter(icon -> groupIconName.equals(icon.getName())).findAny().orElseGet(() -> groups.stream().filter(group -> groupIconName.equals(group.getName())).map(IconGroup::getGroupIcon).findAny().orElse(null));
        }
        return groupIcon;
    }

    private List<IconGroup> getBuiltinGroups(String groupName) {
        String key = String.format(GROUPS_KEY, groupName);
        String[] groupNames = RESOURCE_CONTROLLER.getArrayProperty(key, SEPARATOR);
        ArrayList<IconGroup> groups = new ArrayList<IconGroup>(groupNames.length);
        for (String subGroupName : groupNames) {
            IconGroup subGroup = this.getBuiltinIconGroups(subGroupName);
            groups.add(subGroup);
        }
        return groups;
    }

    private List<MindIcon> getBuiltinIcons(String groupName) {
        String key = String.format(GROUP_KEY, groupName);
        String[] iconNames = RESOURCE_CONTROLLER.getArrayProperty(key, SEPARATOR);
        ArrayList<MindIcon> icons = new ArrayList<MindIcon>(iconNames.length);
        for (String iconName : iconNames) {
            MindIcon icon = this.createMindIcon(iconName);
            icons.add(icon);
        }
        return icons;
    }

    private IconGroup getUserIcons() {
        MindIcon groupIcon = this.createMindIcon(USER_GROUP_ICON);
        String description = TextUtils.getText(String.format(GROUP_DESC_KEY, USER_ICON_GROUP_NAME));
        return new IconGroup(USER_ICON_GROUP_NAME, groupIcon, description);
    }

    private List<IconGroup> loadUserIcons() {
        List<IconGroup> icons;
        if (RESOURCE_CONTROLLER.isApplet()) {
            icons = Collections.emptyList();
        } else {
            File iconDir = new File(RESOURCE_CONTROLLER.getFreeplaneUserDirectory(), "icons");
            if (!iconDir.exists()) {
                LogUtils.info("creating user icons directory " + iconDir);
                iconDir.mkdirs();
                icons = Collections.emptyList();
            } else {
                icons = this.getUserIconsFromDirectory(iconDir, "");
            }
        }
        return icons;
    }

    private List<IconGroup> getUserIconsFromDirectory(File iconDir, String dir) {
        String fullName;
        String[] userIconArray = iconDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return IconStoreFactory.this.hasValidIconFileExtension(name) || new File(dir, name).isDirectory();
            }
        });
        Arrays.sort(userIconArray, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return IconStoreFactory.this.getIconFileNameWithoutExtension(o1).compareTo(IconStoreFactory.this.getIconFileNameWithoutExtension(o2));
            }
        });
        if (userIconArray == null) {
            return Collections.emptyList();
        }
        ArrayList<IconGroup> icons = new ArrayList<IconGroup>(userIconArray.length);
        for (String fileName : userIconArray) {
            List<IconGroup> childUserIcons;
            File childDir = new File(iconDir, fileName);
            if (!childDir.isDirectory() || (childUserIcons = this.getUserIconsFromDirectory(childDir, (fullName = dir + fileName) + '/')).isEmpty()) continue;
            IconGroup firstGroupIcon = childUserIcons.get(0);
            icons.add(new IconGroup(fileName, firstGroupIcon.getGroupIcon(), fileName, childUserIcons));
        }
        for (String fileName : userIconArray) {
            File userIconFile = new File(iconDir, fileName);
            fullName = dir + fileName;
            if (userIconFile.isDirectory()) continue;
            String iconName = fullName.substring(0, fullName.length() - 4);
            String iconDescription = fileName.substring(0, fileName.length() - 4);
            if (iconName.equals("")) continue;
            if (this.iconStore.containsMindIcon(iconName)) {
                this.iconStore.getMindIcon(iconName).useUserIcon(userIconFile);
                continue;
            }
            UserIcon icon = new UserIcon(iconName, fullName, iconDescription, this.order++);
            icons.add(new IconGroup(icon));
        }
        return icons;
    }

    private boolean hasValidIconFileExtension(String name) {
        return iconFileNamePattern.matcher(name).matches();
    }

    private String getIconFileNameWithoutExtension(String fileNameWithExtension) {
        return this.hasValidIconFileExtension(fileNameWithExtension) ? fileNameWithExtension.substring(0, fileNameWithExtension.length() - 4) : fileNameWithExtension;
    }

    class EmojiGroupBuilder
    implements EntryVisitor {
        EmojiGroupBuilder() {
        }

        @Override
        public void visit(Entry entry) {
            String emoji = (String)entry.getAttribute("emoji");
            String file = (String)entry.getAttribute("file");
            String entity = entry.isLeaf() ? (String)entry.getAttribute("entity") : "";
            String description = (String)entry.getAttribute("description");
            EmojiIcon emojiIcon = new EmojiIcon(emoji, entity, file, description, IconStoreFactory.this.order++);
            String name = entry.getName();
            IconGroup entryGroup = name.isEmpty() ? new IconGroup(emojiIcon) : new IconGroup(name, emojiIcon);
            entry.setAttribute(IconGroup.class, (Object)entryGroup);
            Entry parent = entry.getParent();
            if (parent != null) {
                IconGroup parentGroup = parent.getAttribute(IconGroup.class);
                parentGroup.addGroup(entryGroup);
            }
        }

        @Override
        public boolean shouldSkipChildren(Entry entry) {
            return false;
        }
    }
}

