/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.AllDependenciesCondition;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.PredicateAggregator;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class Architectures {
    private Architectures() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static LayeredArchitecture.DependencySettings layeredArchitecture() {
        return new LayeredArchitecture.DependencySettings();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static OnionArchitecture onionArchitecture() {
        return new OnionArchitecture();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class LayeredArchitecture
    implements ArchRule {
        private final LayerDefinitions layerDefinitions;
        private final Set<LayerDependencySpecification> dependencySpecifications;
        private final DependencySettings dependencySettings;
        private final PredicateAggregator<Dependency> irrelevantDependenciesPredicate;
        private final Optional<String> overriddenDescription;
        private final boolean optionalLayers;
        private final AllClassesAreContainedInArchitectureCheck allClassesAreContainedInArchitectureCheck;

        private LayeredArchitecture(DependencySettings dependencySettings) {
            this(new LayerDefinitions(), new LinkedHashSet<LayerDependencySpecification>(), dependencySettings, new PredicateAggregator().thatORs(), Optional.empty(), false, new AllClassesAreContainedInArchitectureCheck.Disabled());
        }

        private LayeredArchitecture(LayerDefinitions layerDefinitions, Set<LayerDependencySpecification> dependencySpecifications, DependencySettings dependencySettings, PredicateAggregator<Dependency> irrelevantDependenciesPredicate, Optional<String> overriddenDescription, boolean optionalLayers, AllClassesAreContainedInArchitectureCheck allClassesAreContainedInArchitectureCheck) {
            this.layerDefinitions = layerDefinitions;
            this.dependencySpecifications = dependencySpecifications;
            this.dependencySettings = dependencySettings;
            this.irrelevantDependenciesPredicate = irrelevantDependenciesPredicate;
            this.overriddenDescription = overriddenDescription;
            this.optionalLayers = optionalLayers;
            this.allClassesAreContainedInArchitectureCheck = allClassesAreContainedInArchitectureCheck;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture withOptionalLayers(boolean optionalLayers) {
            return new LayeredArchitecture(this.layerDefinitions, this.dependencySpecifications, this.dependencySettings, this.irrelevantDependenciesPredicate, this.overriddenDescription, optionalLayers, this.allClassesAreContainedInArchitectureCheck);
        }

        private LayeredArchitecture addLayerDefinition(LayerDefinition definition) {
            this.layerDefinitions.add(definition);
            return this;
        }

        private LayeredArchitecture addDependencySpecification(LayerDependencySpecification dependencySpecification) {
            this.dependencySpecifications.add(dependencySpecification);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayerDefinition layer(String name) {
            return new LayerDefinition(name, false);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayerDefinition optionalLayer(String name) {
            return new LayerDefinition(name, true);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public String getDescription() {
            if (this.overriddenDescription.isPresent()) {
                return this.overriddenDescription.get();
            }
            String prefix = "Layered architecture " + this.dependencySettings.description;
            ArrayList<String> lines = Lists.newArrayList(prefix + ", consisting of" + (this.optionalLayers ? " (optional)" : ""));
            for (LayerDefinition definition : this.layerDefinitions) {
                lines.add(definition.toString());
            }
            for (LayerDependencySpecification specification : this.dependencySpecifications) {
                lines.add(specification.toString());
            }
            return Joiner.on(System.lineSeparator()).join(lines);
        }

        public String toString() {
            return this.getDescription();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public EvaluationResult evaluate(JavaClasses classes) {
            EvaluationResult result = new EvaluationResult(this, Priority.MEDIUM);
            this.checkEmptyLayers(classes, result);
            this.allClassesAreContainedInArchitectureCheck.evaluate(classes, this.layerDefinitions).ifPresent(result::add);
            for (LayerDependencySpecification specification : this.dependencySpecifications) {
                result.add(this.evaluateDependenciesShouldBeSatisfied(classes, specification));
            }
            return result;
        }

        private void checkEmptyLayers(JavaClasses classes, EvaluationResult result) {
            if (!this.optionalLayers) {
                for (LayerDefinition layerDefinition : this.layerDefinitions) {
                    if (layerDefinition.isOptional()) continue;
                    result.add(this.evaluateLayersShouldNotBeEmpty(classes, layerDefinition));
                }
            }
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ensureAllClassesAreContainedInArchitecture() {
            return this.ensureAllClassesAreContainedInArchitectureIgnoring(DescribedPredicate.alwaysFalse());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ensureAllClassesAreContainedInArchitectureIgnoring(String ... packageIdentifiers) {
            return this.ensureAllClassesAreContainedInArchitectureIgnoring(JavaClass.Predicates.resideInAnyPackage(packageIdentifiers).as(Formatters.joinSingleQuoted(packageIdentifiers), new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ensureAllClassesAreContainedInArchitectureIgnoring(DescribedPredicate<? super JavaClass> predicate) {
            return new LayeredArchitecture(this.layerDefinitions, this.dependencySpecifications, this.dependencySettings, this.irrelevantDependenciesPredicate, this.overriddenDescription, this.optionalLayers, new AllClassesAreContainedInArchitectureCheck.Enabled(predicate));
        }

        private EvaluationResult evaluateLayersShouldNotBeEmpty(JavaClasses classes, LayerDefinition layerDefinition) {
            return ArchRuleDefinition.classes().that(this.layerDefinitions.containsPredicateFor(layerDefinition.name)).should(LayeredArchitecture.notBeEmptyFor(layerDefinition)).allowEmptyShould(true).evaluate(classes);
        }

        private EvaluationResult evaluateDependenciesShouldBeSatisfied(JavaClasses classes, LayerDependencySpecification specification) {
            AllDependenciesCondition satisfyLayerDependenciesCondition = specification.constraint == LayerDependencyConstraint.ORIGIN ? ArchConditions.onlyHaveDependentsWhere(this.originMatchesIfDependencyIsRelevant(specification.layerName, specification.allowedLayers)) : ArchConditions.onlyHaveDependenciesWhere(this.targetMatchesIfDependencyIsRelevant(specification.layerName, specification.allowedLayers));
            return ArchRuleDefinition.classes().that(this.layerDefinitions.containsPredicateFor(specification.layerName)).should((ArchCondition)satisfyLayerDependenciesCondition).allowEmptyShould(true).evaluate(classes);
        }

        private DescribedPredicate<Dependency> originMatchesIfDependencyIsRelevant(String ownLayer, Set<String> allowedAccessors) {
            DescribedPredicate<Dependency> originPackageMatches = Dependency.Predicates.dependencyOrigin(this.layerDefinitions.containsPredicateFor(allowedAccessors)).or(Dependency.Predicates.dependencyOrigin(this.layerDefinitions.containsPredicateFor(ownLayer)));
            return this.ifDependencyIsRelevant(originPackageMatches);
        }

        private DescribedPredicate<Dependency> targetMatchesIfDependencyIsRelevant(String ownLayer, Set<String> allowedTargets) {
            DescribedPredicate<Dependency> targetPackageMatches = Dependency.Predicates.dependencyTarget(this.layerDefinitions.containsPredicateFor(allowedTargets)).or(Dependency.Predicates.dependencyTarget(this.layerDefinitions.containsPredicateFor(ownLayer)));
            return this.ifDependencyIsRelevant(targetPackageMatches);
        }

        private DescribedPredicate<Dependency> ifDependencyIsRelevant(DescribedPredicate<Dependency> predicate) {
            DescribedPredicate<Dependency> configuredPredicate = this.dependencySettings.ignoreExcludedDependencies.apply(this.layerDefinitions, predicate);
            return this.irrelevantDependenciesPredicate.map(configuredPredicate::or).orElse(configuredPredicate);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public void check(JavaClasses classes) {
            ArchRule.Assertions.check(this, classes);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ArchRule because(String reason) {
            return ArchRule.Factory.withBecause(this, reason);
        }

        @Override
        public ArchRule allowEmptyShould(boolean allowEmptyShould) {
            return this.withOptionalLayers(allowEmptyShould);
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture as(String newDescription) {
            return new LayeredArchitecture(this.layerDefinitions, this.dependencySpecifications, this.dependencySettings, this.irrelevantDependenciesPredicate, Optional.of(newDescription), this.optionalLayers, this.allClassesAreContainedInArchitectureCheck);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ignoreDependency(Class<?> origin, Class<?> target) {
            return this.ignoreDependency(JavaClass.Predicates.equivalentTo(origin), JavaClass.Predicates.equivalentTo(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ignoreDependency(String originFullyQualifiedClassName, String targetFullyQualifiedClassName) {
            return this.ignoreDependency(HasName.Predicates.name(originFullyQualifiedClassName), HasName.Predicates.name(targetFullyQualifiedClassName));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayeredArchitecture ignoreDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
            return new LayeredArchitecture(this.layerDefinitions, this.dependencySpecifications, this.dependencySettings, this.irrelevantDependenciesPredicate.add(Dependency.Predicates.dependency(origin, target)), this.overriddenDescription, this.optionalLayers, this.allClassesAreContainedInArchitectureCheck);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public LayerDependencySpecification whereLayer(String name) {
            this.checkLayerNamesExist(name);
            return new LayerDependencySpecification(name);
        }

        private void checkLayerNamesExist(String ... layerNames) {
            for (String layerName : layerNames) {
                Preconditions.checkArgument(this.layerDefinitions.containLayer(layerName), "There is no layer named '%s'", (Object)layerName);
            }
        }

        private static ArchCondition<JavaClass> notBeEmptyFor(LayerDefinition layerDefinition) {
            return new LayerShouldNotBeEmptyCondition(layerDefinition);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final class DependencySettings {
            final String description;
            final BiFunction<LayerDefinitions, DescribedPredicate<Dependency>, DescribedPredicate<Dependency>> ignoreExcludedDependencies;

            private DependencySettings() {
                this(null, null);
            }

            private DependencySettings(String description, BiFunction<LayerDefinitions, DescribedPredicate<Dependency>, DescribedPredicate<Dependency>> ignoreExcludedDependencies) {
                this.description = description;
                this.ignoreExcludedDependencies = ignoreExcludedDependencies;
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture consideringAllDependencies() {
                return new LayeredArchitecture(this.setToConsideringAllDependencies());
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture consideringOnlyDependenciesInAnyPackage(String packageIdentifier, String ... furtherPackageIdentifiers) {
                String[] packageIdentifiers = (String[])Stream.concat(Stream.of(packageIdentifier), Stream.of(furtherPackageIdentifiers)).toArray(String[]::new);
                return new LayeredArchitecture(this.setToConsideringOnlyDependenciesInAnyPackage(packageIdentifiers));
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture consideringOnlyDependenciesInLayers() {
                return new LayeredArchitecture(this.setToConsideringOnlyDependenciesInLayers());
            }

            private DependencySettings setToConsideringAllDependencies() {
                return new DependencySettings("considering all dependencies", (__, predicate) -> predicate);
            }

            private DependencySettings setToConsideringOnlyDependenciesInAnyPackage(String[] packageIdentifiers) {
                DescribedPredicate<JavaClass> outsideOfRelevantPackage = JavaClass.Predicates.resideOutsideOfPackages(packageIdentifiers);
                return new DependencySettings(String.format("considering only dependencies in any package [%s]", Formatters.joinSingleQuoted(packageIdentifiers)), (__, predicate) -> predicate.or(this.originOrTargetIs(outsideOfRelevantPackage)));
            }

            private DependencySettings setToConsideringOnlyDependenciesInLayers() {
                return new DependencySettings("considering only dependencies in layers", (layerDefinitions, predicate) -> {
                    DescribedPredicate<JavaClass> notInLayers = DescribedPredicate.not(layerDefinitions.containsPredicateForAll());
                    return predicate.or(this.originOrTargetIs(notInLayers));
                });
            }

            private DescribedPredicate<Dependency> originOrTargetIs(DescribedPredicate<JavaClass> predicate) {
                return Dependency.Functions.GET_ORIGIN_CLASS.is(predicate).or(Dependency.Functions.GET_TARGET_CLASS.is(predicate));
            }
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public final class LayerDependencySpecification {
            private final String layerName;
            private final Set<String> allowedLayers = new LinkedHashSet<String>();
            private LayerDependencyConstraint constraint;
            private String descriptionSuffix;

            private LayerDependencySpecification(String layerName) {
                this.layerName = layerName;
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture mayNotBeAccessedByAnyLayer() {
                return this.denyLayerAccess(LayerDependencyConstraint.ORIGIN, "may not be accessed by any layer");
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture mayOnlyBeAccessedByLayers(String ... layerNames) {
                return this.restrictLayers(LayerDependencyConstraint.ORIGIN, layerNames, "may only be accessed by layers [%s]");
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture mayNotAccessAnyLayer() {
                return this.denyLayerAccess(LayerDependencyConstraint.TARGET, "may not access any layer");
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture mayOnlyAccessLayers(String ... layerNames) {
                return this.restrictLayers(LayerDependencyConstraint.TARGET, layerNames, "may only access layers [%s]");
            }

            private LayeredArchitecture denyLayerAccess(LayerDependencyConstraint constraint, String description) {
                this.allowedLayers.clear();
                this.constraint = constraint;
                this.descriptionSuffix = description;
                return LayeredArchitecture.this.addDependencySpecification(this);
            }

            private LayeredArchitecture restrictLayers(LayerDependencyConstraint constraint, String[] layerNames, String descriptionTemplate) {
                Preconditions.checkArgument(layerNames.length > 0, "At least 1 layer name must be provided.");
                LayeredArchitecture.this.checkLayerNamesExist(layerNames);
                this.allowedLayers.addAll(Arrays.asList(layerNames));
                this.constraint = constraint;
                this.descriptionSuffix = String.format(descriptionTemplate, Formatters.joinSingleQuoted(layerNames));
                return LayeredArchitecture.this.addDependencySpecification(this);
            }

            public String toString() {
                return String.format("where layer '%s' %s", this.layerName, this.descriptionSuffix);
            }
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public final class LayerDefinition {
            private final String name;
            private final boolean optional;
            private DescribedPredicate<JavaClass> containsPredicate;

            private LayerDefinition(String name, boolean optional) {
                Preconditions.checkState(!Strings.isNullOrEmpty(name), "Layer name must be present");
                this.name = name;
                this.optional = optional;
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture definedBy(DescribedPredicate<? super JavaClass> predicate) {
                Preconditions.checkNotNull(predicate, "Supplied predicate must not be null");
                this.containsPredicate = predicate.forSubtype();
                return LayeredArchitecture.this.addLayerDefinition(this);
            }

            @PublicAPI(usage=PublicAPI.Usage.ACCESS)
            public LayeredArchitecture definedBy(String ... packageIdentifiers) {
                return this.definedBy(JavaClass.Predicates.resideInAnyPackage(packageIdentifiers).as(Formatters.joinSingleQuoted(packageIdentifiers), new Object[0]));
            }

            boolean isOptional() {
                return this.optional;
            }

            DescribedPredicate<JavaClass> containsPredicate() {
                return this.containsPredicate;
            }

            public String toString() {
                return String.format("%slayer '%s' (%s)", this.optional ? "optional " : "", this.name, this.containsPredicate);
            }
        }

        private static final class LayerDefinitions
        implements Iterable<LayerDefinition> {
            private final Map<String, LayerDefinition> layerDefinitions = new LinkedHashMap<String, LayerDefinition>();

            private LayerDefinitions() {
            }

            void add(LayerDefinition definition) {
                this.layerDefinitions.put(definition.name, definition);
            }

            boolean containLayer(String layerName) {
                return this.layerDefinitions.containsKey(layerName);
            }

            DescribedPredicate<JavaClass> containsPredicateFor(String layerName) {
                return this.containsPredicateFor(Collections.singleton(layerName));
            }

            DescribedPredicate<JavaClass> containsPredicateForAll() {
                return this.containsPredicateFor(this.layerDefinitions.keySet());
            }

            DescribedPredicate<JavaClass> containsPredicateFor(Collection<String> layerNames) {
                DescribedPredicate<JavaClass> result = DescribedPredicate.alwaysFalse();
                for (LayerDefinition definition : this.get(layerNames)) {
                    result = result.or(definition.containsPredicate());
                }
                return result;
            }

            private Iterable<LayerDefinition> get(Collection<String> layerNames) {
                return layerNames.stream().map(this.layerDefinitions::get).collect(Collectors.toSet());
            }

            @Override
            public Iterator<LayerDefinition> iterator() {
                return this.layerDefinitions.values().iterator();
            }
        }

        private static abstract class AllClassesAreContainedInArchitectureCheck {
            private AllClassesAreContainedInArchitectureCheck() {
            }

            abstract Optional<EvaluationResult> evaluate(JavaClasses var1, LayerDefinitions var2);

            static class Disabled
            extends AllClassesAreContainedInArchitectureCheck {
                Disabled() {
                }

                @Override
                Optional<EvaluationResult> evaluate(JavaClasses classes, LayerDefinitions layerDefinitions) {
                    return Optional.empty();
                }
            }

            static class Enabled
            extends AllClassesAreContainedInArchitectureCheck {
                private final DescribedPredicate<? super JavaClass> ignorePredicate;

                private Enabled(DescribedPredicate<? super JavaClass> ignorePredicate) {
                    this.ignorePredicate = ignorePredicate;
                }

                @Override
                Optional<EvaluationResult> evaluate(JavaClasses classes, LayerDefinitions layerDefinitions) {
                    return Optional.of(ArchRuleDefinition.classes().should(this.beContainedInLayers(layerDefinitions)).evaluate(classes));
                }

                private ArchCondition<JavaClass> beContainedInLayers(LayerDefinitions layerDefinitions) {
                    final DescribedPredicate<JavaClass> classContainedInLayers = layerDefinitions.containsPredicateForAll();
                    return new ArchCondition<JavaClass>("be contained in architecture", new Object[0]){

                        @Override
                        public void check(JavaClass javaClass, ConditionEvents events) {
                            if (!ignorePredicate.test(javaClass) && !classContainedInLayers.test(javaClass)) {
                                events.add(SimpleConditionEvent.violated(javaClass, String.format("Class <%s> is not contained in architecture", javaClass.getName())));
                            }
                        }
                    };
                }
            }
        }

        private static enum LayerDependencyConstraint {
            ORIGIN,
            TARGET;

        }

        private static class LayerShouldNotBeEmptyCondition
        extends ArchCondition<JavaClass> {
            private final LayerDefinition layerDefinition;
            private boolean empty = true;

            LayerShouldNotBeEmptyCondition(LayerDefinition layerDefinition) {
                super("not be empty", new Object[0]);
                this.layerDefinition = layerDefinition;
            }

            @Override
            public void check(JavaClass item, ConditionEvents events) {
                this.empty = false;
            }

            @Override
            public void finish(ConditionEvents events) {
                if (this.empty) {
                    events.add(SimpleConditionEvent.violated(this.layerDefinition, String.format("Layer '%s' is empty", this.layerDefinition.name)));
                }
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class OnionArchitecture
    implements ArchRule {
        private static final String DOMAIN_MODEL_LAYER = "domain model";
        private static final String DOMAIN_SERVICE_LAYER = "domain service";
        private static final String APPLICATION_SERVICE_LAYER = "application service";
        private static final String ADAPTER_LAYER = "adapter";
        private final Optional<String> overriddenDescription;
        private Optional<DescribedPredicate<? super JavaClass>> domainModelPredicate = Optional.empty();
        private Optional<DescribedPredicate<? super JavaClass>> domainServicePredicate = Optional.empty();
        private Optional<DescribedPredicate<? super JavaClass>> applicationPredicate = Optional.empty();
        private Map<String, DescribedPredicate<? super JavaClass>> adapterPredicates = new LinkedHashMap<String, DescribedPredicate<? super JavaClass>>();
        private boolean optionalLayers = false;
        private List<IgnoredDependency> ignoredDependencies = new ArrayList<IgnoredDependency>();
        private AllClassesAreContainedInArchitectureCheck allClassesAreContainedInArchitectureCheck = new AllClassesAreContainedInArchitectureCheck.Disabled();

        private OnionArchitecture() {
            this.overriddenDescription = Optional.empty();
        }

        private OnionArchitecture(Optional<DescribedPredicate<? super JavaClass>> domainModelPredicate, Optional<DescribedPredicate<? super JavaClass>> domainServicePredicate, Optional<DescribedPredicate<? super JavaClass>> applicationPredicate, Map<String, DescribedPredicate<? super JavaClass>> adapterPredicates, boolean optionalLayers, List<IgnoredDependency> ignoredDependencies, Optional<String> overriddenDescription, AllClassesAreContainedInArchitectureCheck allClassesAreContainedInArchitectureCheck) {
            this.domainModelPredicate = domainModelPredicate;
            this.domainServicePredicate = domainServicePredicate;
            this.applicationPredicate = applicationPredicate;
            this.adapterPredicates = adapterPredicates;
            this.optionalLayers = optionalLayers;
            this.ignoredDependencies = ignoredDependencies;
            this.overriddenDescription = overriddenDescription;
            this.allClassesAreContainedInArchitectureCheck = allClassesAreContainedInArchitectureCheck;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture domainModels(String ... packageIdentifiers) {
            return this.domainModels(this.byPackagePredicate(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture domainModels(DescribedPredicate<? super JavaClass> predicate) {
            this.domainModelPredicate = Optional.of(predicate);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture domainServices(String ... packageIdentifiers) {
            return this.domainServices(this.byPackagePredicate(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture domainServices(DescribedPredicate<? super JavaClass> predicate) {
            this.domainServicePredicate = Optional.of(predicate);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture applicationServices(String ... packageIdentifiers) {
            return this.applicationServices(this.byPackagePredicate(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture applicationServices(DescribedPredicate<? super JavaClass> predicate) {
            this.applicationPredicate = Optional.of(predicate);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture adapter(String name, String ... packageIdentifiers) {
            return this.adapter(name, this.byPackagePredicate(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture adapter(String name, DescribedPredicate<? super JavaClass> predicate) {
            this.adapterPredicates.put(name, predicate);
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture withOptionalLayers(boolean optionalLayers) {
            this.optionalLayers = optionalLayers;
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ignoreDependency(Class<?> origin, Class<?> target) {
            return this.ignoreDependency(JavaClass.Predicates.equivalentTo(origin), JavaClass.Predicates.equivalentTo(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ignoreDependency(String origin, String target) {
            return this.ignoreDependency(HasName.Predicates.name(origin), HasName.Predicates.name(target));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ignoreDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
            this.ignoredDependencies.add(new IgnoredDependency(origin, target));
            return this;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ensureAllClassesAreContainedInArchitecture() {
            return this.ensureAllClassesAreContainedInArchitectureIgnoring(DescribedPredicate.alwaysFalse());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ensureAllClassesAreContainedInArchitectureIgnoring(String ... packageIdentifiers) {
            return this.ensureAllClassesAreContainedInArchitectureIgnoring(JavaClass.Predicates.resideInAnyPackage(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public OnionArchitecture ensureAllClassesAreContainedInArchitectureIgnoring(DescribedPredicate<? super JavaClass> predicate) {
            this.allClassesAreContainedInArchitectureCheck = new AllClassesAreContainedInArchitectureCheck.Enabled(predicate);
            return this;
        }

        private DescribedPredicate<JavaClass> byPackagePredicate(String[] packageIdentifiers) {
            return JavaClass.Predicates.resideInAnyPackage(packageIdentifiers).as(Formatters.joinSingleQuoted(packageIdentifiers), new Object[0]);
        }

        private LayeredArchitecture layeredArchitectureDelegate() {
            LayeredArchitecture layeredArchitectureDelegate = Architectures.layeredArchitecture().consideringAllDependencies().layer(DOMAIN_MODEL_LAYER).definedBy(this.domainModelPredicate.orElse(DescribedPredicate.alwaysFalse())).layer(DOMAIN_SERVICE_LAYER).definedBy(this.domainServicePredicate.orElse(DescribedPredicate.alwaysFalse())).layer(APPLICATION_SERVICE_LAYER).definedBy(this.applicationPredicate.orElse(DescribedPredicate.alwaysFalse())).layer(ADAPTER_LAYER).definedBy(DescribedPredicate.or(this.adapterPredicates.values())).whereLayer(DOMAIN_MODEL_LAYER).mayOnlyBeAccessedByLayers(DOMAIN_SERVICE_LAYER, APPLICATION_SERVICE_LAYER, ADAPTER_LAYER).whereLayer(DOMAIN_SERVICE_LAYER).mayOnlyBeAccessedByLayers(APPLICATION_SERVICE_LAYER, ADAPTER_LAYER).whereLayer(APPLICATION_SERVICE_LAYER).mayOnlyBeAccessedByLayers(ADAPTER_LAYER).withOptionalLayers(this.optionalLayers);
            for (Map.Entry<String, DescribedPredicate<? super JavaClass>> adapter : this.adapterPredicates.entrySet()) {
                String adapterLayer = this.getAdapterLayer(adapter.getKey());
                layeredArchitectureDelegate = layeredArchitectureDelegate.layer(adapterLayer).definedBy(adapter.getValue()).whereLayer(adapterLayer).mayNotBeAccessedByAnyLayer();
            }
            for (IgnoredDependency ignoredDependency : this.ignoredDependencies) {
                layeredArchitectureDelegate = ignoredDependency.ignoreFor(layeredArchitectureDelegate);
            }
            layeredArchitectureDelegate = this.allClassesAreContainedInArchitectureCheck.configure(layeredArchitectureDelegate);
            return layeredArchitectureDelegate.as(this.getDescription());
        }

        private String getAdapterLayer(String name) {
            return String.format("%s %s", name, ADAPTER_LAYER);
        }

        @Override
        public void check(JavaClasses classes) {
            this.layeredArchitectureDelegate().check(classes);
        }

        @Override
        public OnionArchitecture because(String reason) {
            return (OnionArchitecture)ArchRule.Factory.withBecause(this, reason);
        }

        @Override
        public ArchRule allowEmptyShould(boolean allowEmptyShould) {
            return this.withOptionalLayers(allowEmptyShould);
        }

        @Override
        public OnionArchitecture as(String newDescription) {
            return new OnionArchitecture(this.domainModelPredicate, this.domainServicePredicate, this.applicationPredicate, this.adapterPredicates, this.optionalLayers, this.ignoredDependencies, Optional.of(newDescription), this.allClassesAreContainedInArchitectureCheck);
        }

        @Override
        public EvaluationResult evaluate(JavaClasses classes) {
            return this.layeredArchitectureDelegate().evaluate(classes);
        }

        @Override
        public String getDescription() {
            if (this.overriddenDescription.isPresent()) {
                return this.overriddenDescription.get();
            }
            ArrayList<String> lines = Lists.newArrayList("Onion architecture consisting of" + (this.optionalLayers ? " (optional)" : ""));
            this.domainModelPredicate.ifPresent(describedPredicate -> lines.add(String.format("domain models (%s)", describedPredicate.getDescription())));
            this.domainServicePredicate.ifPresent(describedPredicate -> lines.add(String.format("domain services (%s)", describedPredicate.getDescription())));
            this.applicationPredicate.ifPresent(describedPredicate -> lines.add(String.format("application services (%s)", describedPredicate.getDescription())));
            for (Map.Entry<String, DescribedPredicate<? super JavaClass>> adapter : this.adapterPredicates.entrySet()) {
                lines.add(String.format("adapter '%s' (%s)", adapter.getKey(), adapter.getValue().getDescription()));
            }
            return Joiner.on(System.lineSeparator()).join(lines);
        }

        public String toString() {
            return this.getDescription();
        }

        private static abstract class AllClassesAreContainedInArchitectureCheck {
            private AllClassesAreContainedInArchitectureCheck() {
            }

            abstract LayeredArchitecture configure(LayeredArchitecture var1);

            static class Disabled
            extends AllClassesAreContainedInArchitectureCheck {
                Disabled() {
                }

                @Override
                LayeredArchitecture configure(LayeredArchitecture layeredArchitecture) {
                    return layeredArchitecture;
                }
            }

            static class Enabled
            extends AllClassesAreContainedInArchitectureCheck {
                private final DescribedPredicate<? super JavaClass> ignorePredicate;

                private Enabled(DescribedPredicate<? super JavaClass> ignorePredicate) {
                    this.ignorePredicate = ignorePredicate;
                }

                @Override
                LayeredArchitecture configure(LayeredArchitecture layeredArchitecture) {
                    return layeredArchitecture.ensureAllClassesAreContainedInArchitectureIgnoring(this.ignorePredicate);
                }
            }
        }

        private static class IgnoredDependency {
            private final DescribedPredicate<? super JavaClass> origin;
            private final DescribedPredicate<? super JavaClass> target;

            IgnoredDependency(DescribedPredicate<? super JavaClass> origin, DescribedPredicate<? super JavaClass> target) {
                this.origin = origin;
                this.target = target;
            }

            LayeredArchitecture ignoreFor(LayeredArchitecture layeredArchitecture) {
                return layeredArchitecture.ignoreDependency(this.origin, this.target);
            }
        }
    }
}

