/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.cycle_detection;

import com.tngtech.archunit.library.cycle_detection.CycleConfiguration;
import com.tngtech.archunit.library.cycle_detection.JohnsonComponent;
import com.tngtech.archunit.library.cycle_detection.PrimitiveGraph;
import com.tngtech.archunit.library.cycle_detection.TarjanComponentFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JohnsonCycleFinder {
    private static final Logger log = LoggerFactory.getLogger(JohnsonCycleFinder.class);
    private int nodeToProcess = 0;
    private final PrimitiveGraph primitiveGraph;

    JohnsonCycleFinder(PrimitiveGraph primitiveGraph) {
        this.primitiveGraph = primitiveGraph;
    }

    Result findCycles() {
        int[] nextStronglyConnectedComponent;
        Result result = new Result();
        TarjanComponentFinder componentFinder = new TarjanComponentFinder(this.primitiveGraph);
        JohnsonComponent johnsonComponent = JohnsonComponent.within(this.primitiveGraph);
        while (this.nodeToProcess < this.primitiveGraph.getSize() && (nextStronglyConnectedComponent = componentFinder.findNonTrivialStronglyConnectedComponentWithLowestNodeIndexAbove(this.nodeToProcess)) != TarjanComponentFinder.NO_COMPONENT_FOUND) {
            johnsonComponent.init(nextStronglyConnectedComponent);
            this.findCycles(result, johnsonComponent.getStartNodeIndex(), johnsonComponent);
            this.nodeToProcess = johnsonComponent.getStartNodeIndex() + 1;
        }
        return result;
    }

    private boolean findCycles(Result result, int originNodeIndex, JohnsonComponent johnsonComponent) {
        int[] targetNodeIndexes;
        if (!result.canAcceptMoreCycles()) {
            return false;
        }
        boolean foundCycle = false;
        johnsonComponent.pushOnStack(originNodeIndex);
        johnsonComponent.block(originNodeIndex);
        for (int targetNodeIndex : targetNodeIndexes = johnsonComponent.getAdjacentNodesOf(originNodeIndex)) {
            if (johnsonComponent.isStartNodeIndex(targetNodeIndex)) {
                result.add(johnsonComponent.getStack());
                foundCycle = true;
                continue;
            }
            if (!johnsonComponent.isNotBlocked(targetNodeIndex)) continue;
            foundCycle |= this.findCycles(result, targetNodeIndex, johnsonComponent);
        }
        if (foundCycle) {
            johnsonComponent.unblock(originNodeIndex);
        } else {
            for (int targetNodeIndex : targetNodeIndexes) {
                johnsonComponent.markDependentlyBlocked(originNodeIndex, targetNodeIndex);
            }
        }
        johnsonComponent.popFromStack();
        return foundCycle;
    }

    static class Result
    implements Iterable<int[]> {
        private final CycleConfiguration configuration = new CycleConfiguration();
        private final List<int[]> cycles = new ArrayList<int[]>();
        private boolean maxNumberOfCyclesReached = false;

        private Result() {
            log.trace("Maximum number of cycles to detect is set to {}; this limit can be adapted using the `archunit.properties` value `{}=xxx`", (Object)this.configuration.getMaxNumberOfCyclesToDetect(), (Object)"cycles.maxNumberToDetect");
        }

        private boolean canAcceptMoreCycles() {
            return !this.maxNumberOfCyclesReached;
        }

        boolean maxNumberOfCyclesReached() {
            return this.maxNumberOfCyclesReached;
        }

        void add(int[] cycle) {
            if (this.maxNumberOfCyclesReached) {
                return;
            }
            if (this.cycles.size() >= this.configuration.getMaxNumberOfCyclesToDetect()) {
                this.maxNumberOfCyclesReached = true;
                return;
            }
            this.cycles.add(cycle);
        }

        @Override
        public Iterator<int[]> iterator() {
            return this.cycles.iterator();
        }
    }
}

