/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.RemoveOnlyCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ResolverHooks {
    private final FrameworkContext fwCtx;
    private ServiceTracker<ResolverHookFactory, TrackedResolverHookFactory> resolverHookTracker;
    private List<TrackedResolverHookFactory> active = null;
    private BundleImpl[] currentTriggers = null;
    private Map<BundleGeneration, Boolean> resolvableBundles = null;
    private Thread blockThread = null;

    ResolverHooks(FrameworkContext frameworkContext) {
        this.fwCtx = frameworkContext;
    }

    synchronized void open() {
        if (this.fwCtx.debug.hooks) {
            this.fwCtx.debug.println("Begin Tracking Resolver Hooks");
        }
        this.resolverHookTracker = new ServiceTracker<ResolverHookFactory, TrackedResolverHookFactory>((BundleContext)this.fwCtx.systemBundle.bundleContext, ResolverHookFactory.class, new ServiceTrackerCustomizer<ResolverHookFactory, TrackedResolverHookFactory>(){

            @Override
            public TrackedResolverHookFactory addingService(ServiceReference<ResolverHookFactory> reference) {
                return new TrackedResolverHookFactory(((ResolverHooks)ResolverHooks.this).fwCtx.systemBundle.bundleContext.getService(reference), reference.getBundle());
            }

            @Override
            public void modifiedService(ServiceReference<ResolverHookFactory> reference, TrackedResolverHookFactory service) {
            }

            @Override
            public void removedService(ServiceReference<ResolverHookFactory> reference, TrackedResolverHookFactory service) {
                service.resetResolverHook();
            }
        });
        this.resolverHookTracker.open();
    }

    synchronized void close() {
        this.resolverHookTracker.close();
        this.resolverHookTracker = null;
    }

    boolean isOpen() {
        return this.resolverHookTracker != null;
    }

    synchronized void beginResolve(BundleImpl[] triggers) throws BundleException {
        if (!this.isOpen()) {
            return;
        }
        if (this.currentTriggers == null) {
            ArrayList<BundleRevision> triggerCollection = new ArrayList<BundleRevision>();
            for (BundleImpl b : triggers) {
                triggerCollection.add(b.current().bundleRevision);
            }
            this.active = new ArrayList<TrackedResolverHookFactory>();
            for (Map.Entry<ServiceReference<ResolverHookFactory>, TrackedResolverHookFactory> e : this.resolverHookTracker.getTracked().entrySet()) {
                TrackedResolverHookFactory rhf = this.resolverHookTracker.getService(e.getKey());
                if (null == rhf) continue;
                this.blockResolveForHooks();
                try {
                    if (!rhf.begin(triggerCollection)) continue;
                    this.active.add(rhf);
                    this.currentTriggers = triggers;
                }
                catch (RuntimeException re) {
                    throw new BundleException("Resolver hook throw an exception, bid=" + rhf.bundle.getBundleId(), 12, re);
                }
                finally {
                    this.unblockResolveForHooks();
                }
            }
            if (this.active.isEmpty()) {
                this.active = null;
            } else {
                this.resolvableBundles = new HashMap<BundleGeneration, Boolean>();
            }
        }
    }

    synchronized void endResolve(BundleImpl[] triggers) throws BundleException {
        if (triggers == this.currentTriggers) {
            BundleException saved = null;
            if (this.active != null) {
                this.blockResolveForHooks();
                for (TrackedResolverHookFactory rhf : this.active) {
                    ResolverHook rh = rhf.getResolverHook();
                    try {
                        rh.end();
                    }
                    catch (RuntimeException re) {
                        saved = new BundleException("Resolver end hook throw an exception, bid=" + rhf.bundle.getBundleId(), 12, re);
                    }
                }
                this.unblockResolveForHooks();
                this.active = null;
                this.resolvableBundles = null;
            }
            this.currentTriggers = null;
            if (saved != null) {
                throw saved;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void filterMatches(BundleRequirement requirement, Collection<? extends BundleCapability> candidates) throws BundleException {
        if (!this.hasHooks()) return;
        RemoveOnlyCollection<BundleCapability> c = new RemoveOnlyCollection<BundleCapability>(candidates);
        this.blockResolveForHooks();
        try {
            for (TrackedResolverHookFactory rhf : this.active) {
                ResolverHook rh = this.checkActiveRemoved(rhf);
                try {
                    rh.filterMatches(requirement, c);
                }
                catch (RuntimeException re) {
                    throw new BundleException("Resolver hook throw an exception, bid=" + rhf.bundle.getBundleId(), 12, re);
                    return;
                }
            }
        }
        finally {
            this.unblockResolveForHooks();
        }
    }

    boolean filterMatches(BundleRequirement requirement, BundleCapability candidate) throws BundleException {
        if (this.hasHooks()) {
            ShrinkableSingletonCollection<BundleCapability> c = new ShrinkableSingletonCollection<BundleCapability>(candidate);
            this.filterMatches(requirement, c);
            return !c.isEmpty();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    boolean filterResolvable(BundleGeneration bg) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> candidates) throws BundleException {
        if (!this.hasHooks()) return;
        RemoveOnlyCollection<BundleCapability> c = new RemoveOnlyCollection<BundleCapability>(candidates);
        this.blockResolveForHooks();
        try {
            for (TrackedResolverHookFactory rhf : this.active) {
                ResolverHook rh = this.checkActiveRemoved(rhf);
                try {
                    rh.filterSingletonCollisions(singleton, c);
                }
                catch (RuntimeException re) {
                    throw new BundleException("Resolver hook throw an exception, bid=" + rhf.bundle.getBundleId(), 12, re);
                    return;
                }
            }
        }
        finally {
            this.unblockResolveForHooks();
        }
    }

    void checkResolveBlocked() {
        if (this.blockThread != null && Thread.currentThread() == this.blockThread) {
            throw new IllegalStateException("Resolve hooks aren't allowed to resolve bundle");
        }
    }

    boolean hasHooks() {
        return this.active != null;
    }

    private ResolverHook checkActiveRemoved(TrackedResolverHookFactory rhf) throws BundleException {
        ResolverHook rh = rhf.getResolverHook();
        if (null == rh) {
            throw new BundleException("Resolver hook service was unregistered", 12);
        }
        return rh;
    }

    private void blockResolveForHooks() {
        this.blockThread = Thread.currentThread();
    }

    private void unblockResolveForHooks() {
        this.blockThread = null;
    }

    static class ShrinkableSingletonCollection<T>
    extends AbstractCollection<T> {
        T singleton;

        public ShrinkableSingletonCollection(T singleton) {
            this.singleton = singleton;
        }

        @Override
        public boolean add(T br) {
            throw new UnsupportedOperationException("Add not allowed");
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException("Add not allowed");
        }

        @Override
        public boolean isEmpty() {
            return this.singleton == null;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                boolean hasNext;
                {
                    this.hasNext = !ShrinkableSingletonCollection.this.isEmpty();
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        if (ShrinkableSingletonCollection.this.isEmpty()) {
                            throw new ConcurrentModificationException();
                        }
                        return ShrinkableSingletonCollection.this.singleton;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (this.hasNext || ShrinkableSingletonCollection.this.isEmpty()) {
                        throw new IllegalStateException();
                    }
                    ShrinkableSingletonCollection.this.singleton = null;
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (this.singleton != null && this.singleton.equals(o)) {
                this.singleton = null;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.singleton != null ? 1 : 0;
        }
    }

    static class TrackedResolverHookFactory {
        final ResolverHookFactory tracked;
        final Bundle bundle;
        private ResolverHook resolverHook = null;

        TrackedResolverHookFactory(ResolverHookFactory tracked, Bundle bundle) {
            this.tracked = tracked;
            this.bundle = bundle;
        }

        boolean begin(Collection<BundleRevision> triggers) {
            this.resolverHook = this.tracked.begin(triggers);
            return this.resolverHook != null;
        }

        ResolverHook getResolverHook() {
            return this.resolverHook;
        }

        void resetResolverHook() {
            this.resolverHook = null;
        }
    }
}

