/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.memory;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.bundlestorage.memory.BundleArchiveImpl;

class Archive
implements FileArchive {
    private final BundleArchiveImpl ba;
    Manifest manifest;
    protected HashMap<String, byte[]> content;
    ArrayList<String> subDirs;
    final String path;

    Archive(BundleArchiveImpl ba, InputStream is) throws IOException {
        this.ba = ba;
        this.path = ".";
        JarInputStream ji = new JarInputStream(is);
        this.manifest = ji.getManifest();
        if (this.manifest == null) {
            throw new IOException("Bundle manifest is missing");
        }
        this.content = this.loadJarStream(ji);
    }

    Archive(Archive a, String path) throws IOException {
        byte[] bs;
        this.ba = a.ba;
        this.path = path;
        if (null != path && path.length() > 0 && '/' == path.charAt(0)) {
            path = path.substring(1);
        }
        if ((bs = a.content.remove(path)) == null) {
            throw new FileNotFoundException("No such file: " + path);
        }
        JarInputStream ji = new JarInputStream(new ByteArrayInputStream(bs));
        this.content = this.loadJarStream(ji);
    }

    @Override
    public BundleGeneration getBundleGeneration() {
        return this.ba.getBundleGeneration();
    }

    @Override
    public int getSubId() {
        return 0;
    }

    String getAttribute(String key) {
        return this.manifest.getMainAttributes().getValue(key);
    }

    @Override
    public byte[] getClassBytes(String classFile) throws IOException {
        byte[] bytes = this.content.remove(classFile);
        if (bytes == null) {
            if (this.subDirs == null) {
                return null;
            }
            Iterator<String> it = this.subDirs.iterator();
            boolean found = false;
            while (it.hasNext()) {
                String subDir = it.next();
                bytes = this.content.remove(subDir + "/" + classFile);
                if (bytes == null) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        return bytes;
    }

    @Override
    public BundleResourceStream getBundleResourceStream(String component) {
        byte[] b;
        if (component.startsWith("/")) {
            component = component.substring(1);
        }
        if ((b = this.content.get(component)) != null) {
            return new BundleResourceStream(new ByteArrayInputStream(b), b.length);
        }
        return null;
    }

    @Override
    public Enumeration<String> findResourcesPath(String path) {
        Vector<String> answer = new Vector<String>();
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/") && path.length() > 1) {
            path = path + "/";
        }
        for (String entry : this.content.keySet()) {
            String terminal;
            StringTokenizer st;
            String entryPath;
            if (!entry.startsWith(path) || answer.contains(entryPath = (st = new StringTokenizer(terminal = entry.substring(path.length()), "/")).hasMoreTokens() ? path + st.nextToken() : path)) continue;
            answer.add(entryPath);
        }
        if (answer.size() == 0) {
            return null;
        }
        return answer.elements();
    }

    Archive getSubArchive(String path) throws IOException {
        return new Archive(this, path);
    }

    @Override
    public String checkNativeLibrary(String path) {
        return null;
    }

    @Override
    public String getNativeLibrary(String libNameKey) {
        return null;
    }

    @Override
    public Class<?> loadClassBytes(String name, ClassLoader cl) {
        return null;
    }

    @Override
    public boolean exists(String path, boolean onlyDirs) {
        if (path.equals("")) {
            return true;
        }
        if (onlyDirs) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            for (String k : this.content.keySet()) {
                if (!k.startsWith(path)) continue;
                return true;
            }
            return false;
        }
        return this.content.containsKey(path);
    }

    @Override
    public Set<String> listDir(String path) {
        HashSet<String> res = new HashSet<String>();
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        for (String k : this.content.keySet()) {
            String e = this.matchPath(path, k);
            if (e == null) continue;
            res.add(e);
        }
        return res;
    }

    private HashMap<String, byte[]> loadJarStream(JarInputStream ji) throws IOException {
        JarEntry je;
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        while ((je = ji.getNextJarEntry()) != null) {
            byte[] oldb;
            if (je.isDirectory()) continue;
            int len = (int)je.getSize();
            if (len == -1) {
                len = 8192;
            }
            byte[] b = new byte[len];
            int pos = 0;
            do {
                int n;
                if (pos == len) {
                    oldb = b;
                    b = new byte[len *= 2];
                    System.arraycopy(oldb, 0, b, 0, oldb.length);
                }
                while (len - pos > 0 && (n = ji.read(b, pos, len - pos)) > 0) {
                    pos += n;
                }
            } while (ji.available() > 0);
            if (pos != b.length) {
                oldb = b;
                b = new byte[pos];
                System.arraycopy(oldb, 0, b, 0, pos);
            }
            files.put(je.getName(), b);
        }
        return files;
    }

    private String matchPath(String basePath, String path) {
        int len = basePath.length();
        if (path.length() > len && path.startsWith(basePath)) {
            int i = path.indexOf(47, len);
            if (i == -1) {
                return path.substring(len);
            }
            return path.substring(len, i + 1);
        }
        return null;
    }
}

