/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.PrintStream;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;

public class ScriptRunner {
    private final IScript script;
    private IFreeplaneScriptErrorHandler errorHandler = ScriptResources.IGNORING_SCRIPT_ERROR_HANDLER;
    private PrintStream outStream = System.out;
    private ScriptContext scriptContext;

    public ScriptRunner(IScript script) {
        this.script = script;
    }

    public ScriptRunner setErrorHandler(IFreeplaneScriptErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public ScriptRunner setOutStream(PrintStream outStream) {
        this.outStream = outStream;
        return this;
    }

    public ScriptRunner setScriptContext(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    public Object execute(NodeModel node) {
        return this.script.execute(node, this.outStream, this.errorHandler, this.scriptContext);
    }
}

