/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Container;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolTip;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.view.swing.map.FreeplaneTooltip;

class BookmarkButton
extends JButton {
    private final NodeBookmark bookmark;
    private final ModeController modeController;

    public NodeBookmark getBookmark() {
        return this.bookmark;
    }

    BookmarkButton(NodeBookmark bookmark, ModeController modeController) {
        this.bookmark = bookmark;
        this.modeController = modeController;
        this.setOpaque(false);
    }

    @Override
    public JToolTip createToolTip() {
        return this.createBookmarkTooltip();
    }

    @Override
    public String getToolTipText() {
        return this.modeController.createToolTip(this.bookmark.getNode(), (Component)this, ITooltipProvider.TooltipTrigger.LINK);
    }

    private FreeplaneTooltip createBookmarkTooltip() {
        FreeplaneTooltip tip = new FreeplaneTooltip(this.getGraphicsConfiguration(), "text/html", false);
        tip.setBorder(BorderFactory.createEmptyBorder());
        NodeModel node = this.bookmark.getNode();
        TextWritingDirection textDirection = NodeStyleController.getController((ModeController)this.modeController).getTextWritingDirection(node);
        tip.setComponentOrientation(textDirection.componentOrientation);
        URL url = node.getMap().getURL();
        if (url != null) {
            tip.setBase(url);
        } else {
            try {
                tip.setBase(new URL("file: "));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return tip;
    }

    NodeModel getNode() {
        return this.bookmark.getNode();
    }

    public void clearVisualFeedback() {
        BookmarkToolbar toolbar = this.getBookmarkToolbar();
        if (toolbar != null) {
            toolbar.clearVisualFeedback();
        }
    }

    public void showFeedback(BookmarkToolbar.DropIndicatorType type) {
        BookmarkToolbar toolbar = this.getBookmarkToolbar();
        if (toolbar != null) {
            toolbar.showVisualFeedback(this, type);
        }
    }

    public void showDropZoneIndicator(boolean dropsAfter) {
        BookmarkToolbar.DropIndicatorType type = dropsAfter ? BookmarkToolbar.DropIndicatorType.DROP_AFTER : BookmarkToolbar.DropIndicatorType.DROP_BEFORE;
        this.showFeedback(type);
    }

    private BookmarkToolbar getBookmarkToolbar() {
        Container parent = this.getParent();
        return parent instanceof BookmarkToolbar ? (BookmarkToolbar)((Object)parent) : null;
    }
}

