/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Point;
import javax.swing.JButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkIndexCalculator;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.bookmarks.mindmapmode.ui.DropValidation;

class DropValidator {
    private final BookmarkIndexCalculator indexCalculator;

    DropValidator(BookmarkToolbar toolbar) {
        this.indexCalculator = new BookmarkIndexCalculator(toolbar);
    }

    DropValidation validateDrop(int sourceIndex, JButton targetButton, Point dropPoint) {
        if (!this.indexCalculator.isValidBookmarkMove(sourceIndex, targetButton, dropPoint)) {
            return DropValidation.forBookmarkMove(false, -1, false);
        }
        int finalTargetIndex = this.indexCalculator.calculateBookmarkMoveIndex(sourceIndex, targetButton, dropPoint);
        boolean dropsAfter = this.indexCalculator.isDropAfter(targetButton, dropPoint);
        return DropValidation.forBookmarkMove(true, finalTargetIndex, dropsAfter);
    }

    DropValidation validateNodeDrop(JButton targetButton, Point dropPoint) {
        boolean isInsertionDrop = this.indexCalculator.isInInsertionZone(targetButton, dropPoint);
        boolean dropsAfter = this.indexCalculator.isDropAfter(targetButton, dropPoint);
        return DropValidation.forNodeDrop(true, isInsertionDrop, dropsAfter);
    }

    BookmarkIndexCalculator.ToolbarDropPosition calculateToolbarDropPosition(Point dropPoint) {
        return this.indexCalculator.calculateToolbarDropPosition(dropPoint);
    }
}

