/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard.mindmapmode;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.clipboard.mindmapmode.CutAction;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.clipboard.mindmapmode.PasteAction;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class MClipboardControllers
extends ClipboardControllers {
    private final SortedSet<MClipboardController> controllers = new TreeSet<MClipboardController>((x$0, x$1) -> this.prioritySort((ClipboardController)x$0, (ClipboardController)x$1));

    public MClipboardControllers() {
        this.createActions();
    }

    private void createActions() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addAction((AFreeplaneAction)new CutAction());
        modeController.addAction((AFreeplaneAction)new PasteAction());
    }

    public boolean add(MClipboardController e) {
        return this.controllers.add(e);
    }

    public void copy() {
        Optional<MClipboardController> controller = this.controllers.stream().filter(ClipboardController::canCopy).findFirst();
        if (controller.isPresent()) {
            controller.ifPresent(ClipboardController::copy);
        } else {
            super.copy();
        }
    }

    public void cut() {
        this.controllers.stream().filter(MClipboardController::canCut).findFirst().ifPresent(MClipboardController::cut);
    }

    public void paste(ActionEvent e) {
        Transferable t = ClipboardAccessor.getInstance().getClipboardContents();
        if (t != null) {
            this.controllers.stream().filter(c -> c.canPaste(t)).findFirst().ifPresent(c -> c.paste(e, t));
        }
    }
}

