/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mapio.mindmapmode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class MMapIO
extends MapIO {
    private static MMapIO INSTANCE;
    private final MFileManager fileManager;
    private final MMapController mapController;

    public static MMapIO getInstance() {
        return INSTANCE;
    }

    private MMapIO(MFileManager urlManager, MMapController mapController) {
        super((UrlManager)urlManager, (MapController)mapController);
        this.fileManager = urlManager;
        this.mapController = mapController;
    }

    public static void install(MModeController modeController) {
        if (INSTANCE != null) {
            throw new IllegalStateException("Should be used only in one mode");
        }
        MFileManager urlManager = (MFileManager)modeController.getExtension(UrlManager.class);
        MMapController mapController = (MMapController)modeController.getMapController();
        INSTANCE = new MMapIO(urlManager, mapController);
        modeController.addExtension(MapIO.class, (IExtension)INSTANCE);
    }

    public void load(URL url, MapModel map) throws FileNotFoundException, IOException, XMLException, XMLParseException, URISyntaxException {
        this.fileManager.load(url, map);
    }

    public boolean loadCatchExceptions(URL url, MapModel map) {
        return this.fileManager.loadCatchExceptions(url, map);
    }

    public void loadSafeAndLock(URL url, MapModel map) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        this.fileManager.loadAndLock(url, map);
    }

    public void open() {
        this.fileManager.open();
    }

    public MapModel openUntitledMap(File startFile, boolean follow) {
        return this.fileManager.openUntitledMap(startFile, follow);
    }

    public boolean save(MapModel map) {
        return this.fileManager.save(map);
    }

    public boolean save(MapModel map, File file) {
        return this.fileManager.save(map, file);
    }

    public boolean saveAs(MapModel map) {
        return this.fileManager.saveAs(map);
    }

    public void writeToFile(MapModel map, File file) throws FileNotFoundException, IOException {
        this.fileManager.writeToFile(map, file);
    }

    public NodeModel loadTree(MapModel map, File file) throws XMLParseException, IOException {
        return this.fileManager.loadTree(map, file);
    }

    public MapModel newMapFromDefaultTemplate() {
        return this.fileManager.newMapFromDefaultTemplate();
    }

    public void newMap(URL url, boolean follow) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        this.mapController.newMap(url, follow);
    }

    public MapModel createUntitledMap(URL url, boolean follow) {
        try {
            return this.mapController.createUntitledMap(url, follow);
        }
        catch (Exception e) {
            this.fileManager.handleLoadingException(e);
            return null;
        }
    }

    public MapModel readMap(URL url) {
        try {
            return this.mapController.readMap(url);
        }
        catch (Exception e) {
            this.fileManager.handleLoadingException(e);
            return null;
        }
    }

    public void openMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        this.mapController.openMap(url);
    }

    public void openDocumentationMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        this.mapController.openDocumentationMap(url);
    }

    public void restoreCurrentMap() throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        this.mapController.restoreCurrentMap();
    }
}

