/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle.mindmapmode;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.List;
import org.freeplane.api.Dash;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeBorderModel;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeCssHook;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.nodestyle.mindmapmode.BoldAction;
import org.freeplane.features.nodestyle.mindmapmode.CopyFormat;
import org.freeplane.features.nodestyle.mindmapmode.CssEditor;
import org.freeplane.features.nodestyle.mindmapmode.EditNodeCssAction;
import org.freeplane.features.nodestyle.mindmapmode.HorizontalTextAlignmentAction;
import org.freeplane.features.nodestyle.mindmapmode.ItalicAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeBackgroundColorAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeColorAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeColorBlendAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeShapeAction;
import org.freeplane.features.nodestyle.mindmapmode.PasteFormat;
import org.freeplane.features.nodestyle.mindmapmode.RemoveFormatAction;
import org.freeplane.features.nodestyle.mindmapmode.StrikeThroughAction;
import org.freeplane.features.nodestyle.mindmapmode.TextWritingDirectionAction;
import org.freeplane.features.nodestyle.mindmapmode.UnderlineAction;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MNodeStyleController
extends NodeStyleController {
    public MNodeStyleController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new StyleCopier(modeController));
        modeController.addAction((AFreeplaneAction)new BoldAction());
        modeController.addAction((AFreeplaneAction)new UnderlineAction());
        modeController.addAction((AFreeplaneAction)new StrikeThroughAction());
        modeController.addAction((AFreeplaneAction)new ItalicAction());
        modeController.addAction((AFreeplaneAction)new CopyFormat());
        modeController.addAction((AFreeplaneAction)new PasteFormat());
        modeController.addAction((AFreeplaneAction)new RemoveFormatAction());
        modeController.addAction((AFreeplaneAction)new HorizontalTextAlignmentAction(HorizontalTextAlignment.LEFT));
        modeController.addAction((AFreeplaneAction)new HorizontalTextAlignmentAction(HorizontalTextAlignment.CENTER));
        modeController.addAction((AFreeplaneAction)new HorizontalTextAlignmentAction(HorizontalTextAlignment.RIGHT));
        modeController.addAction((AFreeplaneAction)new TextWritingDirectionAction(TextWritingDirection.LEFT_TO_RIGHT));
        modeController.addAction((AFreeplaneAction)new TextWritingDirectionAction(TextWritingDirection.RIGHT_TO_LEFT));
        AMultipleNodeAction increaseNodeFont = new AMultipleNodeAction("IncreaseNodeFontAction"){
            private static final long serialVersionUID = 1L;

            protected void actionPerformed(ActionEvent e, NodeModel node) {
                MNodeStyleController.this.increaseFontSize(node, 1);
            }
        };
        modeController.addAction((AFreeplaneAction)increaseNodeFont);
        AMultipleNodeAction decreaseNodeFont = new AMultipleNodeAction("DecreaseNodeFontAction"){
            private static final long serialVersionUID = 1L;

            protected void actionPerformed(ActionEvent e, NodeModel node) {
                MNodeStyleController.this.increaseFontSize(node, -1);
            }
        };
        modeController.addAction((AFreeplaneAction)decreaseNodeFont);
        modeController.addAction((AFreeplaneAction)new NodeColorAction());
        modeController.addAction((AFreeplaneAction)new NodeColorBlendAction());
        modeController.addAction((AFreeplaneAction)new NodeBackgroundColorAction());
        modeController.addAction((AFreeplaneAction)new EditNodeCssAction());
        for (NodeStyleShape shape : NodeStyleShape.values()) {
            if (shape.equals((Object)NodeStyleShape.as_parent)) break;
            modeController.addAction((AFreeplaneAction)new NodeShapeAction(shape));
        }
    }

    public void copyStyle(NodeModel source, NodeModel target) {
        this.copyStyleModel(source, target);
        this.copySizeModel(source, target);
        this.copyBorderModel(source, target);
        MNodeStyleController.copyCss(source, target);
    }

    private static void copyCss(NodeModel source, NodeModel target) {
        NodeCss nodeCss = (NodeCss)source.getExtension(NodeCss.class);
        if (nodeCss != null) {
            target.putExtension((IExtension)nodeCss);
        }
    }

    private void copyStyleModel(NodeModel source, NodeModel target) {
        NodeStyleModel sourceStyleModel = NodeStyleModel.getModel((NodeModel)source);
        if (sourceStyleModel != null) {
            this.setColor(target, sourceStyleModel.getColor());
            this.setBackgroundColor(target, sourceStyleModel.getBackgroundColor());
            this.setShapeConfiguration(target, sourceStyleModel.getShapeConfiguration());
            this.setFontFamily(target, sourceStyleModel.getFontFamilyName());
            this.setFontSize(target, sourceStyleModel.getFontSize());
            this.setBold(target, sourceStyleModel.isBold());
            this.setStrikedThrough(target, sourceStyleModel.isStrikedThrough());
            this.setItalic(target, sourceStyleModel.isItalic());
            this.setNodeFormat(target, sourceStyleModel.getNodeFormat());
            this.setNodeNumbering(target, sourceStyleModel.getNodeNumbering());
            this.setHorizontalTextAlignment(target, sourceStyleModel.getHorizontalTextAlignment());
            this.setTextWritingDirection(target, sourceStyleModel.getTextWritingDirection());
        }
    }

    private void copySizeModel(NodeModel source, NodeModel target) {
        NodeSizeModel sourceSizeModel = NodeSizeModel.getModel((NodeModel)source);
        if (sourceSizeModel != null) {
            this.setMaxNodeWidth(target, (Quantity<LengthUnit>)sourceSizeModel.getMaxNodeWidth());
            this.setMinNodeWidth(target, (Quantity<LengthUnit>)sourceSizeModel.getMinNodeWidth());
        }
    }

    private void copyBorderModel(NodeModel source, NodeModel target) {
        NodeBorderModel from = NodeBorderModel.getModel((NodeModel)source);
        if (from != null) {
            this.setBorderWidthMatchesEdgeWidth(target, from.getBorderWidthMatchesEdgeWidth());
            this.setBorderWidth(target, (Quantity<LengthUnit>)from.getBorderWidth());
            this.setBorderDashMatchesEdgeDash(target, from.getBorderDashMatchesEdgeDash());
            this.setBorderDash(target, from.getBorderDash());
            this.setBorderColorMatchesEdgeColor(target, from.getBorderColorMatchesEdgeColor());
            this.setBorderColor(target, from.getBorderColor());
        }
    }

    private NodeStyleModel createOwnStyleModel(final NodeModel node) {
        NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
        if (styleModel != null) {
            return styleModel;
        }
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                node.addExtension((IExtension)new NodeStyleModel());
            }

            public String getDescription() {
                return null;
            }

            public void undo() {
                node.removeExtension(NodeStyleModel.class);
            }
        };
        modeController.execute(actor, node.getMap());
        return NodeStyleModel.getModel((NodeModel)node);
    }

    private NodeSizeModel createOwnSizeModel(final NodeModel node) {
        NodeSizeModel sizeModel = NodeSizeModel.getModel((NodeModel)node);
        if (sizeModel != null) {
            return sizeModel;
        }
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                node.addExtension((IExtension)new NodeSizeModel());
            }

            public String getDescription() {
                return null;
            }

            public void undo() {
                node.removeExtension(NodeSizeModel.class);
            }
        };
        modeController.execute(actor, node.getMap());
        return NodeSizeModel.getModel((NodeModel)node);
    }

    public void increaseFontSize(NodeModel node, int increment) {
        int newSize = this.getFontSize(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) + increment;
        if (newSize > 0) {
            this.setFontSize(node, newSize);
        }
    }

    public void setBackgroundColor(final NodeModel node, final Color color) {
        ModeController modeController = this.getModeController();
        final Color oldColor = NodeStyleModel.getBackgroundColor((NodeModel)node);
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setBackgroundColor((NodeModel)node, (Color)color);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setBackgroundColor";
            }

            public void undo() {
                NodeStyleModel.setBackgroundColor((NodeModel)node, (Color)oldColor);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setBold(final NodeModel node, final Boolean bold) {
        final Boolean oldBold = NodeStyleModel.isBold((NodeModel)node);
        if (oldBold == bold || oldBold != null && oldBold.equals(bold)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setBold(bold);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setBold";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setBold(oldBold);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setUnderlined(final NodeModel node, final Boolean underline) {
        final Boolean oldUnderline = NodeStyleModel.isUnderlined((NodeModel)node);
        if (oldUnderline == underline || oldUnderline != null && oldUnderline.equals(underline)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setUnderlined(underline);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setUnderlined";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setUnderlined(oldUnderline);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setColor(final NodeModel node, final Color color) {
        ModeController modeController = this.getModeController();
        final Color oldColor = NodeStyleModel.getColor((NodeModel)node);
        if (oldColor == color || oldColor != null && oldColor.equals(color)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setColor((NodeModel)node, (Color)color);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                NodeStyleModel.setColor((NodeModel)node, (Color)oldColor);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setStyleSheet(NodeModel node, String css) {
        NodeCss old;
        if (css != null) {
            css = css.trim();
        }
        if ((old = (NodeCss)node.getExtension(NodeCss.class)) == null && css == null || old != null && old.css.equals(css)) {
            return;
        }
        NodeCssHook controller = (NodeCssHook)this.getModeController().getExtension(NodeCssHook.class);
        controller.undoableDeactivateHook(node);
        if (css != null) {
            if (css.isEmpty()) {
                controller.undoableActivateHook(node, (IExtension)NodeCss.EMPTY);
            } else {
                controller.undoableActivateHook(node, (IExtension)new NodeCss(css));
            }
        }
    }

    public void setFontFamily(final NodeModel node, final String fontFamily) {
        final String oldFontFamily = NodeStyleModel.getFontFamilyName((NodeModel)node);
        if (oldFontFamily == fontFamily || oldFontFamily != null && oldFontFamily.equals(fontFamily)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontFamilyName(fontFamily);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFontFamily";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontFamilyName(oldFontFamily);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setFontFamily(String fontFamily) {
        for (NodeModel selected : this.getModeController().getMapController().getSelectedNodes()) {
            this.setFontFamily(selected, fontFamily);
        }
    }

    public void setFontSize(int size) {
        List selectedNodes = this.getModeController().getMapController().getSelectedNodes();
        for (NodeModel selected : selectedNodes) {
            this.setFontSize(selected, size);
        }
    }

    public void setFontSize(final NodeModel node, final Integer fontSize) {
        final Integer oldFontSize = NodeStyleModel.getFontSize((NodeModel)node);
        if (oldFontSize == fontSize || oldFontSize != null && oldFontSize.equals(fontSize)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontSize(fontSize);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFontSize";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontSize(oldFontSize);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setItalic(final NodeModel node, final Boolean italic) {
        final Boolean oldItalic = NodeStyleModel.isItalic((NodeModel)node);
        if (oldItalic == italic || oldItalic != null && oldItalic.equals(italic)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setItalic(italic);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setItalic";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setItalic(oldItalic);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setNodeNumbering(final NodeModel node, final Boolean enableNodeNumbering) {
        final ModeController modeController = this.getModeController();
        final Boolean oldValue = NodeStyleModel.getNodeNumbering((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setNodeNumbering((NodeModel)node, (Boolean)enableNodeNumbering);
                MapController mapController = modeController.getMapController();
                mapController.mapSaved(node.getMap(), false);
                mapController.delayedNodeRefresh(node, (Object)"NodeNumbering", (Object)oldValue, (Object)enableNodeNumbering);
            }

            public String getDescription() {
                return "setNodeNumbering";
            }

            public void undo() {
                NodeStyleModel.setNodeNumbering((NodeModel)node, (Boolean)oldValue);
                MapController mapController = modeController.getMapController();
                mapController.mapSaved(node.getMap(), false);
                modeController.getMapController().delayedNodeRefresh(node, (Object)"NodeNumbering", (Object)enableNodeNumbering, (Object)oldValue);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setNodeFormat(final NodeModel node, final String format) {
        final ModeController modeController = this.getModeController();
        final String oldFormat = NodeStyleModel.getNodeFormat((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setNodeFormat((NodeModel)node, (String)format);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setNodeFormat";
            }

            public void undo() {
                NodeStyleModel.setNodeFormat((NodeModel)node, (String)oldFormat);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setShape(NodeModel node, String shape) {
        this.setShape(node, shape == null ? null : NodeStyleShape.valueOf((String)shape));
    }

    public void setShape(NodeModel node, NodeStyleShape shape) {
        NodeGeometryModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withShape(shape));
    }

    public void setShapeHorizontalMargin(NodeModel node, Quantity<LengthUnit> margin) {
        NodeGeometryModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withHorizontalMargin(margin));
    }

    public void setShapeVerticalMargin(NodeModel node, Quantity<LengthUnit> margin) {
        NodeGeometryModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withVerticalMargin(margin));
    }

    public void setUniformShape(NodeModel node, boolean uniform) {
        NodeGeometryModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withUniform(uniform));
    }

    public void setShapeConfiguration(final NodeModel node, final NodeGeometryModel shape) {
        final ModeController modeController = this.getModeController();
        final NodeGeometryModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setShapeConfiguration((NodeModel)node, (NodeGeometryModel)shape);
                modeController.getMapController().nodeChanged(node);
                this.childShapeRefresh(node);
            }

            public String getDescription() {
                return "setShape";
            }

            private void childShapeRefresh(NodeModel node2) {
                for (NodeModel child : node2.getChildren()) {
                    NodeStyleShape childShape;
                    if (child.getViewers().isEmpty() || (childShape = NodeStyleModel.getShape((NodeModel)child)) != null && !NodeStyleShape.as_parent.equals((Object)childShape)) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.childShapeRefresh(child);
                }
            }

            public void undo() {
                NodeStyleModel.setShapeConfiguration((NodeModel)node, (NodeGeometryModel)oldShape);
                modeController.getMapController().nodeChanged(node);
                this.childShapeRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setMinNodeWidth(final NodeModel node, final Quantity<LengthUnit> minNodeWidth) {
        Quantity.assertNonNegativeOrNull(minNodeWidth);
        final NodeSizeModel sizeModel = this.createOwnSizeModel(node);
        final Quantity oldValue = NodeSizeModel.getMinNodeWidth((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                sizeModel.setMinNodeWidth(minNodeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMinNodeWidth";
            }

            public void undo() {
                sizeModel.setMinNodeWidth(oldValue);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
        Quantity maxNodeWidth = this.getMaxWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        if (maxNodeWidth != null && minNodeWidth != null && maxNodeWidth.toBaseUnits() < minNodeWidth.toBaseUnits()) {
            this.setMaxNodeWidth(node, minNodeWidth);
        }
    }

    public void setMaxNodeWidth(final NodeModel node, final Quantity<LengthUnit> maxNodeWidth) {
        Quantity.assertNonNegativeOrNull(maxNodeWidth);
        final NodeSizeModel sizeModel = this.createOwnSizeModel(node);
        final Quantity oldValue = NodeSizeModel.getMaxNodeWidth((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                sizeModel.setMaxNodeWidth(maxNodeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMaxNodeWidth";
            }

            public void undo() {
                sizeModel.setMaxNodeWidth(oldValue);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
        Quantity minNodeWidth = this.getMinWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        if (maxNodeWidth != null && minNodeWidth != null && maxNodeWidth.toBaseUnitsRounded() < minNodeWidth.toBaseUnitsRounded()) {
            this.setMinNodeWidth(node, maxNodeWidth);
        }
    }

    public void setHorizontalTextAlignment(final NodeModel node, final HorizontalTextAlignment textAlignment) {
        final HorizontalTextAlignment oldTextAlignment = NodeStyleModel.getHorizontalTextAlignment((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setHorizontalTextAlignment((NodeModel)node, (HorizontalTextAlignment)textAlignment);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setHorizontalTextAlignment";
            }

            public void undo() {
                NodeStyleModel.setHorizontalTextAlignment((NodeModel)node, (HorizontalTextAlignment)oldTextAlignment);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setTextWritingDirection(final NodeModel node, final TextWritingDirection textDirection) {
        final TextWritingDirection oldTextDirection = NodeStyleModel.getTextWritingDirection((NodeModel)node);
        if (textDirection == oldTextDirection) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setTextWritingDirection((NodeModel)node, (TextWritingDirection)textDirection);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node, TextWritingDirection.class, (Object)oldTextDirection, (Object)textDirection);
            }

            public String getDescription() {
                return "setTextWritingDirection";
            }

            public void undo() {
                NodeStyleModel.setTextWritingDirection((NodeModel)node, (TextWritingDirection)oldTextDirection);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node, TextWritingDirection.class, (Object)textDirection, (Object)oldTextDirection);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setBorderWidthMatchesEdgeWidth(final NodeModel node, final Boolean borderWidthMatchesEdgeWidth) {
        final Boolean oldBorderWidthMatchesEdgeWidth = NodeBorderModel.getBorderWidthMatchesEdgeWidth((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeBorderModel.setBorderWidthMatchesEdgeWidth((NodeModel)node, (Boolean)borderWidthMatchesEdgeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setBorderWidthMatchesEdgeWidth";
            }

            public void undo() {
                NodeBorderModel.setBorderWidthMatchesEdgeWidth((NodeModel)node, (Boolean)oldBorderWidthMatchesEdgeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setBorderDashMatchesEdgeDash(final NodeModel node, final Boolean borderDashMatchesEdgeDash) {
        final Boolean oldBorderDashMatchesEdgeDash = NodeBorderModel.getBorderDashMatchesEdgeDash((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeBorderModel.setBorderDashMatchesEdgeDash((NodeModel)node, (Boolean)borderDashMatchesEdgeDash);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setBorderDashMatchesEdgeDash";
            }

            public void undo() {
                NodeBorderModel.setBorderDashMatchesEdgeDash((NodeModel)node, (Boolean)oldBorderDashMatchesEdgeDash);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setBorderColorMatchesEdgeColor(final NodeModel node, final Boolean borderColorMatchesEdgeColor) {
        final Boolean oldBorderColorMatchesEdgeColor = NodeBorderModel.getBorderColorMatchesEdgeColor((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeBorderModel.setBorderColorMatchesEdgeColor((NodeModel)node, (Boolean)borderColorMatchesEdgeColor);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setBorderColorMatchesEdgeColor";
            }

            public void undo() {
                NodeBorderModel.setBorderColorMatchesEdgeColor((NodeModel)node, (Boolean)oldBorderColorMatchesEdgeColor);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setBorderWidth(final NodeModel node, final Quantity<LengthUnit> borderWidth) {
        final Quantity oldBorderWidth = NodeBorderModel.getBorderWidth((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeBorderModel.setBorderWidth((NodeModel)node, (Quantity)borderWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setBorderWidth";
            }

            public void undo() {
                NodeBorderModel.setBorderWidth((NodeModel)node, (Quantity)oldBorderWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setBorderDash(final NodeModel node, final Dash borderDash) {
        final Dash oldBorderDash = NodeBorderModel.getBorderDash((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeBorderModel.setBorderDash((NodeModel)node, (Dash)borderDash);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setBorderDash";
            }

            public void undo() {
                NodeBorderModel.setBorderDash((NodeModel)node, (Dash)oldBorderDash);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setBorderColor(final NodeModel node, final Color borderColor) {
        final Color oldBorderColor = NodeBorderModel.getBorderColor((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeBorderModel.setBorderColor((NodeModel)node, (Color)borderColor);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setBorderColor";
            }

            public void undo() {
                NodeBorderModel.setBorderColor((NodeModel)node, (Color)oldBorderColor);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void setStrikedThrough(final NodeModel node, final Boolean strikedThrough) {
        final Boolean oldStrikedThrough = NodeStyleModel.isStrikedThrough((NodeModel)node);
        if (oldStrikedThrough == strikedThrough || oldStrikedThrough != null && oldStrikedThrough.equals(strikedThrough)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = this.getModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setStrikedThrough(strikedThrough);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setStrikedThrough";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setStrikedThrough(oldStrikedThrough);
                MNodeStyleController.this.getModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    void editCss(NodeModel selectedNode) {
        String css = this.getStyleSheet((NodeModel)selectedNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).css;
        StringBuilder ruleBuilder = new StringBuilder(100);
        ruleBuilder.append("body {");
        ruleBuilder.append(new CssRuleBuilder().withCSSFont(this.getFont(selectedNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE)).withColor(this.getColor(selectedNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE)).withBackground(this.getBackgroundColor(selectedNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE)).withAlignment(this.getHorizontalTextAlignment((NodeModel)selectedNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).swingConstant).withDirection(this.getTextWritingDirection(selectedNode)));
        ruleBuilder.append("}\n");
        CssEditor cssEditor = new CssEditor(ruleBuilder.toString());
        if (cssEditor.editCss(css) == 0) {
            this.setStyleSheet(selectedNode, cssEditor.getNewCss());
        }
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private final ModeController modeController;

        public StyleCopier(ModeController modeController) {
            this.modeController = modeController;
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            NodeBorderModel fromBorder;
            NodeSizeModel fromSize;
            NodeStyleModel fromStyle = (NodeStyleModel)from.getExtension(NodeStyleModel.class);
            if (fromStyle != null) {
                fromStyle.copyTo(NodeStyleModel.createNodeStyleModel((NodeModel)to));
            }
            if ((fromSize = (NodeSizeModel)from.getExtension(NodeSizeModel.class)) != null) {
                fromSize.copyTo(NodeSizeModel.createNodeSizeModel((NodeModel)to));
            }
            if ((fromBorder = (NodeBorderModel)from.getExtension(NodeBorderModel.class)) != null) {
                fromBorder.copyTo(NodeBorderModel.createNodeBorderModel((NodeModel)to));
            }
            MNodeStyleController.copyCss(from, to);
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(NodeStyleModel.class);
            from.removeExtension(NodeSizeModel.class);
            from.removeExtension(NodeBorderModel.class);
            from.removeExtension(NodeCss.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.removeStyleData(key, from, which);
            this.removeSizeData(key, from, which);
            this.removeBorderData(key, from, which);
            this.removeCssData(key, from, which);
        }

        private void removeSizeData(Object key, NodeModel from, NodeModel which) {
            NodeSizeModel whichData = (NodeSizeModel)which.getExtension(NodeSizeModel.class);
            if (whichData == null) {
                return;
            }
            NodeSizeModel fromData = (NodeSizeModel)from.getExtension(NodeSizeModel.class);
            if (fromData == null) {
                return;
            }
            if (null != whichData.getMaxNodeWidth()) {
                fromData.setMaxNodeWidth(null);
            }
            if (null != whichData.getMinNodeWidth()) {
                fromData.setMinNodeWidth(null);
            }
        }

        private void removeBorderData(Object key, NodeModel from, NodeModel which) {
            NodeBorderModel whichData = (NodeBorderModel)which.getExtension(NodeBorderModel.class);
            if (whichData == null) {
                return;
            }
            NodeBorderModel fromData = (NodeBorderModel)from.getExtension(NodeBorderModel.class);
            if (fromData == null) {
                return;
            }
            if (null != whichData.getBorderWidthMatchesEdgeWidth()) {
                fromData.setBorderWidthMatchesEdgeWidth(null);
            }
            if (null != whichData.getBorderWidth()) {
                fromData.setBorderWidth(null);
            }
            if (null != whichData.getBorderDashMatchesEdgeDash()) {
                fromData.setBorderDashMatchesEdgeDash(null);
            }
            if (null != whichData.getBorderDash()) {
                fromData.setBorderDash(null);
            }
            if (null != whichData.getBorderColorMatchesEdgeColor()) {
                fromData.setBorderColorMatchesEdgeColor(null);
            }
            if (null != whichData.getBorderColor()) {
                fromData.setBorderColor(null);
            }
        }

        private void removeStyleData(Object key, NodeModel from, NodeModel which) {
            NodeStyleModel whichStyle = (NodeStyleModel)which.getExtension(NodeStyleModel.class);
            if (whichStyle == null) {
                return;
            }
            NodeStyleModel fromStyle = (NodeStyleModel)from.getExtension(NodeStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            if (null != whichStyle.isBold()) {
                fromStyle.setBold(null);
            }
            if (null != whichStyle.isUnderlined()) {
                fromStyle.setUnderlined(null);
            }
            if (null != whichStyle.isItalic()) {
                fromStyle.setItalic(null);
            }
            if (null != whichStyle.isStrikedThrough()) {
                fromStyle.setStrikedThrough(null);
            }
            if (null != whichStyle.getFontFamilyName()) {
                fromStyle.setFontFamilyName(null);
            }
            if (null != whichStyle.getFontSize()) {
                fromStyle.setFontSize(null);
            }
            if (NodeGeometryModel.NULL_SHAPE != whichStyle.getShapeConfiguration()) {
                fromStyle.setShapeConfiguration(NodeGeometryModel.NULL_SHAPE);
            }
            if (null != whichStyle.getColor()) {
                fromStyle.setColor(null);
            }
            if (null != whichStyle.getBackgroundColor()) {
                fromStyle.setBackgroundColor(null);
            }
            if (null != whichStyle.getNodeFormat()) {
                fromStyle.setNodeFormat(null);
            }
            if (null != whichStyle.getNodeNumbering()) {
                fromStyle.setNodeNumbering(null);
            }
            if (null != whichStyle.getHorizontalTextAlignment()) {
                fromStyle.setHorizontalTextAlignment(null);
            }
            if (null != whichStyle.getTextWritingDirection()) {
                fromStyle.setTextWritingDirection(null);
            }
        }

        private void removeCssData(Object key, NodeModel from, NodeModel which) {
            if (null != which.getExtension(NodeCss.class)) {
                from.removeExtension(NodeCss.class);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.resolveShape(to);
        }

        private void resolveShape(NodeModel to) {
            if (this.hasOwnShape(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                if (!this.hasOwnShape(source)) continue;
                NodeStyleShape shape = this.getShape(source);
                NodeStyleModel.createNodeStyleModel((NodeModel)to).setShape(shape);
                return;
            }
        }

        private boolean hasOwnShape(NodeModel to) {
            return !NodeStyleShape.as_parent.equals((Object)this.getShape(to));
        }

        private NodeStyleShape getShape(NodeModel node) {
            return ((NodeStyleController)this.modeController.getExtension(NodeStyleController.class)).getShape(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        }
    }
}

