/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.presentations.mindmapmode.NamedElement;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;

public class UndoableNamedElementCollection<T extends NamedElement<T>> {
    private final ModeController controller;
    private final MapModel mapModel;
    private final NamedElementCollection<T> collection;

    public static <T extends NamedElement<T>> UndoableNamedElementCollection<T> of(NamedElementCollection<T> collection) {
        return new UndoableNamedElementCollection<T>(Controller.getCurrentModeController(), Controller.getCurrentController().getMap(), collection);
    }

    public UndoableNamedElementCollection(ModeController controller, MapModel mapModel, NamedElementCollection<T> collection) {
        this.controller = controller;
        this.mapModel = mapModel;
        this.collection = collection;
    }

    public void add(final String name) {
        final int currentElementIndex = this.collection.getCurrentElementIndex();
        IActor actor = new IActor(){

            public String getDescription() {
                return "add";
            }

            public void act() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
                UndoableNamedElementCollection.this.collection.add(name);
            }

            public void undo() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex + 1);
                UndoableNamedElementCollection.this.collection.removeCurrentElement();
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void add(T element) {
        final int currentElementIndex = this.collection.getCurrentElementIndex();
        IActor actor = new IActor(){
            final /* synthetic */ NamedElement val$element;
            {
                this.val$element = namedElement;
            }

            public String getDescription() {
                return "add";
            }

            public void act() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
                UndoableNamedElementCollection.this.collection.add(this.val$element);
            }

            public void undo() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex + 1);
                UndoableNamedElementCollection.this.collection.removeCurrentElement();
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void removeCurrentElement() {
        final int currentElementIndex = this.collection.getCurrentElementIndex();
        T removedElement = this.collection.getCurrentElement();
        IActor actor = new IActor(){
            final /* synthetic */ NamedElement val$removedElement;
            {
                this.val$removedElement = namedElement;
            }

            public String getDescription() {
                return "removeCurrentElement";
            }

            public void act() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
                UndoableNamedElementCollection.this.collection.removeCurrentElement();
            }

            public void undo() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex - 1);
                UndoableNamedElementCollection.this.collection.add(this.val$removedElement);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void moveCurrentElementUp() {
        this.moveCurrentElementTo(this.collection.getCurrentElementIndex() - 1);
    }

    public void moveCurrentElementDown() {
        this.moveCurrentElementTo(this.collection.getCurrentElementIndex() + 1);
    }

    public void moveCurrentElementTo(final int newElementIndex) {
        if (!this.collection.canMoveCurrentElementTo(newElementIndex)) {
            return;
        }
        final int oldElementIndex = this.collection.getCurrentElementIndex();
        IActor actor = new IActor(){

            public String getDescription() {
                return "moveCurrentElementTo";
            }

            public void act() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(oldElementIndex);
                UndoableNamedElementCollection.this.collection.moveCurrentElementTo(newElementIndex);
            }

            public void undo() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(newElementIndex);
                UndoableNamedElementCollection.this.collection.moveCurrentElementTo(oldElementIndex);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void copyCurrentElement() {
        final int currentElementIndex = this.collection.getCurrentElementIndex();
        IActor actor = new IActor(){

            public String getDescription() {
                return "copy";
            }

            public void act() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
                UndoableNamedElementCollection.this.collection.copyCurrentElement();
            }

            public void undo() {
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex + 1);
                UndoableNamedElementCollection.this.collection.removeCurrentElement();
                UndoableNamedElementCollection.this.collection.selectCurrentElement(currentElementIndex);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }
}

