/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import org.freeplane.api.swing.JFileChooser;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.features.filepreview.MindMapPreviewWithOptions;

class ReplaceMapStylesAction
extends AFreeplaneAction {
    ReplaceMapStylesAction() {
        super("ReplaceMapStylesAction");
    }

    public void actionPerformed(ActionEvent event) {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        MFileManager fileManager = MFileManager.getController(modeController);
        JFreeplaneCustomizableFileChooser fileChooser = fileManager.getMindMapFileChooser();
        MindMapPreviewWithOptions previewOptions = new MindMapPreviewWithOptions((JFileChooser)fileChooser);
        fileChooser.setAccessory((JComponent)previewOptions);
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showOpenDialog((Component)controller.getMapViewManager().getMapViewComponent());
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (!file.exists()) {
            return;
        }
        try {
            MapModel map = controller.getMap();
            MapStyle mapStyleController = MapStyle.getController((ModeController)modeController);
            mapStyleController.replaceStyles(file, map, previewOptions.isFollowChecked(), previewOptions.isAssociateChecked());
        }
        catch (MalformedURLException e) {
            LogUtils.severe((Throwable)e);
        }
    }
}

