/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application.survey;

import java.io.InputStream;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.freeplane.main.application.ApplicationLifecycleListener;
import org.freeplane.main.application.survey.FreeplaneSurveyProperties;
import org.freeplane.main.application.survey.SurveyRunner;

public class SurveyStarter
implements ApplicationLifecycleListener {
    private static final String SURVEY_ID_KEY = "surveyId";
    private static final String SURVEY_URL_KEY = "surveyUrl";
    private static final String QUESTION_KEY = "question";
    private static final String TITLE_KEY = "title";
    private static final String RUN_ON_KEY = "runOn";
    private static final String FREQUENCY_KEY = "frequency";
    private final FreeplaneSurveyProperties freeplaneSurveyProperties;
    private final SurveyRunner surveyRunner;
    private String surveyId;
    private String title;
    private String question;
    private String surveyUrl;
    private RunningPoint runOn;
    private final double randomNumber;

    public SurveyStarter(FreeplaneSurveyProperties freeplaneSurveyProperties, SurveyRunner surveyRunner, double randomNumber) {
        this.freeplaneSurveyProperties = freeplaneSurveyProperties;
        this.surveyRunner = surveyRunner;
        this.randomNumber = randomNumber;
    }

    @Override
    public void onStartupFinished() {
        this.configureAndRunSurvey();
    }

    Thread configureAndRunSurvey() {
        if (this.freeplaneSurveyProperties.mayAskUserAgain()) {
            this.freeplaneSurveyProperties.setNextSurveyDay(1);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Properties surveyProperties = new Properties();
                    try (InputStream input = SurveyStarter.this.freeplaneSurveyProperties.openRemoteConfiguration();){
                        surveyProperties.load(input);
                        int frequency = Integer.parseInt(surveyProperties.getProperty(SurveyStarter.FREQUENCY_KEY));
                        if (frequency > 0 && SurveyStarter.this.randomNumber < 1.0 / (double)frequency || SurveyStarter.this.freeplaneSurveyProperties.remindMeLaterIsActive()) {
                            SurveyStarter.this.surveyId = surveyProperties.getProperty(SurveyStarter.SURVEY_ID_KEY);
                            SurveyStarter.this.title = surveyProperties.getProperty(SurveyStarter.TITLE_KEY);
                            SurveyStarter.this.question = surveyProperties.getProperty(SurveyStarter.QUESTION_KEY);
                            SurveyStarter.this.surveyUrl = surveyProperties.getProperty(SurveyStarter.SURVEY_URL_KEY);
                            SurveyStarter.this.runOn = RunningPoint.valueOf(surveyProperties.getProperty(SurveyStarter.RUN_ON_KEY, RunningPoint.NEVER.name()));
                        } else {
                            SurveyStarter.this.runOn = RunningPoint.NEVER;
                        }
                    }
                    catch (Exception e) {
                        SurveyStarter.this.runOn = RunningPoint.NEVER;
                    }
                    if (RunningPoint.ON_START == SurveyStarter.this.runOn) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SurveyStarter.this.surveyRunner.runServey(SurveyStarter.this.surveyId, SurveyStarter.this.title, SurveyStarter.this.question, SurveyStarter.this.surveyUrl);
                            }
                        });
                    }
                }
            });
            thread.start();
            return thread;
        }
        return null;
    }

    @Override
    public void onApplicationStopped() {
        if (RunningPoint.ON_QUIT == this.runOn) {
            this.surveyRunner.runServey(this.surveyId, this.title, this.question, this.surveyUrl);
        }
    }

    static enum RunningPoint {
        ON_START,
        ON_QUIT,
        NEVER;

    }
}

