/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public abstract class IdentifierManager
extends AbstractValueManager {
    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                String s = lu.getStringValue().toLowerCase(Locale.ROOT).intern();
                Value v = this.getIdentifiers().get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return v;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lu);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    protected Value createIdentValue(String value, CSSEngine engine) throws DOMException {
        Value v = this.getIdentifiers().get(value.toLowerCase(Locale.ROOT).intern());
        if (v == null) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return v;
    }

    public abstract StringMap<Value> getIdentifiers();
}

