/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.LoremIpsum;
import io.sf.jclf.text.format.ObjectFormat;
import io.sf.jclf.text.format.SpecParsingException;

public class StringFormat
extends ObjectFormat {
    public StringFormat() {
        this.precision = 0;
    }

    @Override
    protected char setFormat(String format) throws SpecParsingException {
        char tipo = super.setFormat(format);
        if (this.precision != 0 && this.width > this.precision) {
            throw new SpecParsingException("Width is greater than precision at a String format");
        }
        return tipo;
    }

    @Override
    public String format(Object o) {
        String s = o instanceof String ? (String)o : (o instanceof String[] ? ((String[])o)[0] : o.toString());
        int buflen = s.length();
        if (this.precision > buflen) {
            buflen = this.precision;
        }
        StringBuilder sb = new StringBuilder(buflen + 20);
        if (this.ralign) {
            this.rightAppend(sb, s, ' ', this.width, this.precision);
        } else {
            this.leftAppend(sb, s, ' ', this.width, this.precision);
        }
        return sb.toString();
    }

    private void leftAppend(StringBuilder sb, String s, char fillchar, int minchars, int maxchars) {
        int len = s.length();
        if (minchars != 0 && len < minchars) {
            int l = minchars - len;
            sb.append(s);
            for (int i = 0; i < l; ++i) {
                sb.append(fillchar);
            }
            return;
        }
        if (maxchars == 0 || len <= maxchars) {
            sb.append(s);
            return;
        }
        sb.append(s.substring(0, maxchars));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(10);
        if (!this.ralign) {
            sb.append('-');
        }
        if (this.width != 0) {
            sb.append(this.width);
        }
        if (this.precision > 0 && this.width != this.precision) {
            sb.append('.').append(this.precision);
        }
        if (sb.length() > 0) {
            sb.append('s');
        }
        return sb.toString();
    }

    @Override
    public Object sample() {
        if (this.precision > 0) {
            return new LoremIpsum().toString(this.precision);
        }
        return new LoremIpsum().toString(this.width * 2 + 8);
    }
}

