/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.StringList;
import io.sf.carte.doc.WrapperStringList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;

class CSSDOMConfiguration
implements DOMConfiguration,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> configParameters = new HashMap<String, Object>();
    boolean cssWhitespaceProcessing = true;
    boolean normalizeCharacters = false;
    boolean keepComments = true;
    boolean useComputedStyles = false;

    CSSDOMConfiguration() {
        this.configParameters.put("css-whitespace-processing", this.cssWhitespaceProcessing);
        this.configParameters.put("use-computed-styles", this.useComputedStyles);
        this.configParameters.put("comments", this.keepComments);
        this.configParameters.put("normalize-characters", this.normalizeCharacters);
    }

    @Override
    public boolean canSetParameter(String name, Object value) {
        if (name.equals("css-whitespace-processing") || name.equals("normalize-characters") || name.equals("comments") || name.equals("use-computed-styles") || name.equals("well-formed")) {
            return value instanceof Boolean;
        }
        if (value instanceof Boolean) {
            if (!((Boolean)value).booleanValue()) {
                return name.equals("canonical-form") || name.equals("check-character-normalization") || name.equals("datatype-normalization") || name.equals("validate") || name.equals("validate-if-schema");
            }
            return name.equals("element-content-whitespace") || name.equals("cdata-sections") || name.equals("namespaces") || name.equals("namespace-declarations");
        }
        return false;
    }

    @Override
    public Object getParameter(String name) throws DOMException {
        return this.configParameters.get(name);
    }

    @Override
    public StringList getParameterNames() {
        return new WrapperStringList(this.configParameters.keySet());
    }

    @Override
    public void setParameter(String name, Object value) throws DOMException {
        if (this.canSetParameter(name, value)) {
            if (name.equals("css-whitespace-processing")) {
                this.cssWhitespaceProcessing = (Boolean)value;
            } else if (name.equals("normalize-characters")) {
                this.normalizeCharacters = (Boolean)value;
            } else if (name.equals("comments")) {
                this.keepComments = (Boolean)value;
            } else if (name.equals("use-computed-styles")) {
                this.useComputedStyles = (Boolean)value;
            }
            this.configParameters.put(name, value);
        }
    }
}

