/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Locale;

class BorderImageShorthandSetter
extends ShorthandSetter {
    BorderImageShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "border-image");
    }

    @Override
    public short assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return 0;
        }
        if (kwscan == 2) {
            return 2;
        }
        boolean errorFound = false;
        boolean bisourceUnset = true;
        boolean bisliceUnset = true;
        boolean biwidthUnset = true;
        boolean bioutsetUnset = true;
        boolean birepeatUnset = true;
        while (this.currentValue != null) {
            StyleDeclarationErrorHandler errHandler;
            block32: {
                block31: {
                    int c;
                    ValueList list;
                    LexicalUnit.LexicalType lut;
                    block33: {
                        if (this.isImage()) {
                            this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                            bisourceUnset = false;
                            this.nextCurrentValue();
                            continue;
                        }
                        lut = this.currentValue.getLexicalUnitType();
                        if (lut == LexicalUnit.LexicalType.IDENT) {
                            if (this.testIdentifiers("border-image-repeat")) {
                                this.setSubpropertyValue("border-image-repeat", this.createCSSValue("border-image-repeat", this.currentValue));
                                birepeatUnset = false;
                            } else if ("none".equalsIgnoreCase(this.currentValue.getStringValue())) {
                                this.setSubpropertyValue("border-image-source", this.createCSSValue("border-image-source", this.currentValue));
                                bisourceUnset = false;
                            } else if ("auto".equalsIgnoreCase(this.currentValue.getStringValue())) {
                                this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                                biwidthUnset = false;
                            } else {
                                if (this.isPrefixedIdentValue()) {
                                    this.setPrefixedValue(this.currentValue);
                                    this.flush();
                                    return 1;
                                }
                                errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                                if (errHandler != null) {
                                    errHandler.unknownIdentifier("border-image", this.currentValue.getStringValue());
                                }
                                errorFound = true;
                            }
                            this.nextCurrentValue();
                            continue;
                        }
                        if (!ValueFactory.isPercentageOrNumberSACUnit(this.currentValue)) break block31;
                        list = ValueList.createWSValueList();
                        do {
                            list.add(this.createCSSValue("border-image-slice", this.currentValue));
                            this.nextCurrentValue();
                        } while (this.currentValue != null && (lut = this.currentValue.getLexicalUnitType()) != LexicalUnit.LexicalType.OPERATOR_SLASH && lut != LexicalUnit.LexicalType.IDENT);
                        this.setSubpropertyValue("border-image-slice", list);
                        bisliceUnset = false;
                        if (this.currentValue == null) break block32;
                        if (lut == LexicalUnit.LexicalType.IDENT) {
                            if (!"fill".equals(this.currentValue.getStringValue().toLowerCase(Locale.ROOT))) continue;
                            list.add(this.createCSSValue("border-image-slice", this.currentValue));
                            this.nextCurrentValue();
                            if (this.currentValue == null) break;
                            lut = this.currentValue.getLexicalUnitType();
                        }
                        if (lut != LexicalUnit.LexicalType.OPERATOR_SLASH) break block32;
                        this.nextCurrentValue();
                        lut = this.currentValue.getLexicalUnitType();
                        if (lut == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            this.nextCurrentValue();
                            if (!ValueFactory.isLengthOrNumberSACUnit(this.currentValue)) {
                                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.PREFIXED_FUNCTION) {
                                    this.setPrefixedValue(this.currentValue);
                                    this.flush();
                                    return 1;
                                }
                                StyleDeclarationErrorHandler errHandler2 = this.styleDeclaration.getStyleDeclarationErrorHandler();
                                if (errHandler2 == null) break;
                                CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for border-image: expected width / outset");
                                ex.setValueText(BaseCSSStyleDeclaration.lexicalUnitToString(this.currentValue));
                                errHandler2.wrongValue("border-image", ex);
                                errorFound = true;
                                break;
                            }
                            list = ValueList.createWSValueList();
                            c = 0;
                            while (ValueFactory.isLengthOrNumberSACUnit(this.currentValue)) {
                                list.add(this.createCSSValue("border-image-outset", this.currentValue));
                                this.nextCurrentValue();
                                c = (byte)(c + 1);
                                if (this.currentValue != null && c < 4) continue;
                            }
                            if (list.getLength() == 0) continue;
                            this.setSubpropertyValue("border-image-outset", list);
                            bioutsetUnset = false;
                            continue;
                        }
                        if (lut != LexicalUnit.LexicalType.IDENT) break block33;
                        if (!"auto".equalsIgnoreCase(this.currentValue.getStringValue())) continue;
                        this.setSubpropertyValue("border-image-width", this.createCSSValue("border-image-width", this.currentValue));
                        biwidthUnset = false;
                        this.nextCurrentValue();
                        break block32;
                    }
                    c = 0;
                    list = ValueList.createWSValueList();
                    while (ValueFactory.isSizeOrNumberSACUnit(this.currentValue)) {
                        list.add(this.createCSSValue("border-image-width", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        lut = this.currentValue.getLexicalUnitType();
                        c = (byte)(c + 1);
                        if (lut != LexicalUnit.LexicalType.OPERATOR_SLASH && lut != LexicalUnit.LexicalType.IDENT && c < 4) continue;
                    }
                    if (list.getLength() != 0) {
                        this.setSubpropertyValue("border-image-width", list);
                        biwidthUnset = false;
                    }
                    if (lut != LexicalUnit.LexicalType.OPERATOR_SLASH) break block32;
                    this.nextCurrentValue();
                    if (this.currentValue == null) break;
                    list = ValueList.createWSValueList();
                    while (ValueFactory.isLengthOrNumberSACUnit(this.currentValue) && c < 4) {
                        list.add(this.createCSSValue("border-image-outset", this.currentValue));
                        this.nextCurrentValue();
                        if (this.currentValue == null) break;
                        c = (byte)(c + 1);
                    }
                    if (list.getLength() == 0) break block32;
                    this.setSubpropertyValue("border-image-outset", list);
                    bioutsetUnset = false;
                    break block32;
                }
                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.PREFIXED_FUNCTION) {
                    this.setPrefixedValue(this.currentValue);
                    this.flush();
                    return 1;
                }
                errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
                if (errHandler != null) {
                    errHandler.unassignedShorthandValue("border-image", this.currentValue.toString());
                }
                errorFound = true;
                break;
            }
            if (bisourceUnset || bisliceUnset || biwidthUnset || bioutsetUnset || birepeatUnset || this.currentValue == null) continue;
            errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (errHandler != null) {
                errHandler.shorthandError("border-image", "Unexpected value: " + this.currentValue.toString());
            }
            errorFound = true;
            break;
        }
        if (errorFound) {
            return 2;
        }
        if (bisourceUnset) {
            this.setSubpropertyValue("border-image-source", this.defaultPropertyValue("border-image-source"));
        }
        if (bisliceUnset) {
            this.setSubpropertyValue("border-image-slice", this.defaultPropertyValue("border-image-slice"));
        }
        if (biwidthUnset) {
            this.setSubpropertyValue("border-image-width", this.defaultPropertyValue("border-image-width"));
        }
        if (bioutsetUnset) {
            this.setSubpropertyValue("border-image-outset", this.defaultPropertyValue("border-image-outset"));
        }
        if (birepeatUnset) {
            this.setSubpropertyValue("border-image-repeat", this.defaultPropertyValue("border-image-repeat"));
        }
        this.flush();
        return 0;
    }
}

