/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Locale;
import java.util.Set;

class GenericShorthandBuilder
extends ShorthandBuilder {
    final String initialvalue;

    GenericShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue) {
        super(shorthandName, parentStyle);
        this.initialvalue = initialvalue;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        if (this.isInheritedProperty()) {
            check = this.checkValuesForType(CSSValue.Type.UNSET, declaredSet);
            if (check == 1) {
                buf.append("unset");
                this.appendPriority(buf, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
        }
        if ((check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet)) == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
            return 1;
        }
        return this.appendPostKeywordShorthandValues(buf, declaredSet, important);
    }

    int appendPostKeywordShorthandValues(StringBuilder buf, Set<String> declaredSet, boolean important) {
        String[] subp;
        BufferSimpleWriter wri = new BufferSimpleWriter(buf);
        DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
        boolean appended = false;
        for (String property : subp = this.getLonghandProperties()) {
            if (!declaredSet.contains(property) || this.isResetProperty(property)) continue;
            StyleValue cssVal = this.getCSSValue(property);
            if (cssVal.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)cssVal).isCommaSeparated() || this.invalidValueClash(declaredSet, property, cssVal)) {
                return 1;
            }
            appended = this.appendValueText(wri, context, property, appended);
        }
        if (!appended) {
            buf.append(this.initialvalue);
        }
        this.appendPriority(buf, important);
        this.endShorthandSerialization(wri, context, important);
        return 0;
    }

    boolean isResetProperty(String property) {
        return false;
    }

    boolean invalidValueClash(Set<String> declaredSet, String property, StyleValue cssVal) {
        if (cssVal.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)cssVal;
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.invalidValueClash(declaredSet, property, list.item(i))) continue;
                return true;
            }
        } else {
            if (cssVal.getCssValueType() == CSSValue.CssType.TYPED) {
                return this.invalidPrimitiveValueClash(declaredSet, property, (TypedValue)cssVal);
            }
            if (cssVal.getCssValueType() != CSSValue.CssType.KEYWORD) {
                return true;
            }
        }
        return false;
    }

    boolean invalidPrimitiveValueClash(Set<String> declaredSet, String propertyName, TypedValue primi) {
        if (primi.getPrimitiveType() == CSSValue.Type.IDENT) {
            return this.invalidIdentValueClash(declaredSet, propertyName, primi);
        }
        return false;
    }

    boolean invalidIdentValueClash(Set<String> declaredSet, String propertyName, TypedValue primi) {
        String ident = primi.getStringValue().toLowerCase(Locale.ROOT);
        if (!GenericShorthandBuilder.getShorthandDatabase().isIdentifierValue(propertyName, ident) && !ident.equals(this.initialvalue)) {
            if (this.identifierValuesAreKnown(propertyName) || GenericShorthandBuilder.containsControl(ident)) {
                return true;
            }
            for (String property : declaredSet) {
                if (!GenericShorthandBuilder.getShorthandDatabase().hasKnownIdentifierValues(property) || !GenericShorthandBuilder.getShorthandDatabase().isIdentifierValue(property, ident)) continue;
                return true;
            }
        }
        return false;
    }

    boolean identifierValuesAreKnown(String propertyName) {
        return GenericShorthandBuilder.getShorthandDatabase().hasKnownIdentifierValues(propertyName);
    }

    boolean appendValueText(BufferSimpleWriter wri, DeclarationFormattingContext context, String property, boolean appended) {
        return this.appendValueIfNotInitial(wri, context, property, appended);
    }

    @Override
    boolean isInheritedProperty() {
        String ptyname = this.getLonghandProperties()[0];
        return PropertyDatabase.getInstance().isInherited(ptyname);
    }

    void endShorthandSerialization(BufferSimpleWriter wri, DeclarationFormattingContext context, boolean importantShorthand) {
    }
}

