/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;

class GridPlacementShorthandBuilder
extends ShorthandBuilder {
    GridPlacementShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle) {
        super(shorthandName, parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 2;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        check = this.checkValuesForType(CSSValue.Type.UNSET, declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return 0;
        }
        check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet);
        if (check == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
            return 1;
        }
        String[] subp = this.getSubproperties();
        StyleValue cssVal0 = this.getCSSValue(subp[0]);
        if (cssVal0.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)cssVal0).isCommaSeparated()) {
            return 1;
        }
        this.appendValueText(buf, cssVal0);
        if (subp.length == 2) {
            StyleValue cssVal = this.getCSSValue(subp[1]);
            if (this.isPrintValue(subp[1], cssVal, cssVal0)) {
                buf.append('/');
                this.appendValueText(buf, cssVal);
            }
        } else {
            boolean p2;
            StyleValue cssVal3 = this.getCSSValue(subp[3]);
            StyleValue cssVal2 = this.getCSSValue(subp[2]);
            StyleValue cssVal1 = this.getCSSValue(subp[1]);
            boolean p3 = this.isPrintValue(subp[3], cssVal3, cssVal1);
            boolean bl = p2 = this.isPrintValue(subp[2], cssVal2, cssVal0) || p3;
            if (this.isPrintValue(subp[1], cssVal1, cssVal0) || p2) {
                buf.append('/');
                this.appendValueText(buf, cssVal1);
                if (p2) {
                    buf.append('/');
                    this.appendValueText(buf, cssVal2);
                    if (p3) {
                        buf.append('/');
                        this.appendValueText(buf, cssVal3);
                    }
                }
            }
        }
        this.appendPriority(buf, important);
        return 0;
    }

    private boolean isPrintValue(String propertyName, StyleValue cssValue, StyleValue cssVal0) {
        if (cssValue.getCssValueType() != CSSValue.CssType.KEYWORD) {
            if (cssValue.getPrimitiveType() != CSSValue.Type.IDENT) {
                return true;
            }
            if (cssVal0.getPrimitiveType() == CSSValue.Type.IDENT) {
                return !this.valueEquals(cssVal0, cssValue);
            }
        }
        return this.isNotInitialValue(cssValue, propertyName) && this.isNotInitialValue(cssVal0, propertyName);
    }

    @Override
    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !this.isEffectiveInitialKeyword(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(StringBuilder buf, StyleValue cssVal) {
        if (!this.isEffectiveInitialKeyword(cssVal)) {
            buf.append(cssVal.getMinifiedCssText(this.getShorthandName()));
        } else {
            buf.append("auto");
        }
    }
}

