/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.BooleanConditionFactory;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaFeaturePredicate;
import io.sf.carte.doc.style.css.MediaQueryFactory;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SupportsConditionFactory;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSMediaParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.DeclarationPredicate;
import io.sf.carte.doc.style.css.nsac.InputSource;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SheetContext;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.parser.AbstractCondition;
import io.sf.carte.doc.style.css.parser.AbstractPageSelector;
import io.sf.carte.doc.style.css.parser.AbstractSelector;
import io.sf.carte.doc.style.css.parser.AnBExpression;
import io.sf.carte.doc.style.css.parser.BufferTokenHandler;
import io.sf.carte.doc.style.css.parser.CSSTokenHandler;
import io.sf.carte.doc.style.css.parser.CombinatorConditionImpl;
import io.sf.carte.doc.style.css.parser.CommentStore;
import io.sf.carte.doc.style.css.parser.ConditionSetterFactory;
import io.sf.carte.doc.style.css.parser.ConditionalSelectorImpl;
import io.sf.carte.doc.style.css.parser.ControlTokenHandler;
import io.sf.carte.doc.style.css.parser.EmptyCommentStore;
import io.sf.carte.doc.style.css.parser.HandlerManager;
import io.sf.carte.doc.style.css.parser.IdentCharacterCheck;
import io.sf.carte.doc.style.css.parser.LangConditionImpl;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MediaFeaturePredicateUnit;
import io.sf.carte.doc.style.css.parser.MediaQueryDatabase;
import io.sf.carte.doc.style.css.parser.NSACMediaQueryFactory;
import io.sf.carte.doc.style.css.parser.NSACSelectorFactory;
import io.sf.carte.doc.style.css.parser.NestingCondition;
import io.sf.carte.doc.style.css.parser.PageSelectorListImpl;
import io.sf.carte.doc.style.css.parser.PageTypeSelector;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoPageSelector;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorListImpl;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.parser.URLTokenHandler;
import io.sf.carte.doc.style.css.parser.ValueTokenHandler;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.uparser.ContentHandler;
import io.sf.carte.uparser.ControlHandler;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenErrorHandler;
import io.sf.carte.uparser.TokenProducer;
import io.sf.carte.uparser.TokenProducer3;
import io.sf.carte.util.agent.AgentUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class CSSParser
implements Parser,
Cloneable {
    private CSSHandler handler;
    private CSSErrorHandler errorHandler;
    private final EnumSet<Parser.Flag> parserFlags;
    private int streamSizeLimit = 0x6000000;

    public CSSParser() {
        this.parserFlags = EnumSet.noneOf(Parser.Flag.class);
        this.handler = null;
        this.errorHandler = null;
    }

    public CSSParser(EnumSet<Parser.Flag> parserFlags) {
        this.parserFlags = parserFlags;
    }

    protected CSSParser(CSSParser copyMe) {
        this.parserFlags = copyMe.parserFlags;
        this.handler = copyMe.handler;
        this.errorHandler = copyMe.errorHandler;
    }

    @Override
    public void setDocumentHandler(CSSHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setErrorHandler(CSSErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFlag(Parser.Flag flag) {
        this.parserFlags.add(flag);
    }

    @Override
    public void unsetFlag(Parser.Flag flag) {
        this.parserFlags.remove((Object)flag);
    }

    public void setStreamSizeLimit(int streamSizeLimit) {
        if (streamSizeLimit < 65536) {
            throw new IllegalArgumentException("Limit too low.");
        }
        this.streamSizeLimit = streamSizeLimit;
    }

    @Override
    public void parseStyleSheet(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        Parser.NamespaceMap nsMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            nsMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        RuleListManager manager = new RuleListManager(nsMap, true);
        TokenProducer tp = manager.createTokenProducer();
        tp.setAcceptEofEndingQuoted(true);
        manager.parseStart();
        tp.parse(reader, "/*", "*/");
    }

    @Override
    public void parseStyleSheet(String uri) throws CSSParseException, IOException, IllegalStateException {
        URL url;
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        try {
            url = new URI(uri).toURL();
        }
        catch (Exception e) {
            throw new MalformedURLException(e.getMessage());
        }
        URLConnection ucon = url.openConnection();
        ucon.setConnectTimeout(15000);
        ucon.connect();
        InputStream is = ucon.getInputStream();
        is = new BufferedInputStream(is);
        String contentEncoding = ucon.getContentEncoding();
        String conType = ucon.getContentType();
        if (CSSUtil.isInvalidCSSContentType(url, conType) && !this.isRedirect(ucon)) {
            String msg;
            if (conType != null) {
                conType = conType.replaceAll("\\p{Cc}", "*CTRL*");
                msg = "Style sheet at " + url.toExternalForm() + " served with invalid type (" + conType + ").";
            } else {
                msg = "Style sheet at " + url.toExternalForm() + " has no valid content type.";
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(msg);
        }
        Parser.NamespaceMap nsMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            nsMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        RuleListManager manager = new RuleListManager(nsMap, false);
        TokenProducer tp = manager.createTokenProducer();
        tp.setAcceptEofEndingQuoted(true);
        try (Reader re = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)StandardCharsets.UTF_8);){
            manager.parseStart();
            tp.parse(re, "/*", "*/");
        }
    }

    private boolean isRedirect(URLConnection ucon) {
        if (ucon instanceof HttpURLConnection) {
            try {
                int code = ((HttpURLConnection)ucon).getResponseCode();
                return code > 300 && code < 400 && code != 304;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void parseStyleSheet(InputSource source) throws CSSParseException, IOException, IllegalStateException, IllegalArgumentException {
        if (source == null) {
            throw new NullPointerException("Null source.");
        }
        Reader re = source.getCharacterStream();
        if (re == null) {
            InputStream is = source.getByteStream();
            if (is == null) {
                String uri = source.getURI();
                if (uri == null) {
                    throw new IllegalArgumentException("Null character stream");
                }
                this.parseStyleSheet(uri);
                return;
            }
            String charset = source.getEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            re = new InputStreamReader(is, charset);
        }
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        Parser.NamespaceMap nsMap = null;
        if (this.handler instanceof Parser.NamespaceMap) {
            nsMap = (Parser.NamespaceMap)((Object)this.handler);
        }
        RuleListManager manager = new RuleListManager(nsMap, true);
        TokenProducer tp = manager.createTokenProducer();
        tp.setAcceptEofEndingQuoted(true);
        manager.parseStart();
        tp.parse(re, "/*", "*/");
    }

    @Override
    public void parseStyleDeclaration(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationListManager manager = new DeclarationListManager();
        TokenProducer tp = manager.createTokenProducer();
        manager.parseStart();
        tp.parse(reader, "/*", "*/");
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        DeclarationListManager manager = new DeclarationListManager();
        TokenProducer tp = manager.createTokenProducer();
        Reader reader = this.getReaderFromSource(source);
        manager.parseStart();
        tp.parse(reader, "/*", "*/");
    }

    private Reader getReaderFromSource(InputSource source) throws IOException {
        if (source == null) {
            throw new NullPointerException("Null source.");
        }
        Reader re = source.getCharacterStream();
        if (re == null) {
            InputStream is = source.getByteStream();
            if (is != null) {
                String encoding = source.getEncoding();
                Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
                re = new InputStreamReader(is, charset);
            } else {
                String uri = source.getURI();
                if (uri != null) {
                    URL url;
                    try {
                        url = new URI(uri).toURL();
                    }
                    catch (Exception e) {
                        throw new MalformedURLException(e.getMessage());
                    }
                    URLConnection con = url.openConnection();
                    con.setConnectTimeout(30000);
                    con.connect();
                    is = con.getInputStream();
                    is = new BufferedInputStream(is);
                    String contentEncoding = con.getContentEncoding();
                    String conType = con.getContentType();
                    String encoding = source.getEncoding();
                    Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
                    re = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)charset);
                }
            }
        }
        return re;
    }

    public void parseDeclarationRule(Reader reader) throws CSSParseException, IOException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        if (!(this.handler instanceof DeclarationRuleHandler)) {
            throw new IllegalStateException("Document handler needs to implement DeclarationRuleHandler.");
        }
        GenericBlockAtRuleManager manager = new GenericBlockAtRuleManager();
        TokenProducer tp = ((HandlerManager)manager).createTokenProducer();
        ((HandlerManager)manager).parseStart();
        tp.parse(reader, "/*", "*/");
    }

    public PageSelectorList parsePageSelectorList(String pageSelectorStr) throws DOMException {
        if (pageSelectorStr == null) {
            throw new NullPointerException("Null page selector");
        }
        PageSelectorListImpl list = new PageSelectorListImpl();
        StringTokenizer commast = new StringTokenizer(pageSelectorStr, ",");
        while (commast.hasMoreTokens()) {
            String selstr = commast.nextToken();
            selstr = ParseHelper.unescapeStringValue(selstr, true, false);
            StringTokenizer st = new StringTokenizer(selstr, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                AbstractPageSelector psitem = this.parsePageSelector(s);
                if (psitem != null) {
                    list.add(psitem);
                    continue;
                }
                throw new DOMSyntaxException("Invalid page selector: " + s);
            }
        }
        return list;
    }

    private AbstractPageSelector parsePageSelector(String s) {
        AbstractPageSelector psitem = null;
        AbstractPageSelector ps = null;
        int colonidx = s.indexOf(58);
        if (colonidx == -1) {
            return new PageTypeSelector(s);
        }
        if (colonidx != 0) {
            String pts = s.substring(0, colonidx);
            if (!CSSUtil.isValidIdentifier(pts)) {
                return null;
            }
            psitem = ps = new PageTypeSelector(pts);
        }
        ++colonidx;
        int len = s.length();
        while (colonidx < len) {
            String pp;
            int nextColonIdx = s.indexOf(58, colonidx);
            if (nextColonIdx == colonidx) {
                return null;
            }
            if (nextColonIdx == -1) {
                pp = s.substring(colonidx).toLowerCase(Locale.ROOT);
                colonidx = len;
            } else {
                pp = s.substring(colonidx, nextColonIdx).toLowerCase(Locale.ROOT);
                colonidx = nextColonIdx + 1;
            }
            if (this.containsOnlyLcLetters(pp)) {
                PseudoPageSelector pps = new PseudoPageSelector(pp);
                if (ps != null) {
                    ps.setNextSelector(pps);
                } else {
                    psitem = pps;
                }
                ps = pps;
                continue;
            }
            return null;
        }
        return psitem;
    }

    private boolean containsOnlyLcLetters(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    @Override
    public void parseRule(Reader reader) throws CSSParseException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleManager manager = new RuleManager(null);
        TokenProducer tp = manager.createTokenProducer();
        manager.parseStart();
        tp.parse(reader, "/*", "*/");
    }

    @Override
    public void parseRule(Reader reader, Parser.NamespaceMap nsmap) throws CSSParseException, IOException, IllegalStateException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleManager manager = new RuleManager(nsmap);
        TokenProducer tp = manager.createTokenProducer();
        manager.parseStart();
        tp.parse(reader, "/*", "*/");
    }

    public void parseRule(InputSource source) throws CSSParseException, IOException {
        if (this.handler == null) {
            throw new IllegalStateException("No document handler was set.");
        }
        RuleManager manager = new RuleManager(null);
        TokenProducer tp = manager.createTokenProducer();
        Reader re = this.getReaderFromSource(source);
        manager.parseStart();
        tp.parse(re, "/*", "*/");
    }

    public void parsePageRuleBody(String blockList) throws CSSParseException {
        PageManager manager = new PageManager();
        TokenProducer tp = manager.createTokenProducer();
        manager.parseStart();
        tp.parse(blockList, "/*", "*/");
    }

    public void parseKeyFramesBody(String blockList) throws CSSParseException {
        KeyframesManager manager = new KeyframesManager();
        TokenProducer tp = manager.createTokenProducer();
        manager.parseStart();
        tp.parse(blockList, "/*", "*/");
    }

    public void parseFontFeatureValuesBody(String blockList) throws CSSParseException {
        FontFeatureValuesManager manager = new FontFeatureValuesManager();
        TokenProducer tp = manager.createTokenProducer();
        manager.parseStart();
        tp.parse(blockList, "/*", "*/");
    }

    public BooleanCondition parseSupportsCondition(String conditionText, CSSRule rule) throws CSSParseException, CSSBudgetException {
        AbstractCSSStyleSheet parentStyleSheet = null;
        if (rule != null) {
            parentStyleSheet = (AbstractCSSStyleSheet)rule.getParentStyleSheet();
        }
        return this.parseSupportsCondition(conditionText, rule, parentStyleSheet);
    }

    public BooleanCondition parseSupportsCondition(String conditionText, CSSRule rule, SheetContext parentStyleSheet) throws CSSParseException, CSSBudgetException {
        SupportsManager manager = new SupportsManager(rule, parentStyleSheet);
        TokenProducer tp = manager.createTokenProducer();
        try {
            tp.parse(conditionText, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            throw new CSSBudgetException("Nested conditions exceed limit", e);
        }
        SupportsTokenHandler supportsHandler = manager.getInitialTokenHandler();
        if (supportsHandler.errorCode == 0) {
            return supportsHandler.getCondition();
        }
        return null;
    }

    protected SupportsConditionFactory createSupportsConditionFactory(SheetContext parentSheet) {
        return new io.sf.carte.doc.style.css.om.SupportsConditionFactory(parentSheet);
    }

    @Override
    public void parseMediaQueryList(String media, MediaQueryFactory queryFactory, MediaQueryHandler mqhandler) throws CSSBudgetException {
        MediaQueryManager manager = new MediaQueryManager(queryFactory, mqhandler);
        this.parseMediaQueryList(media, manager, mqhandler);
    }

    private void parseMediaQueryList(String media, MediaQueryManager manager, MediaQueryHandler mqhandler) throws CSSBudgetException {
        TokenProducer tp = manager.createTokenProducer();
        mqhandler.startQuery();
        try {
            tp.parse(media, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            CSSParseException ex = manager.getInitialTokenHandler().createException(0, (byte)127, "Nested queries exceed limit.");
            ex.initCause(e);
            mqhandler.invalidQuery(ex);
            throw new CSSBudgetException("Nested queries exceed limit", e);
        }
    }

    @Override
    public MediaQueryList parseMediaQueryList(String media, Node owner) throws CSSBudgetException {
        MediaQueryFactory mediaQueryFactory = this.getMediaQueryFactory();
        MediaQueryHandler mqhandler = mediaQueryFactory.createMediaQueryHandler(owner);
        MediaQueryManager manager = new MediaQueryManager(mediaQueryFactory, mqhandler);
        TokenProducer tp = manager.createTokenProducer();
        mqhandler.startQuery();
        try {
            tp.parse(media, "/*", "*/");
        }
        catch (IndexOutOfBoundsException e) {
            CSSParseException ex = manager.getInitialTokenHandler().createException(0, (byte)127, "Nested queries exceed limit.");
            ex.initCause(e);
            mqhandler.invalidQuery(ex);
            throw new CSSBudgetException("Nested queries exceed limit", e);
        }
        return mqhandler.getMediaQueryList();
    }

    protected MediaQueryFactory getMediaQueryFactory() {
        return new NSACMediaQueryFactory();
    }

    private static boolean isKnownFeature(String string) {
        return string.startsWith("min-") || string.startsWith("max-") || MediaQueryDatabase.isMediaFeature(string) || string.startsWith("device-");
    }

    private static boolean isValidFeatureSyntax(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public SelectorList parseSelectors(Reader reader) throws CSSParseException, CSSBudgetException, IOException {
        SelectorManager manager = new SelectorManager();
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(reader, "/*", "*/");
        return manager.getTrimmedSelectorList();
    }

    @Override
    public SelectorList parseSelectors(String selectorText, Parser.NamespaceMap nsmap) throws CSSParseException {
        SelectorManager manager = new SelectorManager(nsmap);
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(selectorText);
        return manager.getTrimmedSelectorList();
    }

    public SelectorList parseSelectors(InputSource source) throws CSSParseException, IOException {
        Reader re = this.getReaderFromSource(source);
        SelectorManager manager = new SelectorManager();
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(re, "/*", "*/");
        return manager.getTrimmedSelectorList();
    }

    public SelectorList parseSelectors(String seltext) throws CSSException {
        SelectorManager manager = new SelectorManager();
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(seltext, "/*", "*/");
        return manager.getTrimmedSelectorList();
    }

    private SelectorList parseSelectors(String seltext, NSACSelectorFactory factory) throws CSSParseException {
        SelectorManager manager = new SelectorManager(factory);
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(seltext);
        return manager.getTrimmedSelectorList();
    }

    @Override
    public Condition parsePseudoElement(String pseudoElement) throws CSSException {
        Selector sel;
        SelectorList peList = this.parseSelectors(pseudoElement);
        if (peList.getLength() == 1 && (sel = peList.item(0)).getSelectorType() == Selector.SelectorType.CONDITIONAL) {
            Condition cond = ((ConditionalSelector)sel).getCondition();
            Condition.ConditionType condType = cond.getConditionType();
            block0 : switch (condType) {
                case PSEUDO_ELEMENT: {
                    return cond;
                }
                case AND: {
                    CombinatorCondition comb = (CombinatorCondition)cond;
                    int len = comb.getLength();
                    for (int i = 0; i < len; ++i) {
                        Condition condItem = comb.getCondition(i);
                        if (condItem.getConditionType() != Condition.ConditionType.PSEUDO_ELEMENT) break block0;
                    }
                    return cond;
                }
            }
        }
        throw new CSSException("Not a pseudo-element: " + pseudoElement);
    }

    @Override
    public LexicalUnit parsePropertyValue(Reader reader) throws CSSParseException, IOException {
        DeclarationValueManager manager = new DeclarationValueManager();
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(reader, "/*", "*/");
        return manager.getLexicalUnit();
    }

    private LexicalUnit parsePropertyValue(Reader reader, final HandlerManager parent, final int index) throws CSSParseException, IOException {
        DeclarationValueManager manager = new DeclarationValueManager(){

            @Override
            protected ControlTokenHandler createControlTokenHandler() {
                return new ChildControlTokenHandler(parent.getControlHandler(), index);
            }
        };
        manager.getControlHandler().setCurrentLocation(index);
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(reader, "/*", "*/");
        return manager.getLexicalUnit();
    }

    public LexicalUnit parsePropertyValue(String propertyName, Reader reader) throws CSSParseException, IOException {
        DeclarationValueManager manager = new DeclarationValueManager(propertyName);
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(reader, "/*", "*/");
        return manager.getLexicalUnit();
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws CSSParseException, IOException {
        Reader re = this.getReaderFromSource(source);
        DeclarationValueManager manager = new DeclarationValueManager();
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(re, "/*", "*/");
        return manager.getLexicalUnit();
    }

    @Override
    public boolean parsePriority(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        int cp = reader.read();
        if (cp != -1) {
            int count = 0;
            StringBuilder buf = new StringBuilder(9);
            int parsingWord = 0;
            if (CSSParser.isNotSeparator(cp)) {
                buf.appendCodePoint(cp);
                parsingWord = 1;
                count = 1;
            }
            while ((cp = reader.read()) != -1 && parsingWord != 2) {
                if (CSSParser.isNotSeparator(cp)) {
                    buf.appendCodePoint(cp);
                    count = (short)(count + 1);
                    if (count == 10) {
                        return false;
                    }
                    parsingWord = 1;
                    continue;
                }
                if (parsingWord != 1) continue;
                parsingWord = 2;
            }
            return "important".equals(buf.toString().toLowerCase(Locale.ROOT));
        }
        return false;
    }

    static boolean bufferEndsWithEscapedCharOrWS(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len > 1 && (ParseHelper.isHexCodePoint(bufCp = buffer.codePointAt(len - 1)) || bufCp == 32)) {
            for (int i = 2; i <= Math.min(len, 6); ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (ParseHelper.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    static boolean bufferEndsWithEscapedChar(StringBuilder buffer) {
        int bufCp;
        int len = buffer.length();
        if (len > 1 && ParseHelper.isHexCodePoint(bufCp = buffer.codePointAt(len - 1))) {
            for (int i = 2; i <= Math.min(len, 6); ++i) {
                bufCp = buffer.codePointAt(len - i);
                if (ParseHelper.isHexCodePoint(bufCp)) continue;
                if (bufCp != 92) break;
                return true;
            }
        }
        return false;
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isNotSeparator(int cp) {
        return cp != 32 && cp != 9 && cp != 10 && cp != 12 && cp != 13;
    }

    private static boolean equalSequences(CharSequence seq1, CharSequence seq2) {
        int len = seq1.length();
        if (len != seq2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (seq1.charAt(i) == seq2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static String safeUnescapeIdentifier(String inputString) {
        return ParseHelper.unescapeStringValue(inputString, true, true);
    }

    static boolean isNotForbiddenIdentStart(String s) {
        char c = s.charAt(0);
        if (c != '-') {
            return !CSSParser.isDigit(c) && c != '+';
        }
        return s.length() > 1 && !CSSParser.isDigit(c = s.charAt(1)) || c == '\\';
    }

    public CSSParser clone() {
        CSSParser parser = new CSSParser(this);
        return parser;
    }

    static LexicalUnitImpl findLastValue(LexicalUnitImpl lu) {
        LexicalUnitImpl nextlu;
        while ((nextlu = lu.nextLexicalUnit) != null) {
            lu = nextlu;
        }
        return lu;
    }

    static boolean typeIsAlgebraicOperator(LexicalUnit.LexicalType type) {
        return type == LexicalUnit.LexicalType.OPERATOR_PLUS || type == LexicalUnit.LexicalType.OPERATOR_MINUS || type == LexicalUnit.LexicalType.OPERATOR_MULTIPLY || type == LexicalUnit.LexicalType.OPERATOR_SLASH;
    }

    private void endDocument() {
        if (this.handler != null) {
            this.handler.endOfStream();
        }
    }

    private class RuleListManager
    extends BlockContentsManager {
        RuleListManager(Parser.NamespaceMap nsMap, boolean topLevel) {
            super(nsMap, topLevel);
        }

        RuleListManager(BlockContentsManager parent) {
            super(parent);
        }

        @Override
        protected SelectorTokenHandler getInitialTokenHandler() {
            return this.selectorHandler;
        }

        @Override
        protected BlockContentsManager.StyleRuleSelectorTH createSelectorTokenHandler(Parser.NamespaceMap nsMap) {
            return new BlockContentsManager.StyleRuleSelectorTH(nsMap){

                @Override
                protected void handleSemicolon(int index) {
                    this.unexpectedSemicolonError(index);
                    this.resetHandler();
                    this.resetParseError();
                }

                @Override
                public void handleErrorRecovery() {
                    this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler(){

                        @Override
                        protected void resumeDeclarationRuleList() {
                            this.resetHandler();
                            this.yieldHandling(RuleListManager.this.selectorHandler);
                        }

                        @Override
                        protected void resumeDeclarationList() {
                            RuleListManager.this.declarationManager.restoreInitialHandler();
                        }

                        @Override
                        protected void endDeclarationBlock(int index) {
                            this.yieldHandling(RuleListManager.this.selectorHandler);
                        }
                    });
                }
            };
        }
    }

    private class DeclarationListManager
    extends ListHandlerManager {
        String propertyName;
        boolean whitespaceBeforeColon;
        private final ValueTokenHandler valueth;
        private boolean priorityImportant;

        DeclarationListManager() {
            this.propertyName = null;
            this.whitespaceBeforeColon = false;
            this.priorityImportant = false;
            this.valueth = this.createValueTokenHandler();
        }

        DeclarationListManager(HandlerManager parent) {
            super(parent);
            this.propertyName = null;
            this.whitespaceBeforeColon = false;
            this.priorityImportant = false;
            this.valueth = this.createValueTokenHandler();
        }

        protected ValueTokenHandler createValueTokenHandler() {
            return new DeclValueTokenHandler();
        }

        @Override
        protected CSSTokenHandler getInitialTokenHandler() {
            return this.createPropertyNameTokenHandler();
        }

        protected CSSTokenHandler createPropertyNameTokenHandler() {
            return new PropertyNameTokenHandler();
        }

        @Override
        public void restoreInitialHandler() {
            super.restoreInitialHandler();
            this.resetFields();
        }

        protected void handleAtKeyword(int index) {
            this.getControlHandler().getCurrentHandler().unexpectedCharError(index, 64);
        }

        protected void endOfPropertyDeclaration(int index) {
            if (this.propertyName != null && !this.valueth.isInError()) {
                LexicalUnitImpl lunit = this.valueth.getLexicalUnit();
                if (!this.isCustomProperty()) {
                    if (lunit != null) {
                        this.handleProperty(index, this.propertyName, lunit, this.priorityImportant);
                    } else {
                        this.getControlHandler().getCurrentHandler().handleError(index, (byte)32, "Found property name (" + this.propertyName + ") but no value");
                    }
                } else {
                    if (lunit == null) {
                        lunit = new LexicalUnitImpl(LexicalUnit.LexicalType.EMPTY);
                        lunit.value = "";
                        this.valueth.getCommentStore().setPrecedingComments(lunit);
                    }
                    this.handleLexicalProperty(index, this.propertyName, lunit, this.priorityImportant);
                }
                this.valueth.resetHandler();
            }
            this.resetFields();
        }

        private boolean isCustomProperty() {
            return this.propertyName.startsWith("--");
        }

        protected void handleProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
            this.getControlHandler().setCurrentLocation(index);
            CSSParser.this.handler.property(propertyName, lunit, priorityImportant);
        }

        void handleLexicalProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
            this.getControlHandler().setCurrentLocation(index);
            CSSParser.this.handler.lexicalProperty(propertyName, lunit, priorityImportant);
        }

        void resetFields() {
            this.propertyName = null;
            this.whitespaceBeforeColon = false;
            this.priorityImportant = false;
        }

        @Override
        public void rightCurlyBracket(int index) {
            this.endOfPropertyDeclaration(index);
            this.endManagement(index);
        }

        class DeclValueTokenHandler
        extends CSSParserHandlerManager.BaseValueTokenHandler {
            DeclValueTokenHandler() {
            }

            @Override
            String getPropertyName() {
                return DeclarationListManager.this.propertyName;
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.processBuffer(index, 123);
                super.leftCurlyBracket(index);
            }

            @Override
            protected void setPriorityHandler(int index) {
                this.yieldHandling(new PriorityTokenHandler());
            }

            @Override
            protected void endOfPropertyDeclaration(int index) {
                DeclarationListManager.this.endOfPropertyDeclaration(index);
                DeclarationListManager.this.restoreInitialHandler();
            }

            @Override
            protected boolean isCustomProperty() {
                return DeclarationListManager.this.isCustomProperty();
            }

            @Override
            public DeclarationListManager getManager() {
                return DeclarationListManager.this;
            }
        }

        class PropertyNameTokenHandler
        extends DeclarationIdentTokenHandler {
            PropertyNameTokenHandler() {
            }

            private void yieldHandling() {
                this.yieldHandling(DeclarationListManager.this.valueth);
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                this.setPropertyName(index);
                this.setWhitespacePrevCp();
            }

            @Override
            public void word(int index, CharSequence word) {
                if (DeclarationListManager.this.propertyName == null) {
                    super.word(index, word);
                } else {
                    this.nonPropertyToken(index, word);
                }
            }

            protected void nonPropertyToken(int index, CharSequence word) {
                this.unexpectedTokenError(index, word);
            }

            @Override
            public void escaped(int index, int codepoint) {
                if (DeclarationListManager.this.propertyName == null) {
                    super.escaped(index, codepoint);
                } else {
                    this.nonPropertyEscaped(index, codepoint);
                }
            }

            protected void nonPropertyEscaped(int index, int codepoint) {
                this.unexpectedCharError(index, codepoint);
            }

            @Override
            public void character(int index, int codepoint) {
                switch (codepoint) {
                    case 45: 
                    case 95: {
                        if (DeclarationListManager.this.propertyName != null) break;
                        this.buffer.append((char)codepoint);
                        this.prevcp = 65;
                        return;
                    }
                    case 58: {
                        if (DeclarationListManager.this.propertyName != null) {
                            DeclarationListManager.this.whitespaceBeforeColon = true;
                            this.yieldHandling();
                            return;
                        }
                        if (this.buffer.length() != 0) {
                            this.processBuffer(index, codepoint);
                            if (!this.isInError()) {
                                this.yieldHandling();
                            }
                            return;
                        }
                    }
                    case 35: 
                    case 42: 
                    case 44: 
                    case 46: {
                        this.expectSelector(index, codepoint);
                        return;
                    }
                    case 43: 
                    case 62: 
                    case 124: 
                    case 126: {
                        this.expectCompoundSelector(index, codepoint);
                        return;
                    }
                    case 38: {
                        this.nestingSelector(index);
                        return;
                    }
                    case 64: {
                        if (this.buffer.length() != 0) break;
                        DeclarationListManager.this.handleAtKeyword(index);
                        return;
                    }
                    case 59: {
                        if (this.unexpectedSemicolonError(index)) {
                            this.getManager().restoreInitialHandler();
                        }
                        this.resetParseError();
                        return;
                    }
                }
                this.unexpectedCharError(index, codepoint);
            }

            protected void nestingSelector(int index) {
                this.unexpectedCharError(index, 38);
            }

            protected void expectSelector(int index, int triggerCp) {
                if (triggerCp == 42 && CSSParser.this.parserFlags.contains((Object)Parser.Flag.STARHACK) && DeclarationListManager.this.propertyName == null && this.buffer.length() == 0 && DeclarationListManager.this.isTopManager()) {
                    this.buffer.append('*');
                    this.handleWarning(index, (byte)-4, "STARHACK IE hack.");
                } else {
                    this.unexpectedCharError(index, triggerCp);
                }
            }

            protected void expectCompoundSelector(int index, int triggerCp) {
                this.expectSelector(index, triggerCp);
            }

            private void setPropertyName(int index) {
                String raw = this.buffer.toString();
                if (!this.isEscapedIdent()) {
                    if (CSSParser.isNotForbiddenIdentStart(raw)) {
                        DeclarationListManager.this.propertyName = raw;
                        this.buffer.setLength(0);
                        return;
                    }
                } else if (CSSParser.isNotForbiddenIdentStart(raw)) {
                    DeclarationListManager.this.propertyName = this.unescapeBuffer(index);
                    if (!this.parseError && !CSSUtil.isValidIdentifier(DeclarationListManager.this.propertyName)) {
                        this.handleWarning(index - this.buffer.length(), (byte)-4, "Suspicious property name: " + raw);
                    }
                    return;
                }
                this.handleError(index - this.buffer.length(), (byte)7, "Invalid property name: '" + raw + '\'');
            }

            @Override
            boolean unexpectedSemicolonError(int index) {
                String msg = "Unexpected ';'";
                if (DeclarationListManager.this.propertyName != null || this.buffer.length() != 0) {
                    this.reportError(index, (byte)4, msg);
                } else {
                    this.handleWarning(index, (byte)4, msg);
                }
                this.resetHandler();
                DeclarationListManager.this.resetFields();
                return true;
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                if (!this.parseError && this.buffer.length() == 0 && DeclarationListManager.this.propertyName == null && this.parendepth == 0 && DeclarationListManager.this.valueth.getSquareBracketDepth() == 0) {
                    super.commented(index, commentType, comment);
                    this.prevcp = 12;
                } else {
                    this.separator(index, 32);
                    this.prevcp = 32;
                }
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                if (DeclarationListManager.this.propertyName != null || this.buffer.length() > 0) {
                    this.unexpectedEOFError(len);
                }
                DeclarationListManager.this.endOfStream(len);
            }
        }

        class DescriptorDeclValueTH
        extends DeclValueTokenHandler {
            DescriptorDeclValueTH() {
            }

            @Override
            protected void setPriorityHandler(int index) {
                this.handleError(index, (byte)33, "Important priorities are invalid in descriptors.");
            }
        }

        abstract class DeclarationIdentTokenHandler
        extends CSSParserHandlerManager.IdentTokenHandler {
            DeclarationIdentTokenHandler() {
            }

            @Override
            public void rightCurlyBracket(int index) {
                if (this.buffer.length() != 0) {
                    this.processBuffer(index, 125);
                }
                super.rightCurlyBracket(index);
            }

            @Override
            public void handleErrorRecovery() {
                DeclarationListManager.this.valueth.resetParseError();
                super.handleErrorRecovery();
            }
        }

        private class PriorityTokenHandler
        extends DeclarationIdentTokenHandler {
            PriorityTokenHandler() {
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                String prio = this.unescapeBuffer(index);
                if ("important".equalsIgnoreCase(prio) && !DeclarationListManager.this.priorityImportant) {
                    DeclarationListManager.this.priorityImportant = true;
                } else {
                    this.checkIEPrioHack(index, prio);
                }
            }

            private void checkIEPrioHack(int index, String prio) {
                String compatText;
                this.buffer.append('!').append(prio);
                if (CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIO) && "ie".equals(prio) && (compatText = DeclarationListManager.this.valueth.setFullIdentCompat(this.rawBuffer())) != null) {
                    DeclarationListManager.this.valueth.warnIdentCompat(index, compatText);
                } else {
                    DeclarationListManager.this.valueth.handleError(index, (byte)9, "Invalid priority: " + prio);
                }
            }

            @Override
            public void character(int index, int codepoint) {
                if (this.buffer.length() != 0) {
                    this.processBuffer(index, codepoint);
                    if (this.isInError()) {
                        return;
                    }
                }
                switch (codepoint) {
                    case 59: {
                        if (!(DeclarationListManager.this.priorityImportant || CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIO) && DeclarationListManager.this.valueth.getLexicalUnit().getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT)) {
                            DeclarationListManager.this.valueth.reportError(index - 1, (byte)4, "Unexpected '!'.");
                            DeclarationListManager.this.valueth.resetParseError();
                            DeclarationListManager.this.valueth.resetHandler();
                            this.resetHandler();
                            DeclarationListManager.this.propertyName = null;
                            DeclarationListManager.this.restoreInitialHandler();
                            break;
                        }
                        DeclarationListManager.this.endOfPropertyDeclaration(index);
                        DeclarationListManager.this.restoreInitialHandler();
                        break;
                    }
                    case 33: {
                        String compatText;
                        if (DeclarationListManager.this.priorityImportant && CSSParser.this.parserFlags.contains((Object)Parser.Flag.IEPRIOCHAR) && (compatText = DeclarationListManager.this.valueth.setFullIdentCompat(this.rawBuffer())) != null) {
                            DeclarationListManager.this.valueth.warnIdentCompat(index, compatText);
                            LexicalUnitImpl lunit = DeclarationListManager.this.valueth.getLexicalUnit();
                            lunit.setUnitType(LexicalUnit.LexicalType.COMPAT_PRIO);
                            lunit.setCssUnit((short)255);
                            break;
                        }
                    }
                    default: {
                        DeclarationListManager.this.valueth.unexpectedCharError(index, codepoint);
                    }
                }
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                DeclarationListManager.this.endOfPropertyDeclaration(len);
                if (!this.isInError() && DeclarationListManager.this.getParentManager() != null) {
                    this.unexpectedEOFError(len);
                }
                DeclarationListManager.this.endOfStream(len);
            }
        }
    }

    public static interface DeclarationRuleHandler
    extends CSSHandler {
        public boolean startAtRule(String var1, String var2);

        public void endAtRule();
    }

    private class GenericBlockAtRuleManager
    extends CSSParserHandlerManager {
        GenericBlockAtRuleManager() {
        }

        void endAtRule() {
            ((DeclarationRuleHandler)CSSParser.this.handler).endAtRule();
        }

        @Override
        public void endOfStream(int len) {
            super.endOfStream(len);
            CSSParser.this.endDocument();
        }

        @Override
        protected CSSTokenHandler getInitialTokenHandler() {
            return new CSSParserHandlerManager.IdentTokenHandler(){
                private String atRule;
                {
                    this.atRule = null;
                }

                @Override
                public void character(int index, int codePoint) throws RuntimeException {
                    if (codePoint == 64 && this.prevcp != 64) {
                        this.prevcp = codePoint;
                    } else {
                        this.unexpectedCharError(index, codePoint);
                    }
                }

                @Override
                void processBuffer(int index, int triggerCp) {
                    this.atRule = this.unescapeBuffer(index);
                    if (this.atRule.length() > 2) {
                        BlockRuleTH th = new BlockRuleTH(this.atRule);
                        this.yieldHandling(th);
                    } else {
                        this.handleError(index, (byte)33, "Malformed @-rule.");
                    }
                }

                @Override
                public void leftCurlyBracket(int index) {
                    this.processBuffer(index, 123);
                    if (!this.isInError()) {
                        this.sendLeftCurlyBracketEvent(index, this);
                    }
                }

                @Override
                public void separator(int index, int codepoint) {
                    if (this.buffer.length() > 0) {
                        this.processBuffer(index, codepoint);
                    }
                }

                @Override
                public void commented(int index, int commentType, String comment) {
                    this.separator(index, 12);
                    if (!this.parseError && this.buffer.length() == 0 && this.atRule == null && commentType == 0) {
                        CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
                    }
                    this.prevcp = 12;
                }

                @Override
                public void handleErrorRecovery() {
                    this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler());
                }

                @Override
                public void endOfStream(int len) {
                    if (this.prevcp != 32 || this.buffer.length() > 0) {
                        this.unexpectedEOFError(len);
                    }
                    GenericBlockAtRuleManager.this.endOfStream(len);
                }
            };
        }

        private class RuleEndContentHandler
        extends ParseEndContentHandler {
            RuleEndContentHandler() {
            }

            @Override
            public HandlerManager getManager() {
                return GenericBlockAtRuleManager.this;
            }
        }

        private class BlockRuleTH
        extends DefaultTokenHandler {
            private String ruleName;

            BlockRuleTH(String ruleName) {
                this.ruleName = null;
                this.ruleName = ruleName;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(64);
            }

            @Override
            public void leftCurlyBracket(int index) {
                String rulePreamble = null;
                if (this.buffer.length() != 0) {
                    rulePreamble = this.unescapeBuffer(index);
                }
                if (!this.startAtRule(index, this.ruleName, rulePreamble)) {
                    this.handleErrorRecovery();
                    this.sendLeftCurlyBracketEvent(index, this);
                } else {
                    this.getManager().yieldManagement(new DeclarationListManager(this.getManager()){

                        @Override
                        public void endManagement(int index) {
                            GenericBlockAtRuleManager.this.endAtRule();
                            this.getControlHandler().yieldHandling(new RuleEndContentHandler());
                        }

                        @Override
                        public void endOfStream(int len) {
                            GenericBlockAtRuleManager.this.endAtRule();
                            GenericBlockAtRuleManager.this.endOfStream(len);
                        }
                    });
                }
            }

            protected boolean startAtRule(int index, String ruleFirstPart, String ruleSecondPart) {
                return ((DeclarationRuleHandler)CSSParser.this.handler).startAtRule(ruleFirstPart, ruleSecondPart);
            }

            public void character(int index, int codepoint) {
                this.bufferAppend(codepoint);
                this.prevcp = codepoint;
            }

            @Override
            protected void processBuffer(int index, int triggerCp) {
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                if (!this.parseError && this.buffer.length() == 0 && this.ruleName == null && this.parendepth == 0 && commentType == 0) {
                    CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
                    this.separator(index, 12);
                    this.prevcp = 12;
                } else {
                    this.separator(index, 32);
                    this.prevcp = 32;
                }
            }

            @Override
            public void endOfStream(int len) {
                this.unexpectedEOFError(len);
                this.getManager().endOfStream(len);
            }

            @Override
            public void handleErrorRecovery() {
                this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler());
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.ruleName = null;
            }

            @Override
            public HandlerManager getManager() {
                return GenericBlockAtRuleManager.this;
            }
        }
    }

    private class RuleManager
    extends RuleListManager {
        RuleManager(Parser.NamespaceMap nsMap) {
            super(nsMap, false);
        }

        @Override
        public void endManagement(int index) {
            super.endManagement(index);
            if (this.rulesFound()) {
                this.getControlHandler().yieldHandling(new RuleEndContentHandler());
            }
        }

        private class RuleEndContentHandler
        extends ParseEndContentHandler {
            RuleEndContentHandler() {
            }

            @Override
            public HandlerManager getManager() {
                return RuleManager.this;
            }
        }
    }

    private class PageManager
    extends DescriptorRuleListManager {
        private DeclarationRuleListManager.PageRuleTH pageTH;

        private PageManager() {
            this.pageTH = new DeclarationRuleListManager.PageRuleTH(){

                @Override
                public void character(int index, int codePoint) {
                    if (codePoint != 64 || this.stage != 0) {
                        super.character(index, codePoint);
                    }
                }
            };
        }

        @Override
        protected DeclarationRuleListManager.PageRuleTH getInitialTokenHandler() {
            return this.pageTH;
        }

        @Override
        protected void reportRuleEnd(int index) {
            if (this.pageTH.stage > 0) {
                CSSParser.this.handler.endPage(this.pageTH.pageSelectorList);
            }
        }

        @Override
        public void endOfStream(int len) {
        }
    }

    private class KeyframesManager
    extends DescriptorRuleListManager {
        private DeclarationRuleListManager.KeyframesTH ruleTH;

        KeyframesManager() {
            this.ruleTH = new DeclarationRuleListManager.KeyframesTH(){

                @Override
                public void character(int index, int codePoint) {
                    if (codePoint != 64 || this.keyframesName != null) {
                        super.character(index, codePoint);
                    }
                }
            };
        }

        @Override
        protected CSSTokenHandler getInitialTokenHandler() {
            return this.ruleTH;
        }

        @Override
        protected void reportRuleEnd(int index) {
            if (this.ruleTH.keyframesName != null) {
                CSSParser.this.handler.endKeyframes();
            }
        }

        @Override
        public void endOfStream(int len) {
        }
    }

    private class FontFeatureValuesManager
    extends DescriptorRuleListManager {
        private DeclarationRuleListManager.FontFeatureValuesTH ruleTH;

        FontFeatureValuesManager() {
            this.ruleTH = new DeclarationRuleListManager.FontFeatureValuesTH(){

                @Override
                public void character(int index, int codePoint) {
                    if (codePoint != 64 || this.stage != 0) {
                        super.character(index, codePoint);
                    }
                }
            };
        }

        @Override
        protected CSSTokenHandler getInitialTokenHandler() {
            return this.ruleTH;
        }

        @Override
        protected void reportRuleEnd(int index) {
            if (this.ruleTH.stage == 4) {
                CSSParser.this.handler.endFontFeatures();
            }
        }

        @Override
        public void endOfStream(int len) {
        }
    }

    private class SupportsManager
    extends CSSParserHandlerManager {
        private SupportsTokenHandler supportsHandler;

        SupportsManager(CSSRule rule, SheetContext parentStyleSheet) {
            this.supportsHandler = new SupportsTokenHandler(rule, parentStyleSheet){

                @Override
                public HandlerManager getManager() {
                    return SupportsManager.this;
                }
            };
        }

        @Override
        protected SupportsTokenHandler getInitialTokenHandler() {
            return this.supportsHandler;
        }
    }

    private class SupportsTokenHandler
    extends ConditionTokenHandler<SupportsConditionFactory> {
        private byte errorCode;
        private CSSParseException errorException;
        private final CSSRule rule;

        SupportsTokenHandler(CSSRule rule, SheetContext parentStyleSheet) {
            super(CSSParser.this, (BooleanConditionFactory)CSSParser.this.createSupportsConditionFactory(parentStyleSheet));
            this.errorCode = 0;
            this.errorException = null;
            this.rule = rule;
            this.setPredicateHandler(new SupportsDelegateHandler());
        }

        SupportsTokenHandler(CSSRule rule) {
            this(rule, (SheetContext)((Object)cSSParser.handler.getStyleSheet()));
        }

        BooleanCondition getCondition() {
            BooleanCondition condition = this.currentCond;
            if (condition != null) {
                while (condition.getParentCondition() != null) {
                    condition = condition.getParentCondition();
                }
            }
            return condition;
        }

        private SelectorList parseSelectors(final int index, String seltext) throws CSSException {
            SelectorManager mgr = new SelectorManager(){

                @Override
                SelectorTokenHandler createSelectorTokenHandler(NSACSelectorFactory factory) {
                    return new SelectorTokenHandler(factory){

                        @Override
                        public void reportError(CSSParseException ex) throws CSSParseException {
                            throw ex;
                        }

                        @Override
                        public void handleErrorRecovery() {
                        }
                    };
                }

                @Override
                protected ControlTokenHandler createControlTokenHandler() {
                    return new ChildControlTokenHandler(SupportsTokenHandler.this.getControlHandler(), index);
                }
            };
            TokenProducer tp = mgr.createTokenProducer();
            tp.parse(seltext, "/*", "*/");
            return mgr.getTrimmedSelectorList();
        }

        @Override
        public void reportError(int index, byte errCode, String message) {
            if (!this.isInError()) {
                if (this.errorCode == 0) {
                    this.errorCode = errCode;
                    this.errorException = this.createException(index, errCode, message);
                    this.reportError(this.errorException);
                }
                this.setParseError();
            }
        }

        @Override
        void handleError(int index, byte errCode, String message, Throwable cause) {
            if (!this.isInError()) {
                if (this.errorCode == 0) {
                    this.errorCode = errCode;
                    this.errorException = this.createException(index, errCode, message);
                    this.errorException.initCause(cause);
                    this.handleError(this.errorException);
                }
                this.setParseError();
            }
        }

        @Override
        public void reportError(CSSParseException ex) throws CSSParseException {
            if (this.errorCode == 0) {
                this.errorCode = (byte)33;
                this.errorException = ex;
            }
            if (this.rule != null) {
                this.rule.getParentStyleSheet().getErrorHandler().ruleParseError(this.rule, ex);
                this.setParseError();
            } else {
                super.reportError(ex);
            }
        }

        @Override
        public void resetHandler() {
            super.resetHandler();
            this.errorCode = 0;
        }

        private class SupportsDelegateHandler
        implements DelegateHandler {
            private boolean readingValue = false;
            private boolean functionToken = false;
            private short valueParendepth;

            SupportsDelegateHandler() {
            }

            @Override
            public boolean isAllowedTopLevel() {
                return this.functionToken;
            }

            public void word(int index, CharSequence word) {
                if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!this.readingValue && !this.functionToken) {
                        SupportsTokenHandler.this.unexpectedTokenError(index, word);
                        return;
                    }
                    if (SupportsTokenHandler.this.isPrevCpWhitespace()) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                }
                SupportsTokenHandler.this.buffer.append(word);
            }

            public void leftParenthesis(int index) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append('(');
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    if (!SupportsTokenHandler.this.isPrevCpWhitespace()) {
                        String fname = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        SupportsTokenHandler.this.resetEscapedTokenIndex();
                        if (!"selector".equalsIgnoreCase(fname)) {
                            SupportsTokenHandler.this.unexpectedTokenError(index, "Unknown function: " + fname);
                            return;
                        }
                        this.functionToken = true;
                        this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                        this.valueParendepth = (short)(this.valueParendepth - 1);
                    } else {
                        SupportsTokenHandler.this.unexpectedCharError(index, 40);
                    }
                }
                SupportsTokenHandler.this.prevcp = 40;
            }

            public void leftSquareBracket(int index) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append('[');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 91);
                }
            }

            public void leftCurlyBracket(int index) {
                SupportsTokenHandler.this.handleLeftCurlyBracket(index);
            }

            public void rightParenthesis(int index) {
                if (this.readingValue) {
                    if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                        String svalue = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        if (!svalue.isEmpty()) {
                            this.setDeclarationPredicate(index, svalue);
                        } else {
                            SupportsTokenHandler.this.unexpectedCharError(index, 41);
                        }
                        this.readingValue = false;
                        SupportsTokenHandler.this.readingPredicate = false;
                        SupportsTokenHandler.this.resetEscapedTokenIndex();
                    } else {
                        SupportsTokenHandler.this.buffer.append(')');
                    }
                } else if (this.functionToken) {
                    if (this.valueParendepth == SupportsTokenHandler.this.getCurrentParenDepth()) {
                        BooleanCondition newCond;
                        this.functionToken = false;
                        SupportsTokenHandler.this.readingPredicate = false;
                        SupportsTokenHandler.this.resetEscapedTokenIndex();
                        SupportsTokenHandler.this.prevcp = 41;
                        String s = SupportsTokenHandler.this.buffer.toString();
                        SupportsTokenHandler.this.buffer.setLength(0);
                        try {
                            SelectorList list = SupportsTokenHandler.this.parseSelectors(index, s);
                            newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createSelectorFunction(list);
                        }
                        catch (CSSBudgetException e) {
                            SupportsTokenHandler.this.handleError(index, (byte)127, "Hit a limit while parsing @supports condition selector.", e);
                            newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + s + ')');
                        }
                        catch (CSSException e) {
                            SupportsTokenHandler.this.handleWarning(index, (byte)127, "Unkown selector in @supports condition.", e);
                            newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition("selector(" + s + ')');
                        }
                        if (SupportsTokenHandler.this.currentCond != null) {
                            SupportsTokenHandler.this.currentCond.addCondition(newCond);
                        }
                        SupportsTokenHandler.this.currentCond = newCond;
                    } else {
                        SupportsTokenHandler.this.buffer.append(')');
                    }
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 41);
                }
            }

            private void setDeclarationPredicate(int index, String value) {
                LexicalUnit lunit;
                String propertyName = ((DeclarationPredicate)SupportsTokenHandler.this.currentCond).getName();
                CSSParser parser = new CSSParser(CSSParser.this.parserFlags);
                StringReader re = new StringReader(value);
                try {
                    lunit = parser.parsePropertyValue(propertyName, re);
                }
                catch (Exception e) {
                    this.warnAndSetFalseCondition(index, propertyName, value, e);
                    return;
                }
                try {
                    ((DeclarationPredicate)SupportsTokenHandler.this.currentCond).setValue(lunit);
                }
                catch (Exception e) {
                    this.warnAndSetFalseCondition(index, propertyName, value, e);
                }
            }

            private void warnAndSetFalseCondition(int index, String propertyName, String svalue, Exception e) {
                SupportsTokenHandler.this.handleWarning(index, (byte)-5, "Invalid @supports condition value.", e);
                StringBuilder buf = new StringBuilder(32);
                buf.append('(').append(propertyName).append(':').append(svalue).append(')');
                BooleanCondition newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createFalseCondition(buf.toString());
                newCond.setParentCondition(SupportsTokenHandler.this.currentCond.getParentCondition());
                SupportsTokenHandler.this.currentCond = newCond;
            }

            public void rightSquareBracket(int index) {
                if (this.readingValue || this.functionToken) {
                    SupportsTokenHandler.this.buffer.append(']');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 93);
                }
            }

            public void rightCurlyBracket(int index) {
                if (this.readingValue) {
                    SupportsTokenHandler.this.buffer.append('}');
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, 125);
                }
            }

            public void character(int index, int codepoint) {
                if (this.readingValue) {
                    if (codepoint == 59) {
                        SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                    } else {
                        SupportsTokenHandler.this.bufferAppend(codepoint);
                    }
                } else if (this.functionToken) {
                    SupportsTokenHandler.this.bufferAppend(codepoint);
                } else if (codepoint == 58 && SupportsTokenHandler.this.getCurrentParenDepth() > 0) {
                    BooleanCondition newCond = ((SupportsConditionFactory)SupportsTokenHandler.this.conditionFactory).createPredicate(SupportsTokenHandler.this.buffer.toString());
                    if (SupportsTokenHandler.this.currentCond != null) {
                        SupportsTokenHandler.this.currentCond.addCondition(newCond);
                    }
                    SupportsTokenHandler.this.currentCond = newCond;
                    SupportsTokenHandler.this.buffer.setLength(0);
                    this.valueParendepth = SupportsTokenHandler.this.getCurrentParenDepth();
                    this.valueParendepth = (short)(this.valueParendepth - 1);
                    this.readingValue = true;
                    SupportsTokenHandler.this.resetEscapedTokenIndex();
                } else {
                    SupportsTokenHandler.this.unexpectedCharError(index, codepoint);
                }
                SupportsTokenHandler.this.prevcp = codepoint;
            }

            public void quoted(int index, CharSequence quoted, int quoteCp) {
                if (this.readingValue || this.functionToken) {
                    if (SupportsTokenHandler.this.buffer.length() != 0) {
                        SupportsTokenHandler.this.buffer.append(' ');
                    }
                    char c = (char)quoteCp;
                    SupportsTokenHandler.this.buffer.append(c).append(quoted).append(c);
                    SupportsTokenHandler.this.prevcp = 65;
                } else {
                    SupportsTokenHandler.this.handleError(index, (byte)9, "Unexpected: '" + quoted + '\'');
                }
            }

            public void escaped(int index, int codepoint) {
                if (SupportsTokenHandler.this.isEscapedCodepoint(codepoint)) {
                    SupportsTokenHandler.this.setEscapedTokenStart(index);
                    SupportsTokenHandler.this.buffer.append('\\');
                }
                SupportsTokenHandler.this.bufferAppend(codepoint);
            }

            public void separator(int index, int cp) {
                if (SupportsTokenHandler.this.isEscapedIdent() && CSSParser.bufferEndsWithEscapedCharOrWS(SupportsTokenHandler.this.buffer)) {
                    SupportsTokenHandler.this.buffer.append(' ');
                }
            }

            public void endOfStream(int len) {
                if (SupportsTokenHandler.this.readingPredicate) {
                    SupportsTokenHandler.this.unexpectedEOFError(len);
                } else if (SupportsTokenHandler.this.buffer.length() != 0) {
                    SupportsTokenHandler.this.reportError(len, (byte)9, "Unexpected token: " + SupportsTokenHandler.this.buffer);
                } else if (SupportsTokenHandler.this.currentCond == null) {
                    SupportsTokenHandler.this.unexpectedEOFError(len, "No condition found");
                }
            }
        }
    }

    private class MediaQueryManager
    extends CSSParserHandlerManager {
        private final MediaQueryTokenHandler mqhandler;

        MediaQueryManager(MediaQueryFactory mediaQueryFactory, MediaQueryHandler mqhandler) {
            this.mqhandler = new MediaQueryTokenHandler(mediaQueryFactory, mqhandler){

                @Override
                public HandlerManager getManager() {
                    return MediaQueryManager.this;
                }
            };
        }

        @Override
        protected MediaQueryTokenHandler getInitialTokenHandler() {
            return this.mqhandler;
        }
    }

    private class MediaQueryTokenHandler
    extends ConditionTokenHandler<MediaQueryFactory> {
        private final HashSet<String> mediaTypes;

        MediaQueryTokenHandler(MediaQueryFactory conditionFactory, MediaQueryHandler mqhandler) {
            super(CSSParser.this, (BooleanConditionFactory)conditionFactory);
            this.mediaTypes = new HashSet(10);
            this.setPredicateHandler(new MediaQueryDelegateHandler(mqhandler));
            String[] mediaTypesArray = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
            Collections.addAll(this.mediaTypes, mediaTypesArray);
        }

        private boolean isValidMediaType(String lcmedia) {
            return this.mediaTypes.contains(lcmedia);
        }

        @Override
        MediaQueryDelegateHandler getPredicateHandler() {
            return (MediaQueryDelegateHandler)super.getPredicateHandler();
        }

        @Override
        void processImplicitAnd(int index) {
            MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
            String medium = mqhelper.mediaType;
            if (medium == null) {
                if (this.buffer.length() != 0) {
                    mqhelper.processMediaType(index);
                } else {
                    this.unexpectedTokenError(index, "and");
                    return;
                }
            }
            this.currentCond = ((MediaQueryFactory)this.conditionFactory).createMediaTypePredicate(medium);
            this.processOperation(index, BooleanCondition.Type.AND, "and");
        }

        @Override
        BooleanCondition createOperation(int index, BooleanCondition.Type opType) throws CSSParseException {
            if (opType == BooleanCondition.Type.AND) {
                return ((MediaQueryFactory)this.conditionFactory).createAndCondition();
            }
            if (this.getPredicateHandler().mediaType == null) {
                return ((MediaQueryFactory)this.conditionFactory).createOrCondition();
            }
            throw this.createException(index, (byte)9, "Unexpected 'OR'");
        }

        void emptyQuery(int index) {
        }

        @Override
        public void unexpectedEOFError(int len, String message) {
            this.reportError(len, (byte)10, message);
        }

        @Override
        void unexpectedTokenError(int index, CharSequence token) {
            this.reportError(index, (byte)9, "Unexpected: " + token);
        }

        @Override
        public void reportError(int index, byte errCode, String message) {
            if (!this.isInError()) {
                CSSParseException ex = this.createException(index, errCode, message);
                this.reportError(ex);
            }
        }

        @Override
        public void reportError(CSSParseException ex) throws CSSParseException {
            MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
            mqhelper.handler.invalidQuery(ex);
            if (!mqhelper.handler.reportsErrors() && CSSParser.this.errorHandler != null) {
                super.reportError(ex);
            }
            this.setParseError();
        }

        @Override
        public void handleError(int index, byte errCode, String message) {
            if (!this.isInError()) {
                CSSParseException ex = this.createException(index, errCode, message);
                this.reportError(ex);
            }
        }

        @Override
        void handleError(int index, byte errCode, String message, Throwable cause) {
            if (!this.isInError()) {
                CSSParseException ex = this.createException(index, errCode, message);
                ex.initCause(cause);
                this.reportError(ex);
            }
        }

        @Override
        public void handleWarning(int index, byte errCode, String message, Throwable cause) {
            if (!this.isInError()) {
                MediaQueryDelegateHandler mqhelper = this.getPredicateHandler();
                CSSParseException ex = this.createException(index, errCode, message);
                if (cause != null) {
                    ex.initCause(cause);
                }
                mqhelper.handler.compatQuery(ex);
                if (CSSParser.this.errorHandler != null) {
                    CSSParser.this.errorHandler.warning(ex);
                }
            }
        }

        @Override
        CSSParseException createException(int index, byte errCode, String message) {
            this.setCurrentLocation(index);
            Locator locator = this.getControlHandler().createLocator();
            return new CSSMediaParseException(message, locator);
        }

        class MediaQueryDelegateHandler
        implements DelegateHandler {
            private final MediaQueryHandler handler;
            private byte stage = 0;
            private boolean negativeQuery = false;
            private boolean spaceFound = false;
            private String mediaType = null;
            private String featureName = null;
            private String firstValue = null;
            private byte rangeType = 0;
            private boolean functionToken = false;
            private static final int WORD_UNQUOTED = 0;

            private MediaQueryDelegateHandler(MediaQueryHandler handler) {
                this.handler = handler;
            }

            MediaQueryHandler getMediaQueryHandler() {
                return this.handler;
            }

            public void word(int index, CharSequence word) {
                if (this.stage == 127) {
                    return;
                }
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0 && MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.buffer.append(word);
                } else if (ParseHelper.equalsIgnoreCase(word, "not")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.reportError(index, (byte)33, "Found 'not' at the wrong parsing stage");
                    } else {
                        this.negativeQuery = true;
                    }
                } else if (ParseHelper.equalsIgnoreCase(word, "only")) {
                    if (this.stage != 0) {
                        MediaQueryTokenHandler.this.reportError(index, (byte)33, "Found 'only' at the wrong parsing stage");
                    } else {
                        this.handler.onlyPrefix();
                    }
                } else if (ParseHelper.equalsIgnoreCase(word, "or")) {
                    MediaQueryTokenHandler.this.reportError(index, (byte)33, "Found 'or'");
                } else if (!this.appendWord(index, word, 0)) {
                    return;
                }
                MediaQueryTokenHandler.this.prevcp = 65;
            }

            private boolean appendWord(int index, CharSequence word, int quote) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0 && !MediaQueryTokenHandler.this.isEscapedIdent() && MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                    if (this.stage == 1) {
                        MediaQueryTokenHandler.this.reportError(index, (byte)33, "Found white space between media");
                        return false;
                    }
                    this.spaceFound = true;
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
                if (quote == 0) {
                    MediaQueryTokenHandler.this.buffer.append(word);
                } else {
                    char c = (char)quote;
                    MediaQueryTokenHandler.this.buffer.append(c).append(word).append(c);
                }
                if (!this.functionToken) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 5) {
                        this.stage = (byte)6;
                    }
                }
                return true;
            }

            @Override
            public void preBooleanHandling(int index, BooleanCondition.Type type) {
                switch (type) {
                    case AND: {
                        if (this.stage > 1) {
                            MediaQueryTokenHandler.this.reportError(index, (byte)33, "Found 'and' at the wrong parsing stage");
                            return;
                        }
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.processMediaType(index);
                        }
                    }
                    case OR: {
                        this.stage = (byte)2;
                        break;
                    }
                }
            }

            private void processMediaType(int index) {
                if (this.mediaType == null && MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                    this.mediaType = this.rawBuffer().trim();
                    if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                        MediaQueryTokenHandler.this.currentCond = null;
                        this.negativeQuery = true;
                        this.handler.negativeQuery();
                    }
                    this.handler.mediaType(this.mediaType);
                }
            }

            private boolean isEmptyNotCondition() {
                return MediaQueryTokenHandler.this.currentCond.getType() == BooleanCondition.Type.NOT && MediaQueryTokenHandler.this.currentCond.getParentCondition() == null && MediaQueryTokenHandler.this.currentCond.getNestedCondition() == null;
            }

            public void leftParenthesis(int index) {
                if (this.functionToken) {
                    MediaQueryTokenHandler.this.buffer.append('(');
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (!MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        this.functionToken = true;
                        MediaQueryTokenHandler.this.buffer.append('(');
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, 40);
                    }
                } else if (this.stage == 2 || this.stage == 0) {
                    this.stage = (byte)3;
                }
                MediaQueryTokenHandler.this.prevcp = 40;
            }

            public void leftCurlyBracket(int index) {
                MediaQueryTokenHandler.this.handleLeftCurlyBracket(index);
                MediaQueryTokenHandler.this.prevcp = 123;
            }

            public void leftSquareBracket(int index) {
                MediaQueryTokenHandler.this.prevcp = 123;
                MediaQueryTokenHandler.this.unexpectedCharError(index, MediaQueryTokenHandler.this.prevcp);
            }

            public void rightParenthesis(int index) {
                if (this.functionToken) {
                    MediaQueryTokenHandler.this.buffer.append(')');
                    this.functionToken = false;
                } else {
                    if (this.stage == 6) {
                        String tempstr;
                        this.processBuffer(index);
                        if (this.firstValue != null && CSSParser.isKnownFeature(this.firstValue)) {
                            tempstr = this.firstValue;
                            this.firstValue = this.featureName;
                            this.featureName = tempstr;
                        } else if (!CSSParser.isKnownFeature(this.featureName)) {
                            if (CSSParser.isValidFeatureSyntax(this.firstValue)) {
                                tempstr = this.firstValue;
                                this.firstValue = this.featureName;
                                this.featureName = tempstr;
                            } else {
                                if (!CSSParser.isValidFeatureSyntax(this.featureName)) {
                                    MediaQueryTokenHandler.this.reportError(index, (byte)33, "Wrong feature expression near " + this.featureName + " " + this.firstValue + ")");
                                    MediaQueryTokenHandler.this.prevcp = 41;
                                    return;
                                }
                                this.reverseRangetype();
                            }
                        } else {
                            this.reverseRangetype();
                        }
                        LexicalUnit value1 = this.parseMediaFeature(index, this.firstValue);
                        this.handlePredicate(index, this.featureName, this.rangeType, value1, this.firstValue);
                    } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        if (this.stage == 4) {
                            String valueSer = MediaQueryTokenHandler.this.buffer.toString();
                            LexicalUnit value = this.parseMediaFeature(index, valueSer);
                            this.handlePredicate(index, this.featureName, (byte)0, value, valueSer);
                        } else if (this.stage == 7) {
                            LexicalUnit value1 = this.parseMediaFeature(index, this.firstValue);
                            LexicalUnit value2 = this.parseMediaFeature(index, MediaQueryTokenHandler.this.buffer.toString());
                            this.handlePredicate(index, this.featureName, this.rangeType, value1, value2);
                        } else if (this.stage == 3 && !this.spaceFound) {
                            this.handleMediaPredicate(index, MediaQueryTokenHandler.this.buffer.toString());
                        } else {
                            MediaQueryTokenHandler.this.reportError(index, (byte)32, MediaQueryTokenHandler.this.buffer.toString());
                        }
                        MediaQueryTokenHandler.this.buffer.setLength(0);
                        this.spaceFound = false;
                        MediaQueryTokenHandler.this.resetEscapedTokenIndex();
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, 41);
                    }
                    if (this.stage == 5) {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, 41);
                    } else {
                        this.rangeType = 0;
                        this.stage = 1;
                    }
                    MediaQueryTokenHandler.this.readingPredicate = false;
                }
                MediaQueryTokenHandler.this.prevcp = 41;
            }

            private LexicalUnit parseMediaFeature(int index, String feature) {
                LexicalUnit nlu;
                LexicalUnit lunit;
                StringReader re = new StringReader(feature);
                HandlerManager manager = MediaQueryTokenHandler.this.getManager();
                try {
                    lunit = CSSParser.this.parsePropertyValue(re, manager, index);
                }
                catch (RuntimeException e) {
                    lunit = null;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                if (lunit == null || (nlu = lunit.getNextLexicalUnit()) != null && (nlu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH || nlu.getNextLexicalUnit() == null)) {
                    MediaQueryTokenHandler.this.reportError(index, (byte)32, "Invalid feature value: " + feature);
                    lunit = null;
                }
                return lunit;
            }

            private void handleMediaPredicate(int index, String featureName) {
                String lcFeatureName;
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null && MediaQueryTokenHandler.this.isValidMediaType(lcFeatureName = featureName.toLowerCase(Locale.ROOT))) {
                    this.mediaType = lcFeatureName;
                    this.handler.mediaType(lcFeatureName);
                } else {
                    MediaFeaturePredicate predicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(featureName);
                    predicate.setRangeType((byte)0);
                    if (MediaQueryTokenHandler.this.currentCond == null) {
                        MediaQueryTokenHandler.this.currentCond = predicate;
                    } else {
                        MediaQueryTokenHandler.this.currentCond.addCondition(predicate);
                    }
                }
                this.clearPredicate();
            }

            private void handlePredicate(int index, String featureName, byte rangeType, LexicalUnit value, String valueSerialization) {
                if (value == null) {
                    MediaQueryTokenHandler.this.reportError(index, (byte)5, valueSerialization);
                    this.clearPredicate();
                    return;
                }
                if (value.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                    MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                }
                MediaFeaturePredicate predicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(featureName);
                predicate.setRangeType(rangeType);
                try {
                    predicate.setValue(value);
                }
                catch (CSSLexicalProcessingException e) {
                    predicate = new MediaFeaturePredicateUnit(featureName);
                    predicate.setRangeType(rangeType);
                    predicate.setValue(value);
                    this.handler.setContainsProxy();
                }
                catch (DOMException e) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, e.getMessage() + ": " + valueSerialization, e);
                    this.clearPredicate();
                    return;
                }
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = predicate;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(predicate);
                }
                this.clearPredicate();
            }

            private void handlePredicate(int index, String featureName, byte rangeType, LexicalUnit value1, LexicalUnit value2) {
                if (value1 == null) {
                    MediaQueryTokenHandler.this.reportError(index, (byte)5, this.firstValue);
                    this.clearPredicate();
                    return;
                }
                if (value2 == null) {
                    String s = MediaQueryTokenHandler.this.buffer.toString();
                    MediaQueryTokenHandler.this.reportError(index, (byte)5, s);
                    this.clearPredicate();
                    return;
                }
                if (value1.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT || value2.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_IDENT) {
                    MediaQueryTokenHandler.this.handleWarning(index, (byte)-2, "Probable hack in media feature.");
                }
                MediaFeaturePredicate predicate = ((MediaQueryFactory)MediaQueryTokenHandler.this.conditionFactory).createPredicate(featureName);
                predicate.setRangeType(rangeType);
                try {
                    predicate.setValueRange(value1, value2);
                }
                catch (CSSLexicalProcessingException e) {
                    predicate = new MediaFeaturePredicateUnit(featureName);
                    predicate.setRangeType(rangeType);
                    predicate.setValueRange(value1, value2);
                    this.handler.setContainsProxy();
                }
                catch (DOMException e) {
                    MediaQueryTokenHandler.this.handleError(index, (byte)5, "Invalid value(s) in range media feature.", e);
                    this.clearPredicate();
                    return;
                }
                if (MediaQueryTokenHandler.this.currentCond == null) {
                    MediaQueryTokenHandler.this.currentCond = predicate;
                } else {
                    MediaQueryTokenHandler.this.currentCond.addCondition(predicate);
                }
                this.clearPredicate();
            }

            private void reverseRangetype() {
                if ((this.rangeType & 2) == 2) {
                    this.rangeType = (byte)(this.rangeType ^ 2);
                    this.rangeType = (byte)(this.rangeType | 4);
                } else if ((this.rangeType & 4) == 4) {
                    this.rangeType = (byte)(this.rangeType ^ 4);
                    this.rangeType = (byte)(this.rangeType | 2);
                }
            }

            public void rightSquareBracket(int index) {
                MediaQueryTokenHandler.this.prevcp = 93;
                MediaQueryTokenHandler.this.unexpectedCharError(index, MediaQueryTokenHandler.this.prevcp);
            }

            public void rightCurlyBracket(int index) {
                MediaQueryTokenHandler.this.prevcp = 125;
                MediaQueryTokenHandler.this.unexpectedCharError(index, MediaQueryTokenHandler.this.prevcp);
            }

            public void character(int index, int codepoint) {
                if (this.functionToken) {
                    if (MediaQueryTokenHandler.this.isPrevCpWhitespace()) {
                        MediaQueryTokenHandler.this.buffer.append(' ');
                    }
                    MediaQueryTokenHandler.this.bufferAppend(codepoint);
                } else {
                    if (codepoint == 58) {
                        if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                            this.featureName = this.rawBuffer();
                            this.stage = (byte)4;
                        } else {
                            MediaQueryTokenHandler.this.reportError(index, (byte)33, "Empty feature name");
                        }
                    } else if (codepoint == 44) {
                        if (!MediaQueryTokenHandler.this.isInError()) {
                            if (MediaQueryTokenHandler.this.getCurrentParenDepth() != 0) {
                                MediaQueryTokenHandler.this.reportError(index, (byte)33, "Unmatched parenthesis");
                                return;
                            }
                            if (this.stage == 0) {
                                MediaQueryTokenHandler.this.reportError(index, (byte)33, "No media found");
                            }
                            this.processBuffer(index);
                            this.endQuery(index);
                        } else if (MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                            this.handler.endQuery();
                            this.clearQuery();
                        }
                        this.handler.startQuery();
                    } else if (codepoint == 46) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 6 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('.');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, 46);
                        }
                    } else if (codepoint == 47) {
                        if (this.stage == 4 || this.stage == 3 || this.stage == 6 || this.stage == 7 || this.functionToken) {
                            MediaQueryTokenHandler.this.buffer.append('/');
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 59) {
                        if (this.stage == 1 && MediaQueryTokenHandler.this.getCurrentParenDepth() == 0) {
                            if (!MediaQueryTokenHandler.this.isInError()) {
                                this.processBuffer(index);
                                this.endQuery(index);
                            } else {
                                this.handler.endQuery();
                                this.clearQuery();
                            }
                            MediaQueryTokenHandler.this.handleSemicolon(index);
                        } else {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 60) {
                        if (this.stage < 3 || this.rangeType > 3 && ((this.rangeType & 0x10) != 0 || (this.rangeType & 4) != 0)) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 2);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 0x10);
                            this.stage = (byte)7;
                        }
                    } else if (codepoint == 61) {
                        if (this.stage < 3 || this.rangeType > 5 && (this.rangeType & 8) != 0) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 1);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 8);
                            this.stage = (byte)7;
                        }
                    } else if (codepoint == 62 || this.rangeType >= 4 && ((this.rangeType & 0x20) != 0 || (this.rangeType & 2) != 0)) {
                        if (this.stage < 3) {
                            MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                        } else if (this.stage != 6 && this.stage != 7) {
                            this.rangeType = (byte)(this.rangeType | 4);
                            this.stage = (byte)5;
                        } else {
                            this.processBuffer(index);
                            this.rangeType = (byte)(this.rangeType | 0x20);
                            this.stage = (byte)7;
                        }
                    } else {
                        MediaQueryTokenHandler.this.unexpectedCharError(index, codepoint);
                    }
                    if (this.stage == 5 && this.firstValue == null && MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.firstValue = this.rawBuffer();
                    }
                }
            }

            private void processBuffer(int index) {
                if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    if (this.stage == 1) {
                        this.processMediaType(index);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(index, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        MediaQueryTokenHandler.this.readingPredicate = false;
                    } else if (this.stage == 6) {
                        this.featureName = this.rawBuffer();
                    }
                }
            }

            private void endQuery(int index) {
                if (MediaQueryTokenHandler.this.currentCond != null) {
                    while (MediaQueryTokenHandler.this.currentCond.getParentCondition() != null) {
                        MediaQueryTokenHandler.this.currentCond = MediaQueryTokenHandler.this.currentCond.getParentCondition();
                    }
                    this.handler.condition(MediaQueryTokenHandler.this.currentCond);
                } else if (this.negativeQuery && this.mediaType == null) {
                    MediaQueryTokenHandler.this.reportError(index, (byte)32, "Negative query without media.");
                }
                this.handler.endQuery();
                this.clearQuery();
            }

            private void clearQuery() {
                MediaQueryTokenHandler.this.currentCond = null;
                this.mediaType = null;
                this.stage = 0;
                this.negativeQuery = false;
                this.functionToken = false;
                MediaQueryTokenHandler.this.resetHandler();
                this.clearPredicate();
            }

            private void clearPredicate() {
                this.featureName = null;
                this.firstValue = null;
                this.rangeType = 0;
                this.spaceFound = false;
            }

            String rawBuffer() {
                this.spaceFound = false;
                return MediaQueryTokenHandler.this.rawBuffer();
            }

            public void quoted(int index, CharSequence quoted, int quoteCp) {
                MediaQueryTokenHandler.this.reportError(index, (byte)9, "Unexpected: '" + quoted + '\'');
            }

            public void escaped(int index, int codepoint) {
                if (MediaQueryTokenHandler.this.isEscapedCodepoint(codepoint)) {
                    MediaQueryTokenHandler.this.setEscapedTokenStart(index);
                    MediaQueryTokenHandler.this.buffer.append('\\');
                }
                MediaQueryTokenHandler.this.bufferAppend(codepoint);
                if (this.stage == 5) {
                    this.stage = (byte)6;
                } else if (this.stage == 0) {
                    this.stage = 1;
                }
            }

            public void separator(int index, int cp) {
                if (MediaQueryTokenHandler.this.isEscapedIdent() && CSSParser.bufferEndsWithEscapedCharOrWS(MediaQueryTokenHandler.this.buffer)) {
                    MediaQueryTokenHandler.this.buffer.append(' ');
                }
            }

            public void endOfStream(int len) {
                if (this.stage == 1) {
                    this.processBuffer(len);
                }
                if (MediaQueryTokenHandler.this.currentCond == null && this.mediaType == null) {
                    if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                        this.processMediaType(len);
                        if (this.mediaType == null) {
                            MediaQueryTokenHandler.this.unexpectedTokenError(len, MediaQueryTokenHandler.this.buffer.toString());
                            MediaQueryTokenHandler.this.buffer.setLength(0);
                        }
                        this.handler.endQuery();
                        this.clearQuery();
                    } else if (this.stage == 0) {
                        MediaQueryTokenHandler.this.emptyQuery(len);
                    } else {
                        MediaQueryTokenHandler.this.unexpectedEOFError(len, "No valid query found");
                    }
                } else if (MediaQueryTokenHandler.this.readingPredicate || this.stage > 1) {
                    MediaQueryTokenHandler.this.unexpectedEOFError(len, "Unexpected end of file");
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.buffer.length() != 0) {
                    MediaQueryTokenHandler.this.reportError(len, (byte)9, "Unexpected token: " + MediaQueryTokenHandler.this.buffer);
                    this.handler.endQuery();
                } else if (MediaQueryTokenHandler.this.currentCond != null && this.isEmptyNotCondition()) {
                    MediaQueryTokenHandler.this.unexpectedEOFError(len, "No valid query found");
                    this.handler.endQuery();
                } else {
                    this.endQuery(len);
                }
                this.handler.endQueryList();
            }
        }
    }

    class SelectorManager
    extends CSSParserHandlerManager {
        SelectorTokenHandler selectorHandler;

        SelectorManager(SelectorTokenHandler selectorHandler) {
            this.selectorHandler = selectorHandler;
            this.selectorHandler.setManager(this);
        }

        SelectorManager() {
            this(new NSACSelectorFactory());
        }

        SelectorManager(Parser.NamespaceMap nsMap) {
            this.selectorHandler = this.createSelectorTokenHandler(nsMap);
            this.selectorHandler.setManager(this);
        }

        SelectorManager(NSACSelectorFactory factory) {
            this.selectorHandler = this.createSelectorTokenHandler(factory);
            this.selectorHandler.setManager(this);
        }

        SelectorTokenHandler createSelectorTokenHandler(Parser.NamespaceMap nsMap) {
            SelectorTokenHandler selectorHandler = nsMap == null ? new SelectorTokenHandler(new NSACSelectorFactory()) : new SelectorTokenHandler(nsMap);
            return selectorHandler;
        }

        SelectorTokenHandler createSelectorTokenHandler(NSACSelectorFactory factory) {
            return new SelectorTokenHandler(factory);
        }

        @Override
        protected SelectorTokenHandler getInitialTokenHandler() {
            return this.selectorHandler;
        }

        public SelectorList getSelectorList() {
            return this.selectorHandler.getSelectorList();
        }

        SelectorListImpl getTrimmedSelectorList() {
            return this.selectorHandler.getTrimmedSelectorList();
        }

        NSACSelectorFactory getSelectorFactory() {
            return this.selectorHandler.factory;
        }
    }

    private class DeclarationValueManager
    extends CSSParserHandlerManager {
        private final String propertyName;
        private ValueTokenHandler valueth;

        DeclarationValueManager() {
            this("");
        }

        DeclarationValueManager(String propertyName) {
            this.valueth = new ValueOnlyTokenHandler();
            this.propertyName = propertyName;
        }

        LexicalUnit getLexicalUnit() {
            return this.valueth.getLexicalUnit();
        }

        @Override
        protected CSSTokenHandler getInitialTokenHandler() {
            return this.valueth;
        }

        @Override
        protected ControlTokenHandler createControlTokenHandler() {
            return new CSSControlTokenHandler(){

                @Override
                public void tokenStart(TokenControl control) {
                    super.tokenStart(control);
                    this.yieldHandling(DeclarationValueManager.this.valueth);
                    ((DeclarationValueManager)DeclarationValueManager.this).valueth.prevcp = 32;
                }
            };
        }

        private class ValueOnlyTokenHandler
        extends CSSParserHandlerManager.BaseValueTokenHandler {
            ValueOnlyTokenHandler() {
            }

            @Override
            String getPropertyName() {
                return DeclarationValueManager.this.propertyName;
            }

            @Override
            protected void endOfValue(int index) {
                this.unexpectedCharError(index, 59);
            }

            @Override
            public void rightCurlyBracket(int index) {
                super.rightCurlyBracket(index);
                this.unexpectedCharError(index, 125);
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                if (!this.isInError() && this.getLexicalUnit() == null) {
                    this.handleError(len, (byte)32, "No value found");
                }
            }

            @Override
            public void handleErrorRecovery() {
            }

            @Override
            ControlTokenHandler getControlHandler() {
                return DeclarationValueManager.this.getControlHandler();
            }

            @Override
            public HandlerManager getManager() {
                return DeclarationValueManager.this;
            }
        }
    }

    private class CSSControlTokenHandler
    extends ControlTokenHandler {
        CSSControlTokenHandler() {
        }

        CSSControlTokenHandler(ControlTokenHandler copyMe) {
            super(copyMe);
        }

        @Override
        public void setDocumentHandler(CSSHandler handler) {
            CSSParser.this.setDocumentHandler(handler);
        }

        @Override
        public void setErrorHandler(CSSErrorHandler handler) {
            CSSParser.this.setErrorHandler(handler);
        }

        @Override
        public CSSErrorHandler getErrorHandler() {
            return CSSParser.this.errorHandler;
        }
    }

    private class ChildControlTokenHandler
    extends CSSControlTokenHandler {
        private final int offset;

        ChildControlTokenHandler(ControlTokenHandler copyMe, int offset) {
            super(copyMe);
            this.offset = offset;
        }

        @Override
        void setCurrentLocation(int index) {
            super.setCurrentLocation(index + this.offset);
        }
    }

    private abstract class DefaultTokenHandler
    extends BufferTokenHandler {
        DefaultTokenHandler() {
        }

        boolean bufferEqualsAndClear(String lcWord) {
            if (ParseHelper.equalsIgnoreCase(this.buffer, lcWord)) {
                this.buffer.setLength(0);
                this.resetEscapedTokenIndex();
                return true;
            }
            return false;
        }

        boolean checkValidCustomIdent(int index, String name) {
            if ("initial".equalsIgnoreCase(name) || "inherit".equalsIgnoreCase(name) || "unset".equalsIgnoreCase(name) || "none".equalsIgnoreCase(name) || "reset".equalsIgnoreCase(name)) {
                this.handleError(index, (byte)7, "A CSS keyword is not a valid custom ident.");
                return false;
            }
            return true;
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            this.separator(index, 12);
            if (commentType == 0) {
                CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
            }
            this.prevcp = 12;
        }

        @Override
        public CSSErrorHandler getErrorHandler() {
            return CSSParser.this.errorHandler;
        }

        @Override
        public void handleErrorRecovery() {
            this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler());
        }
    }

    private abstract class ManagerCallbackTokenHandler
    extends DefaultTokenHandler {
        private HandlerManager manager;
        private CSSTokenHandler yieldHandler;

        ManagerCallbackTokenHandler() {
        }

        ManagerCallbackTokenHandler(HandlerManager manager) {
            this.setManager(manager);
        }

        public void setManager(HandlerManager manager) {
            this.manager = manager;
        }

        @Override
        public HandlerManager getManager() {
            return this.manager;
        }

        @Override
        public void endOfStream(int len) {
            super.endOfStream(len);
            this.getManager().endOfStream(len);
        }

        public void setYieldHandler(CSSTokenHandler yieldHandler) {
            this.yieldHandler = yieldHandler;
        }

        CSSTokenHandler getYieldHandler() {
            return this.yieldHandler;
        }

        protected void yieldHandling() {
            if (this.yieldHandler != null) {
                this.yieldHandling(this.yieldHandler);
            }
        }

        @Override
        public void handleErrorRecovery() {
            this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler(){

                @Override
                protected void endDeclarationBlock(int index) {
                    this.getManager().rightCurlyBracket(index);
                }
            });
        }
    }

    private abstract class CSSParserHandlerManager
    extends HandlerManager {
        CSSParserHandlerManager() {
        }

        CSSParserHandlerManager(HandlerManager parent) {
            super(parent);
        }

        @Override
        protected ControlTokenHandler createControlTokenHandler() {
            return new CSSControlTokenHandler();
        }

        @Override
        public TokenProducer createTokenProducer() {
            IdentCharacterCheck ccheck = new IdentCharacterCheck();
            TokenProducer tp = new TokenProducer((TokenProducer3.CharacterCheck)ccheck, CSSParser.this.streamSizeLimit);
            CSSTokenHandler ini = this.getInitialTokenHandler();
            tp.setContentHandler((ContentHandler)ini);
            tp.setErrorHandler((TokenErrorHandler)ini);
            tp.setControlHandler((ControlHandler)this.getControlHandler());
            return tp;
        }

        @Override
        public void parseStart() {
            CSSParser.this.handler.parseStart(this.getControlHandler());
        }

        @Override
        protected CSSErrorHandler getErrorHandler() {
            return CSSParser.this.errorHandler;
        }

        abstract class BaseValueTokenHandler
        extends ValueTokenHandler {
            BaseValueTokenHandler() {
            }

            @Override
            public boolean hasParserFlag(Parser.Flag flag) {
                return CSSParser.this.parserFlags.contains((Object)flag);
            }

            @Override
            protected CommentStore createCommentStore() {
                if (this.hasParserFlag(Parser.Flag.VALUE_COMMENTS_IGNORE)) {
                    return new EmptyCommentStore();
                }
                return super.createCommentStore();
            }

            @Override
            public CSSErrorHandler getErrorHandler() {
                return CSSParser.this.errorHandler;
            }

            @Override
            public void handleErrorRecovery() {
                this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler());
            }

            @Override
            public HandlerManager getManager() {
                return CSSParserHandlerManager.this;
            }
        }

        abstract class IdentTokenHandler
        extends DefaultTokenHandler {
            IdentTokenHandler() {
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder();
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                this.separator(index, 12);
                if (this.buffer.length() == 0 && commentType == 0) {
                    CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
                }
                this.prevcp = 12;
            }

            public void character(int index, int codePoint) throws RuntimeException {
                this.unexpectedCharError(index, codePoint);
            }

            @Override
            ControlTokenHandler getControlHandler() {
                return CSSParserHandlerManager.this.getControlHandler();
            }

            @Override
            public HandlerManager getManager() {
                return CSSParserHandlerManager.this;
            }
        }
    }

    private abstract class ListHandlerManager
    extends CSSParserHandlerManager {
        ListHandlerManager() {
        }

        ListHandlerManager(HandlerManager parent) {
            super(parent);
        }

        @Override
        public void endOfStream(int len) {
            HandlerManager parent = this.getParentManager();
            if (parent != null) {
                parent.endOfStream(len);
            } else {
                CSSParser.this.endDocument();
            }
        }
    }

    private abstract class DescriptorListManager
    extends DeclarationListManager {
        DescriptorListManager(HandlerManager parent) {
            super(parent);
        }

        @Override
        protected ValueTokenHandler createValueTokenHandler() {
            return new DeclarationListManager.DescriptorDeclValueTH();
        }

        @Override
        public void endManagement(int index) {
            this.reportRuleEnd(index);
            super.endManagement(index);
        }

        @Override
        public void endOfStream(int len) {
            this.reportRuleEnd(len);
            super.endOfStream(len);
        }

        protected abstract void reportRuleEnd(int var1);
    }

    private abstract class ParseEndContentHandler
    extends DefaultTokenHandler {
        boolean foundControl = false;

        ParseEndContentHandler() {
        }

        @Override
        void processBuffer(int index, int triggerCp) {
        }

        @Override
        public void word(int index, CharSequence word) {
            this.reportError(index);
        }

        @Override
        public void separator(int index, int codePoint) {
        }

        @Override
        public void rightCurlyBracket(int index) {
            this.reportError(index);
        }

        public void character(int index, int codePoint) {
            this.unexpectedCharError(index, codePoint);
        }

        @Override
        public void escaped(int index, int codePoint) {
            this.reportError(index);
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (!this.foundControl && !this.parseError && commentType == 0) {
                CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
            }
        }

        @Override
        public void endOfStream(int len) {
            CSSParser.this.handler.endOfStream();
        }

        private void reportError(int index) {
            this.handleError(index, (byte)9, "Found tokens after rule");
        }

        @Override
        public void handleError(int index, byte errCode, String message) {
            if (!this.isInError() && CSSParser.this.errorHandler != null) {
                this.handleError(this.createException(index, errCode, message));
            }
            this.setParseError();
        }
    }

    private class CDOTokenHandler
    extends ManagerCallbackTokenHandler {
        CDOTokenHandler(HandlerManager parent) {
            super(parent);
            this.prevcp = 60;
        }

        @Override
        void processBuffer(int index, int triggerCp) {
        }

        @Override
        public void word(int index, CharSequence word) {
            if (!CSSParser.equalSequences("--", word) || this.prevcp != 33) {
                this.unexpectedTokenError(index, word);
            } else {
                this.yieldHandling();
            }
        }

        public void character(int index, int codePoint) {
            if (codePoint == 33 && this.prevcp == 60) {
                this.prevcp = codePoint;
                return;
            }
            this.unexpectedCharError(index, codePoint);
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            this.unexpectedTokenError(index, comment);
        }

        @Override
        public void endOfStream(int len) {
            this.unexpectedEOFError(len, "EOF while processing CDO/CDC.");
            this.getManager().endOfStream(len);
        }

        @Override
        public void separator(int index, int codePoint) {
            this.unexpectedCharError(index, codePoint);
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quote) {
            this.unexpectedTokenError(index, quoted);
        }

        @Override
        public void leftParenthesis(int index) {
            this.unexpectedCharError(index, 40);
        }

        @Override
        public void leftSquareBracket(int index) {
            this.unexpectedCharError(index, 91);
        }

        @Override
        public void leftCurlyBracket(int index) {
            this.getYieldHandler().unexpectedLeftCurlyBracketError(index);
        }

        @Override
        public void rightParenthesis(int index) {
            this.unexpectedCharError(index, 41);
        }

        @Override
        public void rightSquareBracket(int index) {
            this.unexpectedCharError(index, 93);
        }

        @Override
        public void rightCurlyBracket(int index) {
            this.unexpectedCharError(index, 125);
        }

        @Override
        public void escaped(int index, int codePoint) {
            this.unexpectedCharError(index, codePoint);
        }

        @Override
        void unexpectedCharError(int index, int codepoint) {
            this.getYieldHandler().unexpectedCharError(index, codepoint);
        }

        @Override
        void unexpectedTokenError(int index, CharSequence token) {
            this.getYieldHandler().unexpectedTokenError(index, token);
        }

        @Override
        public void unexpectedEOFError(int len, String message) {
            this.getYieldHandler().unexpectedEOFError(len, message);
        }
    }

    class SelectorTokenHandler
    extends ManagerCallbackTokenHandler {
        NSACSelectorFactory factory;
        Parser.NamespaceMap nsMap;
        ParserSelectorListImpl selist = new ParserSelectorListImpl();
        AbstractSelector currentsel = null;
        private HashMap<Condition, ConditionSetterFactory.ConditionSetter> setterMap = new HashMap();
        private String namespacePrefix = null;
        byte stage = 0;
        private boolean functionToken;
        boolean hasHas;
        static final byte STAGE_INITIAL = 0;
        private static final byte STAGE_COMBINATOR_OR_END = 2;
        private static final byte STAGE_ATTR_START = 4;
        private static final byte STAGE_ATTR_EXPECT_SYMBOL_OR_CLOSE = 7;
        private static final byte STAGE_ATTR_SYMBOL = 5;
        private static final byte STAGE_ATTR_POST_SYMBOL = 6;
        private static final byte STAGE_EXPECT_ID_OR_CLASSNAME = 8;
        private static final byte STAGE_EXPECT_PSEUDOELEM_NAME = 9;
        private static final byte STAGE_EXPECT_PSEUDOCLASS_NAME = 10;
        private static final byte STAGE_EXPECT_PSEUDO_ARGUMENT = 11;
        int curlyBracketDepth;

        SelectorTokenHandler(Parser.NamespaceMap nsMap) {
            this.factory = new NSACSelectorFactory();
            this.nsMap = nsMap == null ? this.factory : nsMap;
            this.buffer = new StringBuilder(64);
        }

        SelectorTokenHandler(NSACSelectorFactory factory) {
            this.factory = factory;
            this.nsMap = factory;
            this.buffer = new StringBuilder(100);
        }

        SelectorListImpl getSelectorList() {
            return this.selist;
        }

        SelectorListImpl getTrimmedSelectorList() {
            this.selist.trimToSize();
            return this.selist;
        }

        protected boolean isInsideHas() {
            return this.hasHas;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (this.buffer.length() != 0 && this.isPrevCpWhitespace()) {
                this.buffer.append(' ');
            }
            if (this.stage == 4 && this.prevcp != 65 && this.prevcp != 124) {
                this.unexpectedTokenError(index, word);
            } else if (this.stage == 0) {
                this.stage = 1;
                this.buffer.append(word);
            } else if (this.stage == 2) {
                this.buffer.append(word);
                this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                this.stage = 1;
            } else if (this.stage == 6 && this.isPrevCpWhitespace()) {
                if (word.length() == 1) {
                    char c = word.charAt(0);
                    if (c == 'i' || c == 'I') {
                        this.setAttributeConditionFlag(AttributeCondition.Flag.CASE_I);
                    } else if (c == 's' || c == 'S') {
                        this.setAttributeConditionFlag(AttributeCondition.Flag.CASE_S);
                    } else {
                        this.handleError(index, (byte)4, "Expected 'i', found: '" + c + '\'');
                    }
                    if (this.buffer.length() != 0) {
                        this.handleError(index, (byte)9, "Expected 'i' or 's', found: '" + this.buffer.toString() + '\'');
                        this.buffer.setLength(0);
                    }
                } else {
                    this.handleError(index, (byte)9, "Expected 'i', found: '" + word + "'");
                }
            } else if (this.stage == 1) {
                HandlerManager ancMgr;
                if (this.prevcp != 42) {
                    this.buffer.append(word);
                } else if (CSSParser.this.parserFlags.contains((Object)Parser.Flag.STARHACK) && this.selist.isEmpty() && this.currentsel == null && this.buffer.length() == 0 && (ancMgr = this.getManager().getParentManager()) != null && (ancMgr = ancMgr.getParentManager()) != null && (ancMgr.isTopManager() || (ancMgr = ancMgr.getParentManager()).isTopManager())) {
                    this.handleStarHack(index, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else if (this.stage != 7) {
                this.buffer.append(word);
            } else {
                this.unexpectedTokenError(index, word);
            }
            this.prevcp = 65;
        }

        protected void handleStarHack(int index, CharSequence word) {
            this.unexpectedCharError(index, 42);
        }

        @Override
        public void separator(int index, int codepoint) {
            if (this.isEscapedIdent() && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                this.buffer.append(' ');
                return;
            }
            if (this.prevcp == 58 || this.prevcp == 46 || this.prevcp == 35 || this.prevcp == 124 && this.getActiveSelector() == null) {
                this.unexpectedCharError(index, codepoint);
                return;
            }
            if (this.stage == 5) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    this.stage = (byte)6;
                }
            } else if (this.stage == 1 || this.stage == 8 || this.stage == 9 || this.stage == 10) {
                this.processBuffer(index, codepoint, false);
                if (this.prevcp == 65 || this.prevcp == 42 || this.prevcp == 41 || this.prevcp == 93 || this.prevcp == 38) {
                    this.stage = (byte)2;
                }
            } else if (this.stage == 4) {
                if (this.buffer.length() != 0) {
                    this.stage = (byte)7;
                } else if (this.namespacePrefix != null) {
                    this.unexpectedCharError(index, codepoint);
                }
                return;
            }
            if (this.prevcp != 44) {
                this.setWhitespacePrevCp();
            }
        }

        @Override
        String unescapeBuffer(int index) {
            String s;
            if (this.namespacePrefix == null) {
                s = this.unescapeStringValue(index);
            } else {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected token: " + this.namespacePrefix);
                this.namespacePrefix = null;
                s = "";
            }
            this.buffer.setLength(0);
            this.resetEscapedTokenIndex();
            return s;
        }

        void processBuffer(int index, int triggerCp, boolean lastStage) {
            if (this.prevcp == 42) {
                if (this.currentsel == null || this.currentsel.getSelectorType() != Selector.SelectorType.UNIVERSAL) {
                    this.setSimpleSelector(index, this.factory.getUniversalSelector(this.namespacePrefix));
                }
            } else if (this.stage == 2) {
                if (!lastStage) {
                    this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                    if (this.buffer.length() != 0) {
                        NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                        String raw = this.buffer.toString();
                        if (CSSParser.isNotForbiddenIdentStart(raw)) {
                            String s;
                            sel.localName = s = this.unescapeBuffer(index);
                            this.stage = 1;
                        } else {
                            this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                        }
                    }
                }
            } else if (this.buffer.length() != 0) {
                if (this.stage == 1) {
                    String uri;
                    String raw = this.buffer.toString();
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix == null) {
                        uri = this.getDefaultNamespaceURI();
                    } else {
                        uri = this.getNamespaceURI(index);
                        if (this.parseError) {
                            return;
                        }
                    }
                    sel.namespaceUri = uri;
                    if (CSSParser.isNotForbiddenIdentStart(raw)) {
                        String s;
                        sel.localName = s = this.unescapeBuffer(index);
                    } else {
                        this.handleError(index - raw.length(), (byte)7, "Invalid identifier: " + raw);
                    }
                } else if (this.stage == 8) {
                    String raw = this.buffer.toString();
                    if (CSSParser.isNotForbiddenIdentStart(raw)) {
                        String s = this.unescapeBuffer(index).trim();
                        this.setAttributeSelectorValue(index, s);
                        this.stage = 1;
                    } else {
                        this.handleError(index - raw.length(), (byte)7, "Invalid class name: " + raw);
                    }
                } else if (this.stage == 10) {
                    this.newPseudoClassSelector(index, triggerCp);
                    this.stage = 1;
                } else if (this.stage == 9) {
                    this.newPseudoElementSelector(index, triggerCp);
                    this.stage = 1;
                } else if (this.stage != 11) {
                    if (this.stage == 6) {
                        this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    } else {
                        this.handleError(index, (byte)9, "Unexpected: <" + this.buffer + ">");
                        this.buffer.setLength(0);
                    }
                }
            } else if (this.namespacePrefix != null) {
                this.handleError(index - this.namespacePrefix.length() - 1, (byte)9, "Unexpected: " + this.namespacePrefix + "|");
                this.namespacePrefix = null;
            } else if (this.stage > 1 && this.stage != 11) {
                this.unexpectedCharError(index, triggerCp);
            }
        }

        @Override
        void processBuffer(int index, int triggerCp) {
            throw new IllegalStateException();
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteChar) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else if (this.stage == 11) {
                if (this.buffer.length() != 0 && this.isPrevCpWhitespace()) {
                    this.buffer.append(' ');
                }
                char c = (char)quoteChar;
                this.buffer.append(c).append(quoted).append(c);
            } else {
                char c = (char)quoteChar;
                StringBuilder buf = new StringBuilder(quoted.length() + 2);
                buf.append(c).append(quoted).append(c);
                this.unexpectedTokenError(index, buf.toString());
            }
            this.prevcp = 65;
        }

        @Override
        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            if (this.stage == 5 && this.currentsel != null) {
                this.setAttributeSelectorValue(index, quoted);
                this.stage = (byte)6;
            } else {
                this.handleError(index, (byte)9, "Quoted string contained unexpected control character: \"" + quoted + '\"');
            }
            this.prevcp = 65;
        }

        private void setAttributeSelectorValue(int index, CharSequence value) {
            NSACSelectorFactory.AttributeConditionImpl attrcond;
            assert (this.currentsel != null);
            AbstractCondition cond = null;
            if (!this.currentsel.isSimpleSelector()) {
                SimpleSelector simple = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                if (simple.getSelectorType() != Selector.SelectorType.CONDITIONAL) {
                    throw new IllegalStateException("Descendant selector has no conditional simple selector");
                }
                cond = ((ConditionalSelectorImpl)simple).condition;
            } else if (this.currentsel.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                cond = ((ConditionalSelectorImpl)this.currentsel).getCondition();
            }
            if (cond instanceof CombinatorConditionImpl) {
                cond = ((CombinatorConditionImpl)cond).getLastCondition();
            }
            if (cond instanceof NSACSelectorFactory.AttributeConditionImpl && (attrcond = (NSACSelectorFactory.AttributeConditionImpl)cond) != null) {
                String oldValue = attrcond.getValue();
                if (oldValue == null) {
                    attrcond.setValue(value.toString());
                } else {
                    StringBuilder buf = new StringBuilder(oldValue.length() + value.length() + 1);
                    buf.append(oldValue);
                    if (this.isPrevCpWhitespace()) {
                        buf.append(' ');
                    }
                    attrcond.setValue(buf.append(value).toString());
                }
                return;
            }
            this.handleError(index, (byte)9, "Unexpected token in selector: <" + value + ">");
        }

        private void setAttributeConditionFlag(AttributeCondition.Flag flag) {
            Selector simple = this.getActiveSelector();
            if (simple == null || simple.getSelectorType() != Selector.SelectorType.CONDITIONAL) {
                throw new IllegalStateException("Processing attribute modifier of non-conditional selector");
            }
            AbstractCondition cond = ((ConditionalSelectorImpl)simple).getCondition();
            if (cond.getConditionType() == Condition.ConditionType.AND) {
                cond = ((CombinatorConditionImpl)cond).getLastCondition();
            }
            ((NSACSelectorFactory.AttributeConditionImpl)cond).setFlag(flag);
        }

        private Selector getActiveSelector() {
            Selector sel = this.currentsel != null && !this.currentsel.isSimpleSelector() ? ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector() : this.currentsel;
            return sel;
        }

        private Condition getActiveCondition(Condition cond) {
            if (cond.getConditionType() == Condition.ConditionType.AND) {
                cond = ((CombinatorConditionImpl)cond).getLastCondition();
            }
            return cond;
        }

        @Override
        public void leftParenthesis(int index) {
            this.parendepth = (short)(this.parendepth + 1);
            if (this.stage == 11) {
                this.buffer.append('(');
                this.prevcp = 40;
            } else if (!this.isInError()) {
                if (this.prevcp == 65 && this.buffer.length() > 0) {
                    if (this.stage == 10) {
                        this.newPseudoClassSelector(index, 40);
                        if (!this.isInError()) {
                            this.stage = (byte)11;
                            this.functionToken = true;
                        }
                        this.prevcp = 40;
                        return;
                    }
                    if (this.stage == 9) {
                        this.newPseudoElementSelector(index, 40);
                        if (!this.isInError()) {
                            this.stage = (byte)11;
                            this.functionToken = true;
                        }
                        this.prevcp = 40;
                        return;
                    }
                }
                this.unexpectedCharError(index, 40);
            }
        }

        @Override
        public void leftSquareBracket(int index) {
            if (this.stage == 11) {
                this.buffer.append('[');
                this.prevcp = 91;
            } else if (!this.isInError()) {
                if (this.prevcp != 65 && CSSParser.isNotSeparator(this.prevcp) && this.prevcp != 42 && this.prevcp != 44 && this.prevcp != 93 && this.prevcp != 41 && this.prevcp != 43 && this.prevcp != 62 && this.prevcp != 125 && this.prevcp != 126 && this.prevcp != 124) {
                    this.unexpectedCharError(index, 91);
                } else {
                    this.processBuffer(index, 91, false);
                    this.stage = (byte)4;
                    this.prevcp = 65;
                }
            }
        }

        @Override
        public void leftCurlyBracket(int index) {
            this.unexpectedCharError(index, 123);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void rightParenthesis(int index) {
            this.decrParenDepth(index);
            if (this.stage == 11) {
                if (this.parendepth != 0) {
                    this.buffer.append(')');
                    this.prevcp = 41;
                    return;
                }
                Selector sel = this.getActiveSelector();
                if (sel.getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                    AbstractCondition abstractCondition = ((ConditionalSelectorImpl)sel).condition;
                    Condition condition = this.getActiveCondition(abstractCondition);
                    ConditionSetterFactory.ConditionSetter setter = this.setterMap.get(condition);
                    this.setterMap.remove(condition);
                    setter.setArgument(index, condition, this);
                    this.buffer.setLength(0);
                    this.resetEscapedTokenIndex();
                    this.stage = 1;
                } else {
                    this.unexpectedCharError(index, 41);
                }
            } else {
                this.unexpectedCharError(index, 41);
            }
            if (this.functionToken) {
                this.functionToken = false;
            }
            this.prevcp = 41;
        }

        @Override
        public void rightSquareBracket(int index) {
            if (this.stage == 11) {
                this.buffer.append(']');
            } else if (this.stage == 6) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                }
                this.stage = 1;
            } else if (this.stage == 4 || this.stage == 7) {
                if (this.buffer.length() != 0) {
                    this.newAttributeSelector(index, 93, Condition.ConditionType.ATTRIBUTE);
                    this.stage = 1;
                } else {
                    this.handleError(index, (byte)4, "Unexpected ']', expected attribute name");
                }
            } else if (this.stage == 5) {
                if (this.buffer.length() != 0) {
                    this.setAttributeSelectorValue(index, this.unescapeBuffer(index));
                    this.stage = 1;
                } else {
                    this.handleError(index, (byte)4, "Unexpected ']', expected attribute value");
                }
            } else {
                this.unexpectedCharError(index, 93);
            }
            this.prevcp = 93;
        }

        @Override
        public void rightCurlyBracket(int index) {
            this.handleError(index, (byte)4, "Unexpected '}'");
        }

        /*
         * Unable to fully structure code
         */
        public void character(int index, int codepoint) {
            if (!this.skipCharacterHandling()) {
                if (this.stage == 11) {
                    if (codepoint == 44 && (this.prevcp == 44 || this.buffer.length() == 0)) {
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    if (this.isPrevCpWhitespace() && this.buffer.length() != 0) {
                        this.buffer.append(' ');
                    }
                    this.bufferAppend(codepoint);
                } else if (this.stage == 4 || this.stage == 7) {
                    if (codepoint == 124) {
                        if (this.stage == 4) {
                            if (this.namespacePrefix == null) {
                                this.readNamespacePrefix(index, codepoint);
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                        } else if (this.prevcp != 65) {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint == 61) {
                        if (this.prevcp == 124 && this.namespacePrefix != null && this.buffer.length() == 0) {
                            this.buffer.append(this.namespacePrefix);
                            this.namespacePrefix = null;
                        }
                        if (this.prevcp == 124) {
                            this.newAttributeSelector(index, this.prevcp, Condition.ConditionType.BEGIN_HYPHEN_ATTRIBUTE);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 126) {
                            this.newAttributeSelector(index, this.prevcp, Condition.ConditionType.ONE_OF_ATTRIBUTE);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 36) {
                            this.newAttributeSelector(index, this.prevcp, Condition.ConditionType.ENDS_ATTRIBUTE);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 94) {
                            this.newAttributeSelector(index, this.prevcp, Condition.ConditionType.BEGINS_ATTRIBUTE);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 42) {
                            this.newAttributeSelector(index, this.prevcp, Condition.ConditionType.SUBSTRING_ATTRIBUTE);
                            this.stage = (byte)5;
                        } else if (this.prevcp == 65) {
                            this.newAttributeSelector(index, codepoint, Condition.ConditionType.ATTRIBUTE);
                            this.stage = (byte)5;
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (this.buffer.length() == 0) {
                        if (codepoint != 126 && codepoint != 36 && codepoint != 94 && codepoint != 42) {
                            if (this.stage == 4 && ParseHelper.isValidXMLStartNonAlphaCharacter(codepoint)) {
                                this.bufferAppend(codepoint);
                                this.prevcp = 65;
                                return;
                            }
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else if (codepoint != 126 && codepoint != 36 && codepoint != 94 && codepoint != 42) {
                        if (this.stage == 4 && ParseHelper.isValidXMLNonAlphaCharacter(codepoint)) {
                            this.bufferAppend(codepoint);
                            this.prevcp = 65;
                            return;
                        }
                        this.unexpectedCharError(index, codepoint);
                    }
                } else if (codepoint == 42) {
                    if (this.stage == 0) {
                        this.stage = 1;
                    } else if (this.stage == 2) {
                        this.newCombinatorSelector(Selector.SelectorType.DESCENDANT);
                        ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = this.factory.getUniversalSelector(this.namespacePrefix);
                        this.namespacePrefix = null;
                        this.stage = 1;
                    } else if (this.stage == 1 && this.namespacePrefix != null && this.prevcp == 124) {
                        this.setSimpleSelector(index, this.factory.createUniversalSelector(this.getNamespaceURI(index)));
                    } else {
                        this.unexpectedCharError(index, codepoint);
                    }
                } else {
                    if (this.prevcp == 124) {
                        if (codepoint == 124) {
                            this.handleColumnCombinator(index);
                            this.prevcp = 32;
                            return;
                        }
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    switch (codepoint) {
                        case 126: {
                            if (this.stage == 2) {
                                this.stage = 1;
                            } else {
                                this.processBuffer(index, codepoint, false);
                                if (this.isInError()) {
                                    return;
                                }
                            }
                            this.newCombinatorSelector(index, Selector.SelectorType.SUBSEQUENT_SIBLING, codepoint);
                            break;
                        }
                        case 46: {
                            if (this.stage != 8 || this.buffer.length() != 0) {
                                this.processBuffer(index, codepoint, false);
                                if (this.isInError()) break;
                                this.newClassOrIDSelector(index, Condition.ConditionType.CLASS);
                                this.stage = (byte)8;
                                break;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break;
                        }
                        case 35: {
                            if (this.stage != 8 || this.buffer.length() != 0) {
                                this.processBuffer(index, codepoint, false);
                                if (this.isInError()) break;
                                this.newClassOrIDSelector(index, Condition.ConditionType.ID);
                                this.stage = (byte)8;
                                break;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break;
                        }
                        case 58: {
                            if (this.prevcp == 58) {
                                this.stage = (byte)9;
                                break;
                            }
                            this.processBuffer(index, codepoint, false);
                            this.stage = (byte)10;
                            break;
                        }
                        case 62: {
                            if (this.stage == 2) {
                                this.stage = 1;
                            } else if (this.stage == 1 && CSSParser.access$3300("--", this.buffer)) {
                                if (this.isTopLevel() && this.prevcp == 65 && !this.isEscapedIdent() && !this.functionToken) {
                                    this.buffer.setLength(0);
                                    this.stage = 0;
                                    this.prevcp = 32;
                                    return;
                                }
                                this.unexpectedCharError(index, codepoint);
                            }
                            this.processBuffer(index, codepoint, false);
                            if (this.stage < 2 && !this.isInError()) {
                                this.newCombinatorSelector(index, Selector.SelectorType.CHILD, codepoint);
                                break;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break;
                        }
                        case 43: {
                            if (this.stage == 2) {
                                this.stage = 1;
                            }
                            this.processBuffer(index, codepoint, false);
                            if (this.isInError()) break;
                            this.newCombinatorSelector(index, Selector.SelectorType.DIRECT_ADJACENT, codepoint);
                            break;
                        }
                        case 124: {
                            if (this.stage == 8 || this.stage == 10 || this.stage == 9) {
                                this.processBuffer(index, codepoint, false);
                                if (this.isInError()) {
                                    return;
                                }
                                try {
                                    ncp = this.getTokenControl().skipNextCodepoint();
                                    if (ncp != 124) {
                                        if (ncp == -1) {
                                            this.unexpectedEOFError(index + 1, "EOF while processing column combinator selector");
                                            ** break;
                                        }
                                        this.unexpectedCharError(index + 1, ncp);
                                        ** break;
                                    }
                                    this.newCombinatorSelector(index, Selector.SelectorType.COLUMN_COMBINATOR, 124);
                                    this.prevcp = 32;
                                    return;
lbl165:
                                    // 2 sources

                                }
                                catch (IOException e) {
                                    this.handleError(index + 1, (byte)11, "I/O Error when processing column combinator selector", e);
                                }
                                break;
                            }
                            if (this.stage == 2) {
                                this.stage = 1;
                                break;
                            }
                            if (this.stage == 1 && this.namespacePrefix == null) {
                                this.readNamespacePrefix(index, codepoint);
                                break;
                            }
                            if (this.stage == 0 && this.namespacePrefix == null && this.buffer.length() == 0) {
                                this.namespacePrefix = "";
                                break;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break;
                        }
                        case 44: {
                            if (this.functionToken) {
                                if (this.prevcp == 44) {
                                    this.unexpectedCharError(index, codepoint);
                                    break;
                                }
                                this.buffer.append(',');
                                break;
                            }
                            this.processBuffer(index, codepoint, true);
                            if (this.isInError()) break;
                            if (this.addCurrentSelector(index)) {
                                this.stage = 0;
                                break;
                            }
                            this.unexpectedCharError(index, codepoint);
                            break;
                        }
                        case 64: {
                            if (this.stage == 0 && this.selist.isEmpty()) {
                                this.handleAtKeyword(index);
                                break;
                            }
                            this.unexpectedCharError(index, 64);
                            break;
                        }
                        case 45: {
                            this.buffer.append('-');
                            break;
                        }
                        case 95: {
                            this.buffer.append('_');
                            break;
                        }
                        case 38: {
                            if (this.stage > 2 && this.stage != 11) {
                                this.unexpectedCharError(index, codepoint);
                                break;
                            }
                            this.processBuffer(index, codepoint, false);
                            this.stage = 1;
                            this.newNestingSelector();
                            break;
                        }
                        case 59: {
                            if (this.parendepth == 0) {
                                this.handleSemicolon(index);
                                this.prevcp = 32;
                            } else {
                                this.unexpectedCharError(index, codepoint);
                            }
                            return;
                        }
                        default: {
                            if (this.stage < 8) {
                                if (this.stage == 0) {
                                    if (ParseHelper.isValidXMLStartNonAlphaCharacter(codepoint)) {
                                        this.bufferAppend(codepoint);
                                        this.stage = 1;
                                        this.prevcp = 65;
                                        return;
                                    }
                                } else if (ParseHelper.isValidXMLNonAlphaCharacter(codepoint)) {
                                    this.bufferAppend(codepoint);
                                    this.prevcp = 65;
                                    return;
                                }
                                if (codepoint == 60 && this.isTopLevel()) {
                                    this.processBuffer(index, codepoint, false);
                                    if (!this.isInError()) {
                                        this.handleCDO();
                                    }
                                    this.prevcp = 32;
                                    return;
                                }
                            } else if (!this.isUnexpectedCharacter(codepoint)) {
                                this.bufferAppend(codepoint);
                                this.prevcp = 65;
                                return;
                            }
                            this.unexpectedCharError(index, codepoint);
                        }
                    }
                }
            }
            this.prevcp = codepoint;
        }

        boolean skipCharacterHandling() {
            return this.parseError;
        }

        private void handleColumnCombinator(int index) {
            if (this.stage == 1) {
                if (this.currentsel == null) {
                    NSACSelectorFactory.ElementSelectorImpl sel = this.newElementSelector(index);
                    if (this.namespacePrefix != null) {
                        sel.localName = this.namespacePrefix;
                        this.namespacePrefix = null;
                    } else if (this.buffer.length() != 0) {
                        sel.localName = this.unescapeBuffer(index);
                    } else {
                        this.unexpectedCharError(index, 124);
                        return;
                    }
                }
                this.newCombinatorSelector(index, Selector.SelectorType.COLUMN_COMBINATOR, 124);
            } else if (this.stage == 0 && this.buffer.length() == 0 && this.currentsel == null) {
                this.namespacePrefix = null;
                this.newCombinatorSelector(index, Selector.SelectorType.COLUMN_COMBINATOR, 124);
            } else {
                this.unexpectedCharError(index, 124);
            }
        }

        private boolean isUnexpectedCharacter(int cp) {
            return cp == 33 || cp == 36 || cp == 37 || cp == 38 || cp == 47 || cp >= 59 && cp <= 63 || cp == 94 || cp == 96;
        }

        private void handleCDO() {
            CDOTokenHandler cdoCdcTH = new CDOTokenHandler(this.getManager());
            cdoCdcTH.setYieldHandler(this);
            this.yieldHandling(cdoCdcTH);
        }

        private void readNamespacePrefix(int index, int codepoint) {
            if (this.prevcp == 65) {
                this.namespacePrefix = this.unescapeBuffer(index);
            } else if (this.prevcp == 42 && this.buffer.length() == 0) {
                this.namespacePrefix = "*";
            } else {
                this.unexpectedCharError(index, codepoint);
            }
        }

        protected void handleAtKeyword(int index) {
            this.unexpectedCharError(index, 64);
        }

        protected void handleSemicolon(int index) {
            this.unexpectedCharError(index, 59);
        }

        private void newPseudoClassSelector(int index, int triggerCp) {
            String name = this.unescapeBuffer(index);
            String lcname = name.toLowerCase(Locale.ROOT);
            ConditionSetterFactory.ConditionSetter setter = ConditionSetterFactory.getInstance().getPseudoClassSetter(lcname);
            AbstractCondition condition = setter.create(index, triggerCp, lcname, this);
            if (condition != null) {
                this.setterMap.put(condition, setter);
                this.setConditionalSelector(condition);
            }
        }

        private void newPseudoElementSelector(int index, int triggerCp) {
            String name = this.unescapeBuffer(index);
            String lcname = name.toLowerCase(Locale.ROOT);
            ConditionSetterFactory.ConditionSetter setter = ConditionSetterFactory.getInstance().getPseudoElementSetter(lcname);
            AbstractCondition condition = setter.create(index, triggerCp, lcname, this);
            if (condition != null) {
                this.setterMap.put(condition, setter);
                this.setConditionalSelector(condition);
            }
        }

        private void newAttributeSelector(int index, int triggerCp, Condition.ConditionType condtype) {
            NSACSelectorFactory.AttributeConditionImpl condition;
            String name = this.rawBuffer();
            String lcname = name.toLowerCase(Locale.ROOT).intern();
            if (!name.isEmpty()) {
                condition = this.factory.createAttributeCondition(condtype);
                switch (condtype) {
                    case ATTRIBUTE: 
                    case BEGIN_HYPHEN_ATTRIBUTE: 
                    case ONE_OF_ATTRIBUTE: 
                    case ENDS_ATTRIBUTE: 
                    case SUBSTRING_ATTRIBUTE: 
                    case BEGINS_ATTRIBUTE: {
                        if (this.namespacePrefix != null) {
                            condition.setNamespaceURI(this.getNamespaceURI(index));
                        }
                        if (CSSParser.isNotForbiddenIdentStart(name)) {
                            condition.setLocalName(CSSParser.safeUnescapeIdentifier(name).trim());
                            break;
                        }
                        if (triggerCp != 61 && triggerCp != 93) {
                            --index;
                        }
                        this.handleError(index - name.length(), (byte)7, "Invalid pseudo-class: " + name);
                        return;
                    }
                    default: {
                        condition.setValue(lcname.trim());
                        break;
                    }
                }
            } else {
                if (triggerCp != 61) {
                    --index;
                }
                this.unexpectedCharError(index, triggerCp);
                return;
            }
            this.setConditionalSelector(condition);
        }

        private void newClassOrIDSelector(int index, Condition.ConditionType condtype) {
            String name = this.unescapeBuffer(index);
            String lcname = name.trim().toLowerCase(Locale.ROOT).intern();
            NSACSelectorFactory.AttributeConditionImpl condition = this.factory.createAttributeCondition(condtype);
            condition.setValue(lcname);
            this.setConditionalSelector(condition);
        }

        private void newNestingSelector() {
            this.setConditionalSelector(NestingCondition.getInstance());
        }

        private void setConditionalSelector(AbstractCondition condition) {
            if (this.currentsel == null) {
                this.currentsel = this.factory.createConditionalSelector((SimpleSelector)((Object)this.currentsel), condition);
            } else if (this.currentsel.isSimpleSelector()) {
                this.currentsel = this.currentsel.withCondition(this.factory, condition);
            } else {
                NSACSelectorFactory.CombinatorSelectorImpl combsel = (NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel;
                SimpleSelector simple = combsel.simpleSelector;
                combsel.simpleSelector = simple == null ? this.factory.createConditionalSelector(NSACSelectorFactory.getUniversalSelector(), condition) : ((AbstractSelector)((Object)simple)).withCondition(this.factory, condition);
            }
        }

        private String getDefaultNamespaceURI() {
            String uri = this.nsMap.getNamespaceURI("");
            if (uri != null && this.factory != this.nsMap) {
                this.factory.registerNamespacePrefix("", uri);
            }
            return uri;
        }

        private String getNamespaceURI(int index) {
            String uri;
            if (this.namespacePrefix.length() != 0) {
                uri = this.nsMap.getNamespaceURI(this.namespacePrefix);
                if (uri != null) {
                    if (this.factory != this.nsMap) {
                        this.factory.registerNamespacePrefix(this.namespacePrefix, uri);
                    }
                } else if (!this.namespacePrefix.equals("*")) {
                    this.handleError(index - this.buffer.length() - this.namespacePrefix.length() - 1, (byte)15, "Unknown namespace prefix: " + this.namespacePrefix);
                }
            } else {
                uri = "";
            }
            this.namespacePrefix = null;
            return uri;
        }

        private NSACSelectorFactory.ElementSelectorImpl newElementSelector(int index) {
            NSACSelectorFactory.ElementSelectorImpl elemsel = this.factory.createElementSelector();
            this.setSimpleSelector(index, elemsel);
            return elemsel;
        }

        private void setSimpleSelector(int index, SimpleSelector simple) {
            if (this.currentsel == null) {
                this.currentsel = (AbstractSelector)((Object)simple);
            } else if (!this.currentsel.isSimpleSelector()) {
                ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).simpleSelector = simple;
            } else {
                this.handleError(index - this.buffer.length(), (byte)9, "Unexpected token after '" + this.currentsel.toString() + "': " + simple.toString());
            }
        }

        protected void newCombinatorSelector(int index, Selector.SelectorType type, int triggerCp) {
            if (this.currentsel != null && this.isValidCurrentSelector()) {
                this.newCombinatorSelector(type);
            } else {
                this.unexpectedCharError(index, triggerCp);
            }
        }

        void newCombinatorSelector(Selector.SelectorType type) {
            this.currentsel = this.factory.createCombinatorSelector(type, this.currentsel);
            this.stage = 0;
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (this.stage == 4 || this.stage == 5 || this.stage == 8 || this.stage == 11 || this.stage == 0 || this.stage == 2) {
                if (this.isEscapedCodepoint(codepoint)) {
                    this.setEscapedTokenStart(index);
                    this.buffer.append('\\');
                } else {
                    Selector sel;
                    if (Character.isISOControl(codepoint)) {
                        this.unexpectedCharError(index, codepoint);
                        return;
                    }
                    if (this.stage == 11 && (sel = this.getActiveSelector()).getSelectorType() == Selector.SelectorType.CONDITIONAL) {
                        Condition cond = ((ConditionalSelectorImpl)sel).condition;
                        if ((cond = this.getActiveCondition(cond)).getConditionType() == Condition.ConditionType.SELECTOR_ARGUMENT) {
                            this.buffer.append('\\');
                        }
                    }
                }
                this.bufferAppend(codepoint);
                if (this.stage == 0) {
                    this.stage = 1;
                }
                this.prevcp = 65;
            } else {
                this.unexpectedCharError(index - 1, 92);
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            if (this.stage == 0 && this.selist.size() == 0) {
                super.commented(index, commentType, comment);
            } else {
                this.separator(index, 12);
                if (this.prevcp != 44) {
                    this.prevcp = 12;
                }
            }
        }

        @Override
        public void endOfStream(int len) {
            this.processBuffer(len, 32, true);
            if (!this.parseError && !this.addCurrentSelector(len)) {
                this.unexpectedEOFError(len);
            }
            this.getManager().endOfStream(len);
        }

        boolean addCurrentSelector(int index) {
            if (this.currentsel != null) {
                if (this.isValidCurrentSelector()) {
                    this.selist.add(this.currentsel, index);
                    this.currentsel = null;
                    return true;
                }
                this.selist.clear();
                this.currentsel = null;
            }
            return false;
        }

        boolean isValidCurrentSelector() {
            SimpleSelector last = null;
            switch (this.currentsel.getSelectorType()) {
                case CHILD: 
                case DESCENDANT: 
                case COLUMN_COMBINATOR: 
                case DIRECT_ADJACENT: 
                case SUBSEQUENT_SIBLING: {
                    last = ((NSACSelectorFactory.CombinatorSelectorImpl)this.currentsel).getSecondSelector();
                    break;
                }
                case CONDITIONAL: {
                    AbstractCondition cond = ((ConditionalSelectorImpl)this.currentsel).getCondition();
                    Condition.ConditionType condtype = cond.getConditionType();
                    if (condtype == Condition.ConditionType.AND) {
                        if ((cond = ((CombinatorConditionImpl)cond).getLastCondition()) == null) {
                            return false;
                        }
                        condtype = cond.getConditionType();
                    }
                    switch (condtype) {
                        case ATTRIBUTE: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getLocalName() != null) break;
                            return false;
                        }
                        case PSEUDO_ELEMENT: 
                        case PSEUDO_CLASS: {
                            if (((PseudoConditionImpl)cond).name != null) break;
                            return false;
                        }
                        case BEGIN_HYPHEN_ATTRIBUTE: 
                        case ONE_OF_ATTRIBUTE: 
                        case ENDS_ATTRIBUTE: 
                        case SUBSTRING_ATTRIBUTE: 
                        case BEGINS_ATTRIBUTE: 
                        case CLASS: {
                            if (((NSACSelectorFactory.AttributeConditionImpl)cond).getValue() != null) break;
                            return false;
                        }
                        case LANG: {
                            if (((LangConditionImpl)cond).getLang() != null) break;
                            return false;
                        }
                        case SELECTOR_ARGUMENT: {
                            if (((SelectorArgumentConditionImpl)cond).getSelectors() != null) break;
                            return false;
                        }
                    }
                }
                default: {
                    return true;
                }
            }
            return last != null;
        }

        @Override
        public void resetHandler() {
            super.resetHandler();
            this.stage = 0;
            this.functionToken = false;
            this.hasHas = false;
            this.buffer.setLength(0);
            this.namespacePrefix = null;
            this.currentsel = null;
        }

        @Override
        public void reportError(CSSParseException ex) throws CSSParseException {
            super.reportError(ex);
            this.selist.clear();
            this.resetHandler();
        }

        @Override
        public void error(int index, byte errCode, CharSequence context) {
            if (errCode == 1) {
                index -= context.length() + 1;
            }
            super.error(index, errCode, context);
            this.currentsel = null;
            this.selist.clear();
        }

        class ParserSelectorListImpl
        extends SelectorListImpl {
            private static final long serialVersionUID = 1L;

            ParserSelectorListImpl() {
            }

            public boolean add(Selector sel, int index) {
                if (this.add(sel)) {
                    return true;
                }
                if (CSSParser.this.errorHandler != null) {
                    int selsz;
                    try {
                        selsz = sel.toString().length();
                    }
                    catch (RuntimeException e) {
                        selsz = 1;
                    }
                    String message = "Duplicate selector in list";
                    try {
                        message = message + ": " + sel.toString();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    CSSParser.this.errorHandler.warning(SelectorTokenHandler.this.createException(index - selsz, (byte)-1, message));
                }
                return false;
            }
        }

        class MyAnBExpression
        extends AnBExpression {
            private static final long serialVersionUID = 1L;

            MyAnBExpression() {
            }

            @Override
            protected SelectorList parseSelector(String selText) {
                CSSParser parser = CSSParser.this.clone();
                return parser.parseSelectors(selText, SelectorTokenHandler.this.factory);
            }
        }

        class SelectorArgumentManager
        extends SelectorManager {
            SelectorArgumentManager(NSACSelectorFactory factory) {
                super(new SelectorArgumentTokenHandler(factory){

                    @Override
                    protected boolean isInsideHas() {
                        return SelectorTokenHandler.this.isInsideHas();
                    }
                });
            }
        }
    }

    private class SelectorArgumentTokenHandler
    extends SelectorTokenHandler {
        SelectorArgumentTokenHandler(NSACSelectorFactory factory) {
            super(factory);
        }

        @Override
        protected void newCombinatorSelector(int index, Selector.SelectorType type, int triggerCp) {
            if (this.currentsel == null) {
                this.currentsel = this.factory.createScopeSelector();
            } else if (!this.isValidCurrentSelector()) {
                this.unexpectedCharError(index, triggerCp);
                return;
            }
            this.newCombinatorSelector(type);
        }
    }

    private class DeclarationRuleListManager
    extends DeclarationListManager {
        boolean foundControl;

        private DeclarationRuleListManager() {
            this.foundControl = false;
        }

        DeclarationRuleListManager(HandlerManager parent) {
            super(parent);
            this.foundControl = false;
        }

        void setRulesFound() {
        }

        boolean rulesFound() {
            return false;
        }

        @Override
        protected ControlTokenHandler createControlTokenHandler() {
            return new CSSControlTokenHandler(){

                @Override
                public void control(int index, int codepoint) {
                    super.control(index, codepoint);
                    DeclarationRuleListManager.this.foundControl = true;
                }
            };
        }

        @Override
        protected CSSTokenHandler getInitialTokenHandler() {
            this.propertyName = null;
            return super.getInitialTokenHandler();
        }

        protected String defaultNamespaceURI() {
            return null;
        }

        @Override
        protected void handleAtKeyword(int index) {
            if (this.propertyName == null) {
                this.getControlHandler().yieldHandling(new AtRuleLauncher());
            } else {
                this.getControlHandler().getCurrentHandler().unexpectedCharError(index, 64);
            }
        }

        private void handleAtRule(int index, String ruleName) {
            CSSTokenHandler rulehandler = this.createRuleHandler(index, ruleName);
            if (rulehandler != null) {
                this.getControlHandler().yieldHandling(rulehandler);
                this.setRulesFound();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        protected CSSTokenHandler createRuleHandler(int index, String ruleName) {
            void var3_13;
            if ("charset".equals(ruleName)) {
                if (!this.rulesFound()) {
                    CharsetRuleTH charsetRuleTH = new CharsetRuleTH();
                    return var3_13;
                }
                this.getControlHandler().getCurrentHandler().handleError(index - 8, (byte)33, "@charset must be the first rule");
                return null;
            }
            if ("import".equals(ruleName)) {
                ImportRuleTH importRuleTH = new ImportRuleTH();
                return var3_13;
            }
            if ("namespace".equals(ruleName)) {
                CSSTokenHandler cSSTokenHandler = this.createNamespaceRuleTH();
                return var3_13;
            }
            if ("font-face".equals(ruleName)) {
                FontFaceTH fontFaceTH = new FontFaceTH();
                return var3_13;
            }
            if ("page".equals(ruleName)) {
                PageRuleTH pageRuleTH = new PageRuleTH();
                return var3_13;
            }
            if ("counter-style".equals(ruleName)) {
                CounterStyleTH counterStyleTH = new CounterStyleTH();
                return var3_13;
            }
            if ("keyframes".equals(ruleName)) {
                KeyframesTH keyframesTH = new KeyframesTH();
                return var3_13;
            }
            if ("font-feature-values".equals(ruleName)) {
                FontFeatureValuesTH fontFeatureValuesTH = new FontFeatureValuesTH();
                return var3_13;
            }
            if ("property".equals(ruleName)) {
                PropertyTH propertyTH = new PropertyTH();
                return var3_13;
            }
            CSSTokenHandler cSSTokenHandler = this.createUnknownRuleHandler(index, ruleName);
            return var3_13;
        }

        protected CSSTokenHandler createNamespaceRuleTH() {
            return new NamespaceRuleTH();
        }

        protected CSSTokenHandler createUnknownRuleHandler(int index, String ruleName) {
            return new UnknownRuleTokenHandler(ruleName);
        }

        class AtRuleLauncher
        extends CSSParserHandlerManager.IdentTokenHandler {
            AtRuleLauncher() {
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                if (this.buffer.length() > 0) {
                    this.processBuffer(index, 12);
                    CSSTokenHandler curh = this.getControlHandler().getCurrentHandler();
                    if (curh != this) {
                        curh.commented(index, commentType, comment);
                    }
                } else {
                    this.unexpectedTokenError(index, comment);
                }
            }

            @Override
            public void separator(int index, int codepoint) {
                if (this.getEscapedTokenIndex() != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                } else if (this.buffer.length() > 0) {
                    this.processBuffer(index, codepoint);
                    CSSTokenHandler curh = this.getControlHandler().getCurrentHandler();
                    if (curh != this) {
                        curh.separator(index, codepoint);
                    }
                    this.setWhitespacePrevCp();
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            }

            @Override
            public void character(int index, int codePoint) throws RuntimeException {
                if (codePoint == 59) {
                    if (this.unexpectedSemicolonError(index)) {
                        this.getManager().restoreInitialHandler();
                    }
                } else if (this.buffer.length() > 0) {
                    this.processBuffer(index, codePoint);
                    CSSTokenHandler curh = this.getControlHandler().getCurrentHandler();
                    if (curh != this) {
                        curh.character(index, codePoint);
                    }
                } else {
                    this.unexpectedCharError(index, codePoint);
                }
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.processBuffer(index, 123);
                CSSTokenHandler curhnd = this.getControlHandler().getCurrentHandler();
                if (curhnd != this) {
                    curhnd.leftCurlyBracket(index);
                }
            }

            @Override
            public void leftParenthesis(int index) {
                this.processBuffer(index, 40);
                CSSTokenHandler curhnd = this.getControlHandler().getCurrentHandler();
                if (curhnd != this) {
                    curhnd.leftParenthesis(index);
                }
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                String atRule = this.unescapeBuffer(index);
                if (atRule.length() > 2) {
                    DeclarationRuleListManager.this.handleAtRule(index, atRule);
                } else {
                    this.handleError(index, (byte)33, "Malformed @-rule.");
                }
            }

            @Override
            public void endOfStream(int len) {
                this.unexpectedEOFError(len);
                DeclarationRuleListManager.this.endOfStream(len);
            }
        }

        class CharsetRuleTH
        extends AbstractRuleHandler {
            private String charset;

            CharsetRuleTH() {
                this.charset = null;
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quote) {
                if (this.charset == null) {
                    this.charset = quoted.toString();
                } else {
                    this.unexpectedTokenError(index, quoted);
                }
            }

            public void character(int index, int codepoint) {
                this.prevcp = codepoint;
                if (codepoint == 59) {
                    this.endRuleBody(index);
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            }

            @Override
            public void commented(int index, int commentType, String comment) {
            }

            @Override
            public void word(int index, CharSequence word) {
                this.unexpectedTokenError(index, word);
            }

            @Override
            public void escaped(int index, int codePoint) {
                this.unexpectedCharError(index, 92);
            }

            @Override
            public void separator(int index, int codepoint) {
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (this.charset != null) {
                    CSSParser.this.handler.charset(this.charset);
                }
            }

            @Override
            void processBuffer(int index, int triggerCp) {
            }

            @Override
            public void handleErrorRecovery() {
                this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler());
            }
        }

        class ImportRuleTH
        extends StatementAtRuleHandler {
            private String importURL;
            private String layerName;
            private MediaQueryList mediaQuery;
            private BooleanCondition supportsCondition;

            ImportRuleTH() {
                this.importURL = null;
                this.layerName = null;
                this.mediaQuery = null;
                this.supportsCondition = null;
            }

            @Override
            public void separator(int index, int codepoint) {
                if (this.getEscapedTokenIndex() != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                } else {
                    this.processBuffer(index, 32);
                    this.setWhitespacePrevCp();
                }
            }

            public void character(int index, int codepoint) {
                if (codepoint == 59) {
                    this.handleSemicolon(index);
                    this.prevcp = codepoint;
                } else if (codepoint == 44) {
                    this.processBuffer(index, codepoint);
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            }

            private void handleSemicolon(int index) {
                if (this.parendepth == 0) {
                    this.processBuffer(index, 59);
                    if (!this.isInError() && this.importURL != null) {
                        if (this.mediaQuery == null) {
                            this.endRuleBody(index);
                        }
                    } else if (this.unexpectedSemicolonError(index)) {
                        DeclarationRuleListManager.this.restoreInitialHandler();
                    }
                } else {
                    this.handleError(index, (byte)6, "Unmatched parentheses in rule.");
                }
                this.resetHandler();
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
                if (this.importURL == null && this.buffer.length() == 0) {
                    this.importURL = quoted.toString();
                    this.prevcp = 65;
                } else {
                    this.unexpectedTokenError(index, quoted);
                }
            }

            @Override
            public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
                this.unexpectedTokenError(index, quoted);
            }

            @Override
            public void leftParenthesis(final int index) {
                this.parendepth = (short)(this.parendepth + 1);
                if (this.prevcp == 65) {
                    this.prevcp = 40;
                    this.trimBufferTail();
                    if (ParseHelper.equalsIgnoreCase(this.buffer, "url")) {
                        this.buffer.setLength(0);
                        if (this.importURL == null) {
                            this.yieldHandling(new URLTokenHandler(this){

                                @Override
                                protected void setURL(String url, LexicalUnitImpl urlUnit) {
                                    if (url != null) {
                                        ImportRuleTH.this.importURL = url;
                                    } else {
                                        ImportRuleTH.this.unexpectedCharError(index, 41);
                                    }
                                }
                            });
                            return;
                        }
                    } else if (ParseHelper.equalsIgnoreCase(this.buffer, "supports")) {
                        this.buffer.setLength(0);
                        if (this.supportsCondition == null) {
                            SupportsTokenHandler th = new SupportsTokenHandler(null){

                                @Override
                                public void rightParenthesis(int index2) {
                                    super.rightParenthesis(index2);
                                    if (this.getCurrentParenDepth() == 0 && this.isTopLevel()) {
                                        this.endOfCondition(index2, false);
                                    }
                                }

                                @Override
                                boolean endOfCondition(int index2, boolean eof) {
                                    boolean ret = super.endOfCondition(index2, eof);
                                    ImportRuleTH.this.supportsCondition = this.getCondition();
                                    if (ret) {
                                        this.yieldHandling(ImportRuleTH.this);
                                    }
                                    return ret;
                                }

                                @Override
                                public void endOfStream(int len) {
                                    if (this.endOfCondition(len, true)) {
                                        this.handleWarning(index, (byte)-6, "Unexpected EOF in @import supports condition.");
                                    }
                                    ImportRuleTH.this.endOfStream(len);
                                }

                                @Override
                                public HandlerManager getManager() {
                                    return ImportRuleTH.this.getManager();
                                }
                            };
                            th.leftParenthesis(index);
                            this.yieldHandling(th);
                            return;
                        }
                    } else if (ParseHelper.equalsIgnoreCase(this.buffer, "layer")) {
                        this.buffer.setLength(0);
                        if (this.layerName == null) {
                            CSSParserHandlerManager.IdentTokenHandler th = new CSSParserHandlerManager.IdentTokenHandler(){

                                @Override
                                public void word(int index2, CharSequence word) {
                                    if (ImportRuleTH.this.layerName == null) {
                                        super.word(index2, word);
                                    } else {
                                        this.unexpectedTokenError(index2, word);
                                    }
                                }

                                @Override
                                public void character(int index2, int codePoint) throws RuntimeException {
                                    if (codePoint == 46 && ImportRuleTH.this.layerName == null) {
                                        this.buffer.append('.');
                                    } else {
                                        super.character(index2, codePoint);
                                    }
                                }

                                @Override
                                public void rightParenthesis(int index2) {
                                    this.processBuffer(index2, 41);
                                    if (ImportRuleTH.this.layerName != null) {
                                        ImportRuleTH.this.parendepth = (short)(ImportRuleTH.this.parendepth - 1);
                                        this.yieldHandling(ImportRuleTH.this);
                                    } else {
                                        this.unexpectedCharError(index2, 41);
                                    }
                                }

                                @Override
                                void processBuffer(int index2, int triggerCp) {
                                    if (this.buffer.length() != 0) {
                                        String s = this.unescapeBuffer(index2);
                                        if (s.indexOf(46) != -1) {
                                            StringTokenizer st = new StringTokenizer(s, ".");
                                            while (st.hasMoreElements()) {
                                                if (this.checkValidCustomIdent(index2, st.nextToken())) continue;
                                                return;
                                            }
                                        } else if (!this.checkValidCustomIdent(index2, s)) {
                                            return;
                                        }
                                        ImportRuleTH.this.layerName = s;
                                    }
                                }

                                @Override
                                public void endOfStream(int len) {
                                    this.processBuffer(len, 0);
                                    if (!this.isInError()) {
                                        this.handleWarning(index, (byte)-6, "Unexpected EOF in @import layer declaration.");
                                    }
                                    ImportRuleTH.this.endOfStream(len);
                                }

                                @Override
                                public void handleErrorRecovery() {
                                    ImportRuleTH.this.handleErrorRecovery();
                                }

                                @Override
                                public HandlerManager getManager() {
                                    return ImportRuleTH.this.getManager();
                                }
                            };
                            th.parendepth = (short)(th.parendepth + 1);
                            this.yieldHandling(th);
                            return;
                        }
                    }
                } else if (this.importURL != null) {
                    this.prevcp = 40;
                    MediaQueryTokenHandler th = this.createMediaQueryHandler();
                    int len = this.buffer.length();
                    if (len != 0) {
                        th.word(index - len, this.buffer);
                        this.buffer.setLength(0);
                        this.resetEscapedTokenIndex();
                    }
                    th.leftParenthesis(index);
                    this.yieldHandling(th);
                    return;
                }
                this.unexpectedCharError(index, 40);
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                int len = this.buffer.length();
                if (len != 0) {
                    this.trimBufferTail();
                    String s = this.unescapeBuffer(index);
                    if ("layer".equalsIgnoreCase(s)) {
                        if (this.layerName == null) {
                            this.layerName = "";
                            this.buffer.setLength(0);
                            this.resetEscapedTokenIndex();
                            return;
                        }
                    } else if (this.importURL != null) {
                        MediaQueryTokenHandler th = this.createMediaQueryHandler();
                        th.word(index, s);
                        if (triggerCp != 32) {
                            th.character(index, triggerCp);
                        } else {
                            th.separator(index, 32);
                        }
                        if (triggerCp != 59) {
                            this.yieldHandling(th);
                        }
                        return;
                    }
                    this.handleError(index - len, (byte)33, "Unexpected token: '" + s + '\'');
                }
            }

            @Override
            protected void reportRuleEnd(int index) {
                this.processBuffer(index, 32);
                if (!this.isInError()) {
                    if (this.importURL != null) {
                        if (this.mediaQuery == null) {
                            this.mediaQuery = CSSParser.this.getMediaQueryFactory().createAllMedia();
                        } else if (this.mediaQuery.hasErrors()) {
                            if (this.mediaQuery.isNotAllMedia()) {
                                this.reportError(index, (byte)33, "Invalid media query.");
                                this.resetHandler();
                                return;
                            }
                            this.handleWarning(index, (byte)33, "Media query has errors.");
                        }
                        String defaultNSURI = DeclarationRuleListManager.this.defaultNamespaceURI();
                        CSSParser.this.handler.importStyle(this.importURL, this.layerName, this.supportsCondition, this.mediaQuery, defaultNSURI);
                    } else {
                        this.reportError(index, (byte)9, "Malformed @-rule.");
                    }
                }
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.importURL = null;
                this.layerName = null;
                this.mediaQuery = null;
                this.supportsCondition = null;
            }

            @Override
            public void endOfStream(int len) {
                this.reportRuleEnd(len);
                if (this.importURL == null && !this.isInError()) {
                    this.handleWarning(len, (byte)-6, "Unexpected end of stream");
                }
                super.endOfStream(len);
            }

            private MediaQueryTokenHandler createMediaQueryHandler() {
                MediaQueryFactory mediaQueryFactory = CSSParser.this.getMediaQueryFactory();
                MediaQueryHandler mqhandler = mediaQueryFactory.createMediaQueryHandler(null);
                return new ImportMediaQueryTokenHandler(mediaQueryFactory, mqhandler);
            }

            class ImportMediaQueryTokenHandler
            extends RuleMediaQueryTH {
                ImportMediaQueryTokenHandler(MediaQueryFactory conditionFactory, MediaQueryHandler mqhandler) {
                    super(conditionFactory, mqhandler);
                }

                @Override
                void handleLeftCurlyBracket(int index) {
                    if (this.endOfCondition(index, false)) {
                        super.handleLeftCurlyBracket(index);
                    } else {
                        CSSTokenHandler curh = this.getControlHandler().getCurrentHandler();
                        if (curh != this) {
                            curh.leftCurlyBracket(index);
                        }
                    }
                }

                @Override
                protected void handleSemicolon(int index) {
                    ImportRuleTH.this.mediaQuery = this.getPredicateHandler().getMediaQueryHandler().getMediaQueryList();
                    if (this.getCurrentParenDepth() <= 0) {
                        ImportRuleTH.this.endRuleBody(index);
                    } else if (this.getControlHandler().getCurrentHandler() != this) {
                        this.handleErrorRecovery();
                    }
                }

                @Override
                public void endOfStream(int len) {
                    super.endOfStream(len);
                    ImportRuleTH.this.mediaQuery = this.getPredicateHandler().getMediaQueryHandler().getMediaQueryList();
                    ImportRuleTH.this.endOfStream(len);
                }

                @Override
                public DeclarationRuleListManager getManager() {
                    return DeclarationRuleListManager.this;
                }
            }
        }

        class FontFaceTH
        extends NoSelectorRuleHandler {
            FontFaceTH() {
            }

            @Override
            protected void reportRuleEnd(int index) {
                CSSParser.this.handler.endFontFace();
            }

            @Override
            public void leftCurlyBracket(int index) {
                CSSParser.this.handler.startFontFace();
                this.expectRuleBody(index);
            }
        }

        class PageRuleTH
        extends AbstractBlockRuleHandler {
            private PageSelectorListImpl pageSelectorList;
            private static final int STAGE_TOKEN_PROCESSED = 1;
            private static final int STAGE_EXPECT_PSEUDOPAGE_NAME = 2;
            private static final int STAGE_EXPECT_RULE_BODY = 3;
            private static final int STAGE_RULE_BODY = 4;
            short stage;

            PageRuleTH() {
                this.pageSelectorList = new PageSelectorListImpl();
                this.stage = 0;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(64);
            }

            @Override
            public void word(int index, CharSequence word) {
                switch (this.stage) {
                    case 0: 
                    case 2: {
                        this.buffer.append(word);
                        this.stage = 1;
                        break;
                    }
                    default: {
                        this.unexpectedTokenError(index, word);
                    }
                }
            }

            @Override
            public void separator(int index, int codepoint) {
                switch (this.stage) {
                    case 0: 
                    case 3: {
                        break;
                    }
                    case 1: {
                        if (this.getEscapedTokenIndex() != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                            this.buffer.append(' ');
                            break;
                        }
                        this.stage = (short)3;
                        break;
                    }
                    default: {
                        this.unexpectedCharError(index, codepoint);
                    }
                }
            }

            public void character(int index, int codePoint) {
                switch (codePoint) {
                    case 58: {
                        if (this.stage > 1) break;
                        this.buffer.append(':');
                        this.stage = (short)2;
                        return;
                    }
                    case 44: {
                        if (this.stage == 1) {
                            this.processBuffer(index, codePoint);
                            this.stage = 0;
                            return;
                        }
                        if (this.stage != 3) break;
                        this.stage = 0;
                        return;
                    }
                }
                this.unexpectedCharError(index, codePoint);
            }

            @Override
            public void leftCurlyBracket(int index) {
                if (this.stage == 2) {
                    this.unexpectedLeftCurlyBracketError(index);
                    return;
                }
                this.processBuffer(index, 123);
                if (this.isInError()) {
                    this.sendLeftCurlyBracketEvent(index, this);
                    return;
                }
                PageSelectorListImpl psList = this.pageSelectorList.isEmpty() ? null : this.pageSelectorList;
                CSSParser.this.handler.startPage(psList);
                this.stage = (short)4;
                this.expectRuleBody(index);
            }

            @Override
            void expectRuleBody(int index) {
                DeclarationRuleListManager.this.yieldManagement(new MarginRuleListManager(this.getManager()));
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                int len = this.buffer.length();
                if (len != 0) {
                    String selector = this.unescapeBuffer(index);
                    AbstractPageSelector sel = CSSParser.this.parsePageSelector(selector);
                    if (sel != null) {
                        this.pageSelectorList.add(sel);
                    } else {
                        this.unexpectedTokenError(index - len, selector);
                    }
                }
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (this.stage == 4) {
                    CSSParser.this.handler.endPage(this.pageSelectorList);
                }
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.pageSelectorList.clear();
                this.stage = 0;
            }

            private class MarginRuleListManager
            extends DescriptorRuleListManager {
                MarginRuleListManager(HandlerManager parent) {
                    super(parent);
                }

                @Override
                protected CSSTokenHandler createUnknownRuleHandler(int index, String ruleName) {
                    return new MarginRuleTH(ruleName);
                }

                @Override
                protected void reportRuleEnd(int index) {
                    PageRuleTH.this.reportRuleEnd(index);
                }

                class MarginRuleTH
                extends NoSelectorRuleHandler {
                    private final String ruleName;

                    MarginRuleTH(String ruleName) {
                        this.ruleName = ruleName;
                    }

                    @Override
                    public void leftCurlyBracket(int index) {
                        CSSParser.this.handler.startMargin(this.ruleName);
                        super.leftCurlyBracket(index);
                    }

                    @Override
                    protected void reportRuleEnd(int index) {
                        CSSParser.this.handler.endMargin();
                    }

                    @Override
                    public HandlerManager getManager() {
                        return MarginRuleListManager.this;
                    }
                }
            }
        }

        class CounterStyleTH
        extends AbstractBlockRuleHandler {
            private String counterStyleName;

            CounterStyleTH() {
                this.counterStyleName = null;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(64);
            }

            @Override
            public void word(int index, CharSequence word) {
                if (this.counterStyleName == null) {
                    super.word(index, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            }

            @Override
            public void escaped(int index, int codePoint) {
                if (this.counterStyleName == null) {
                    super.escaped(index, codePoint);
                } else {
                    this.unexpectedCharError(index, codePoint);
                }
            }

            public void character(int index, int codePoint) {
                this.unexpectedCharError(index, codePoint);
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                String name;
                int len = this.buffer.length();
                if (len != 0 && this.checkValidCustomIdent(index, name = this.unescapeBuffer(index))) {
                    this.counterStyleName = name;
                }
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (this.counterStyleName != null) {
                    CSSParser.this.handler.endCounterStyle();
                }
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.counterStyleName = null;
            }

            @Override
            public void leftCurlyBracket(int index) {
                if (this.counterStyleName == null) {
                    this.processBuffer(index, 123);
                    if (this.counterStyleName == null) {
                        this.unexpectedLeftCurlyBracketError(index);
                        return;
                    }
                }
                CSSParser.this.handler.startCounterStyle(this.counterStyleName);
                this.expectRuleBody(index);
            }

            @Override
            public void reportError(CSSParseException ex) throws CSSParseException {
                super.reportError(ex);
                this.counterStyleName = null;
            }
        }

        class KeyframesTH
        extends AbstractBlockRuleHandler {
            String keyframesName;

            KeyframesTH() {
                this.keyframesName = null;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(64);
            }

            @Override
            public void word(int index, CharSequence word) {
                if (this.keyframesName == null) {
                    super.word(index, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            }

            @Override
            public void escaped(int index, int codePoint) {
                if (this.keyframesName == null) {
                    super.escaped(index, codePoint);
                } else {
                    this.unexpectedCharError(index, codePoint);
                }
            }

            public void character(int index, int codePoint) {
                this.unexpectedCharError(index, codePoint);
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quote) {
                String s = quoted.toString();
                if (this.keyframesName == null) {
                    if (this.checkValidCustomIdent(index, s)) {
                        this.keyframesName = s;
                    }
                } else {
                    this.unexpectedTokenError(index, s);
                }
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                int len = this.buffer.length();
                if (len != 0) {
                    if (this.keyframesName == null) {
                        String s = this.unescapeBuffer(index);
                        if (this.checkValidCustomIdent(index, s)) {
                            this.keyframesName = s;
                        }
                    } else {
                        this.unexpectedTokenError(index - len, this.buffer);
                    }
                }
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (this.keyframesName != null) {
                    CSSParser.this.handler.endKeyframes();
                }
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.processBuffer(index, 123);
                if (this.isInError()) {
                    this.sendLeftCurlyBracketEvent(index, this);
                    return;
                }
                if (this.keyframesName == null) {
                    this.unexpectedLeftCurlyBracketError(index);
                    return;
                }
                CSSParser.this.handler.startKeyframes(this.keyframesName);
                this.expectRuleBody(index);
            }

            @Override
            void expectRuleBody(final int index) {
                DeclarationRuleListManager.this.yieldManagement(new KeyframeListManager(this.getManager()){

                    @Override
                    public void endManagement(int index2) {
                        KeyframesTH.this.reportRuleEnd(index2);
                        this.restoreManagement(DeclarationRuleListManager.this);
                    }

                    @Override
                    public void endOfStream(int len) {
                        KeyframesTH.this.reportRuleEnd(index);
                        DeclarationRuleListManager.this.endOfStream(len);
                    }
                });
            }

            @Override
            public void reportError(CSSParseException ex) throws CSSParseException {
                super.reportError(ex);
                this.keyframesName = null;
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.keyframesName = null;
            }
        }

        class FontFeatureValuesTH
        extends AbstractBlockRuleHandler {
            private LinkedList<String> familyList;
            private static final short STAGE_IDENT_FOUND = 1;
            private static final short STAGE_STRING_FOUND = 2;
            private static final short STAGE_COMMA_FOUND = 3;
            private static final short STAGE_PROCESSING_BODY = 4;
            short stage;

            FontFeatureValuesTH() {
                this.familyList = new LinkedList();
                this.stage = 0;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(72);
            }

            @Override
            public void word(int index, CharSequence word) {
                if (this.stage == 1) {
                    this.buffer.append(' ');
                }
                super.word(index, word);
                this.stage = 1;
            }

            @Override
            public void separator(int index, int codepoint) {
                if (this.getEscapedTokenIndex() != -1 && CSSParser.bufferEndsWithEscapedChar(this.buffer)) {
                    this.buffer.append(' ');
                }
                this.setWhitespacePrevCp();
            }

            public void character(int index, int codePoint) {
                switch (codePoint) {
                    case 44: {
                        if (this.stage == 1) {
                            this.processBuffer(index, codePoint);
                            this.stage = (short)3;
                            break;
                        }
                        if (this.stage == 2) {
                            this.stage = (short)3;
                            break;
                        }
                    }
                    default: {
                        this.unexpectedCharError(index, codePoint);
                        break;
                    }
                    case 59: {
                        this.unexpectedSemicolonError(index);
                    }
                }
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quote) {
                if (this.stage != 1) {
                    this.familyList.add(quoted.toString());
                    this.stage = (short)2;
                } else {
                    this.unexpectedTokenError(index, quoted);
                }
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (this.stage == 4) {
                    CSSParser.this.handler.endFontFeatures();
                }
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.processBuffer(index, 123);
                if (this.familyList.isEmpty()) {
                    this.unexpectedLeftCurlyBracketError(index);
                    return;
                }
                String[] ff = new String[this.familyList.size()];
                ff = this.familyList.toArray(ff);
                CSSParser.this.handler.startFontFeatures(ff);
                this.stage = (short)4;
                this.expectRuleBody(index);
            }

            @Override
            void expectRuleBody(int index) {
                DeclarationRuleListManager.this.yieldManagement(new FontFeatureListManager(this.getManager()){

                    @Override
                    protected void reportRuleEnd(int index) {
                        FontFeatureValuesTH.this.reportRuleEnd(index);
                    }
                });
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                String ff;
                if (this.buffer.length() != 0 && this.checkValidCustomIdent(index, ff = this.unescapeBuffer(index))) {
                    this.familyList.add(ff);
                }
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.familyList.clear();
                this.stage = 0;
            }
        }

        class PropertyTH
        extends AbstractBlockRuleHandler {
            private String customPropertyName;
            private CSSValueSyntax syntax;
            private boolean isUniversalSyntax;
            private boolean hasInherits;
            private LexicalUnit initialValue;
            private boolean ruleStarted;

            PropertyTH() {
                this.customPropertyName = null;
                this.syntax = null;
                this.initialValue = null;
                this.ruleStarted = false;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(64);
            }

            @Override
            public void word(int index, CharSequence word) {
                if (this.customPropertyName == null) {
                    super.word(index, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            }

            @Override
            public void escaped(int index, int codePoint) {
                if (this.customPropertyName == null) {
                    super.escaped(index, codePoint);
                } else {
                    this.unexpectedCharError(index, codePoint);
                }
            }

            public void character(int index, int codePoint) {
                this.unexpectedCharError(index, codePoint);
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                int len = this.buffer.length();
                if (len != 0) {
                    String name;
                    if (this.customPropertyName == null && (name = this.unescapeBuffer(index)).startsWith("--")) {
                        this.customPropertyName = name;
                        return;
                    }
                    this.unexpectedTokenError(index - len, this.buffer);
                }
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (this.ruleStarted) {
                    if (this.syntax == null) {
                        this.handleError(index, (byte)33, "@property rule lacks mandatory 'syntax' descriptor.");
                        CSSParser.this.handler.endProperty(true);
                    } else if (!this.hasInherits) {
                        this.handleError(index, (byte)33, "@property rule lacks mandatory 'inherits' descriptor.");
                        CSSParser.this.handler.endProperty(true);
                    } else if (!this.isUniversalSyntax && (this.initialValue == null || this.initialValue.matches(this.syntax) != CSSValueSyntax.Match.TRUE || this.initialValue.getLexicalUnitType() == LexicalUnit.LexicalType.DIMENSION && CSSUnit.isRelativeLengthUnitType(this.initialValue.getCssUnit()))) {
                        this.handleError(index, (byte)33, "@property rule lacks a valid 'initial-value' descriptor.");
                        CSSParser.this.handler.endProperty(true);
                    } else {
                        CSSParser.this.handler.endProperty(false);
                    }
                }
            }

            @Override
            public void leftCurlyBracket(int index) {
                if (this.customPropertyName == null) {
                    this.processBuffer(index, 123);
                    if (this.isInError()) {
                        this.sendLeftCurlyBracketEvent(index, this);
                        return;
                    }
                    if (this.customPropertyName == null) {
                        this.unexpectedLeftCurlyBracketError(index);
                        return;
                    }
                }
                this.ruleStarted = true;
                CSSParser.this.handler.startProperty(this.customPropertyName);
                this.expectRuleBody(index);
            }

            @Override
            void expectRuleBody(int index) {
                DeclarationRuleListManager.this.yieldManagement(new DescriptorListManager(this.getManager()){

                    @Override
                    protected void handleProperty(int index, String propertyName, LexicalUnitImpl lunit, boolean priorityImportant) {
                        if ("syntax".equalsIgnoreCase(propertyName)) {
                            if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) {
                                PropertyTH.this.handleError(index, (byte)33, "'syntax' descriptor in @property rule must be a string.");
                                return;
                            }
                            String s = lunit.getStringValue().trim();
                            SyntaxParser parser = new SyntaxParser();
                            try {
                                PropertyTH.this.syntax = parser.parseSyntax(s);
                            }
                            catch (CSSException e) {
                                PropertyTH.this.handleError(index, (byte)33, "Wrong 'syntax' descriptor in @property rule: '" + s + '\'');
                                return;
                            }
                            PropertyTH.this.isUniversalSyntax = PropertyTH.this.syntax.getCategory() == CSSValueSyntax.Category.universal;
                        } else if ("inherits".equalsIgnoreCase(propertyName)) {
                            String s;
                            if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || !"true".equals(s = lunit.getStringValue().toLowerCase(Locale.ROOT)) && !"false".equals(s)) {
                                PropertyTH.this.handleError(index, (byte)33, "'inherits' descriptor in @property rule must be either 'true' or 'false'.");
                                return;
                            }
                            PropertyTH.this.hasInherits = true;
                        } else if ("initial-value".equalsIgnoreCase(propertyName)) {
                            this.handleLexicalProperty(index, propertyName, lunit, priorityImportant);
                            PropertyTH.this.initialValue = lunit;
                            return;
                        }
                        super.handleProperty(index, propertyName, lunit, priorityImportant);
                    }

                    @Override
                    public void endManagement(int index) {
                        this.reportRuleEnd(index);
                        this.restoreManagement(DeclarationRuleListManager.this);
                    }

                    @Override
                    protected void reportRuleEnd(int index) {
                        PropertyTH.this.reportRuleEnd(index);
                    }
                });
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.customPropertyName = null;
                this.syntax = null;
                this.initialValue = null;
                this.hasInherits = false;
            }
        }

        class NamespaceRuleTH
        extends StatementAtRuleHandler {
            private String nsPrefix;
            private String namespaceURI;

            NamespaceRuleTH() {
                this.nsPrefix = null;
                this.namespaceURI = null;
            }

            @Override
            public void word(int index, CharSequence word) {
                if (this.namespaceURI == null) {
                    super.word(index, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            }

            @Override
            void processBuffer(int index, int triggerCp) {
                this.trimBufferTail();
                if (this.nsPrefix == null) {
                    this.nsPrefix = this.unescapeBuffer(index);
                }
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
                this.prevcp = 65;
                if (this.namespaceURI == null) {
                    if (quoted.length() > 0) {
                        this.namespaceURI = quoted.toString();
                        if (this.nsPrefix == null) {
                            this.nsPrefix = "";
                        }
                        return;
                    }
                    if (this.nsPrefix == null) {
                        this.nsPrefix = "";
                        return;
                    }
                }
                this.unexpectedTokenError(index, quoted);
            }

            public void character(int index, int codepoint) {
                this.prevcp = codepoint;
                if (codepoint == 59) {
                    if (this.buffer.length() != 0) {
                        this.processBuffer(index, codepoint);
                    }
                    this.handleSemicolon(index);
                } else {
                    this.unexpectedCharError(index, codepoint);
                }
            }

            private void handleSemicolon(int index) {
                if (this.namespaceURI != null) {
                    this.endRuleBody(index);
                } else {
                    this.reportError(index, (byte)33, "Incomplete @-rule.");
                    this.getManager().restoreInitialHandler();
                }
            }

            @Override
            public void leftParenthesis(final int index) {
                this.parendepth = (short)(this.parendepth + 1);
                if (this.namespaceURI == null && this.prevcp == 65 && this.bufferEqualsAndClear("url")) {
                    if (this.nsPrefix == null) {
                        this.nsPrefix = "";
                    }
                    this.yieldHandling(new URLTokenHandler(this){

                        @Override
                        protected void setURL(String url, LexicalUnitImpl urlUnit) {
                            if (url != null) {
                                NamespaceRuleTH.this.namespaceURI = url;
                            } else {
                                NamespaceRuleTH.this.unexpectedCharError(index, 41);
                            }
                        }
                    });
                } else {
                    this.unexpectedCharError(index, 40);
                }
                this.prevcp = 40;
            }

            @Override
            protected void reportRuleEnd(int index) {
                if (!this.isInError()) {
                    if (this.buffer.length() != 0) {
                        this.processBuffer(index, 32);
                        if (this.isInError()) {
                            this.resetHandler();
                            return;
                        }
                    }
                    if (this.nsPrefix == null) {
                        this.reportError(index, (byte)9, "Malformed @-rule.");
                        return;
                    }
                    if (this.namespaceURI != null) {
                        this.namespaceDeclaration(this.nsPrefix, this.namespaceURI);
                    } else {
                        this.reportError(index, (byte)33, "No URI in namespace rule");
                        return;
                    }
                }
                this.resetHandler();
            }

            void namespaceDeclaration(String prefix, String uri) {
                CSSParser.this.handler.namespaceDeclaration(prefix, uri);
                this.registerNamespacePrefix(prefix, uri);
            }

            protected void registerNamespacePrefix(String prefix, String uri) {
            }

            @Override
            public void endOfStream(int len) {
                this.reportRuleEnd(len);
                if (this.parendepth == 0) {
                    if (!this.isInError()) {
                        this.handleWarning(len, (byte)-6, "Unexpected end of stream");
                    }
                } else if (!this.isInError()) {
                    this.unexpectedEOFError(len);
                }
                super.endOfStream(len);
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.nsPrefix = null;
                this.namespaceURI = null;
            }
        }

        class UnknownRuleTokenHandler
        extends ManagerCallbackTokenHandler {
            private int curlyBracketDepth;
            private int sqBracketDepth;

            UnknownRuleTokenHandler(String ruleName) {
                super(DeclarationRuleListManager.this);
                this.curlyBracketDepth = 0;
                this.sqBracketDepth = 0;
                if (ruleName == null || ruleName.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                this.buffer.append('@').append(ruleName);
                this.prevcp = 64;
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(300);
            }

            @Override
            public void handleErrorRecovery() {
            }

            @Override
            public void separator(int index, int codepoint) {
                if (!this.isPrevCpWhitespace() || this.isEscapedIdent() && CSSParser.bufferEndsWithEscapedCharOrWS(this.buffer)) {
                    this.buffer.append(' ');
                }
                this.setWhitespacePrevCp();
            }

            @Override
            public void quoted(int index, CharSequence quoted, int quoteCp) {
                char c = (char)quoteCp;
                this.buffer.append(c).append(quoted).append(c);
                this.prevcp = 64;
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.buffer.append('{');
                ++this.curlyBracketDepth;
                this.prevcp = 123;
            }

            @Override
            public void leftParenthesis(int index) {
                this.buffer.append('(');
                this.parendepth = (short)(this.parendepth + 1);
                this.prevcp = 40;
            }

            @Override
            public void leftSquareBracket(int index) {
                this.buffer.append('[');
                ++this.sqBracketDepth;
                this.prevcp = 91;
            }

            @Override
            public void rightParenthesis(int index) {
                this.buffer.append(')');
                this.parendepth = (short)(this.parendepth - 1);
                this.prevcp = 41;
            }

            @Override
            public void rightSquareBracket(int index) {
                this.buffer.append(']');
                --this.sqBracketDepth;
                this.prevcp = 93;
            }

            @Override
            public void rightCurlyBracket(int index) {
                this.buffer.append('}');
                --this.curlyBracketDepth;
                if (this.syntaxCheck()) {
                    this.endRuleBody(index);
                }
                this.prevcp = 125;
            }

            public void character(int index, int codepoint) {
                this.bufferAppend(codepoint);
                this.prevcp = codepoint;
                if (codepoint == 59 && this.syntaxCheck()) {
                    this.endRuleBody(index);
                }
            }

            private boolean syntaxCheck() {
                return this.curlyBracketDepth == 0 && this.parendepth == 0 && this.sqBracketDepth == 0;
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                if (commentType == 0) {
                    this.buffer.append("/*").append(comment).append("*/");
                }
            }

            void endRuleBody(int index) {
                this.reportRuleEnd(index);
                DeclarationRuleListManager.this.restoreInitialHandler();
            }

            void reportRuleEnd(int index) {
                this.trimBufferTail();
                CSSParser.this.handler.ignorableAtRule(this.buffer.toString());
                this.resetHandler();
            }

            @Override
            void processBuffer(int index, int triggerCp) {
            }

            @Override
            public void endOfStream(int len) {
                this.reportRuleEnd(len);
                this.getManager().endOfStream(len);
            }
        }

        abstract class KeyframeListManager
        extends CSSParserHandlerManager {
            KeyframeListManager(HandlerManager parent) {
                super(parent);
            }

            @Override
            protected CSSTokenHandler getInitialTokenHandler() {
                return new KeyframeTH();
            }

            @Override
            public void rightCurlyBracket(int index) {
                this.endManagement(index);
            }

            class KeyframeTH
            extends DeclarationListManager.DeclarationIdentTokenHandler {
                private LexicalUnitImpl keyframeSelector = null;
                private LexicalUnitImpl currentlu = null;

                KeyframeTH() {
                }

                @Override
                protected void initializeBuffer() {
                    this.buffer = new StringBuilder(50);
                }

                @Override
                public void commented(int index, int commentType, String comment) {
                    this.separator(index, 12);
                    if (this.keyframeSelector == null && this.currentlu == null && commentType == 0) {
                        CSSParser.this.handler.comment(comment, this.isPreviousCpLF());
                    }
                    this.prevcp = 12;
                }

                @Override
                void processBuffer(int index, int triggerCp) {
                    int len = this.buffer.length();
                    if (len != 0) {
                        String raw = this.buffer.toString();
                        if (CSSUtil.isValidIdentifier(raw)) {
                            String s = this.unescapeBuffer(index);
                            if (this.checkValidCustomIdent(index, s)) {
                                LexicalUnitImpl sel = new LexicalUnitImpl(LexicalUnit.LexicalType.IDENT);
                                sel.value = s;
                                sel.identCssText = raw;
                                this.setCurrentLexicalUnit(sel);
                            }
                        } else if ("0".equals(raw)) {
                            LexicalUnitImpl sel = new LexicalUnitImpl(LexicalUnit.LexicalType.INTEGER);
                            sel.intValue = 0;
                            sel.setCssUnit((short)0);
                            this.setCurrentLexicalUnit(sel);
                        } else {
                            this.unexpectedTokenError(index, "Invalid identifier: " + raw);
                        }
                    }
                }

                @Override
                public void character(int index, int codePoint) {
                    switch (codePoint) {
                        case 37: {
                            if (this.buffer.length() <= 0) break;
                            String s = this.rawBuffer();
                            try {
                                float pcnt = Float.parseFloat(s);
                                LexicalUnitImpl sel = new LexicalUnitImpl(LexicalUnit.LexicalType.PERCENTAGE);
                                sel.floatValue = pcnt;
                                sel.dimensionUnitText = "%";
                                sel.setCssUnit((short)2);
                                this.setCurrentLexicalUnit(sel);
                                return;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break;
                            }
                        }
                        case 44: {
                            this.processBuffer(index, codePoint);
                            if (this.keyframeSelector == null) break;
                            this.setCurrentLexicalUnit(new LexicalUnitImpl(LexicalUnit.LexicalType.OPERATOR_COMMA));
                            this.prevcp = codePoint;
                            return;
                        }
                        case 45: {
                            if (this.buffer.length() == 0) break;
                        }
                        case 43: 
                        case 46: {
                            this.buffer.append((char)codePoint);
                            return;
                        }
                    }
                    this.unexpectedCharError(index, codePoint);
                }

                private void setCurrentLexicalUnit(LexicalUnitImpl sel) {
                    if (this.currentlu != null) {
                        this.currentlu.nextLexicalUnit = sel;
                        sel.previousLexicalUnit = this.currentlu;
                    } else {
                        this.keyframeSelector = sel;
                    }
                    this.currentlu = sel;
                }

                @Override
                public void leftCurlyBracket(final int index) {
                    if (this.keyframeSelector == null) {
                        this.processBuffer(index, 123);
                        if (this.isInError()) {
                            this.sendLeftCurlyBracketEvent(index, this);
                            return;
                        }
                        if (this.keyframeSelector == null) {
                            this.unexpectedLeftCurlyBracketError(index);
                            return;
                        }
                    }
                    CSSParser.this.handler.startKeyframe(this.keyframeSelector);
                    this.keyframeSelector = null;
                    KeyframeListManager.this.yieldManagement(new DescriptorListManager(this.getManager()){

                        @Override
                        public void endManagement(int index2) {
                            this.reportRuleEnd(index2);
                            this.restoreManagement(KeyframeListManager.this);
                        }

                        @Override
                        public void endOfStream(int len) {
                            this.reportRuleEnd(index);
                            KeyframeListManager.this.endOfStream(len);
                        }

                        @Override
                        protected void reportRuleEnd(int index2) {
                            CSSParser.this.handler.endKeyframe();
                        }
                    });
                }

                @Override
                public void resetHandler() {
                    super.resetHandler();
                    this.keyframeSelector = null;
                    this.currentlu = null;
                }

                @Override
                public HandlerManager getManager() {
                    return KeyframeListManager.this;
                }
            }
        }

        abstract class FontFeatureListManager
        extends DescriptorRuleListManager {
            FontFeatureListManager(HandlerManager parent) {
                super(parent);
            }

            @Override
            public void rightCurlyBracket(int index) {
                this.endManagement(index);
            }

            @Override
            protected CSSTokenHandler createUnknownRuleHandler(int index, String ruleName) {
                return new FontFeatureTH(ruleName);
            }

            class FontFeatureTH
            extends NoSelectorRuleHandler {
                private String featureMapName;

                FontFeatureTH(String ruleName) {
                    this.featureMapName = ruleName;
                }

                @Override
                public void leftCurlyBracket(int index) {
                    CSSParser.this.handler.startFeatureMap(this.featureMapName);
                    super.leftCurlyBracket(index);
                }

                @Override
                protected void reportRuleEnd(int index) {
                    CSSParser.this.handler.endFeatureMap();
                }

                @Override
                public HandlerManager getManager() {
                    return FontFeatureListManager.this;
                }
            }
        }

        abstract class NoSelectorRuleHandler
        extends AbstractBlockRuleHandler {
            protected NoSelectorRuleHandler() {
            }

            @Override
            public void word(int index, CharSequence word) {
                this.unexpectedTokenError(index, word);
            }

            @Override
            public void escaped(int index, int codepoint) {
                this.unexpectedCharError(index - 1, 92);
            }

            @Override
            public void separator(int index, int codepoint) {
            }

            @Override
            void processBuffer(int index, int triggerCp) {
            }

            public void character(int index, int codePoint) {
                if (codePoint == 59) {
                    if (this.unexpectedSemicolonError(index)) {
                        this.getManager().restoreInitialHandler();
                    }
                    this.resetParseError();
                } else {
                    this.unexpectedCharError(index, codePoint);
                }
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.expectRuleBody(index);
            }

            @Override
            public void handleErrorRecovery() {
                this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler(){

                    @Override
                    protected void endDeclarationBlock(int index) {
                        NoSelectorRuleHandler.this.endRule();
                        super.endDeclarationBlock(index);
                    }
                });
            }
        }

        abstract class AbstractBlockRuleHandler
        extends AbstractRuleHandler {
            AbstractBlockRuleHandler() {
            }

            void expectRuleBody(int index) {
                DeclarationRuleListManager.this.yieldManagement(new DescriptorListManager(this.getManager()){

                    @Override
                    protected void reportRuleEnd(int index) {
                        AbstractBlockRuleHandler.this.reportRuleEnd(index);
                    }
                });
            }

            @Override
            public void endOfStream(int len) {
                this.unexpectedEOFError(len);
                super.endOfStream(len);
            }
        }

        abstract class RuleMediaQueryTH
        extends MediaQueryTokenHandler {
            RuleMediaQueryTH(MediaQueryFactory conditionFactory, MediaQueryHandler mqhandler) {
                super(conditionFactory, mqhandler);
                mqhandler.startQuery();
            }
        }

        abstract class StatementAtRuleHandler
        extends AbstractRuleHandler {
            StatementAtRuleHandler() {
            }

            @Override
            protected void initializeBuffer() {
                this.buffer = new StringBuilder(100);
            }

            @Override
            public void resetHandler() {
                super.resetHandler();
                this.buffer.setLength(0);
            }
        }

        abstract class AbstractRuleHandler
        extends DefaultTokenHandler {
            AbstractRuleHandler() {
            }

            @Override
            public void commented(int index, int commentType, String comment) {
                this.separator(index, 12);
                this.prevcp = 12;
            }

            @Override
            public HandlerManager getManager() {
                return DeclarationRuleListManager.this;
            }

            @Override
            public void handleErrorRecovery() {
                this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler(){

                    @Override
                    protected void endDeclarationBlock(int index) {
                        AbstractRuleHandler.this.reportRuleEnd(index);
                        super.endDeclarationBlock(index);
                    }
                });
            }

            void endRuleBody(int index) {
                this.reportRuleEnd(index);
                this.endRule();
            }

            protected abstract void reportRuleEnd(int var1);

            protected void endRule() {
                DeclarationRuleListManager.this.restoreInitialHandler();
            }

            @Override
            public void endOfStream(int len) {
                this.getManager().endOfStream(len);
            }
        }
    }

    abstract class DescriptorRuleListManager
    extends DeclarationRuleListManager {
        DescriptorRuleListManager() {
        }

        DescriptorRuleListManager(HandlerManager parent) {
            super(parent);
        }

        @Override
        protected ValueTokenHandler createValueTokenHandler() {
            return new DeclarationListManager.DescriptorDeclValueTH();
        }

        @Override
        public void endManagement(int index) {
            this.reportRuleEnd(index);
            super.endManagement(index);
        }

        @Override
        public void endOfStream(int len) {
            this.reportRuleEnd(len);
            super.endOfStream(len);
        }

        protected abstract void reportRuleEnd(int var1);
    }

    private class BlockContentsManager
    extends DeclarationRuleListManager {
        final BlockContentsDeclarationManager declarationManager;
        final StyleRuleSelectorTH selectorHandler;
        private final boolean topLevel;
        boolean rulesFound;

        BlockContentsManager(Parser.NamespaceMap nsMap, boolean topLevel) {
            this.rulesFound = false;
            this.topLevel = topLevel;
            this.declarationManager = this.createDeclarationManager();
            this.selectorHandler = this.createSelectorTokenHandler(nsMap);
            this.selectorHandler.setManager(this);
        }

        BlockContentsManager(BlockContentsManager parent) {
            super(parent);
            this.rulesFound = false;
            this.topLevel = parent.topLevel;
            this.rulesFound = true;
            this.declarationManager = this.createDeclarationManager();
            this.selectorHandler = this.createSelectorTokenHandler(parent.selectorHandler.nsMap);
            this.selectorHandler.setManager(this);
        }

        BlockContentsManager(BlockContentsDeclarationManager parent) {
            super(parent);
            this.rulesFound = false;
            BlockContentsManager parentMan = parent.getParentManager();
            this.topLevel = parentMan.topLevel;
            this.rulesFound = true;
            this.declarationManager = this.createDeclarationManager();
            this.selectorHandler = this.createSelectorTokenHandler(parentMan.selectorHandler.nsMap);
            this.selectorHandler.setManager(this);
        }

        protected BlockContentsDeclarationManager createDeclarationManager() {
            return new BlockContentsDeclarationManager();
        }

        protected StyleRuleSelectorTH createSelectorTokenHandler(Parser.NamespaceMap nsMap) {
            return new StyleRuleSelectorTH(nsMap);
        }

        @Override
        void setRulesFound() {
            this.rulesFound = true;
        }

        @Override
        boolean rulesFound() {
            return this.rulesFound;
        }

        @Override
        public void restoreInitialHandler() {
            super.restoreInitialHandler();
            this.selectorHandler.resetHandler();
            this.selectorHandler.resetParseError();
        }

        @Override
        public void endOfStream(int len) {
            SelectorListImpl selist = this.selectorHandler.getSelectorList();
            if (!selist.isEmpty()) {
                CSSParser.this.handler.endSelector(selist);
            }
            super.endOfStream(len);
        }

        @Override
        public void endManagement(int index) {
            SelectorListImpl selist = this.selectorHandler.getSelectorList();
            if (!selist.isEmpty()) {
                CSSParser.this.handler.endSelector(selist);
                this.selectorHandler.selist = this.selectorHandler.new SelectorTokenHandler.ParserSelectorListImpl();
            } else {
                HandlerManager parentMgr = this.getParentManager();
                if (parentMgr == null) {
                    if (!this.getControlHandler().isInErrorRecovery()) {
                        this.selectorHandler.unexpectedCharError(index, 125);
                    }
                } else {
                    this.resetFields();
                    this.selectorHandler.resetHandler();
                    this.yieldManagement(parentMgr);
                    return;
                }
            }
            this.resetFields();
            this.restoreInitialHandler();
        }

        @Override
        protected String defaultNamespaceURI() {
            return this.selectorHandler.factory.getNamespaceURI("");
        }

        @Override
        protected CSSTokenHandler createNamespaceRuleTH() {
            return new DeclarationRuleListManager.NamespaceRuleTH(){

                @Override
                protected void registerNamespacePrefix(String prefix, String uri) {
                    BlockContentsManager.this.selectorHandler.factory.registerNamespacePrefix(prefix, uri);
                }
            };
        }

        @Override
        protected ManagerCallbackTokenHandler createUnknownRuleHandler(int index, String ruleName) {
            ManagerCallbackTokenHandler ruleHandler = "media".equals(ruleName) ? this.createMediaQueryHandler() : ("supports".equals(ruleName) ? this.createSupportsConditionHandler() : (ManagerCallbackTokenHandler)super.createUnknownRuleHandler(index, ruleName));
            return ruleHandler;
        }

        protected MediaQueryTokenHandler createMediaQueryHandler() {
            MediaQueryFactory mediaQueryFactory = CSSParser.this.getMediaQueryFactory();
            MediaQueryHandler mqhandler = mediaQueryFactory.createMediaQueryHandler(null);
            MediaRuleMediaQueryTH th = new MediaRuleMediaQueryTH(mediaQueryFactory, mqhandler);
            th.setManager(this);
            return th;
        }

        protected SupportsTokenHandler createSupportsConditionHandler() {
            SupportsRuleTH th = new SupportsRuleTH();
            th.setManager(this);
            return th;
        }

        private class BlockContentsDeclarationManager
        extends DeclarationRuleListManager {
            BlockContentsDeclarationManager() {
                super(BlockContentsManager.this);
            }

            @Override
            protected BlockContentsManager getParentManager() {
                return BlockContentsManager.this;
            }

            @Override
            public void endManagement(int index) {
                BlockContentsManager.this.endManagement(index);
            }

            @Override
            public void endOfStream(int len) {
                BlockContentsManager.this.endOfStream(len);
            }

            @Override
            protected CSSTokenHandler createUnknownRuleHandler(int index, String ruleName) {
                ManagerCallbackTokenHandler th = BlockContentsManager.this.createUnknownRuleHandler(index, ruleName);
                th.setManager(this);
                return th;
            }

            @Override
            protected CSSTokenHandler createPropertyNameTokenHandler() {
                return new BlockContentsPropertyNameTH();
            }

            @Override
            protected ValueTokenHandler createValueTokenHandler() {
                return new DeclarationListManager.DeclValueTokenHandler(){

                    @Override
                    public void leftCurlyBracket(int index) {
                        if (this.functionToken || this.getLexicalUnit() == null && this.buffer.length() == 0) {
                            super.leftCurlyBracket(index);
                        } else {
                            StyleRuleSelectorTH selh = this.nestedSelectorHandler(index);
                            if (selh == null) {
                                super.leftCurlyBracket(index);
                                return;
                            }
                            selh.leftCurlyBracket(index);
                        }
                    }

                    @Override
                    protected StyleRuleSelectorTH nestedSelectorHandler(int index) {
                        NestedRuleManager nested = new NestedRuleManager();
                        StyleRuleSelectorTH selh = nested.selectorHandler;
                        selh.word(index, BlockContentsDeclarationManager.this.propertyName);
                        if (BlockContentsDeclarationManager.this.whitespaceBeforeColon) {
                            selh.separator(index, 32);
                        }
                        selh.character(index, 58);
                        LexicalUnitImpl lu = this.getLexicalUnit();
                        while (lu != null) {
                            switch (lu.getLexicalUnitType()) {
                                case IDENT: {
                                    selh.word(index, lu.currentToString());
                                    selh.separator(index, 32);
                                    break;
                                }
                                case OPERATOR_COMMA: {
                                    selh.character(index, 44);
                                    break;
                                }
                                case EMPTY: {
                                    break;
                                }
                                default: {
                                    return null;
                                }
                            }
                            lu = lu.nextLexicalUnit;
                        }
                        if (this.buffer.length() != 0) {
                            selh.word(index, this.buffer);
                        }
                        return selh;
                    }

                    @Override
                    protected void handlePseudo(int index) {
                        StyleRuleSelectorTH selh = this.nestedSelectorHandler(index);
                        if (selh != null) {
                            selh.character(index, 58);
                            this.yieldHandling(selh);
                        } else {
                            super.handlePseudo(index);
                        }
                    }
                };
            }

            private void setNestingSelector(SelectorTokenHandler selh) {
                NestingCondition nesting = NestingCondition.getInstance();
                if (selh.currentsel == null) {
                    selh.currentsel = selh.factory.createConditionalSelector(NSACSelectorFactory.getUniversalSelector(), nesting);
                } else if (selh.currentsel.isSimpleSelector()) {
                    selh.currentsel = selh.currentsel.withCondition(selh.factory, nesting);
                } else {
                    NSACSelectorFactory.CombinatorSelectorImpl comb = (NSACSelectorFactory.CombinatorSelectorImpl)selh.currentsel;
                    SimpleSelector simple = comb.simpleSelector;
                    simple = simple == null ? selh.factory.createConditionalSelector(NSACSelectorFactory.getUniversalSelector(), nesting) : ((AbstractSelector)((Object)simple)).withCondition(selh.factory, nesting);
                    comb.simpleSelector = simple;
                }
                selh.prevcp = 65;
                selh.stage = 1;
            }

            private SelectorTokenHandler yieldToNestedRuleHandler() {
                NestedRuleManager nested = new NestedRuleManager();
                StyleRuleSelectorTH selh = nested.selectorHandler;
                this.getControlHandler().yieldHandling(selh);
                return selh;
            }

            private class BlockContentsPropertyNameTH
            extends DeclarationListManager.PropertyNameTokenHandler {
                BlockContentsPropertyNameTH() {
                }

                @Override
                public void leftCurlyBracket(int index) {
                    NestedRuleManager nested = new NestedRuleManager();
                    StyleRuleSelectorTH selh = nested.selectorHandler;
                    this.setSelectorState(index, 123, selh);
                    selh.processBuffer(index, 123, true);
                    if (this.isInError()) {
                        this.getControlHandler().getCurrentHandler().leftCurlyBracket(index);
                    } else if (selh.currentsel == null) {
                        super.leftCurlyBracket(index);
                    } else {
                        ((SelectorTokenHandler)selh).leftCurlyBracket(index);
                    }
                }

                @Override
                public void leftSquareBracket(int index) {
                    SelectorTokenHandler selh = BlockContentsDeclarationManager.this.yieldToNestedRuleHandler();
                    this.setSelectorState(index, 91, selh);
                    if (selh.currentsel == null && selh.stage == 0) {
                        BlockContentsDeclarationManager.this.setNestingSelector(selh);
                        selh.stage = (byte)2;
                    }
                    selh.leftSquareBracket(index);
                }

                @Override
                protected void nonPropertyToken(int index, CharSequence word) {
                    SelectorTokenHandler selh = BlockContentsDeclarationManager.this.yieldToNestedRuleHandler();
                    BlockContentsDeclarationManager.this.setNestingSelector(selh);
                    selh.stage = (byte)2;
                    selh.word(index, BlockContentsDeclarationManager.this.propertyName);
                    selh.separator(index, 32);
                    selh.word(index, word);
                    this.resetHandler();
                    BlockContentsDeclarationManager.this.resetFields();
                }

                @Override
                protected void nonPropertyEscaped(int index, int codepoint) {
                    SelectorTokenHandler selh = BlockContentsDeclarationManager.this.yieldToNestedRuleHandler();
                    BlockContentsDeclarationManager.this.setNestingSelector(selh);
                    selh.stage = (byte)2;
                    selh.word(index, BlockContentsDeclarationManager.this.propertyName);
                    selh.separator(index, 32);
                    selh.escaped(index, codepoint);
                    this.resetHandler();
                    BlockContentsDeclarationManager.this.resetFields();
                }

                @Override
                protected void nestingSelector(int index) {
                    SelectorTokenHandler selh = BlockContentsDeclarationManager.this.yieldToNestedRuleHandler();
                    this.setSelectorState(index, 38, selh);
                    if (selh.currentsel == null) {
                        BlockContentsDeclarationManager.this.setNestingSelector(selh);
                    } else {
                        selh.character(index, 38);
                    }
                }

                private void setSelectorState(int index, int triggerCp, SelectorTokenHandler selh) {
                    if (BlockContentsDeclarationManager.this.propertyName != null) {
                        selh.word(index, BlockContentsDeclarationManager.this.propertyName);
                        selh.processBuffer(index, 32, false);
                        selh.stage = (byte)2;
                    } else if (this.buffer.length() > 0) {
                        selh.word(index, this.buffer);
                        selh.setEscapedTokenStart(this.getEscapedTokenIndex());
                        if (this.isPrevCpWhitespace()) {
                            selh.processBuffer(index, triggerCp, false);
                            selh.stage = (byte)2;
                        }
                        this.buffer.setLength(0);
                    }
                    this.resetHandler();
                    BlockContentsDeclarationManager.this.resetFields();
                }

                @Override
                protected void expectSelector(int index, int triggerCp) {
                    SelectorTokenHandler selh = BlockContentsDeclarationManager.this.yieldToNestedRuleHandler();
                    this.setSelectorState(index, triggerCp, selh);
                    selh.character(index, triggerCp);
                }

                @Override
                protected void expectCompoundSelector(int index, int triggerCp) {
                    SelectorTokenHandler selh = BlockContentsDeclarationManager.this.yieldToNestedRuleHandler();
                    this.setSelectorState(index, triggerCp, selh);
                    if (selh.currentsel == null) {
                        BlockContentsDeclarationManager.this.setNestingSelector(selh);
                    }
                    selh.character(index, triggerCp);
                }
            }

            private class NestedRuleManager
            extends BlockContentsManager {
                NestedRuleManager() {
                    super(BlockContentsDeclarationManager.this);
                }

                @Override
                protected StyleRuleSelectorTH createSelectorTokenHandler(Parser.NamespaceMap nsMap) {
                    NSACSelectorFactory factory = BlockContentsManager.this.selectorHandler.factory;
                    StyleRuleSelectorTH selh = (BlockContentsManager)this.new StyleRuleSelectorTH(factory);
                    return selh;
                }

                @Override
                public void restoreInitialHandler() {
                    this.selectorHandler.resetHandler();
                    this.selectorHandler.resetParseError();
                    this.yieldManagement(this.getParentManager());
                }

                @Override
                public void endManagement(int index) {
                    SelectorListImpl selist = this.selectorHandler.getSelectorList();
                    if (!selist.isEmpty()) {
                        CSSParser.this.handler.endSelector(selist);
                    }
                    this.resetFields();
                    this.yieldManagement(BlockContentsDeclarationManager.this);
                }

                @Override
                public void endOfStream(int len) {
                    SelectorListImpl selist = this.selectorHandler.getSelectorList();
                    if (!selist.isEmpty()) {
                        CSSParser.this.handler.endSelector(selist);
                    }
                    BlockContentsManager.this.endOfStream(len);
                }
            }
        }

        class StyleRuleSelectorTH
        extends SelectorTokenHandler {
            StyleRuleSelectorTH(Parser.NamespaceMap nsMap) {
                super(nsMap);
            }

            StyleRuleSelectorTH(NSACSelectorFactory factory) {
                super(factory);
            }

            @Override
            public void leftCurlyBracket(int index) {
                this.processBuffer(index, 123, true);
                if (!this.isInError()) {
                    if (this.addCurrentSelector(index)) {
                        this.selist.trimToSize();
                        CSSParser.this.handler.startSelector(this.selist);
                        BlockContentsManager.this.yieldManagement(BlockContentsManager.this.declarationManager);
                        BlockContentsManager.this.setRulesFound();
                    } else {
                        this.unexpectedLeftCurlyBracketError(index);
                    }
                } else {
                    this.sendLeftCurlyBracketEvent(index, this);
                }
                this.buffer.setLength(0);
                this.resetEscapedTokenIndex();
                this.stage = 0;
            }

            @Override
            public void rightCurlyBracket(int index) {
                this.processBuffer(index, 32, true);
                if (!this.parseError) {
                    if (!this.selist.isEmpty() || this.currentsel != null) {
                        this.unexpectedCharError(index, 125);
                    }
                    this.resetHandler();
                    this.selist.clear();
                }
                BlockContentsManager.this.endManagement(index);
            }

            @Override
            boolean skipCharacterHandling() {
                return this.parseError && (this.prevcp != 59 || this.curlyBracketDepth != 0);
            }

            @Override
            protected void handleAtKeyword(int index) {
                if (this.buffer.length() == 0) {
                    BlockContentsManager.this.handleAtKeyword(index);
                } else {
                    super.handleAtKeyword(index);
                }
            }

            @Override
            protected void handleSemicolon(int index) {
                this.unexpectedSemicolonError(index);
                this.resetHandler();
                this.resetParseError();
                BlockContentsManager.this.declarationManager.restoreInitialHandler();
            }

            @Override
            protected void handleStarHack(int index, CharSequence word) {
                int idx = index - 1;
                if (!CSSUtil.isValidIdentifier(word)) {
                    this.handleWarning(idx, (byte)-4, "Suspicious property name in STARHACK IE Hack: *" + word);
                } else {
                    this.handleWarning(idx, (byte)-4, "STARHACK IE hack: *" + word);
                }
                DeclarationListManager mgr = (DeclarationListManager)BlockContentsManager.this.getParentManager();
                DeclarationListManager.PropertyNameTokenHandler starhackHandler = new DeclarationListManager.PropertyNameTokenHandler(mgr){

                    @Override
                    void processBuffer(int index, int triggerCp) {
                        this.getManager().propertyName = this.unescapeBuffer(index);
                        this.setWhitespacePrevCp();
                    }

                    @Override
                    public DeclarationListManager getManager() {
                        return (DeclarationListManager)BlockContentsManager.this.getParentManager();
                    }
                };
                starhackHandler.buffer.append('*').append(word);
                starhackHandler.prevcp = 65;
                this.yieldHandling(starhackHandler);
            }

            @Override
            boolean isTopLevel() {
                return BlockContentsManager.this.topLevel;
            }

            @Override
            public void endOfStream(int len) {
                this.processBuffer(len, 32, true);
                if (!(this.isInError() || this.selist.isEmpty() && this.currentsel == null)) {
                    this.unexpectedEOFError(len);
                    this.selist.clear();
                }
                BlockContentsManager.this.endOfStream(len);
            }

            @Override
            public void handleErrorRecovery() {
                this.yieldHandling(new BufferTokenHandler.IgnoredDeclarationTokenHandler(){

                    @Override
                    protected void resumeDeclarationList() {
                        this.getManager().getParentManager().restoreInitialHandler();
                    }

                    @Override
                    protected void endDeclarationBlock(int index) {
                        this.getManager().getParentManager().rightCurlyBracket(index);
                    }
                });
            }
        }

        class MediaRuleMediaQueryTH
        extends DeclarationRuleListManager.RuleMediaQueryTH {
            private MediaQueryList currentMediaCondition;

            MediaRuleMediaQueryTH(MediaQueryFactory conditionFactory, MediaQueryHandler mqhandler) {
                super(conditionFactory, mqhandler);
            }

            @Override
            boolean endOfCondition(int index, boolean eof) {
                boolean ret = super.endOfCondition(index, eof);
                this.currentMediaCondition = this.getPredicateHandler().getMediaQueryHandler().getMediaQueryList();
                return ret;
            }

            @Override
            void handleLeftCurlyBracket(int index) {
                if (this.endOfCondition(index, false)) {
                    CSSParser.this.handler.startMedia(this.currentMediaCondition);
                    DeclarationRuleListManager declMan = BlockContentsManager.this.selectorHandler.selist.isEmpty() ? new RuleListManager(BlockContentsManager.this){

                        @Override
                        public void endManagement(int index) {
                            SelectorListImpl selist = this.selectorHandler.getSelectorList();
                            if (!selist.isEmpty()) {
                                super.endManagement(index);
                            } else {
                                CSSParser.this.handler.endMedia(MediaRuleMediaQueryTH.this.currentMediaCondition);
                                this.yieldManagement(MediaRuleMediaQueryTH.this.getManager());
                            }
                        }

                        @Override
                        public void endOfStream(int len) {
                            SelectorListImpl selist = this.selectorHandler.getSelectorList();
                            if (!selist.isEmpty()) {
                                CSSParser.this.handler.endSelector(selist);
                            }
                            CSSParser.this.handler.endMedia(MediaRuleMediaQueryTH.this.currentMediaCondition);
                            MediaRuleMediaQueryTH.this.getManager().endOfStream(len);
                        }
                    } : new BlockContentsDeclarationManager(){

                        @Override
                        public void endManagement(int index) {
                            CSSParser.this.handler.endMedia(MediaRuleMediaQueryTH.this.currentMediaCondition);
                            this.yieldManagement(MediaRuleMediaQueryTH.this.getManager());
                        }

                        @Override
                        public void endOfStream(int len) {
                            CSSParser.this.handler.endMedia(MediaRuleMediaQueryTH.this.currentMediaCondition);
                            MediaRuleMediaQueryTH.this.getManager().endOfStream(len);
                        }
                    };
                    BlockContentsManager.this.yieldManagement(declMan);
                } else {
                    this.handleErrorRecovery();
                }
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                if (this.currentMediaCondition != null) {
                    CSSParser.this.handler.endMedia(this.currentMediaCondition);
                }
                if (!this.isInError()) {
                    this.unexpectedEOFError(len);
                }
                this.getManager().endOfStream(len);
            }
        }

        private class SupportsRuleTH
        extends SupportsTokenHandler {
            private BooleanCondition currentSupportsCondition;

            SupportsRuleTH() {
                super((CSSRule)null);
            }

            @Override
            boolean endOfCondition(int index, boolean eof) {
                boolean ret = super.endOfCondition(index, eof);
                if (ret) {
                    this.currentSupportsCondition = this.getCondition();
                    CSSParser.this.handler.startSupports(this.currentSupportsCondition);
                }
                return ret;
            }

            @Override
            void handleLeftCurlyBracket(int index) {
                if (this.endOfCondition(index, false)) {
                    DeclarationRuleListManager declMan = BlockContentsManager.this.selectorHandler.selist.isEmpty() ? new RuleListManager(BlockContentsManager.this){

                        @Override
                        public void endManagement(int index) {
                            SelectorListImpl selist = this.selectorHandler.getSelectorList();
                            if (!selist.isEmpty()) {
                                super.endManagement(index);
                            } else {
                                CSSParser.this.handler.endSupports(SupportsRuleTH.this.currentSupportsCondition);
                                this.yieldManagement(SupportsRuleTH.this.getManager());
                            }
                        }

                        @Override
                        public void endOfStream(int len) {
                            SelectorListImpl selist = this.selectorHandler.getSelectorList();
                            if (!selist.isEmpty()) {
                                CSSParser.this.handler.endSelector(selist);
                            }
                            CSSParser.this.handler.endSupports(SupportsRuleTH.this.currentSupportsCondition);
                            SupportsRuleTH.this.getManager().endOfStream(len);
                        }
                    } : new SupportsBlockBlockDeclarationManager();
                    BlockContentsManager.this.yieldManagement(declMan);
                }
            }

            @Override
            public void endOfStream(int len) {
                super.endOfStream(len);
                if (!this.isInError()) {
                    this.unexpectedEOFError(len);
                }
                this.getManager().endOfStream(len);
            }

            private class SupportsBlockBlockDeclarationManager
            extends BlockContentsDeclarationManager {
                SupportsBlockBlockDeclarationManager() {
                }

                @Override
                public void endManagement(int index) {
                    CSSParser.this.handler.endSupports(SupportsRuleTH.this.currentSupportsCondition);
                    this.yieldManagement(SupportsRuleTH.this.getManager());
                }

                @Override
                public void endOfStream(int len) {
                    CSSParser.this.handler.endSupports(SupportsRuleTH.this.currentSupportsCondition);
                    SupportsRuleTH.this.getManager().endOfStream(len);
                }
            }
        }
    }

    private static abstract class ConditionTokenHandler<F extends BooleanConditionFactory>
    extends ManagerCallbackTokenHandler {
        final F conditionFactory;
        BooleanCondition currentCond = null;
        private int opDepthIndex = 0;
        private final short[] opParenDepth = new short[32];
        private boolean topLevel = true;
        private DelegateHandler predicateHandler;
        boolean readingPredicate = false;
        final /* synthetic */ CSSParser this$0;

        ConditionTokenHandler(F conditionFactory) {
            this.this$0 = var1_1;
            this.conditionFactory = conditionFactory;
        }

        @Override
        protected void initializeBuffer() {
            this.buffer = new StringBuilder(64);
        }

        DelegateHandler getPredicateHandler() {
            return this.predicateHandler;
        }

        void setPredicateHandler(DelegateHandler predicateHandler) {
            this.predicateHandler = predicateHandler;
        }

        @Override
        short getCurrentParenDepth() {
            return this.opParenDepth[this.opDepthIndex];
        }

        @Override
        boolean isTopLevel() {
            return this.topLevel;
        }

        @Override
        public void word(int index, CharSequence word) {
            if (!this.readingPredicate) {
                if (this.buffer.length() == 0) {
                    this.processWord(index, word.toString());
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else if (this.getCurrentParenDepth() > 1 || this.predicateHandler.isAllowedTopLevel()) {
                this.predicateHandler.word(index, word);
            } else {
                this.processWord(index, word.toString());
            }
            this.prevcp = 65;
        }

        private void processWord(int index, String word) {
            String lctoken = word.toLowerCase(Locale.ROOT);
            if ("not".equals(lctoken)) {
                this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.NOT);
                BooleanCondition newCond = this.conditionFactory.createNotCondition();
                if (this.currentCond != null) {
                    this.currentCond.addCondition(newCond);
                }
                this.setNestedCondition(newCond);
            } else if ("and".equals(lctoken)) {
                this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.AND);
                if (this.currentCond != null) {
                    this.processOperation(index, BooleanCondition.Type.AND, word);
                } else {
                    this.processImplicitAnd(index);
                }
            } else if ("or".equals(lctoken)) {
                if (this.currentCond != null) {
                    this.predicateHandler.preBooleanHandling(index, BooleanCondition.Type.OR);
                    this.processOperation(index, BooleanCondition.Type.OR, word);
                } else {
                    this.unexpectedTokenError(index, word);
                }
            } else {
                this.readingPredicate = true;
                this.predicateHandler.word(index, word);
            }
        }

        void processOperation(int index, BooleanCondition.Type opType, String opname) {
            BooleanCondition operation = this.currentCond.getParentCondition();
            BooleanCondition.Type curType = this.currentCond.getType();
            if (curType == BooleanCondition.Type.PREDICATE || curType == BooleanCondition.Type.SELECTOR_FUNCTION) {
                if (operation == null) {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                } else if (operation.getType() == opType) {
                    this.currentCond = operation;
                } else {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    if (this.getCurrentParenDepth() != 0) {
                        BooleanCondition oldCond = operation.replaceLast(newCond);
                        newCond.addCondition(oldCond);
                    } else {
                        newCond.addCondition(operation);
                    }
                    this.setNestedCondition(newCond);
                }
            } else if (curType == BooleanCondition.Type.NOT) {
                if (operation != null) {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    BooleanCondition oldCond = operation.replaceLast(newCond);
                    newCond.addCondition(oldCond);
                    this.setNestedCondition(newCond);
                } else if (opType == BooleanCondition.Type.AND || opType == BooleanCondition.Type.OR) {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                } else {
                    this.unexpectedTokenError(index, opname);
                }
            } else if (curType != opType) {
                if (this.getCurrentParenDepth() != 0 || !this.topLevel) {
                    this.unexpectedTokenError(index, opname);
                } else {
                    BooleanCondition newCond = this.createOperation(index, opType);
                    newCond.addCondition(this.currentCond);
                    this.setNestedCondition(newCond);
                }
            }
        }

        BooleanCondition createOperation(int index, BooleanCondition.Type opType) throws CSSParseException {
            if (opType == BooleanCondition.Type.AND) {
                return this.conditionFactory.createAndCondition();
            }
            return this.conditionFactory.createOrCondition();
        }

        private void setNestedCondition(BooleanCondition newCond) {
            this.currentCond = newCond;
            ++this.opDepthIndex;
        }

        void processImplicitAnd(int index) {
            this.unexpectedTokenError(index, "and");
        }

        @Override
        void processBuffer(int index, int triggerCp) {
            this.unexpectedCharError(index, triggerCp);
        }

        @Override
        public void leftParenthesis(int index) {
            int n = this.opDepthIndex;
            this.opParenDepth[n] = (short)(this.opParenDepth[n] + 1);
            this.predicateHandler.leftParenthesis(index);
            this.readingPredicate = true;
            this.prevcp = 40;
        }

        @Override
        public void leftSquareBracket(int index) {
            this.predicateHandler.leftSquareBracket(index);
            this.readingPredicate = true;
            this.prevcp = 91;
        }

        @Override
        public void leftCurlyBracket(int index) {
            this.predicateHandler.leftCurlyBracket(index);
            this.readingPredicate = true;
            this.prevcp = 123;
        }

        void handleLeftCurlyBracket(int index) {
            this.unexpectedLeftCurlyBracketError(index);
        }

        @Override
        public void rightParenthesis(int index) {
            int n = this.opDepthIndex;
            this.opParenDepth[n] = (short)(this.opParenDepth[n] - 1);
            if (this.opParenDepth[this.opDepthIndex] < 0) {
                this.unexpectedCharError(index, 41);
            } else if (this.readingPredicate) {
                this.predicateHandler.rightParenthesis(index);
            } else if (this.buffer.length() != 0) {
                this.unexpectedCharError(index, 41);
            }
            this.topLevel = true;
            if (this.opParenDepth[this.opDepthIndex] == 0 && this.currentCond != null && this.opDepthIndex != 0) {
                --this.opDepthIndex;
                if (this.currentCond.getParentCondition() != null) {
                    this.currentCond = this.currentCond.getParentCondition();
                    this.topLevel = false;
                }
            }
            this.prevcp = 41;
        }

        @Override
        public void rightSquareBracket(int index) {
            if (this.readingPredicate) {
                this.predicateHandler.rightSquareBracket(index);
                this.prevcp = 93;
            } else {
                this.unexpectedCharError(index, 93);
            }
        }

        @Override
        public void rightCurlyBracket(int index) {
            if (this.readingPredicate) {
                this.predicateHandler.rightCurlyBracket(index);
                this.prevcp = 125;
            } else {
                this.unexpectedCharError(index, 125);
            }
        }

        public void character(int index, int codepoint) {
            if (!this.isInError()) {
                if (!this.readingPredicate) {
                    if (codepoint == 44) {
                        this.predicateHandler.character(index, codepoint);
                    } else if (this.getCurrentParenDepth() == 0 && this.opDepthIndex == 0) {
                        if (codepoint == 59) {
                            this.endOfCondition(index, false);
                            this.handleSemicolon(index);
                        } else {
                            this.unexpectedCharError(index, codepoint);
                        }
                    } else {
                        this.unexpectedCharError(index, codepoint);
                        this.handleErrorRecovery();
                    }
                } else {
                    this.predicateHandler.character(index, codepoint);
                }
            } else if (codepoint == 44) {
                this.predicateHandler.character(index, codepoint);
            }
        }

        protected void handleSemicolon(int index) {
            this.unexpectedSemicolonError(index);
        }

        @Override
        public void quoted(int index, CharSequence quoted, int quoteCp) {
            if (!this.isInError()) {
                if (this.readingPredicate) {
                    this.predicateHandler.quoted(index, quoted, quoteCp);
                    this.prevcp = 65;
                } else {
                    this.reportError(index, (byte)9, "Unexpected: '" + quoted + '\'');
                }
            }
        }

        @Override
        public void escaped(int index, int codepoint) {
            if (!this.isInError()) {
                if (this.readingPredicate) {
                    this.predicateHandler.escaped(index, codepoint);
                } else if (this.prevcp == 40) {
                    this.readingPredicate = true;
                    this.predicateHandler.escaped(index, codepoint);
                } else {
                    this.handleError(index, (byte)9, "Unexpected escaped character: \\u" + Integer.toHexString(codepoint));
                }
                this.prevcp = codepoint;
            }
        }

        @Override
        public void separator(int index, int codepoint) {
            if (!this.isInError()) {
                if (this.readingPredicate) {
                    this.predicateHandler.separator(index, codepoint);
                }
                this.setWhitespacePrevCp();
            }
        }

        @Override
        public void commented(int index, int commentType, String comment) {
            this.separator(index, 32);
            this.prevcp = 32;
        }

        @Override
        public void endOfStream(int len) {
            this.endOfCondition(len, true);
        }

        boolean endOfCondition(int index, boolean eof) {
            if (this.opParenDepth[this.opDepthIndex] != 0 && !eof) {
                this.handleError(index, (byte)6, "Unmatched parenthesis");
                return false;
            }
            if (!this.isInError()) {
                this.predicateHandler.endOfStream(index);
            }
            return true;
        }

        @Override
        public void reportError(int index, byte errCode, String message) throws CSSParseException {
            throw this.createException(index, errCode, message);
        }

        @Override
        public void resetHandler() {
            this.prevcp = 32;
            this.parseError = false;
            this.currentCond = null;
            this.buffer.setLength(0);
            this.resetEscapedTokenIndex();
        }
    }

    private static interface DelegateHandler
    extends ContentHandler<RuntimeException> {
        default public void preBooleanHandling(int index, BooleanCondition.Type type) {
        }

        default public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        }

        default public void commented(int index, int commentType, String comment) {
        }

        default public boolean isAllowedTopLevel() {
            return false;
        }
    }
}

